/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.drawgeometry.model;

import android.graphics.Path;
import com.xm.ui.widget.drawgeometry.model.AreaDirectionPath;
import com.xm.ui.widget.drawgeometry.model.DirectionPath;
import com.xm.ui.widget.drawgeometry.model.GeometryPoints;
import com.xm.ui.widget.drawgeometry.model.LineDirectionPath;
import com.xm.ui.widget.drawgeometry.model.OperationHistoryInfo;
import com.xm.ui.widget.drawgeometry.utils.GeometryUtils;
import java.util.ArrayList;
import java.util.List;

public class GeometryInfo {
    public static final int MAX_CUSTOM_COUNT = 8;
    public static final int GEOMETRY_NULL = 0;
    public static final int GEOMETRY_CIRCULAR = 1;
    public static final int GEOMETRY_LINE = 2;
    public static final int GEOMETRY_TRIANGLE = 3;
    public static final int GEOMETRY_RECTANGLE = 4;
    public static final int GEOMETRY_PENTAGON = 5;
    public static final int GEOMETRY_L = 6;
    public static final int GEOMETRY_AO = 8;
    public static final int GEOMETRY_CUSTOM = 9;
    public static final int GEOMETRY_TRAPEZOID = 10;
    public static final int GEOMETRY_TRAPEZOID_SMALL = 11;
    public static final int GEOMETRY_RECTANGLE_SMALL = 12;
    public static final int GEOMETRY_TRAPEZOID_NO_MATCH = 13;
    private static final int RADIUS = 50;
    private static final int DISTANCE = 30;
    private static final int MIN_RADIUS = 200;
    private GeometryPoints mCenterPoints;
    private GeometryPoints mOperationPoints;
    private int mGeometryType = 0;
    private int mCheckedPointsItem = -1;
    private GeometryPoints[] mAllPoints = new GeometryPoints[this.mGeometryType];
    private GeometryPoints[] mOriginalPoints = new GeometryPoints[this.mGeometryType];
    private List<OperationHistoryInfo> mOperationHistoryList;
    private int mAllPointsCount;
    private Path mPath;
    private boolean mIsClosed;
    private float mOriginalAngle;
    private float mAngle = 0.0f;
    private boolean isSupportRotate = false;
    private float mIconWidth;
    private float mMaxRadius;
    private float mMinRadius = 200.0f;
    private int mAreaWidth;
    private int mAreaHeight;
    private DirectionPath mDirectionPath;
    private int mDirection = 0;
    private float mScale;

    public GeometryInfo() {
        this.mCenterPoints = new GeometryPoints(0.0f, 0.0f, 0.0f);
        this.mOperationHistoryList = new ArrayList<OperationHistoryInfo>();
    }

    public void setGeometryType(int geometryType) {
        this.reset();
        this.mGeometryType = geometryType;
        this.mAllPoints = new GeometryPoints[geometryType];
        this.mAllPointsCount = geometryType;
        this.mOriginalPoints = new GeometryPoints[geometryType];
        this.mCenterPoints = new GeometryPoints(0.0f, 0.0f, 0.0f);
        this.mDirectionPath = this.mGeometryType == 2 ? new LineDirectionPath() : new AreaDirectionPath();
    }

    public int getGeometryType() {
        return this.mGeometryType;
    }

    public GeometryPoints getCenterPoints() {
        return this.mCenterPoints;
    }

    public void setCenterPoints(GeometryPoints centerPoints) {
        this.mCenterPoints = centerPoints;
    }

    public GeometryPoints[] getAllPoints() {
        return this.mAllPoints;
    }

    public GeometryPoints getPoints(int pos) {
        if (null != this.mAllPoints && pos < this.mAllPointsCount) {
            return this.mAllPoints[pos];
        }
        return null;
    }

    private void setPoints(int pos, GeometryPoints points) {
        if (null != this.mAllPoints && pos < this.mAllPointsCount) {
            try {
                this.mAllPoints[pos] = points.clone();
                this.mOriginalPoints[pos] = points.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    public void moveAllPoints(float moveX, float moveY) {
        for (GeometryPoints point : this.mAllPoints) {
            if (point == null) continue;
            point.x += moveX;
            point.y += moveY;
            point.checkLegality(this.mAreaWidth, this.mAreaHeight);
        }
        for (GeometryPoints point : this.mOriginalPoints) {
            if (point == null) continue;
            point.x += moveX;
            point.y += moveY;
            point.checkLegality(this.mAreaWidth, this.mAreaHeight);
        }
        this.findCenterPoints();
        for (int i = 0; i < this.mAllPointsCount; ++i) {
            GeometryPoints originalPoints;
            float angle = (float)GeometryUtils.getAngle(this.mAllPoints[i].x - this.mCenterPoints.x, this.mAllPoints[i].y - this.mCenterPoints.y) - this.mAngle;
            if (angle < 0.0f) {
                angle += 360.0f;
            }
            this.mOriginalPoints[i] = originalPoints = GeometryUtils.getSameAngleDifferRadius(angle, (float)Math.hypot(this.mAllPoints[i].x - this.mCenterPoints.x, this.mAllPoints[i].y - this.mCenterPoints.y), this.mCenterPoints);
        }
        this.createOperationGeometry(this.mAngle);
    }

    public void changeGeometry(GeometryPoints points) {
        this.changeGeometry(this.mCheckedPointsItem, points);
    }

    public void changeGeometry(int pointsItem, GeometryPoints points) {
        if (pointsItem < 0) {
            return;
        }
        this.checkLegality();
        if (pointsItem < this.mAllPointsCount) {
            if (this.mGeometryType == 1) {
                float radius;
                this.mAllPoints[pointsItem].radius = radius = (float)Math.hypot(points.x - this.mAllPoints[pointsItem].x, points.y - this.mAllPoints[pointsItem].y);
                this.mOriginalPoints[pointsItem].radius = radius;
            } else {
                this.mAllPoints[pointsItem] = points;
            }
        }
        this.findCenterPoints();
        for (int i = 0; i < this.mAllPointsCount; ++i) {
            GeometryPoints originalPoints;
            float angle = (float)GeometryUtils.getAngle(this.mAllPoints[i].x - this.mCenterPoints.x, this.mAllPoints[i].y - this.mCenterPoints.y) - this.mAngle;
            if (angle < 0.0f) {
                angle += 360.0f;
            }
            this.mOriginalPoints[i] = originalPoints = GeometryUtils.getSameAngleDifferRadius(angle, (float)Math.hypot(this.mAllPoints[i].x - this.mCenterPoints.x, this.mAllPoints[i].y - this.mCenterPoints.y), this.mCenterPoints);
        }
        this.createOperationGeometry(this.mAngle);
    }

    public boolean addCustomAllPoints(GeometryPoints points) {
        if (this.mGeometryType != 9 || this.mIsClosed) {
            return false;
        }
        this.mAllPoints[this.mAllPointsCount] = points;
        ++this.mAllPointsCount;
        if (this.mAllPointsCount >= 8) {
            this.mIsClosed = true;
            this.isSupportRotate = true;
        }
        return true;
    }

    public Path createGeometryPath() {
        if (this.mAllPointsCount <= 0) {
            return null;
        }
        if (null == this.mPath) {
            this.mPath = new Path();
        }
        this.mPath.reset();
        this.checkLegality();
        switch (this.mGeometryType) {
            case 1: {
                this.mPath.addCircle(this.mAllPoints[0].x, this.mAllPoints[0].y, this.mAllPoints[0].radius, Path.Direction.CCW);
                break;
            }
            case 9: {
                this.mPath.moveTo(this.mAllPoints[0].x, this.mAllPoints[0].y);
                for (int i = 1; i < this.mAllPointsCount; ++i) {
                    if (this.mAllPoints[i] == null) continue;
                    this.mPath.lineTo(this.mAllPoints[i].x, this.mAllPoints[i].y);
                }
                if (!this.mIsClosed) break;
                this.mPath.lineTo(this.mAllPoints[0].x, this.mAllPoints[0].y);
                this.isSupportRotate = true;
                break;
            }
            default: {
                this.mPath.moveTo(this.mAllPoints[0].x, this.mAllPoints[0].y);
                for (int i = this.mAllPointsCount - 1; i < this.mAllPointsCount && i >= 0; --i) {
                    this.mPath.lineTo(this.mAllPoints[i].x, this.mAllPoints[i].y);
                }
                this.mPath.close();
            }
        }
        this.mPath.close();
        this.createDirection();
        return this.mPath;
    }

    private void checkLegality() {
        for (GeometryPoints info : this.mAllPoints) {
            if (info == null) continue;
            info.checkLegality(this.mAreaWidth, this.mAreaHeight);
        }
        for (GeometryPoints info : this.mOriginalPoints) {
            if (info == null) continue;
            info.checkLegality(this.mAreaWidth, this.mAreaHeight);
        }
    }

    public boolean pointInside(GeometryPoints points) {
        boolean isPointInside = false;
        switch (this.mGeometryType) {
            case 1: {
                isPointInside = this.pointInCircular(points);
                break;
            }
            case 2: {
                isPointInside = this.pointInLine(points);
                break;
            }
            default: {
                isPointInside = this.mIsClosed && this.pointInGeometry(points);
            }
        }
        return isPointInside;
    }

    private boolean pointInCircular(GeometryPoints points) {
        for (int i = 0; i < this.mAllPointsCount; ++i) {
            double distance = Math.hypot(points.x - this.mAllPoints[i].x, points.y - this.mAllPoints[i].y);
            if (!(distance <= (double)this.mAllPoints[i].radius)) continue;
            return true;
        }
        return false;
    }

    private boolean pointInLine(GeometryPoints points) {
        float angle2;
        if (points.x - this.mAllPoints[0].x > 50.0f && points.x - this.mAllPoints[1].x > 50.0f || this.mAllPoints[0].x - points.x > 50.0f && this.mAllPoints[1].x - points.x > 50.0f || points.y - this.mAllPoints[0].y > 50.0f && points.y - this.mAllPoints[1].y > 50.0f || this.mAllPoints[0].y - points.y > 50.0f && this.mAllPoints[1].y - points.y > 50.0f) {
            return false;
        }
        if (this.mAllPoints[1].x == this.mAllPoints[0].x && Math.abs(this.mAllPoints[0].x - points.x) < 50.0f) {
            return true;
        }
        if (this.mAllPoints[1].y == this.mAllPoints[0].y && Math.abs(this.mAllPoints[0].y - points.y) < 50.0f) {
            return true;
        }
        float angle1 = (float)GeometryUtils.getAngle(this.mAllPoints[1].x - this.mAllPoints[0].x, this.mAllPoints[1].y - this.mAllPoints[0].y);
        return Math.abs(angle1 - (angle2 = (float)GeometryUtils.getAngle(points.x - this.mAllPoints[0].x, points.y - this.mAllPoints[0].y))) < 10.0f;
    }

    private boolean pointInGeometry(GeometryPoints points) {
        int crossings = 0;
        for (int i = 0; i < this.mAllPointsCount; ++i) {
            boolean above;
            int j;
            double slope = 0.0;
            int n = j = i + 1 >= this.mAllPointsCount ? 0 : i + 1;
            if (this.mAllPoints[j].x != this.mAllPoints[i].x) {
                slope = (this.mAllPoints[j].y - this.mAllPoints[i].y) / (this.mAllPoints[j].x - this.mAllPoints[i].x);
            }
            boolean cond1 = this.mAllPoints[i].x <= points.x && points.x < this.mAllPoints[j].x;
            boolean cond2 = this.mAllPoints[j].x <= points.x && points.x < this.mAllPoints[i].x;
            boolean bl = above = (double)points.y < slope * (double)(points.x - this.mAllPoints[i].x) + (double)this.mAllPoints[i].y;
            if (!cond1 && !cond2 || !above) continue;
            ++crossings;
        }
        return crossings % 2 != 0;
    }

    public boolean pointIsIntersection(GeometryPoints points) {
        if (null == points) {
            return false;
        }
        if (this.mGeometryType == 1) {
            double distance = Math.hypot(points.x - this.mAllPoints[0].x, points.y - this.mAllPoints[0].y);
            if (Math.abs(distance - (double)this.mAllPoints[0].radius) <= 5000.0) {
                return true;
            }
        } else {
            for (int i = 0; i < this.mAllPointsCount; ++i) {
                if (this.mAllPoints[i] == null) {
                    return false;
                }
                double distance = Math.hypot(points.x - this.mAllPoints[i].x, points.y - this.mAllPoints[i].y);
                if (!(distance <= 50.0)) continue;
                this.mCheckedPointsItem = i;
                return true;
            }
        }
        return false;
    }

    public void createGeometry(GeometryPoints[] points, int width, int height) {
        boolean isHaveInfo = false;
        this.mMaxRadius = width;
        if (this.mGeometryType == 2) {
            this.mAllPointsCount = 2;
            if (null != points && points.length == 2) {
                isHaveInfo = true;
            } else {
                this.setPoints(0, new GeometryPoints(width * 3 / 4, height / 4));
                this.setPoints(1, new GeometryPoints(width / 4, height * 3 / 4));
            }
            this.isSupportRotate = false;
        } else if (this.mGeometryType == 3) {
            this.mAllPointsCount = 3;
            this.mIsClosed = true;
            this.isSupportRotate = true;
            if (null != points && points.length == 3) {
                isHaveInfo = true;
            } else {
                this.setPoints(0, GeometryUtils.getSameAngleDifferRadius(0.0f, height / 3, new GeometryPoints(width / 2, height / 2)));
                this.setPoints(1, GeometryUtils.getSameAngleDifferRadius(240.0f, height / 3, new GeometryPoints(width / 2, height / 2)));
                this.setPoints(2, GeometryUtils.getSameAngleDifferRadius(120.0f, height / 3, new GeometryPoints(width / 2, height / 2)));
            }
            this.isSupportRotate = true;
        } else if (this.mGeometryType == 1) {
            this.mAllPointsCount = 1;
            this.mIsClosed = true;
            this.mCenterPoints.x = width / 2;
            this.mCenterPoints.y = height / 2;
            if (null != points && points.length == 1) {
                isHaveInfo = true;
            } else {
                this.setPoints(0, new GeometryPoints(width / 2, height / 2, height / 4));
            }
            this.isSupportRotate = false;
        } else if (this.mGeometryType == 4) {
            this.mAllPointsCount = 4;
            this.mIsClosed = true;
            this.isSupportRotate = true;
            if (null != points && points.length == 4) {
                isHaveInfo = true;
            } else {
                this.setPoints(0, new GeometryPoints(width / 4, height / 4));
                this.setPoints(1, new GeometryPoints(width / 4, height * 3 / 4));
                this.setPoints(2, new GeometryPoints(width * 3 / 4, height * 3 / 4));
                this.setPoints(3, new GeometryPoints(width * 3 / 4, height / 4));
            }
        } else if (this.mGeometryType == 5) {
            this.mAllPointsCount = 5;
            this.mIsClosed = true;
            this.isSupportRotate = true;
            if (null != points && points.length == 5) {
                isHaveInfo = true;
            } else {
                this.setPoints(0, GeometryUtils.getSameAngleDifferRadius(0.0f, height / 3, new GeometryPoints(width / 2, height / 2)));
                this.setPoints(1, GeometryUtils.getSameAngleDifferRadius(288.0f, height / 3, new GeometryPoints(width / 2, height / 2)));
                this.setPoints(2, GeometryUtils.getSameAngleDifferRadius(216.0f, height / 3, new GeometryPoints(width / 2, height / 2)));
                this.setPoints(3, GeometryUtils.getSameAngleDifferRadius(144.0f, height / 3, new GeometryPoints(width / 2, height / 2)));
                this.setPoints(4, GeometryUtils.getSameAngleDifferRadius(72.0f, height / 3, new GeometryPoints(width / 2, height / 2)));
            }
        } else if (this.mGeometryType == 6) {
            this.mAllPointsCount = 6;
            this.mIsClosed = true;
            this.isSupportRotate = true;
            if (null != points && points.length == 6) {
                isHaveInfo = true;
            } else {
                this.setPoints(0, new GeometryPoints(width / 4, height / 4));
                this.setPoints(1, new GeometryPoints(width / 4, height * 3 / 4));
                this.setPoints(2, new GeometryPoints(width * 3 / 4, height * 3 / 4));
                this.setPoints(3, new GeometryPoints(width * 3 / 4, height / 2));
                this.setPoints(4, new GeometryPoints(width / 2, height / 2));
                this.setPoints(5, new GeometryPoints(width / 2, height / 4));
            }
        } else if (this.mGeometryType == 8) {
            this.mAllPointsCount = 8;
            this.mIsClosed = true;
            this.isSupportRotate = true;
            if (null != points && points.length == 8) {
                isHaveInfo = true;
            } else {
                this.setPoints(0, new GeometryPoints(width / 4, height / 5));
                this.setPoints(1, new GeometryPoints(width / 4, height * 4 / 5));
                this.setPoints(2, new GeometryPoints(width * 3 / 4, height * 4 / 5));
                this.setPoints(3, new GeometryPoints(width * 3 / 4, height * 3 / 5));
                this.setPoints(4, new GeometryPoints(width / 2, height * 3 / 5));
                this.setPoints(5, new GeometryPoints(width / 2, height * 2 / 5));
                this.setPoints(6, new GeometryPoints(width * 3 / 4, height * 2 / 5));
                this.setPoints(7, new GeometryPoints(width * 3 / 4, height / 5));
            }
        } else if (this.mGeometryType == 10) {
            this.mAllPointsCount = 4;
            this.mIsClosed = true;
            this.isSupportRotate = true;
            if (null != points && points.length == 4) {
                isHaveInfo = true;
            } else {
                this.setPoints(0, new GeometryPoints(width / 3, height / 5));
                this.setPoints(1, new GeometryPoints(width / 4, height * 4 / 5));
                this.setPoints(2, new GeometryPoints(width * 3 / 4, height * 4 / 5));
                this.setPoints(3, new GeometryPoints(width * 2 / 3, height * 1 / 5));
            }
        } else if (this.mGeometryType == 11) {
            this.mAllPointsCount = 4;
            this.mIsClosed = true;
            this.isSupportRotate = true;
            if (null != points && points.length == 4) {
                isHaveInfo = true;
            } else {
                this.setPoints(0, new GeometryPoints(width / 3, height * 2 / 5));
                this.setPoints(1, new GeometryPoints(width / 4, height * 4 / 5));
                this.setPoints(2, new GeometryPoints(width * 3 / 4, height * 4 / 5));
                this.setPoints(3, new GeometryPoints(width * 2 / 3, height * 2 / 5));
            }
        } else if (this.mGeometryType == 12) {
            this.mAllPointsCount = 4;
            this.mIsClosed = true;
            this.isSupportRotate = true;
            if (null != points && points.length == 4) {
                isHaveInfo = true;
            } else {
                this.setPoints(0, new GeometryPoints(width / 4, height / 4));
                this.setPoints(1, new GeometryPoints(width / 4, width / 2));
                this.setPoints(2, new GeometryPoints(width * 3 / 4, width / 2));
                this.setPoints(3, new GeometryPoints(width * 3 / 4, height / 4));
            }
        } else if (this.mGeometryType == 13) {
            this.mAllPointsCount = 4;
            this.mIsClosed = true;
            this.isSupportRotate = true;
            if (null != points && points.length == 4) {
                isHaveInfo = true;
            } else {
                this.setPoints(0, new GeometryPoints(width / 4, height / 5));
                this.setPoints(1, new GeometryPoints(width * 7 / 24, height * 4 / 5));
                this.setPoints(2, new GeometryPoints(width * 3 / 4, height * 4 / 5));
                this.setPoints(3, new GeometryPoints(width * 2 / 3, height * 1 / 5));
            }
        } else if (null != points && points.length >= 1 && points.length <= 8) {
            this.mAllPointsCount = points.length;
            this.mIsClosed = true;
            this.isSupportRotate = true;
            isHaveInfo = true;
        } else {
            this.mAllPointsCount = 1;
            this.mIsClosed = false;
            this.isSupportRotate = false;
            this.setPoints(0, new GeometryPoints(width / 4, height / 4));
        }
        if (isHaveInfo) {
            for (int i = 0; i < points.length; ++i) {
                this.setPoints(i, points[i]);
            }
        }
        this.findCenterPoints();
        this.createOperationGeometry(0.0f);
    }

    public void createGeometry(int width, int height) {
        this.createGeometry(null, width, height);
    }

    public void createGeometry(int width, int height, int iconWidth, int iconHeight) {
        this.createGeometry(width, height);
        this.mIconWidth = iconWidth;
    }

    public void createGeometry(GeometryPoints[] points, int width, int height, int iconWidth, int iconHeight) {
        this.createGeometry(points, width, height);
        this.mIconWidth = iconWidth;
        this.mAreaWidth = width;
        this.mAreaHeight = height;
    }

    private void createDirection() {
        if (this.mDirection != 0 && this.mDirectionPath != null) {
            this.mDirectionPath.createDirection(this.mAllPointsCount, this.mAllPoints, this.mDirection);
        }
    }

    private void createOperationGeometry(float angle) {
        if (this.isSupportRotate) {
            float radius = (float)(Math.hypot(this.mOriginalPoints[0].x - this.mCenterPoints.x, this.mOriginalPoints[0].y - this.mCenterPoints.y) + (double)this.mIconWidth + 30.0);
            this.mOriginalAngle = (float)GeometryUtils.getAngle(this.mOriginalPoints[0].x - this.mCenterPoints.x, this.mOriginalPoints[0].y - this.mCenterPoints.y);
            GeometryPoints operationPoints = GeometryUtils.getSameAngleDifferRadius((this.mOriginalAngle + angle) % 360.0f, radius, this.mCenterPoints);
            if (this.mOperationPoints == null) {
                this.mOperationPoints = new GeometryPoints(operationPoints.x, operationPoints.y, radius);
            } else {
                this.mOperationPoints.x = operationPoints.x;
                this.mOperationPoints.y = operationPoints.y;
                this.mOperationPoints.radius = radius;
            }
        }
    }

    public int getPointsCount() {
        return this.mAllPointsCount;
    }

    public void setClosed(boolean isClosed) {
        this.mIsClosed = isClosed;
        if (this.mGeometryType == 9) {
            this.isSupportRotate = true;
        }
    }

    public boolean isClosed() {
        return this.mIsClosed;
    }

    private void reset() {
        this.mIsClosed = false;
        this.mCenterPoints = null;
        this.mOperationPoints = null;
        this.mOriginalPoints = null;
        this.mAllPoints = null;
        this.mAllPointsCount = 0;
        this.mPath = null;
        this.mCheckedPointsItem = -1;
        this.mOriginalAngle = 0.0f;
        this.mAngle = 0.0f;
        this.isSupportRotate = false;
    }

    public boolean isSelectedFirstItem() {
        return this.mCheckedPointsItem == 0;
    }

    public boolean isRotate(GeometryPoints points) {
        if (this.isSupportRotate) {
            double distance = Math.hypot(points.x - this.mOperationPoints.x, points.y - this.mOperationPoints.y);
            return distance <= 50.0;
        }
        return false;
    }

    public boolean isSupportRotate() {
        return this.isSupportRotate;
    }

    public void setSupportRotate(boolean isSupport) {
        this.isSupportRotate = isSupport;
    }

    public void rotateCenterOfGeometry(GeometryPoints points) {
        float r = (float)Math.hypot(this.mOperationPoints.x - this.mCenterPoints.x, this.mOperationPoints.y - this.mCenterPoints.y);
        float r1 = (float)Math.hypot(points.x - this.mCenterPoints.x, points.y - this.mCenterPoints.y);
        this.mOperationPoints.x = (points.x - this.mCenterPoints.x) * r / r1 + this.mCenterPoints.x;
        this.mOperationPoints.y = (points.y - this.mCenterPoints.y) * r / r1 + this.mCenterPoints.y;
        float x = this.mOperationPoints.x - this.mCenterPoints.x;
        float y = this.mOperationPoints.y - this.mCenterPoints.y;
        this.mAngle = ((float)GeometryUtils.getAngle(x, y) - this.mOriginalAngle + 360.0f) % 360.0f;
        for (int i = 0; i < this.mAllPointsCount; ++i) {
            System.out.println("----x:" + this.mOriginalPoints[i].x + "y:" + this.mOriginalPoints[i].y);
            System.out.println("----x2:" + this.mAllPoints[i].x + "y2:" + this.mAllPoints[i].y);
            x = this.mOriginalPoints[i].x - this.mCenterPoints.x;
            y = this.mOriginalPoints[i].y - this.mCenterPoints.y;
            if (x == 0.0f && y == 0.0f) continue;
            float oldAngle = (float)GeometryUtils.getAngle(x, y);
            float totalAngel = (oldAngle + this.mAngle) % 360.0f;
            float radius = (float)Math.hypot(this.mOriginalPoints[i].x - this.mCenterPoints.x, this.mOriginalPoints[i].y - this.mCenterPoints.y);
            System.out.println("angle:" + this.mAngle + "oldAngle:" + oldAngle + "totalAngel:" + totalAngel);
            GeometryPoints newPoints = GeometryUtils.getSameAngleDifferRadius(totalAngel, radius, this.mCenterPoints);
            this.mAllPoints[i].x = newPoints.x;
            this.mAllPoints[i].y = newPoints.y;
        }
    }

    public void rotateCenterOfPoints(GeometryPoints centerPoints, float rotateAngle) {
        for (int i = 0; i < this.mAllPoints.length; ++i) {
            float angle = (float)GeometryUtils.getAngle(this.mOriginalPoints[i].x - centerPoints.x, this.mOriginalPoints[i].y - centerPoints.y);
            this.mAllPoints[i] = GeometryUtils.getSameAngleDifferRadius((angle + rotateAngle) % 360.0f, (float)Math.hypot(this.mAllPoints[i].x - centerPoints.x, this.mAllPoints[i].y - centerPoints.y), centerPoints);
        }
    }

    private void findCenterPoints() {
        float[] rect = new float[4];
        if (this.mGeometryType != 1 && this.mGeometryType != 2 && this.mIsClosed) {
            rect[0] = this.mAllPoints[0].x;
            rect[1] = this.mAllPoints[0].y;
            rect[2] = this.mAllPoints[0].x;
            rect[3] = this.mAllPoints[0].y;
            float old_x = this.mCenterPoints.x;
            float old_y = this.mCenterPoints.y;
            for (GeometryPoints points : this.mAllPoints) {
                if (points == null) break;
                if (rect[0] > points.x) {
                    rect[0] = points.x;
                }
                if (rect[1] > points.y) {
                    rect[1] = points.y;
                }
                if (rect[2] < points.x) {
                    rect[2] = points.x;
                }
                if (!(rect[3] < points.y)) continue;
                rect[3] = points.y;
            }
            this.mCenterPoints.x = (rect[0] + rect[2]) / 2.0f;
            this.mCenterPoints.y = (rect[1] + rect[3]) / 2.0f;
            this.mCenterPoints.radius = (float)Math.hypot((double)(rect[0] - rect[2]) / 2.0, (double)(rect[1] - rect[3]) / 2.0);
        }
    }

    public GeometryPoints getOperationPoints() {
        return this.mOperationPoints == null ? new GeometryPoints(0.0f, 0.0f, 0.0f) : this.mOperationPoints;
    }

    public boolean setDirection(int direction) {
        this.mDirection = direction;
        return true;
    }

    public boolean setScale(float scale) {
        if (this.mGeometryType == 0 || this.mGeometryType == 2 || this.mGeometryType == 1) {
            return false;
        }
        if (this.mScale < scale && this.mCenterPoints.radius > this.mMaxRadius) {
            return false;
        }
        if (this.mScale > scale && this.mCenterPoints.radius < this.mMinRadius) {
            return false;
        }
        this.mScale = scale;
        System.out.println("scale:" + scale + "radius:" + this.mCenterPoints.radius);
        for (int i = 0; i < this.mAllPointsCount; ++i) {
            float radius = (float)Math.hypot(this.mAllPoints[i].x - this.mCenterPoints.x, this.mAllPoints[i].y - this.mCenterPoints.y);
            float angle = (float)GeometryUtils.getAngle(this.mAllPoints[i].x - this.mCenterPoints.x, this.mAllPoints[i].y - this.mCenterPoints.y);
            radius = (float)((double)radius * Math.sqrt(scale));
            this.mAllPoints[i] = GeometryUtils.getSameAngleDifferRadius(angle, radius, this.mCenterPoints);
            this.mOriginalPoints[i] = GeometryUtils.getSameAngleDifferRadius((angle - this.mAngle + 360.0f) % 360.0f, radius, this.mCenterPoints);
        }
        this.mCenterPoints.radius = (float)((double)this.mCenterPoints.radius * Math.sqrt(scale));
        this.createOperationGeometry(this.mAngle);
        return true;
    }

    public List<GeometryPoints> getAllPoint() {
        ArrayList<GeometryPoints> pointsList = new ArrayList<GeometryPoints>();
        for (int i = 0; i < this.mAllPoints.length; ++i) {
            if (null == this.mAllPoints[i]) continue;
            this.mAllPoints[i].checkLegality(this.mAreaWidth, this.mAreaHeight);
            pointsList.add(this.mAllPoints[i]);
        }
        return pointsList;
    }

    public int getDirection() {
        return this.mDirection;
    }

    public Path getDirectionPath() {
        return this.mDirectionPath != null ? this.mDirectionPath.getDirectionPath() : null;
    }

    public void clearOperationHistory(GeometryPoints[] defaultPoints) {
        if (this.mOperationHistoryList != null) {
            this.mOperationHistoryList.clear();
        }
    }

    public boolean addOperationPointsToHistory() {
        if (this.mAllPoints != null && this.mAllPoints.length >= this.mAllPointsCount && this.mAllPointsCount > 0 && this.mOperationHistoryList != null) {
            OperationHistoryInfo info = new OperationHistoryInfo();
            GeometryPoints[] addPoints = new GeometryPoints[this.mAllPointsCount];
            for (int i = 0; i < this.mAllPointsCount; ++i) {
                try {
                    if (this.mAllPoints[i] == null) {
                        return false;
                    }
                    addPoints[i] = this.mAllPoints[i].clone();
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            info.setOperationPoints(addPoints);
            info.setDirection(this.mDirection);
            info.setPointsCount(this.mAllPointsCount);
            this.mOperationHistoryList.add(info);
            return true;
        }
        return false;
    }

    public boolean retreatToPreviousOperationPoints() {
        GeometryPoints[] points;
        OperationHistoryInfo info;
        int itemPos;
        if (this.mOperationHistoryList != null && (itemPos = this.mOperationHistoryList.size() - 1) >= 0 && (info = this.mOperationHistoryList.get(itemPos)) != null && (points = info.getOperationPoints()) != null) {
            this.mAllPoints = (GeometryPoints[])points.clone();
            this.mOriginalPoints = (GeometryPoints[])points.clone();
            this.mAllPointsCount = info.getPointsCount();
            this.mOperationHistoryList.remove(info);
            this.mDirection = info.getDirection();
            this.mGeometryType = info.getPointsCount();
            this.createGeometry(this.mAllPoints, this.mAreaWidth, this.mAreaHeight);
            return true;
        }
        return false;
    }

    public boolean hasOperationHistoryPoints() {
        if (this.mOperationHistoryList != null) {
            return !this.mOperationHistoryList.isEmpty();
        }
        return false;
    }
}

