/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.drawgeometry.model;

import android.graphics.Path;
import androidx.annotation.NonNull;
import com.xm.ui.widget.drawgeometry.model.GeometryPoints;
import com.xm.ui.widget.drawgeometry.utils.GeometryUtils;

public abstract class DirectionPath {
    public static final int NO_DIRECTION = 0;
    public static final int DIRECTION_FORWARD = 1;
    public static final int DIRECTION_BACKWARD = 2;
    public static final int TWO_WAY = 3;
    protected static final float ARROW_LINE_RATIO = 0.1f;
    protected static final float ARROW_RATIO = 0.05f;
    protected int mDirection = 0;
    protected Path mDirectionPath;
    protected GeometryPoints[] mDirectionPoints1;
    protected GeometryPoints[] mDirectionPoints2;

    protected abstract boolean isPointInGeometry(int var1, GeometryPoints[] var2, GeometryPoints var3);

    protected boolean createDirection(int pointsCount, @NonNull GeometryPoints[] points, int direction) {
        this.mDirection = direction;
        if (this.mDirection == 0) {
            return false;
        }
        if (points == null) {
            return false;
        }
        if (points.length <= 1) {
            return false;
        }
        if (points[0] == null || points[1] == null) {
            return false;
        }
        if (this.mDirectionPoints1 == null) {
            this.mDirectionPoints1 = new GeometryPoints[4];
            this.mDirectionPoints1[0] = new GeometryPoints();
            this.mDirectionPoints1[1] = new GeometryPoints();
            this.mDirectionPoints1[2] = new GeometryPoints();
            this.mDirectionPoints1[3] = new GeometryPoints();
        }
        float x = (points[0].x + points[1].x) / 2.0f;
        float y = (points[0].y + points[1].y) / 2.0f;
        float len = (float)Math.hypot(points[0].x - points[1].x, points[0].y - points[1].y);
        float angle = (float)GeometryUtils.getAngle(points[0].x - points[1].x, points[0].y - points[1].y);
        GeometryPoints pointsStart = GeometryUtils.getSameAngleDifferRadius((angle - 90.0f + 360.0f) % 360.0f, len * 0.1f, new GeometryPoints(x, y));
        GeometryPoints pointsEnd = GeometryUtils.getSameAngleDifferRadius((angle + 90.0f) % 360.0f, len * 0.1f, new GeometryPoints(x, y));
        boolean isPointInGeometry = this.isPointInGeometry(pointsCount, points, pointsStart);
        if (this.mDirection == 1) {
            float arrowAngle2;
            float arrowAngle1;
            if (isPointInGeometry) {
                this.mDirectionPoints1[0] = pointsStart;
                this.mDirectionPoints1[1] = pointsEnd;
                arrowAngle1 = (angle + 60.0f) % 360.0f;
                arrowAngle2 = (angle + 120.0f) % 360.0f;
            } else {
                this.mDirectionPoints1[0] = pointsEnd;
                this.mDirectionPoints1[1] = pointsStart;
                arrowAngle1 = (angle - 60.0f + 360.0f) % 360.0f;
                arrowAngle2 = (angle - 120.0f + 360.0f) % 360.0f;
            }
            this.mDirectionPoints1[2] = GeometryUtils.getSameAngleDifferRadius(arrowAngle1, len * 0.05f, new GeometryPoints(this.mDirectionPoints1[0].x, this.mDirectionPoints1[0].y));
            this.mDirectionPoints1[3] = GeometryUtils.getSameAngleDifferRadius(arrowAngle2, len * 0.05f, new GeometryPoints(this.mDirectionPoints1[0].x, this.mDirectionPoints1[0].y));
        } else if (this.mDirection == 2) {
            float arrowAngle2;
            float arrowAngle1;
            if (isPointInGeometry) {
                this.mDirectionPoints1[0] = pointsEnd;
                this.mDirectionPoints1[1] = pointsStart;
                arrowAngle1 = (angle - 60.0f + 360.0f) % 360.0f;
                arrowAngle2 = (angle - 120.0f + 360.0f) % 360.0f;
            } else {
                this.mDirectionPoints1[0] = pointsStart;
                this.mDirectionPoints1[1] = pointsEnd;
                arrowAngle1 = (angle + 60.0f) % 360.0f;
                arrowAngle2 = (angle + 120.0f) % 360.0f;
            }
            this.mDirectionPoints1[2] = GeometryUtils.getSameAngleDifferRadius(arrowAngle1, len * 0.05f, new GeometryPoints(this.mDirectionPoints1[0].x, this.mDirectionPoints1[0].y));
            this.mDirectionPoints1[3] = GeometryUtils.getSameAngleDifferRadius(arrowAngle2, len * 0.05f, new GeometryPoints(this.mDirectionPoints1[0].x, this.mDirectionPoints1[0].y));
        } else if (this.mDirection == 3) {
            if (this.mDirectionPoints2 == null) {
                this.mDirectionPoints2 = new GeometryPoints[4];
                this.mDirectionPoints2[0] = new GeometryPoints();
                this.mDirectionPoints2[1] = new GeometryPoints();
                this.mDirectionPoints2[2] = new GeometryPoints();
                this.mDirectionPoints2[3] = new GeometryPoints();
            }
            this.mDirectionPoints1[0] = pointsStart;
            this.mDirectionPoints1[1] = pointsEnd;
            float arrowAngle1 = (angle + 60.0f) % 360.0f;
            float arrowAngle2 = (angle + 120.0f) % 360.0f;
            this.mDirectionPoints1[2] = GeometryUtils.getSameAngleDifferRadius(arrowAngle1, len * 0.05f, new GeometryPoints(this.mDirectionPoints1[0].x, this.mDirectionPoints1[0].y));
            this.mDirectionPoints1[3] = GeometryUtils.getSameAngleDifferRadius(arrowAngle2, len * 0.05f, new GeometryPoints(this.mDirectionPoints1[0].x, this.mDirectionPoints1[0].y));
            this.mDirectionPoints2[0] = pointsEnd;
            this.mDirectionPoints2[1] = pointsStart;
            float arrowAngle3 = (angle - 60.0f + 360.0f) % 360.0f;
            float arrowAngle4 = (angle - 120.0f + 360.0f) % 360.0f;
            this.mDirectionPoints2[2] = GeometryUtils.getSameAngleDifferRadius(arrowAngle3, len * 0.05f, new GeometryPoints(this.mDirectionPoints2[0].x, this.mDirectionPoints2[0].y));
            this.mDirectionPoints2[3] = GeometryUtils.getSameAngleDifferRadius(arrowAngle4, len * 0.05f, new GeometryPoints(this.mDirectionPoints2[0].x, this.mDirectionPoints2[0].y));
        }
        return true;
    }

    public Path getDirectionPath() {
        if (this.mDirectionPoints1 == null) {
            return null;
        }
        if (null == this.mDirectionPath) {
            this.mDirectionPath = new Path();
        }
        this.mDirectionPath.reset();
        this.mDirectionPath.moveTo(this.mDirectionPoints1[0].x, this.mDirectionPoints1[0].y);
        this.mDirectionPath.lineTo(this.mDirectionPoints1[1].x, this.mDirectionPoints1[1].y);
        this.mDirectionPath.moveTo(this.mDirectionPoints1[0].x, this.mDirectionPoints1[0].y);
        this.mDirectionPath.lineTo(this.mDirectionPoints1[2].x, this.mDirectionPoints1[2].y);
        this.mDirectionPath.moveTo(this.mDirectionPoints1[0].x, this.mDirectionPoints1[0].y);
        this.mDirectionPath.lineTo(this.mDirectionPoints1[3].x, this.mDirectionPoints1[3].y);
        if (this.mDirection == 3) {
            if (this.mDirectionPoints2 == null) {
                return null;
            }
            this.mDirectionPath.moveTo(this.mDirectionPoints2[0].x, this.mDirectionPoints2[0].y);
            this.mDirectionPath.lineTo(this.mDirectionPoints2[1].x, this.mDirectionPoints2[1].y);
            this.mDirectionPath.moveTo(this.mDirectionPoints2[0].x, this.mDirectionPoints2[0].y);
            this.mDirectionPath.lineTo(this.mDirectionPoints2[2].x, this.mDirectionPoints2[2].y);
            this.mDirectionPath.moveTo(this.mDirectionPoints2[0].x, this.mDirectionPoints2[0].y);
            this.mDirectionPath.lineTo(this.mDirectionPoints2[3].x, this.mDirectionPoints2[3].y);
        }
        return this.mDirectionPath;
    }
}

