/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.ImageView;
import com.xm.UIUtils;
import com.xm.uilibrary.R;
import java.lang.ref.WeakReference;

@SuppressLint(value={"AppCompatCustomView"})
public class XCRoundRectImageView
extends ImageView {
    private Paint mPaint;
    private String mText = "";
    private int mTextColor = 0;
    private float mTextSize = 10.0f;
    private float mRadius;
    private Xfermode mXfermode = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
    private WeakReference<Bitmap> mWeakBitmap;
    private Bitmap mMaskBitmap;
    float xDown;

    public XCRoundRectImageView(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XCRoundRectImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray array = null;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        try {
            array = context.obtainStyledAttributes(attrs, R.styleable.XCRoundRectImageView);
            this.mText = array.getString(R.styleable.XCRoundRectImageView_xc_text);
            this.mTextColor = array.getColor(R.styleable.XCRoundRectImageView_xc_textColor, -1);
            this.mTextSize = array.getDimensionPixelSize(R.styleable.XCRoundRectImageView_xc_textSize, 0);
            this.mRadius = array.getDimension(R.styleable.XCRoundRectImageView_xc_radius, 0.0f);
        }
        finally {
            if (array != null) {
                array.recycle();
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        Bitmap bitmap;
        Bitmap bitmap2 = bitmap = this.mWeakBitmap == null ? null : (Bitmap)this.mWeakBitmap.get();
        if (bitmap == null || bitmap.isRecycled()) {
            Drawable drawable2 = this.getDrawable();
            if (drawable2 == null) {
                return;
            }
            int dWidth = drawable2.getIntrinsicWidth();
            int dHeight = drawable2.getIntrinsicHeight();
            if (drawable2 != null && this.getWidth() > 0 && this.getHeight() > 0) {
                bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                float scale = 1.0f;
                Canvas drawCanvas = new Canvas(bitmap);
                scale = Math.max((float)this.getWidth() * 1.0f / (float)dWidth, (float)this.getHeight() * 1.0f / (float)dHeight);
                drawable2.setBounds(0, 0, (int)(scale * (float)dWidth), (int)(scale * (float)dHeight));
                drawable2.draw(drawCanvas);
                if (this.mMaskBitmap == null || this.mMaskBitmap.isRecycled()) {
                    this.mMaskBitmap = this.getRoundBitmap();
                }
                this.mPaint.reset();
                this.mPaint.setFilterBitmap(false);
                this.mPaint.setXfermode(this.mXfermode);
                drawCanvas.drawBitmap(this.mMaskBitmap, 0.0f, 0.0f, this.mPaint);
                this.mPaint.setXfermode(null);
                canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
                this.mWeakBitmap = new WeakReference<Bitmap>(bitmap);
            } else {
                super.onDraw(canvas);
            }
        } else {
            this.mPaint.setXfermode(null);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.mPaint);
        }
        if (this.mText != null) {
            Rect targetRect = new Rect(0, 0, this.getWidth(), this.getHeight());
            Paint paint = new Paint(1);
            paint.setStrokeWidth(3.0f);
            float a = UIUtils.dp2px(this.getContext(), 8.0f);
            float ba = UIUtils.dp2px(this.getContext(), a);
            paint.setTextSize(this.mTextSize);
            String testString = this.mText;
            paint.setColor(0);
            canvas.drawRect(targetRect, paint);
            paint.setColor(-1);
            Paint.FontMetricsInt fontMetrics = paint.getFontMetricsInt();
            int baseline = (targetRect.bottom + targetRect.top - fontMetrics.bottom - fontMetrics.top) / 2;
            paint.setTextAlign(Paint.Align.CENTER);
            canvas.drawText(testString, (float)targetRect.centerX(), (float)baseline, paint);
        }
    }

    public void invalidate() {
        this.mWeakBitmap = null;
        if (this.mMaskBitmap != null) {
            this.mMaskBitmap.recycle();
            this.mMaskBitmap = null;
        }
        super.invalidate();
    }

    public void setText(String text) {
        this.mText = text;
    }

    public void setTextColor(int color2) {
        this.mTextColor = color2;
    }

    private Bitmap getRoundBitmap() {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint(1);
        paint.setColor(-16777216);
        canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight()), this.mRadius, this.mRadius, paint);
        return bitmap;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return super.onTouchEvent(event);
    }

    public void setImageRadius(float radius) {
        this.mRadius = radius;
        this.invalidate();
    }
}

