/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatEditText;

public class ContainsEmojiEditText
extends AppCompatEditText {
    private int cursorPos;
    private String inputAfterText;
    private boolean resetText;
    private Context mContext;

    public ContainsEmojiEditText(Context context) {
        super(context);
        this.mContext = context;
        this.initEditText();
    }

    public ContainsEmojiEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initEditText();
    }

    public ContainsEmojiEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initEditText();
    }

    private void initEditText() {
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int before, int count) {
                if (!ContainsEmojiEditText.this.resetText) {
                    ContainsEmojiEditText.this.cursorPos = ContainsEmojiEditText.this.getSelectionEnd();
                    ContainsEmojiEditText.this.inputAfterText = s.toString();
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (!ContainsEmojiEditText.this.resetText) {
                    if (count >= 2) {
                        if (ContainsEmojiEditText.this.cursorPos + count > s.length()) {
                            return;
                        }
                        CharSequence input = s.subSequence(ContainsEmojiEditText.this.cursorPos, ContainsEmojiEditText.this.cursorPos + count);
                        if (ContainsEmojiEditText.containsEmoji(input.toString())) {
                            ContainsEmojiEditText.this.resetText = true;
                            ContainsEmojiEditText.this.setText(ContainsEmojiEditText.this.inputAfterText);
                            Editable text = ContainsEmojiEditText.this.getText();
                            if (text instanceof Spannable) {
                                Spannable spanText = (Spannable)text;
                                Selection.setSelection((Spannable)spanText, (int)text.length());
                            }
                        }
                    }
                } else {
                    ContainsEmojiEditText.this.resetText = false;
                }
            }

            public void afterTextChanged(Editable editable) {
            }
        });
    }

    public static boolean containsEmoji(String source) {
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (ContainsEmojiEditText.isEmojiCharacter(codePoint)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEmojiCharacter(char codePoint) {
        return codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff';
    }
}

