/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.pullrefresh;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.xm.ui.widget.icseelogoview.ICSeeLogoView;
import demo.xm.com.libxmfunsdk.R;

public class PullRefreshHeader
extends LinearLayout {
    public static final int ACTION_FINISH = 1;
    public static final int STATE_ARROWS_TO_TOP = 2;
    public static final int STATE_ARROWS_TO_DOWN = 3;
    public static final int STATE_FRESHING = 4;
    private LinearLayout mContainer;
    private ICSeeLogoView mLoadingView;
    private int icseeLoadingSize;
    private int mState = 3;
    private boolean isFreshing = false;

    public PullRefreshHeader(Context context) {
        super(context);
        this.initView(context);
    }

    public PullRefreshHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mContainer = (LinearLayout)LayoutInflater.from((Context)context).inflate(R.layout.funsdk_view_pullrefresh_header, (ViewGroup)this);
        this.mLoadingView = (ICSeeLogoView)this.mContainer.findViewById(R.id.loading_icsee);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.icseeLoadingSize <= 0) {
            this.setLoadingViewSize(this.icseeLoadingSize);
        }
    }

    public int getState() {
        return this.mState;
    }

    public void setState(int state, float pullProgress) {
        System.out.println("pullProgress:" + pullProgress);
        this.mLoadingView.setBackgroundStep(pullProgress);
        if (this.mState == state) {
            return;
        }
        switch (state) {
            case 1: {
                this.isFreshing = false;
                this.mLoadingView.stopAnimation();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.isFreshing = true;
                this.mLoadingView.startAnimation();
                break;
            }
        }
        this.mState = state;
    }

    public void initViewState() {
        this.mLoadingView.stopAnimation();
        this.isFreshing = false;
        this.mState = 3;
    }

    public void setLoadingViewSize(int size) {
        this.icseeLoadingSize = size;
        if (this.mLoadingView != null) {
            ViewGroup.LayoutParams layoutParams = this.mLoadingView.getLayoutParams();
            if (layoutParams != null) {
                layoutParams.width = size;
                layoutParams.height = size;
            }
            this.mLoadingView.requestLayout();
        }
    }
}

