/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.idr;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.lib.FunSDK;
import demo.xm.com.libxmfunsdk.R;
import java.lang.ref.WeakReference;

public class IDRWakeWaitView {
    private ImageView mImgClock;
    private ImageView mImgSZ;
    private ImageView mImgMZ;
    private ImageView mImgBZ;
    private ImageView mImgLeftB;
    private ImageView mImgLeftS;
    private ImageView mImgRightS;
    private ImageView mImgRightB;
    private ViewGroup mViewGroup;
    private TextView mTxtPrompt;
    private Animator[] mWeakAnims;
    private Animator[] mConnectAnims;
    private WeakReference<View> mRootView;
    private boolean isShow;
    private Handler mHandler = new Handler(){

        public void dispatchMessage(Message msg) {
            IDRWakeWaitView.this.startConnectAnim();
        }
    };

    public IDRWakeWaitView(Activity activity) {
        this.mRootView = new WeakReference<View>(activity.getWindow().getDecorView());
        this.mViewGroup = (ViewGroup)LayoutInflater.from((Context)activity).inflate(R.layout.funsdk_view_idr_wait_weak, null);
        this.mViewGroup.setLayoutParams(new ViewGroup.LayoutParams(Resources.getSystem().getDisplayMetrics().widthPixels, Resources.getSystem().getDisplayMetrics().heightPixels));
        this.mViewGroup.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        this.initView();
    }

    private void initView() {
        this.mTxtPrompt = (TextView)this.mViewGroup.findViewById(R.id.txtPrompt);
        this.mImgClock = (ImageView)this.mViewGroup.findViewById(R.id.imgClock);
        this.mImgSZ = (ImageView)this.mViewGroup.findViewById(R.id.imgSZ);
        this.mImgMZ = (ImageView)this.mViewGroup.findViewById(R.id.imgMZ);
        this.mImgBZ = (ImageView)this.mViewGroup.findViewById(R.id.imgBZ);
        this.mImgLeftS = (ImageView)this.mViewGroup.findViewById(R.id.imgLeftS);
        this.mImgLeftB = (ImageView)this.mViewGroup.findViewById(R.id.imgLeftB);
        this.mImgRightS = (ImageView)this.mViewGroup.findViewById(R.id.imgRightS);
        this.mImgRightB = (ImageView)this.mViewGroup.findViewById(R.id.imgRightB);
    }

    public void show() {
        if (this.isShow || this.mRootView == null || this.mRootView.get() == null) {
            return;
        }
        this.isShow = true;
        ViewGroup viewGroup = (ViewGroup)this.mRootView.get();
        viewGroup.addView((View)this.mViewGroup);
        this.startWeakAnim();
    }

    private void stopWeakAnim() {
        if (this.mWeakAnims != null) {
            this.mWeakAnims[0].cancel();
            this.mWeakAnims[1].cancel();
            this.mWeakAnims[2].cancel();
        }
        this.mImgSZ.setVisibility(4);
        this.mImgMZ.setVisibility(4);
        this.mImgBZ.setVisibility(4);
    }

    private void startWeakAnim() {
        this.stopConnectAnim();
        this.mTxtPrompt.setText((CharSequence)FunSDK.TS((String)"Waking_up"));
        if (this.mWeakAnims == null) {
            this.mWeakAnims = new Animator[3];
            ObjectAnimator sAlphaAnim = ObjectAnimator.ofFloat((Object)this.mImgSZ, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            sAlphaAnim.setDuration(1500L);
            sAlphaAnim.setRepeatCount(-1);
            this.mWeakAnims[0] = sAlphaAnim;
            ObjectAnimator mAlphaAnim = ObjectAnimator.ofFloat((Object)this.mImgMZ, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
            mAlphaAnim.setDuration(1500L);
            mAlphaAnim.setRepeatCount(-1);
            this.mWeakAnims[1] = mAlphaAnim;
            ObjectAnimator bAlphaAnim = ObjectAnimator.ofFloat((Object)this.mImgBZ, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
            bAlphaAnim.setDuration(1300L);
            bAlphaAnim.setStartDelay(200L);
            bAlphaAnim.setRepeatCount(-1);
            this.mWeakAnims[2] = bAlphaAnim;
        }
        this.mImgSZ.setVisibility(0);
        this.mImgMZ.setVisibility(0);
        this.mImgBZ.setVisibility(0);
        int length = this.mWeakAnims.length;
        for (int i = 0; i < length; ++i) {
            this.mWeakAnims[i].start();
        }
        this.mHandler.sendEmptyMessageDelayed(0, 3000L);
    }

    private void startConnectAnim() {
        this.stopWeakAnim();
        this.mTxtPrompt.setText((CharSequence)FunSDK.TS((String)"Device_Connectting"));
        if (this.mConnectAnims == null) {
            this.mConnectAnims = new Animator[2];
            ValueAnimator smallAlphaAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
            this.mConnectAnims[0] = smallAlphaAnim;
            smallAlphaAnim.setDuration(1500L);
            smallAlphaAnim.setRepeatCount(-1);
            smallAlphaAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float alpha = ((Float)animation.getAnimatedValue()).floatValue();
                    IDRWakeWaitView.this.mImgLeftS.setAlpha(alpha);
                    IDRWakeWaitView.this.mImgRightS.setAlpha(alpha);
                }
            });
            AnimatorSet animatorSet = new AnimatorSet();
            ValueAnimator bigShowAlphaAnim = ValueAnimator.ofFloat((float[])new float[]{0.4f, 1.0f});
            bigShowAlphaAnim.setDuration(200L);
            ValueAnimator bigHideAlphaAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
            bigHideAlphaAnim.setDuration(1300L);
            bigHideAlphaAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float alpha = ((Float)animation.getAnimatedValue()).floatValue();
                    IDRWakeWaitView.this.mImgRightB.setAlpha(alpha);
                    IDRWakeWaitView.this.mImgLeftB.setAlpha(alpha);
                }
            });
            animatorSet.playSequentially(new Animator[]{bigShowAlphaAnim, bigHideAlphaAnim});
            animatorSet.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    IDRWakeWaitView.this.mConnectAnims[1].start();
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.mConnectAnims[1] = animatorSet;
        }
        this.mImgLeftS.setVisibility(0);
        this.mImgLeftB.setAlpha(0.0f);
        this.mImgLeftB.setVisibility(0);
        this.mImgRightS.setVisibility(0);
        this.mImgRightB.setAlpha(0.0f);
        this.mImgRightB.setVisibility(0);
        this.mConnectAnims[0].start();
        this.mConnectAnims[1].start();
    }

    private void stopConnectAnim() {
        if (this.mConnectAnims != null) {
            this.mConnectAnims[0].cancel();
            this.mConnectAnims[1].cancel();
        }
        this.mImgLeftS.setVisibility(4);
        this.mImgLeftB.setVisibility(4);
        this.mImgRightS.setVisibility(4);
        this.mImgRightB.setVisibility(4);
    }

    public void dismiss() {
        if (!this.isShow) {
            return;
        }
        this.isShow = false;
        this.mHandler.removeCallbacksAndMessages(null);
        this.stopWeakAnim();
        this.stopConnectAnim();
        if (this.mRootView == null || this.mRootView.get() == null) {
            return;
        }
        ((ViewGroup)this.mRootView.get()).removeView((View)this.mViewGroup);
    }

    public void destroy() {
        this.isShow = false;
        this.mHandler.removeCallbacksAndMessages(null);
        this.stopWeakAnim();
        this.stopConnectAnim();
        if (this.mRootView == null || this.mRootView.get() == null) {
            return;
        }
        ((ViewGroup)this.mRootView.get()).removeView((View)this.mViewGroup);
        this.mRootView.clear();
        this.mRootView = null;
    }
}

