/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.dialog;

import android.app.AlertDialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import demo.xm.com.libxmfunsdk.R;
import java.util.ArrayList;
import java.util.List;

public class UpdateTipDialog
implements View.OnClickListener {
    private AlertDialog mDialog;
    private View mCustomDlgView;
    private LayoutInflater mInflater;
    private ListView mContentListView;
    private DialogContentAdapter mAdapter;
    private List<String> mContentList;
    private ViewHolder mDialogHolder;
    private boolean mSubTitleEnable = true;
    private boolean mContentTipEnable = false;
    View.OnTouchListener mTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case 1: 
                case 3: {
                    UpdateTipDialog.this.setOverLayEnable(v, false);
                    break;
                }
                case 0: 
                case 2: {
                    UpdateTipDialog.this.setOverLayEnable(v, true);
                    break;
                }
            }
            return false;
        }
    };
    OnUpdateDialogClickListener mListener;

    public UpdateTipDialog(Context ctx) {
        this.mInflater = LayoutInflater.from((Context)ctx);
        this.mCustomDlgView = this.mInflater.inflate(R.layout.funsdk_update_tip_dlg, null);
        this.mContentList = new ArrayList<String>();
        this.init(ctx);
    }

    private void init(Context ctx) {
        AlertDialog.Builder builder = new AlertDialog.Builder(ctx);
        builder.setView(this.mCustomDlgView);
        this.mContentListView = (ListView)this.mCustomDlgView.findViewById(R.id.dlg_content_list);
        this.mAdapter = new DialogContentAdapter();
        this.mContentListView.setAdapter((ListAdapter)this.mAdapter);
        this.mDialog = builder.create();
        this.mDialogHolder = new ViewHolder();
    }

    public void addContent(String content) {
        this.mContentList.add(content);
    }

    public void addContent(List<String> content) {
        this.mContentList = content;
    }

    public void setThemeColor(int color2) {
        this.mDialogHolder.line.setBackgroundColor(color2);
        this.mDialogHolder.titleText.setTextColor(color2);
    }

    public void setTitle(String title) {
        this.mDialogHolder.titleText.setText((CharSequence)title);
    }

    public void setSubTitleEnable(boolean enable) {
        this.mSubTitleEnable = enable;
        this.mDialogHolder.subTitle.setVisibility(enable ? 0 : 8);
    }

    public boolean getSubTitleEnable() {
        return this.mSubTitleEnable;
    }

    public void setContentTipEnable(boolean enable) {
        this.mContentTipEnable = enable;
        this.mAdapter.notifyDataSetChanged();
    }

    public boolean getContentTipEnable() {
        return this.mContentTipEnable;
    }

    private void setNagetiveButtonEnable(boolean enable) {
        this.mDialogHolder.nagetiveButton.setEnabled(enable);
    }

    public void setPositiveButtonEnable(boolean enable) {
        this.mDialogHolder.positiveButton.setEnabled(enable);
    }

    public void setNagetiveButton(String text) {
        this.mDialogHolder.nagetiveButton.setText((CharSequence)text);
    }

    public void setPositiveButton(String text) {
        this.mDialogHolder.positiveButton.setText((CharSequence)text);
    }

    public void show() {
        if (this.mDialog != null) {
            this.mDialog.show();
        }
    }

    public void dimiss() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    private void setOverLayEnable(View view, boolean b) {
        if (view == this.mDialogHolder.nagetiveButton) {
            this.mDialogHolder.nagetiveButtonOverlay.setVisibility(b ? 0 : 4);
        } else if (view == this.mDialogHolder.positiveButton) {
            this.mDialogHolder.positiveButtonOverlay.setVisibility(b ? 0 : 4);
        }
    }

    public void setOnUpdateDialogClickListener(OnUpdateDialogClickListener ls) {
        this.mListener = ls;
    }

    public void onClick(View v) {
        this.dimiss();
        if (this.mListener == null) {
            return;
        }
        if (v == this.mDialogHolder.nagetiveButton) {
            this.mListener.OnCanel();
        }
        if (v == this.mDialogHolder.positiveButton) {
            this.mListener.OnCommit();
        }
    }

    public static interface OnUpdateDialogClickListener {
        public void OnCanel();

        public void OnCommit();
    }

    class DialogContentAdapter
    extends BaseAdapter {
        DialogContentAdapter() {
        }

        public int getCount() {
            return UpdateTipDialog.this.mContentList == null ? 0 : UpdateTipDialog.this.mContentList.size();
        }

        public Object getItem(int position) {
            return UpdateTipDialog.this.mContentList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            TextView itemContentTv = null;
            ImageView itemTip = null;
            if (convertView == null) {
                convertView = UpdateTipDialog.this.mInflater.inflate(R.layout.funsdk_dlg_content_item, null);
                itemContentTv = (TextView)convertView.findViewById(R.id.dlg_content_item_text);
                itemTip = (ImageView)convertView.findViewById(R.id.dlg_content_tip);
                convertView.setTag(R.id.dlg_content_item_text, (Object)itemContentTv);
                convertView.setTag(R.id.dlg_content_tip, (Object)itemTip);
            } else {
                itemContentTv = (TextView)convertView.getTag(R.id.dlg_content_item_text);
                itemTip = (ImageView)convertView.getTag(R.id.dlg_content_tip);
            }
            itemContentTv.setText((CharSequence)UpdateTipDialog.this.mContentList.get(position));
            itemTip.setVisibility(UpdateTipDialog.this.mContentTipEnable ? 0 : 8);
            return convertView;
        }
    }

    class ViewHolder {
        RelativeLayout titelLayout;
        View line;
        TextView titleText;
        TextView subTitle;
        TextView nagetiveButton;
        TextView nagetiveButtonOverlay;
        TextView positiveButton;
        TextView positiveButtonOverlay;

        public ViewHolder() {
            this.titelLayout = (RelativeLayout)UpdateTipDialog.this.mCustomDlgView.findViewById(R.id.dlg_top_rl);
            this.line = UpdateTipDialog.this.mCustomDlgView.findViewById(R.id.dlg_top_line);
            this.titleText = (TextView)UpdateTipDialog.this.mCustomDlgView.findViewById(R.id.dlg_top_title);
            this.subTitle = (TextView)UpdateTipDialog.this.mCustomDlgView.findViewById(R.id.dlg_subtitle);
            this.subTitle.setVisibility(UpdateTipDialog.this.mSubTitleEnable ? 0 : 8);
            this.nagetiveButton = (TextView)UpdateTipDialog.this.mCustomDlgView.findViewById(R.id.nagative_button);
            this.nagetiveButtonOverlay = (TextView)UpdateTipDialog.this.mCustomDlgView.findViewById(R.id.nagative_button_overlay);
            this.positiveButton = (TextView)UpdateTipDialog.this.mCustomDlgView.findViewById(R.id.positive_button);
            this.positiveButtonOverlay = (TextView)UpdateTipDialog.this.mCustomDlgView.findViewById(R.id.positive_button_overlay);
            this.positiveButton.setOnClickListener((View.OnClickListener)UpdateTipDialog.this);
            this.nagetiveButton.setOnClickListener((View.OnClickListener)UpdateTipDialog.this);
            this.nagetiveButton.setOnTouchListener(UpdateTipDialog.this.mTouchListener);
            this.positiveButton.setOnTouchListener(UpdateTipDialog.this.mTouchListener);
        }
    }
}

