/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.lib.FunSDK;
import com.utils.XUtils;
import com.xm.ui.widget.ButtonCheck;
import com.xm.ui.widget.UserPassEditText;
import demo.xm.com.libxmfunsdk.R;

public class XMPwdEditText
extends LinearLayout {
    private String editHint = "";
    private String editText = "";
    private String editAfterAnimationHint = "";
    private int editShowPwdSrcNorId;
    private int editShowPwdSrcSelId;
    private int editHintColorId;
    private int editTextColorId;
    private int inputMaxLength;
    private float editTextSize;
    private float editHeight;
    private boolean isHintAnimation;
    private UserPassEditText etPwd;
    private ButtonCheck btnShowPwd;
    private XMPwdEditText linkPwdEditText;
    private TextView tvHintAnimation;
    private TextView tvHint;
    private TextView tvHintFixed;

    public XMPwdEditText(Context context) {
        this(context, null);
    }

    public XMPwdEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public XMPwdEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        LayoutInflater.from((Context)context).inflate(R.layout.funsdk_layout_xm_pwd_edittext, (ViewGroup)this, true);
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.XMPwdEditText);
        this.editHeight = params.getDimension(R.styleable.XMPwdEditText_editHeight, (float)XUtils.dp2px(context, 49));
        this.editHint = params.getString(R.styleable.XMPwdEditText_android_hint);
        this.editHintColorId = params.getColor(R.styleable.XMPwdEditText_android_textColorHint, context.getResources().getColor(R.color.hint_color));
        this.editShowPwdSrcNorId = params.getResourceId(R.styleable.XMPwdEditText_rightSrcNor, R.drawable.icon_pwd_hide_nor);
        this.editShowPwdSrcSelId = params.getResourceId(R.styleable.XMPwdEditText_rightSrcSel, R.drawable.icon_pwd_hide_sel);
        this.editText = params.getString(R.styleable.XMPwdEditText_android_text);
        this.editTextColorId = params.getColor(R.styleable.XMPwdEditText_android_textColor, context.getResources().getColor(R.color.default_normal_text_color));
        this.editTextSize = params.getDimension(R.styleable.XMPwdEditText_android_textSize, (float)XUtils.sp2px(context, 12.0f));
        this.isHintAnimation = params.getBoolean(R.styleable.XMPwdEditText_hintAnimation, false);
        this.editAfterAnimationHint = params.getString(R.styleable.XMPwdEditText_afterAnimationHint);
        this.inputMaxLength = params.getInteger(R.styleable.XMPwdEditText_android_maxLength, 256);
        params.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initView();
        this.initData();
        this.initListener();
    }

    private void initView() {
        this.etPwd = (UserPassEditText)this.findViewById(R.id.et_pwd);
        this.btnShowPwd = (ButtonCheck)this.findViewById(R.id.btn_show_pwd);
        this.tvHint = (TextView)this.findViewById(R.id.tv_hint);
        this.tvHintAnimation = (TextView)this.findViewById(R.id.tv_hint_animation);
        this.tvHintFixed = (TextView)this.findViewById(R.id.tv_hint_fixed);
    }

    private void initData() {
        this.etPwd.setText(this.editText);
        this.etPwd.setTextColor(this.editTextColorId);
        this.etPwd.setTextSize(0, this.editTextSize);
        this.etPwd.setHint(FunSDK.TS((String)this.editHint));
        this.etPwd.setHintTextColor(this.editHintColorId);
        this.etPwd.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.inputMaxLength)});
        this.tvHint.setText((CharSequence)FunSDK.TS((String)this.editHint));
        this.tvHintAnimation.setText((CharSequence)FunSDK.TS((String)this.editHint));
        ViewGroup.LayoutParams layoutParams = this.etPwd.getLayoutParams();
        if (layoutParams != null) {
            layoutParams.height = (int)this.editHeight;
        }
        this.btnShowPwd.setNormalBg(this.editShowPwdSrcNorId);
        this.btnShowPwd.setSelectedBg(this.editShowPwdSrcSelId);
    }

    private void initListener() {
        this.btnShowPwd.setOnButtonClick(new ButtonCheck.OnButtonClickListener(){

            public boolean onButtonClick(ButtonCheck bc, boolean bBeforeChecked) {
                XMPwdEditText.this.changeEditText(!bBeforeChecked);
                if (XMPwdEditText.this.linkPwdEditText != null) {
                    XMPwdEditText.this.linkPwdEditText.showPwd(!bBeforeChecked);
                }
                return true;
            }
        });
        this.etPwd.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                XMPwdEditText.this.changeHint();
                return false;
            }
        });
    }

    private void changeHint() {
        if (!this.isHintAnimation) {
            return;
        }
        if (this.tvHint.getVisibility() != 0) {
            this.tvHint.setVisibility(0);
            final AnimationSet animationSet = new AnimationSet(true);
            TranslateAnimation translateAnimation = new TranslateAnimation((float)this.tvHintAnimation.getLeft(), (float)this.tvHint.getLeft(), (float)(this.tvHintAnimation.getTop() + this.tvHintAnimation.getHeight()), 0.0f);
            AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
            animationSet.addAnimation((Animation)translateAnimation);
            animationSet.addAnimation((Animation)alphaAnimation);
            animationSet.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
            animationSet.setDuration(1000L);
            animationSet.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    if (!TextUtils.isEmpty((CharSequence)XMPwdEditText.this.editAfterAnimationHint)) {
                        XMPwdEditText.this.etPwd.setHint(FunSDK.TS((String)XMPwdEditText.this.editAfterAnimationHint));
                        String hint = String.format("%s(%s)", FunSDK.TS((String)XMPwdEditText.this.editHint), FunSDK.TS((String)XMPwdEditText.this.editAfterAnimationHint));
                        XMPwdEditText.this.tvHint.setText((CharSequence)hint);
                        XMPwdEditText.this.tvHintFixed.setText((CharSequence)hint);
                    }
                }

                public void onAnimationEnd(Animation animation) {
                    animationSet.cancel();
                    XMPwdEditText.this.tvHint.clearAnimation();
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            animationSet.setFillAfter(true);
            this.tvHint.startAnimation((Animation)animationSet);
        }
    }

    public void setEditHint(String hint) {
        this.editHint = hint;
        this.etPwd.setHint(hint);
    }

    public void setEditHintColor(int colorId) {
        this.editHintColorId = colorId;
        this.etPwd.setTextColor(this.editHintColorId);
    }

    public void setEditText(String editText) {
        this.editText = editText;
        this.etPwd.setText(editText);
    }

    public String getEditText() {
        return this.etPwd.getText().toString().trim();
    }

    public void setEditTextSize(int textSize) {
        this.editTextSize = textSize;
        this.etPwd.setTextSize(this.editTextSize);
    }

    public void setEditTextColor(int colorId) {
        this.editTextColorId = colorId;
        this.etPwd.setTextColor(this.editTextColorId);
    }

    public void setEditShowPwdSrcNorId(int srcId) {
        this.editShowPwdSrcNorId = srcId;
        this.btnShowPwd.setNormalBg(srcId);
    }

    public void setEditShowPwdSrcSelId(int srcId) {
        this.editShowPwdSrcSelId = srcId;
        this.btnShowPwd.setSelectedBg(srcId);
    }

    public void showPwd(boolean isShow) {
        if (isShow) {
            this.btnShowPwd.setBtnValue(1);
        } else {
            this.btnShowPwd.setBtnValue(0);
        }
        this.changeEditText(isShow);
    }

    private void changeEditText(boolean isShow) {
        if (this.etPwd == null) {
            return;
        }
        if (this.etPwd.getTransformationMethod() == null && !isShow) {
            this.etPwd.setTransformationMethod((TransformationMethod)new PasswordTransformationMethod());
            this.etPwd.setSelection(this.etPwd.getText().toString().length());
        } else if (isShow) {
            this.etPwd.setTransformationMethod(null);
            this.etPwd.setSelection(this.etPwd.getText().toString().length());
        }
    }

    public void addTextChangedListener(TextWatcher textWatcher) {
        if (this.etPwd != null && textWatcher != null) {
            this.etPwd.addTextChangedListener(textWatcher);
        }
    }

    public void linkOtherPwdEditText(XMPwdEditText xmPwdEditText) {
        this.linkPwdEditText = xmPwdEditText;
    }
}

