/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import java.util.ArrayList;
import java.util.List;

public class TreeNode {
    private TreeNode parent = null;
    private List<TreeNode> children = null;
    private String name = null;
    private Object value = null;
    private boolean isLeaf = false;
    private boolean isExpanded = false;
    private int icon = -1;
    private int iconForExpandedOrFolded = -1;
    private int iconForExpanding = -1;
    private int iconForFolding = -1;
    private boolean tableItemOrNot = false;

    public TreeNode(TreeNode parent, String title, int icon, Object userData, int exIcon, int foIcon) {
        this.InitParam(parent, title, userData, icon, exIcon, foIcon);
    }

    public TreeNode(TreeNode parent, String title, int icon) {
        this.InitParam(parent, title, null, icon, -1, -1);
    }

    public TreeNode(TreeNode parent, String title, int icon, Object userData) {
        this.InitParam(parent, title, userData, icon, -1, -1);
    }

    public void InitParam(TreeNode parent, String title, Object userData, int icon, int exIcon, int foIcon) {
        if (parent != null) {
            parent.addChildNode(this);
        }
        this.parent = parent;
        this.name = title;
        this.value = userData;
        this.isLeaf = true;
        this.icon = icon;
        if (exIcon == -1) {
            if (parent != null) {
                this.iconForExpanding = parent.iconForExpanding;
            }
        } else {
            this.iconForExpanding = exIcon;
        }
        if (foIcon == -1) {
            if (parent != null) {
                this.iconForFolding = parent.iconForFolding;
            }
        } else {
            this.iconForFolding = foIcon;
        }
    }

    public void setTableItemOrNot(boolean tableItemOrNot) {
        this.tableItemOrNot = tableItemOrNot;
    }

    public boolean getTableItemOrNot() {
        return this.tableItemOrNot;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setIcon(int icon) {
        this.icon = icon;
    }

    public int getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.name;
    }

    public boolean isLeafOrNot() {
        return this.isLeaf;
    }

    public int getLevel() {
        return this.parent == null ? 0 : this.parent.getLevel() + 1;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public boolean getExpanded() {
        return this.isExpanded;
    }

    private void addChildNode(TreeNode child) {
        if (this.children == null) {
            this.isLeaf = false;
            this.children = new ArrayList<TreeNode>();
        }
        this.children.add(child);
    }

    public void clearChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    public boolean isRoot() {
        return this.parent.equals(null);
    }

    public void setExpandIcon(int expand) {
        this.iconForExpanding = expand;
    }

    public void setFoldIcon(int fold) {
        this.iconForFolding = fold;
    }

    public int getExpandOrFoldIcon() {
        if (this.isExpanded) {
            return this.iconForExpanding;
        }
        return this.iconForFolding;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }
}

