/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import com.utils.XUtils;
import com.xm.ui.widget.data.PercentStyle;
import demo.xm.com.libxmfunsdk.R;
import java.text.DecimalFormat;

public class SquareProgressView
extends View {
    private double progress;
    private final Paint progressBarPaint;
    private final Paint outlinePaint;
    private final Paint textPaint;
    private float widthInDp = 10.0f;
    private float strokewidth = 0.0f;
    private Canvas canvas;
    private boolean outline = false;
    private boolean startline = false;
    private boolean showProgress = false;
    private PercentStyle percentSettings = new PercentStyle(Paint.Align.CENTER, 150.0f, true);
    private boolean clearOnHundred = false;

    public SquareProgressView(Context context) {
        super(context);
        this.progressBarPaint = new Paint();
        this.progressBarPaint.setColor(context.getResources().getColor(17170453));
        this.progressBarPaint.setStrokeWidth((float)XUtils.convertDpToPx(this.widthInDp, this.getContext()));
        this.progressBarPaint.setAntiAlias(true);
        this.progressBarPaint.setStyle(Paint.Style.STROKE);
        this.outlinePaint = new Paint();
        this.outlinePaint.setColor(context.getResources().getColor(17170444));
        this.outlinePaint.setStrokeWidth(1.0f);
        this.outlinePaint.setAntiAlias(true);
        this.outlinePaint.setStyle(Paint.Style.STROKE);
        this.textPaint = new Paint();
        this.textPaint.setColor(context.getResources().getColor(R.color.black));
        this.textPaint.setAntiAlias(true);
        this.textPaint.setStyle(Paint.Style.STROKE);
    }

    public SquareProgressView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.progressBarPaint = new Paint();
        this.progressBarPaint.setColor(context.getResources().getColor(17170453));
        this.progressBarPaint.setStrokeWidth((float)XUtils.convertDpToPx(this.widthInDp, this.getContext()));
        this.progressBarPaint.setAntiAlias(true);
        this.progressBarPaint.setStyle(Paint.Style.STROKE);
        this.outlinePaint = new Paint();
        this.outlinePaint.setColor(context.getResources().getColor(17170444));
        this.outlinePaint.setStrokeWidth(1.0f);
        this.outlinePaint.setAntiAlias(true);
        this.outlinePaint.setStyle(Paint.Style.STROKE);
        this.textPaint = new Paint();
        this.textPaint.setColor(context.getResources().getColor(R.color.black));
        this.textPaint.setAntiAlias(true);
        this.textPaint.setStyle(Paint.Style.STROKE);
    }

    public SquareProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.progressBarPaint = new Paint();
        this.progressBarPaint.setColor(context.getResources().getColor(17170453));
        this.progressBarPaint.setStrokeWidth((float)XUtils.convertDpToPx(this.widthInDp, this.getContext()));
        this.progressBarPaint.setAntiAlias(true);
        this.progressBarPaint.setStyle(Paint.Style.STROKE);
        this.outlinePaint = new Paint();
        this.outlinePaint.setColor(context.getResources().getColor(17170444));
        this.outlinePaint.setStrokeWidth(1.0f);
        this.outlinePaint.setAntiAlias(true);
        this.outlinePaint.setStyle(Paint.Style.STROKE);
        this.textPaint = new Paint();
        this.textPaint.setColor(context.getResources().getColor(R.color.black));
        this.textPaint.setAntiAlias(true);
        this.textPaint.setStyle(Paint.Style.STROKE);
    }

    protected void onDraw(Canvas canvas) {
        this.canvas = canvas;
        super.onDraw(canvas);
        this.strokewidth = XUtils.convertDpToPx(this.widthInDp, this.getContext());
        float scope = canvas.getWidth() + canvas.getHeight() + canvas.getHeight() + canvas.getWidth();
        float percent = scope / 100.0f * Float.valueOf(String.valueOf(this.progress)).floatValue();
        float halfOfTheImage = canvas.getWidth() / 2;
        if (this.outline) {
            this.drawOutline();
        }
        if (this.isStartline()) {
            this.drawStartline();
        }
        if (this.showProgress) {
            this.drawPercent(this.percentSettings);
        }
        if (this.clearOnHundred && this.progress == 100.0) {
            return;
        }
        Path path = new Path();
        if (percent > halfOfTheImage) {
            this.paintFirstHalfOfTheTop(canvas);
            float second = percent - halfOfTheImage;
            if (second > (float)canvas.getHeight()) {
                this.paintRightSide(canvas);
                float third = second - (float)canvas.getHeight();
                if (third > (float)canvas.getWidth()) {
                    this.paintBottomSide(canvas);
                    float forth = third - (float)canvas.getWidth();
                    if (forth > (float)canvas.getHeight()) {
                        this.paintLeftSide(canvas);
                        float fifth = forth - (float)canvas.getHeight();
                        if (fifth == halfOfTheImage) {
                            this.paintSecondHalfOfTheTop(canvas);
                        } else {
                            path.moveTo(this.strokewidth, this.strokewidth / 2.0f);
                            path.lineTo(this.strokewidth + fifth, this.strokewidth / 2.0f);
                            canvas.drawPath(path, this.progressBarPaint);
                        }
                    } else {
                        path.moveTo(this.strokewidth / 2.0f, (float)canvas.getHeight() - this.strokewidth);
                        path.lineTo(this.strokewidth / 2.0f, (float)canvas.getHeight() - forth);
                        canvas.drawPath(path, this.progressBarPaint);
                    }
                } else {
                    path.moveTo((float)canvas.getWidth() - this.strokewidth, (float)canvas.getHeight() - this.strokewidth / 2.0f);
                    path.lineTo((float)canvas.getWidth() - third, (float)canvas.getHeight() - this.strokewidth / 2.0f);
                    canvas.drawPath(path, this.progressBarPaint);
                }
            } else {
                path.moveTo((float)canvas.getWidth() - this.strokewidth / 2.0f, this.strokewidth);
                path.lineTo((float)canvas.getWidth() - this.strokewidth / 2.0f, this.strokewidth + second);
                canvas.drawPath(path, this.progressBarPaint);
            }
        } else {
            path.moveTo(halfOfTheImage, this.strokewidth / 2.0f);
            path.lineTo(halfOfTheImage + percent, this.strokewidth / 2.0f);
            canvas.drawPath(path, this.progressBarPaint);
        }
    }

    private void drawStartline() {
        Path outlinePath = new Path();
        outlinePath.moveTo((float)(this.canvas.getWidth() / 2), 0.0f);
        outlinePath.lineTo((float)(this.canvas.getWidth() / 2), this.strokewidth);
        this.canvas.drawPath(outlinePath, this.outlinePaint);
    }

    private void drawOutline() {
        Path outlinePath = new Path();
        outlinePath.moveTo(0.0f, 0.0f);
        outlinePath.lineTo((float)this.canvas.getWidth(), 0.0f);
        outlinePath.lineTo((float)this.canvas.getWidth(), (float)this.canvas.getHeight());
        outlinePath.lineTo(0.0f, (float)this.canvas.getHeight());
        outlinePath.lineTo(0.0f, 0.0f);
        this.canvas.drawPath(outlinePath, this.outlinePaint);
    }

    public void paintFirstHalfOfTheTop(Canvas canvas) {
        Path path = new Path();
        path.moveTo((float)(canvas.getWidth() / 2), this.strokewidth / 2.0f);
        path.lineTo((float)canvas.getWidth() + this.strokewidth, this.strokewidth / 2.0f);
        canvas.drawPath(path, this.progressBarPaint);
    }

    public void paintRightSide(Canvas canvas) {
        Path path = new Path();
        path.moveTo((float)canvas.getWidth() - this.strokewidth / 2.0f, this.strokewidth);
        path.lineTo((float)canvas.getWidth() - this.strokewidth / 2.0f, (float)canvas.getHeight());
        canvas.drawPath(path, this.progressBarPaint);
    }

    public void paintBottomSide(Canvas canvas) {
        Path path = new Path();
        path.moveTo((float)canvas.getWidth() - this.strokewidth, (float)canvas.getHeight() - this.strokewidth / 2.0f);
        path.lineTo(0.0f, (float)canvas.getHeight() - this.strokewidth / 2.0f);
        canvas.drawPath(path, this.progressBarPaint);
    }

    public void paintLeftSide(Canvas canvas) {
        Path path = new Path();
        path.moveTo(this.strokewidth / 2.0f, (float)canvas.getHeight() - this.strokewidth);
        path.lineTo(this.strokewidth / 2.0f, 0.0f);
        canvas.drawPath(path, this.progressBarPaint);
    }

    public void paintSecondHalfOfTheTop(Canvas canvas) {
        Path path = new Path();
        path.moveTo(this.strokewidth, this.strokewidth / 2.0f);
        path.lineTo((float)(canvas.getWidth() / 2), this.strokewidth / 2.0f);
        canvas.drawPath(path, this.progressBarPaint);
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
        this.invalidate();
    }

    public void setColor(int color2) {
        this.progressBarPaint.setColor(color2);
        this.invalidate();
    }

    public float getWidthInDp() {
        return this.widthInDp;
    }

    public void setWidthInDp(int width) {
        this.widthInDp = width;
        this.progressBarPaint.setStrokeWidth((float)XUtils.convertDpToPx(this.widthInDp, this.getContext()));
        this.invalidate();
    }

    public boolean isOutline() {
        return this.outline;
    }

    public void setOutline(boolean outline) {
        this.outline = outline;
        this.invalidate();
    }

    public boolean isStartline() {
        return this.startline;
    }

    public void setStartline(boolean startline) {
        this.startline = startline;
        this.invalidate();
    }

    private void drawPercent(PercentStyle setting) {
        this.textPaint.setTextAlign(setting.getAlign());
        if (setting.getTextSize() == 0.0f) {
            this.textPaint.setTextSize((float)(this.canvas.getHeight() / 10 * 4));
        } else {
            this.textPaint.setTextSize(setting.getTextSize());
        }
        String percentString = new DecimalFormat("###").format(this.getProgress());
        if (setting.isPercentSign()) {
            percentString = percentString + this.percentSettings.getCustomText();
        }
        this.textPaint.setColor(this.percentSettings.getTextColor());
        this.canvas.drawText(percentString, (float)(this.canvas.getWidth() / 2), (float)((int)((float)(this.canvas.getHeight() / 2) - (this.textPaint.descent() + this.textPaint.ascent()) / 2.0f)), this.textPaint);
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
        this.invalidate();
    }

    public void setPercentStyle(PercentStyle percentSettings) {
        this.percentSettings = percentSettings;
        this.invalidate();
    }

    public PercentStyle getPercentStyle() {
        return this.percentSettings;
    }

    public void setClearOnHundred(boolean clearOnHundred) {
        this.clearOnHundred = clearOnHundred;
        this.invalidate();
    }

    public boolean isClearOnHundred() {
        return this.clearOnHundred;
    }
}

