/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.utils.XUtils;
import com.xm.ui.widget.ButtonCheck;
import com.xm.ui.widget.SquareProgressView;
import com.xm.ui.widget.data.PercentStyle;
import demo.xm.com.libxmfunsdk.R;

public class SquareProgressBar
extends RelativeLayout
implements View.OnClickListener {
    private ImageView imageView;
    private SquareProgressView bar;
    private TextView mediaTypeTv;
    private ImageButton ivSlowPlay;
    private ImageButton ivFastPlay;
    private ImageButton ivNormalPlay;
    private ButtonCheck ivPlayState;
    private TextView tvTitleName;
    private boolean opacity = false;
    private boolean greyscale;
    private boolean isFadingOnProgress = false;
    RelativeLayout.LayoutParams mParams;
    public static final int SPEED_PLAY_NORMAL = 0;
    public static final int SPEED_PLAY_FAST = 1;
    public static final int SPEED_PLAY_SLOW = 2;
    private OnSpeedPlayBtnClickListener mSpeedPlayBtnClickLs;

    public SquareProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initLayout(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mParams != null) {
            this.setMeasuredDimension(this.mParams.width, this.mParams.height);
        }
    }

    public SquareProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initLayout(context);
    }

    public SquareProgressBar(Context context) {
        super(context);
        this.initLayout(context);
    }

    private void initLayout(Context context) {
        LayoutInflater mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        mInflater.inflate(R.layout.funsdk_widget_progressbarview, (ViewGroup)this, true);
        this.bar = (SquareProgressView)this.findViewById(R.id.squareProgressBar1);
        this.bar.bringToFront();
        this.imageView = (ImageView)this.findViewById(R.id.imageView1);
        this.mediaTypeTv = (TextView)this.findViewById(R.id.tv_file_list_media_type);
        this.ivPlayState = (ButtonCheck)this.findViewById(R.id.iv_file_list_play_state);
        this.tvTitleName = (TextView)this.findViewById(R.id.tv_file_list_title_name);
        this.ivSlowPlay = (ImageButton)this.findViewById(R.id.iv_file_list_slow_play);
        this.ivFastPlay = (ImageButton)this.findViewById(R.id.iv_file_list_fast_play);
        this.ivNormalPlay = (ImageButton)this.findViewById(R.id.iv_file_list_normal_play);
        this.ivSlowPlay.setImageResource(R.drawable.ic_video_slowplay);
        this.ivFastPlay.setImageResource(R.drawable.ic_video_fastplay);
        this.ivNormalPlay.setImageResource(R.drawable.playback_play_normal);
        this.ivSlowPlay.setOnClickListener((View.OnClickListener)this);
        this.ivFastPlay.setOnClickListener((View.OnClickListener)this);
        this.ivNormalPlay.setOnClickListener((View.OnClickListener)this);
        this.ivPlayState.setNormalBg(R.drawable.playback_play_sel);
        this.ivPlayState.setClickable(false);
    }

    public ImageView getImageView() {
        return this.imageView;
    }

    public void setImageBitmap(Bitmap bm) {
        this.imageView = (ImageView)this.findViewById(R.id.imageView1);
        this.imageView.setImageBitmap(bm);
    }

    public void setImageResource(int resId) {
        this.imageView = (ImageView)this.findViewById(R.id.imageView1);
        this.imageView.setImageResource(resId);
    }

    public void setBackground(int background) {
        this.imageView = (ImageView)this.findViewById(R.id.imageView1);
        this.imageView.setBackgroundResource(background);
    }

    public void setViewWidth(int width) {
        if (null != this.imageView) {
            this.mParams = (RelativeLayout.LayoutParams)this.imageView.getLayoutParams();
            this.mParams.width = width;
        }
    }

    public void setViewHeight(int height) {
        if (null != this.imageView) {
            this.mParams = (RelativeLayout.LayoutParams)this.imageView.getLayoutParams();
            this.mParams.height = height;
        }
    }

    public void setImageScaleType(ImageView.ScaleType scale) {
        this.imageView.setScaleType(scale);
    }

    public void setProgress(double progress) {
        this.bar.setProgress(progress);
        if (this.opacity) {
            if (this.isFadingOnProgress) {
                this.setOpacity(100 - (int)progress);
            } else {
                this.setOpacity((int)progress);
            }
        } else {
            this.setOpacity(100);
        }
    }

    public void setHoloColor(int androidHoloColor) {
        this.bar.setColor(this.getContext().getResources().getColor(androidHoloColor));
    }

    public void setColor(String colorString) {
        this.bar.setColor(Color.parseColor((String)colorString));
    }

    public void setColorRGB(int r, int g, int b) {
        this.bar.setColor(Color.rgb((int)r, (int)g, (int)b));
    }

    public void setColorRGB(int rgb) {
        this.bar.setColor(rgb);
    }

    public void setWidth(int width) {
        int padding = XUtils.convertDpToPx(width, this.getContext());
        this.imageView.setPadding(padding, padding, padding, padding);
        this.bar.setWidthInDp(width);
    }

    private void setOpacity(int progress) {
        this.imageView.setAlpha((int)(2.55 * (double)progress));
    }

    public void setOpacity(boolean opacity) {
        this.opacity = opacity;
        this.setProgress(this.bar.getProgress());
    }

    public void setOpacity(boolean opacity, boolean isFadingOnProgress) {
        this.opacity = opacity;
        this.isFadingOnProgress = isFadingOnProgress;
        this.setProgress(this.bar.getProgress());
    }

    public void setImageGrayscale(boolean greyscale) {
        this.greyscale = greyscale;
        if (greyscale) {
            ColorMatrix matrix = new ColorMatrix();
            matrix.setSaturation(0.0f);
            this.imageView.setColorFilter((ColorFilter)new ColorMatrixColorFilter(matrix));
        } else {
            this.imageView.setColorFilter(null);
        }
    }

    public boolean isOpacity() {
        return this.opacity;
    }

    public boolean isGreyscale() {
        return this.greyscale;
    }

    public void drawOutline(boolean drawOutline) {
        this.bar.setOutline(drawOutline);
    }

    public boolean isOutline() {
        return this.bar.isOutline();
    }

    public void drawStartline(boolean drawStartline) {
        this.bar.setStartline(drawStartline);
    }

    public boolean isStartline() {
        return this.bar.isStartline();
    }

    public void showProgress(boolean showProgress) {
        this.bar.setShowProgress(showProgress);
    }

    public boolean isShowProgress() {
        return this.bar.isShowProgress();
    }

    public void setPercentStyle(PercentStyle percentStyle) {
        this.bar.setPercentStyle(percentStyle);
    }

    public PercentStyle getPercentStyle() {
        return this.bar.getPercentStyle();
    }

    public void setClearOnHundred(boolean clearOnHundred) {
        this.bar.setClearOnHundred(clearOnHundred);
    }

    public boolean isClearOnHundred() {
        return this.bar.isClearOnHundred();
    }

    public void showBottomMsg() {
        this.mediaTypeTv.setVisibility(0);
    }

    public void hideBottomMsg() {
        this.mediaTypeTv.setVisibility(8);
    }

    public void showTitleName() {
        this.tvTitleName.setVisibility(0);
    }

    public void hideTitleName() {
        this.tvTitleName.setVisibility(8);
    }

    public void setTitleName(CharSequence text) {
        this.tvTitleName.setText(text);
    }

    public void setTitleName(int resid) {
        this.tvTitleName.setText(resid);
    }

    public CharSequence getTitleName() {
        return this.tvTitleName.getText();
    }

    public void setBottomText(CharSequence text) {
        this.mediaTypeTv.setText(text);
    }

    public void setBottomText(int resid) {
        this.mediaTypeTv.setText(resid);
    }

    public CharSequence getBottomText() {
        return this.mediaTypeTv.getText();
    }

    public void showPlayBtn() {
        this.ivPlayState.setVisibility(0);
    }

    public void hidePlayBtn() {
        this.ivPlayState.setVisibility(4);
    }

    public void setPlayBtnNormalSrc(int resId) {
        this.ivPlayState.setNormalBg(resId);
    }

    public void setPlayBtnSelectedSrc(int resId) {
        this.ivPlayState.setSelectedBg(resId);
    }

    public ButtonCheck getPlayBtn() {
        return this.ivPlayState;
    }

    public void showFastPlayBtn() {
        this.ivFastPlay.setVisibility(0);
    }

    public void hideFastPlayBtn() {
        this.ivFastPlay.setVisibility(8);
    }

    public void showSlowPlayBtn() {
        this.ivSlowPlay.setVisibility(0);
    }

    public void hideSlowPlayBtn() {
        this.ivSlowPlay.setVisibility(8);
    }

    public void showNormalPlayBtn() {
        this.ivNormalPlay.setVisibility(0);
    }

    public void hideNormalPlayBtn() {
        this.ivNormalPlay.setVisibility(8);
    }

    public void onClick(View v) {
        if (null != this.mSpeedPlayBtnClickLs) {
            if (v.getId() == R.id.iv_file_list_slow_play) {
                this.mSpeedPlayBtnClickLs.onSpeedPlay(2);
                this.showNormalPlayBtn();
            } else if (v.getId() == R.id.iv_file_list_fast_play) {
                this.mSpeedPlayBtnClickLs.onSpeedPlay(1);
                this.showNormalPlayBtn();
            } else if (v.getId() == R.id.iv_file_list_normal_play) {
                this.mSpeedPlayBtnClickLs.onSpeedPlay(0);
                this.hideNormalPlayBtn();
            }
        }
    }

    public void setOnSpeedPlayBtnClickListener(OnSpeedPlayBtnClickListener ls) {
        this.mSpeedPlayBtnClickLs = ls;
    }

    public static interface OnSpeedPlayBtnClickListener {
        public void onSpeedPlay(int var1);
    }
}

