/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import com.utils.XUtils;
import demo.xm.com.libxmfunsdk.R;
import io.reactivex.annotations.Nullable;

public class SimpleProgressBar
extends View {
    private int pbColorId;
    private int textColorId;
    private Paint paint;
    private Paint textPaint;
    private float progress;
    private String text = "";

    public SimpleProgressBar(Context context) {
        super(context);
        this.init(null, 0);
    }

    public SimpleProgressBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public SimpleProgressBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyle) {
        this.initAttributes(attrs, defStyle);
    }

    private void initAttributes(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.SimpleProgressBar, defStyle, 0);
        this.pbColorId = typedArray.getColor(R.styleable.SimpleProgressBar_PbColor, -65536);
        this.textColorId = typedArray.getColor(R.styleable.SimpleProgressBar_android_textColor, -16777216);
        this.text = typedArray.getString(R.styleable.SimpleProgressBar_android_text);
        typedArray.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.paint = new Paint();
        this.textPaint = new Paint();
        this.paint.setColor(this.pbColorId);
        this.paint.setStyle(Paint.Style.FILL);
        this.textPaint.setColor(this.textColorId);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setStrokeWidth(0.0f);
        this.textPaint.setTextSize((float)XUtils.dp2px(this.getContext(), 16));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.progress != 0.0f) {
            canvas.drawRect(0.0f, 0.0f, this.progress * (float)this.getWidth(), (float)this.getHeight(), this.paint);
        } else {
            canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.paint);
        }
        float textWidth = this.textPaint.measureText(this.text);
        float textHeight = this.textPaint.descent() - this.textPaint.ascent();
        canvas.drawText(this.text, ((float)this.getMeasuredWidth() - textWidth) / 2.0f, ((float)this.getMeasuredHeight() + textHeight) / 2.0f - this.textPaint.descent(), this.textPaint);
    }

    public int getTextColorId() {
        return this.textColorId;
    }

    public void setTextColorId(int textColorId) {
        this.textColorId = textColorId;
        this.textPaint.setColor(textColorId);
        this.invalidate();
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
        this.invalidate();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getPbColorId() {
        return this.pbColorId;
    }

    public void setPbColorId(int pbColorId) {
        this.pbColorId = pbColorId;
        this.paint.setColor(this.getResources().getColor(pbColorId));
        this.invalidate();
    }
}

