/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.widget.AppCompatImageView;
import com.utils.XUtils;
import com.xm.ui.widget.data.BubbleIndicator;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class PanoramaView
extends AppCompatImageView
implements View.OnTouchListener {
    private BubbleIndicator bubbleIndicator;
    private ArrayList<String> imgList;
    private boolean isPositiveSeq;
    private boolean isInit;
    private float touchX;
    private float touchY;
    private Bitmap bitmap;
    private int horSteps;
    private Paint paint;
    private int height;
    private String touchPicPath;
    private boolean isShowTouchFlag;
    private int picNum;
    private int position;
    private OnPanoramaViewListener listener;

    public PanoramaView(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public PanoramaView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public PanoramaView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.bubbleIndicator = new BubbleIndicator(context);
        this.bubbleIndicator.createImageViewFloater(context, attrs, defStyleAttr, "100");
        this.paint = new Paint();
        this.paint.setColor(-65536);
        this.paint.setStyle(Paint.Style.STROKE);
        this.setOnTouchListener(this);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isShowTouchFlag && this.getWidth() > 0 && this.picNum > 0) {
            int width = this.getWidth() / this.picNum;
            canvas.drawRect((float)(this.position * width), 0.0f, (float)((this.position + 1) * width), (float)this.getBottom(), this.paint);
        }
    }

    public void initPanoramaView(int picNum, int horSteps, int horStep) {
        this.picNum = picNum;
        this.horSteps = horSteps;
        if (this.isPositiveSeq) {
            this.position = horStep * picNum / horSteps;
            this.position = this.position >= picNum ? picNum - 1 : this.position;
        } else {
            this.position = picNum - horStep * picNum / horSteps;
            this.position = this.position >= picNum ? picNum - 1 : this.position;
        }
    }

    public void setBitmap(Bitmap bitmap) {
        this.bitmap = bitmap;
        if (bitmap != null) {
            this.setImageBitmap(bitmap);
        }
    }

    public void setImagePath(String panoramaFilePath) {
        if (panoramaFilePath != null && new File(panoramaFilePath).exists()) {
            this.bitmap = BitmapFactory.decodeFile((String)panoramaFilePath);
        }
        if (this.bitmap != null) {
            this.setImageBitmap(this.bitmap);
        }
    }

    public void setImagePath(ArrayList<String> imagePathList) {
        if (imagePathList != null && !imagePathList.isEmpty()) {
            this.imgList = (ArrayList)imagePathList.clone();
        }
    }

    private void createBitmaps(int panoramaWidth) {
        int i;
        if (this.imgList == null) {
            return;
        }
        this.picNum = this.imgList.size();
        Bitmap[] bitmaps = new Bitmap[this.picNum];
        int width = panoramaWidth / bitmaps.length;
        if (this.isPositiveSeq) {
            for (i = 0; i < this.picNum; ++i) {
                bitmaps[i] = PanoramaView.getDealWithBitmap(this.imgList.get(i), width, 0);
            }
        } else {
            for (i = this.picNum - 1; i >= 0; --i) {
                bitmaps[this.picNum - 1 - i] = PanoramaView.getDealWithBitmap(this.imgList.get(i), width, 0);
            }
        }
        this.height = bitmaps[0].getHeight();
        this.bitmap = Bitmap.createBitmap((int)panoramaWidth, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.bitmap);
        for (int i2 = 0; i2 < bitmaps.length; ++i2) {
            canvas.drawBitmap(bitmaps[i2], (float)(width * i2), 0.0f, null);
        }
        if (this.listener != null) {
            this.listener.onCreatePanorama(this.bitmap);
        }
    }

    public void compose(boolean positiveSeq, int panoramaWidth) {
        this.isPositiveSeq = positiveSeq;
        if (panoramaWidth != 0) {
            this.createBitmaps(panoramaWidth);
        }
        if (this.bitmap != null) {
            this.setImageBitmap(this.bitmap);
        }
    }

    public void compose(boolean positiveSeq) {
        this.isPositiveSeq = positiveSeq;
        if (this.getWidth() != 0) {
            this.createBitmaps(this.getWidth());
        }
        if (this.bitmap != null) {
            this.setImageBitmap(this.bitmap);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.bitmap != null) {
            this.bitmap.recycle();
            this.bitmap = null;
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (this.bitmap == null || this.horSteps == 0) {
            return false;
        }
        this.touchX = motionEvent.getX();
        this.touchY = motionEvent.getY();
        if (this.listener != null) {
            if (motionEvent.getAction() == 0) {
                this.listener.onStartTrackingTouch();
                if (this.isPositiveSeq) {
                    this.listener.onSeleted((int)(this.touchX * (float)this.horSteps / (float)this.getWidth()));
                } else {
                    this.listener.onSeleted(this.horSteps - (int)(this.touchX * (float)this.horSteps / (float)this.getWidth()));
                }
            } else if (motionEvent.getAction() == 3 || motionEvent.getAction() == 1) {
                this.listener.onStopTrackingTouch();
            } else if (this.isPositiveSeq) {
                this.listener.onSeleted((int)(this.touchX * (float)this.horSteps / (float)this.getWidth()));
            } else {
                this.listener.onSeleted(this.horSteps - (int)(this.touchX * (float)this.horSteps / (float)this.getWidth()));
            }
        }
        if (this.isShowTouchFlag) {
            this.position = (int)(this.touchX * (float)this.picNum / (float)this.getWidth());
            this.position = this.position >= this.picNum ? this.picNum - 1 : this.position;
            this.invalidate();
        }
        return true;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (!this.isInit) {
            if (this.getWidth() != 0 && this.bitmap == null) {
                this.createBitmaps(this.getWidth());
                if (this.bitmap != null) {
                    this.setImageBitmap(this.bitmap);
                }
            }
            this.isInit = true;
        }
    }

    public void setOnPanormaViewListener(OnPanoramaViewListener ls) {
        this.listener = ls;
    }

    public static Bitmap getDealWithBitmap(String imagePath, int width, int height) {
        Bitmap bitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
        int h = options.outHeight;
        int w = options.outWidth;
        if (width <= 0) {
            width = w;
        }
        if (height <= 0) {
            height = h;
        }
        int beWidth = w / width;
        int beHeight = h / height;
        int be = 1;
        be = beWidth > beHeight ? beWidth : beHeight;
        if (be <= 0) {
            be = 1;
        }
        options.inSampleSize = be;
        return BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
    }

    public static Bitmap getDealWithBitmap(String imagePath, int inSampleSize) {
        Bitmap bitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
        options.inSampleSize = inSampleSize;
        if (bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
        return BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
    }

    public boolean isEffective() {
        return this.bitmap != null;
    }

    public void setShowTouchFlag(boolean isShow) {
        this.isShowTouchFlag = isShow;
    }

    public void showIndicator(int direction) {
        this.bubbleIndicator.setDirection(direction);
        this.bubbleIndicator.showIndicator((View)this, this.touchX);
    }

    public void moveIndicator(String picPath) {
        if (picPath != null) {
            if (!StringUtils.contains((CharSequence)this.touchPicPath, (CharSequence)picPath)) {
                this.touchPicPath = picPath;
                Bitmap bitmap = PanoramaView.getDealWithBitmap(picPath, XUtils.dp2px(this.getContext(), 128), XUtils.dp2px(this.getContext(), 72));
                if (bitmap != null) {
                    this.bubbleIndicator.moveIndicator((int)this.touchX, bitmap);
                }
            } else {
                this.bubbleIndicator.moveIndicator((int)this.touchX);
            }
        }
    }

    public void moveIndicator(Bitmap bitmap) {
        this.bubbleIndicator.moveIndicator((int)this.touchX, bitmap);
    }

    public void hideIndicator() {
        this.bubbleIndicator.hideIndicator();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.bubbleIndicator.changeScreenSize(w, h);
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public static interface OnPanoramaViewListener {
        public void onStopTrackingTouch();

        public void onStartTrackingTouch();

        public void onSeleted(int var1);

        public void onCreatePanorama(Bitmap var1);
    }
}

