/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.lib.FunSDK;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.struct.SDK_FishEyeFrame;
import com.manager.device.fisheye.FishEyeParams;
import com.manager.device.fisheye.FishEyeVidType;
import com.vatics.dewarp.FecCenter;
import com.vatics.dewarp.GL2JNIView;
import com.xmgl.vrsoft.VRSoftGLView;
import demo.xm.com.libxmfunsdk.R;
import java.io.File;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class DisplayImageView
extends RelativeLayout {
    private static final String TAG = "DisplayImageView";
    public static final int GENERAL_PICTURE = 0;
    public static final int FISH_EYE_PICTURE = 1;
    private String filePath;
    private VRSoftGLView mVRSoftGLView;
    private ImageView mImageView;
    private boolean hasGestureOperate;
    private FishEyeParams fishEyeParams;
    private FecCenter fecCenter = null;
    private int mType = -1;
    private boolean showImageSuccess = false;
    private int mDefaultBackground;

    public DisplayImageView(Context context) {
        this(context, null);
    }

    public DisplayImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DisplayImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.DisplayImageView);
        this.mDefaultBackground = array.getResourceId(R.styleable.DisplayImageView_default_background, 17170443);
        this.init(this.getContext());
        array.recycle();
    }

    private void init(Context context) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        params.addRule(13);
        this.mVRSoftGLView = new VRSoftGLView(context);
        this.addView((View)this.mVRSoftGLView, (ViewGroup.LayoutParams)params);
        this.mVRSoftGLView.setDoubleTap(false);
        this.mImageView = new ImageView(context);
        this.addView((View)this.mImageView, (ViewGroup.LayoutParams)params);
        this.mImageView.setVisibility(8);
        this.mVRSoftGLView.setVisibility(8);
        this.mVRSoftGLView.setRendererCallback(new GLSurfaceView.Renderer(){

            public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            }

            public void onSurfaceChanged(GL10 gl, int width, int height) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        DisplayImageView.this.drawImage();
                    }
                });
            }

            public void onDrawFrame(GL10 gl) {
            }
        });
    }

    public void onResume() {
        if (null != this.mVRSoftGLView) {
            this.mVRSoftGLView.onResume();
        }
    }

    public void onPause() {
        if (null != this.mVRSoftGLView) {
            this.mVRSoftGLView.onPause();
        }
    }

    private void drawImage() {
        File file;
        if (this.filePath != null && !this.filePath.equals("") && (file = new File(this.filePath)).exists()) {
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inPreferredConfig = Bitmap.Config.ARGB_8888;
            Bitmap bitmap = BitmapFactory.decodeFile((String)this.filePath, (BitmapFactory.Options)opts);
            if (null != bitmap) {
                Log.d((String)TAG, (String)"\u5f00\u59cb\u7ed8\u5236\u56fe\u7247....");
                this.setShowImageSuccess(true);
                if (this.mType == 0) {
                    this.mImageView.setImageBitmap(bitmap);
                } else if (this.mType == 1 && this.mVRSoftGLView != null && this.mVRSoftGLView.hasReady()) {
                    if (this.fishEyeParams.hasOffset()) {
                        this.fecCenter = new FecCenter(this.fishEyeParams.imageWidth, this.fishEyeParams.imageHeight, this.fishEyeParams.xCenter, this.fishEyeParams.yCenter, this.fishEyeParams.radius);
                    }
                    if (this.fishEyeParams.getVidType() == FishEyeVidType.GENERAL_180VR) {
                        this.mVRSoftGLView.setType(1);
                        this.mVRSoftGLView.setFecParams(GL2JNIView.FecType.GENERAL_180VR, this.fecCenter);
                    } else if (this.fishEyeParams.getVidType() == FishEyeVidType.GENERAL_360VR) {
                        this.mVRSoftGLView.setType(0);
                        this.mVRSoftGLView.setFecParams(GL2JNIView.FecType.GENERAL_360VR, this.fecCenter);
                    }
                    this.mVRSoftGLView.setNewBitmap(bitmap);
                    Log.d((String)TAG, (String)"setNewBitmap");
                }
            } else {
                this.mImageView.setImageResource(this.mDefaultBackground);
                this.setShowImageSuccess(false);
            }
        }
    }

    public void setFishEyeParams(FishEyeParams params) {
        this.fishEyeParams = params;
    }

    public void setImagePath(String filePath) {
        this.filePath = filePath;
        SDK_FishEyeFrame fishFrame = FunSDK.JPGHead_Read_Exif((String)filePath);
        if (null == fishFrame) {
            this.mType = 0;
            this.mImageView.setVisibility(0);
            this.mVRSoftGLView.setVisibility(8);
            this.drawImage();
        } else {
            this.mImageView.setVisibility(8);
            this.mVRSoftGLView.setVisibility(0);
            this.mType = 1;
            this.setFishEyeParams(new FishEyeParams(fishFrame));
        }
        if (this.isNeedChangeViewSize()) {
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            layoutParams.height = -1;
            layoutParams.width = -1;
            this.requestLayout();
        }
    }

    public void updateImagePath(String filePath) {
        SDK_FishEyeFrame fishFrame = FunSDK.JPGHead_Read_Exif((String)filePath);
        if (null == fishFrame) {
            this.mType = 0;
            this.mImageView.setVisibility(0);
            this.mVRSoftGLView.setVisibility(8);
            this.drawImage();
        } else {
            this.mImageView.setVisibility(8);
            this.mVRSoftGLView.setVisibility(0);
            this.mType = 1;
            this.setFishEyeParams(new FishEyeParams(fishFrame));
        }
        if (this.isNeedChangeViewSize()) {
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            layoutParams.height = -1;
            layoutParams.width = -1;
            this.requestLayout();
        }
        if (!StringUtils.contrast(this.filePath, filePath)) {
            this.filePath = filePath;
            this.drawImage();
        }
    }

    public boolean isNeedChangeViewSize() {
        if (this.mType == -1 || this.mType == 1) {
            if (this.getParent() != null) {
                ((ViewGroup)this.getParent()).setBackgroundColor(-16777216);
            }
            return false;
        }
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).setBackgroundColor(Color.parseColor((String)"#323232"));
        }
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.isHasGestureOperate()) {
            return super.onInterceptTouchEvent(ev);
        }
        return true;
    }

    public boolean isHasGestureOperate() {
        return this.hasGestureOperate;
    }

    public void setHasGestureOperate(boolean hasGestureOperate) {
        this.hasGestureOperate = hasGestureOperate;
    }

    public ImageView getGeneralImageView() {
        return this.mImageView;
    }

    public boolean isShowImageSuccess() {
        return this.showImageSuccess;
    }

    public void setShowImageSuccess(boolean showImageSuccess) {
        this.showImageSuccess = showImageSuccess;
    }

    public void setDefaultBackground(int resId) {
        if (resId < 0) {
            return;
        }
        this.mDefaultBackground = resId;
        this.mImageView.setImageResource(this.mDefaultBackground);
    }
}

