/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;

public class CircleView
extends View {
    private int[] circleCountArray;
    private int mMeasureWidth;
    private int mMeasureHeight;
    private int frequence = 300;
    private static final int MIN_VIEW_WIDTH = 100;
    private static final int CIRCLE_GAP = 30;
    private int mFirstCircleCx = 10;
    private static final int CIRCLE_COUNT = 3;
    private static final int RADIUS_NOR = 7;
    private static final int RADIUS_SEL = 9;
    private int lastIndex = 0;
    private int currentIndex = 0;
    private int mCircleCy;
    private Paint mCirClePaint;
    Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            ((CircleView)CircleView.this).circleCountArray[((CircleView)CircleView.this).lastIndex % 3] = 7;
            ((CircleView)CircleView.this).circleCountArray[((CircleView)CircleView.this).currentIndex % 3] = 9;
            CircleView.this.invalidate();
            CircleView.this.lastIndex = CircleView.this.currentIndex;
            CircleView.this.currentIndex++;
        }
    };

    public CircleView(Context context) {
        this(context, null);
    }

    public CircleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initMySelf();
    }

    private void initMySelf() {
        this.setMinimumWidth(100);
        this.circleCountArray = new int[3];
        for (int i = 0; i < this.circleCountArray.length; ++i) {
            this.circleCountArray[i] = 7;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.onMeasureView(widthMeasureSpec, heightMeasureSpec);
    }

    private void onMeasureView(int widthMeasureSpec, int heightMeasureSpec) {
        this.mMeasureWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.mMeasureHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.mFirstCircleCx = this.mMeasureWidth / 2 - 30;
        int heightMeasureMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthMeasureMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        this.mCircleCy = heightMeasureMode == 0x40000000 ? this.mMeasureHeight / 2 : this.mFirstCircleCx;
        Log.e((String)"TTTTT", (String)(this.mMeasureWidth + " " + this.mMeasureHeight + " " + this.mFirstCircleCx));
    }

    public void setFrequence(int frequence) {
        this.frequence = frequence;
    }

    protected void onDraw(Canvas canvas) {
        if (this.mCirClePaint == null) {
            this.mCirClePaint = this.createCirclePaint();
        }
        for (int i = 0; i < 3; ++i) {
            canvas.drawCircle((float)(this.mFirstCircleCx + i * 30), (float)this.mCircleCy, (float)this.circleCountArray[i], this.mCirClePaint);
        }
        super.onDraw(canvas);
        this.handler.sendEmptyMessageDelayed(0, (long)this.frequence);
    }

    private Paint createCirclePaint() {
        Paint paint = new Paint();
        paint.setColor(-1);
        paint.setAntiAlias(true);
        paint.setStyle(Paint.Style.FILL);
        return paint;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.handler.removeMessages(0);
    }
}

