/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import demo.xm.com.libxmfunsdk.R;

public class ChangeColorButton
extends LinearLayout
implements View.OnTouchListener,
View.OnClickListener,
View.OnLongClickListener {
    private int mColor;
    private int[] _imageID = new int[2];
    private String[] _text = new String[4];
    private float _textSize;
    private Boolean[] _textVisiable = new Boolean[4];
    private Boolean _imgVisiable;
    private int _btnAlpha;
    private boolean _btnIsChecked = false;
    private int _textColor;
    private int _textPressedColor;
    private boolean _checkEnable;
    private boolean _alphaEnable;
    private ImageView mImage = null;
    private TextView[] mTexts = new TextView[4];
    private LinearLayout mLayoutOut;
    private LinearLayout mLayoutIn;
    private static int LEFT = 0;
    private static int RIGHT = 1;
    private static int BOTTOM = 2;
    private static int TOP = 3;
    private static int BLACK = -16777216;
    private OnColorBtnTouchListener mColorBtnTouchLs = null;
    private OnColorBtnClickListener mColorBtnClickLs = null;
    private OnColorBtnLongClickListener mColorBtnLongClickLs = null;

    public ChangeColorButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.ChangeColorButton);
        this._imageID[0] = params.getResourceId(R.styleable.ChangeColorButton_colorBtnNormalImg, 0);
        this._imageID[1] = params.getResourceId(R.styleable.ChangeColorButton_colorBtnSelectedImg, 0);
        this._text[0] = params.getString(R.styleable.ChangeColorButton_colorBtnLeftText);
        this._text[1] = params.getString(R.styleable.ChangeColorButton_colorBtnRightText);
        this._text[2] = params.getString(R.styleable.ChangeColorButton_colorBtnBottomText);
        this._text[3] = params.getString(R.styleable.ChangeColorButton_colorBtnTopText);
        this._textSize = params.getDimension(R.styleable.ChangeColorButton_colorBtnTextSize, 12.0f);
        this._textColor = params.getInt(R.styleable.ChangeColorButton_colorBtnTextColor, BLACK);
        this._textPressedColor = params.getInt(R.styleable.ChangeColorButton_colorBtnTextPressedColor, this._textColor);
        this._btnAlpha = params.getInt(R.styleable.ChangeColorButton_colorBtnAlpha, 50);
        this._imgVisiable = params.getBoolean(R.styleable.ChangeColorButton_colorBtnImgVisibility, true);
        this._checkEnable = params.getBoolean(R.styleable.ChangeColorButton_colorBtnCheckEnable, false);
        this._alphaEnable = params.getBoolean(R.styleable.ChangeColorButton_colorBtnAlphaEnable, true);
        params.recycle();
    }

    public void setBtnLeftText(String msg) {
        this._text[ChangeColorButton.LEFT] = msg;
        this.mTexts[LEFT].setText((CharSequence)this._text[LEFT]);
    }

    public void setBtnRightText(String msg) {
        this._text[ChangeColorButton.RIGHT] = msg;
        this.mTexts[RIGHT].setText((CharSequence)this._text[RIGHT]);
    }

    public void setBtnBottomText(String msg) {
        this._text[ChangeColorButton.BOTTOM] = msg;
        this.mTexts[BOTTOM].setText((CharSequence)this._text[BOTTOM]);
    }

    public void setBtnTopText(String msg) {
        this._text[ChangeColorButton.TOP] = msg;
        this.mTexts[TOP].setText((CharSequence)this._text[TOP]);
    }

    public void setBtnLeftTextVisiable(Boolean value) {
        this._textVisiable[ChangeColorButton.LEFT] = value;
        this.mTexts[LEFT].setVisibility(this._textVisiable[LEFT] == true ? 0 : 8);
    }

    public void setBtnRightTextVisiable(Boolean value) {
        this._textVisiable[ChangeColorButton.RIGHT] = value;
        this.mTexts[RIGHT].setVisibility(this._textVisiable[RIGHT] == true ? 0 : 8);
    }

    public void setBtnBottomTextVisiable(Boolean value) {
        this._textVisiable[ChangeColorButton.BOTTOM] = value;
        this.mTexts[BOTTOM].setVisibility(this._textVisiable[BOTTOM] == true ? 0 : 8);
    }

    public void setBtnTopTextVisiable(Boolean value) {
        if (value != null) {
            this._textVisiable[ChangeColorButton.TOP] = value;
            this.mTexts[TOP].setVisibility(this._textVisiable[TOP] == true ? 0 : 8);
        }
    }

    public void setBtnNormalImg(int value) {
        this._imageID[0] = value;
    }

    public void setBtnSelectedImg(int value) {
        this._imageID[1] = value;
    }

    public void setBtImgVisiable(Boolean value) {
        this._imgVisiable = value;
        this.mImage.setVisibility(value == true ? 0 : 8);
    }

    public void setBtnAlpha(int value) {
        if (value >= 255) {
            value = 255;
        }
        this._btnAlpha = value;
    }

    public void setCheckEnable(boolean value) {
        this._checkEnable = value;
    }

    public boolean getCheckEnable() {
        return this._checkEnable;
    }

    public void setChecked(boolean value) {
        this._btnIsChecked = value;
        if (this._checkEnable && this.mImage != null) {
            this.mImage.setImageResource(this._imageID[!this._btnIsChecked ? 0 : 1]);
        }
    }

    public boolean getChecked() {
        return this._btnIsChecked;
    }

    private void initView() {
        this.setOnTouchListener(this);
        this.setOnClickListener(this);
        this.setOnLongClickListener(this);
        this.mImage = new ImageView(this.getContext());
        this.mImage.setImageResource(this._imageID[0]);
        this.mImage.setVisibility(this._imgVisiable == true ? 0 : 8);
        for (int i = 0; i < 4; ++i) {
            this.mTexts[i] = new TextView(this.getContext());
            this.mTexts[i].setText((CharSequence)this._text[i]);
            this.mTexts[i].setTextSize(this._textSize);
            this.mTexts[i].setTextColor(this._textColor);
            this.mTexts[i].setVisibility(this._text[i] == null ? 8 : 0);
            this.mTexts[i].setGravity(17);
        }
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
        lp.gravity = 17;
        this.mLayoutIn = new LinearLayout(this.getContext());
        this.mLayoutIn.setOrientation(0);
        this.mLayoutIn.addView((View)this.mTexts[LEFT], (ViewGroup.LayoutParams)lp);
        this.mLayoutIn.addView((View)this.mImage, (ViewGroup.LayoutParams)lp);
        this.mLayoutIn.addView((View)this.mTexts[RIGHT], (ViewGroup.LayoutParams)lp);
        this.mLayoutOut = new LinearLayout(this.getContext());
        this.mLayoutOut.setOrientation(1);
        this.mLayoutOut.addView((View)this.mTexts[TOP], (ViewGroup.LayoutParams)lp);
        this.mLayoutOut.addView((View)this.mLayoutIn, (ViewGroup.LayoutParams)lp);
        this.mLayoutOut.addView((View)this.mTexts[BOTTOM], (ViewGroup.LayoutParams)lp);
        this.mLayoutOut.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.addView((View)this.mLayoutOut);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initView();
    }

    public void setOnColorBtnTouchListener(OnColorBtnTouchListener ls) {
        this.mColorBtnTouchLs = ls;
    }

    public void setOnColorBtnClickListener(OnColorBtnClickListener ls) {
        this.mColorBtnClickLs = ls;
    }

    public void setOnColorBtnLongClickListener(OnColorBtnLongClickListener ls) {
        this.mColorBtnLongClickLs = ls;
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (this._alphaEnable) {
                    this.mColor = Color.argb((int)this._btnAlpha, (int)0, (int)0, (int)0);
                    this.setBackgroundColor(this.mColor);
                }
                for (int i = 0; i < 4; ++i) {
                    this.mTexts[i].setTextColor(this._textPressedColor);
                }
                if (this.mColorBtnTouchLs == null) break;
                this.mColorBtnTouchLs.colorBtnOnTouch(event);
                break;
            }
            case 1: 
            case 3: {
                if (this._alphaEnable) {
                    this.mColor = Color.argb((int)0, (int)0, (int)0, (int)0);
                    this.setBackgroundColor(this.mColor);
                }
                for (int i = 0; i < 4; ++i) {
                    this.mTexts[i].setTextColor(this._textColor);
                }
                if (this.mColorBtnTouchLs != null) {
                    this.mColorBtnTouchLs.colorBtnOnTouch(event);
                }
                if (!this._checkEnable) break;
                if (!this._btnIsChecked) {
                    this.setChecked(true);
                    break;
                }
                this.setChecked(false);
                break;
            }
        }
        return false;
    }

    public void onClick(View v) {
        if (this.mColorBtnClickLs != null) {
            this.mColorBtnClickLs.colorBtnOnClick(v);
        }
    }

    public boolean onLongClick(View v) {
        if (this.mColorBtnLongClickLs != null) {
            this.mColorBtnLongClickLs.colorBtnOnLongClick(v);
        }
        return true;
    }

    public static interface OnColorBtnLongClickListener {
        public void colorBtnOnLongClick(View var1);
    }

    public static interface OnColorBtnClickListener {
        public void colorBtnOnClick(View var1);
    }

    public static interface OnColorBtnTouchListener {
        public void colorBtnOnTouch(MotionEvent var1);
    }
}

