/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.appcompat.widget.AppCompatSeekBar;
import com.xm.ui.widget.data.BubbleIndicator;

public class BubbleSeekBar
extends AppCompatSeekBar {
    private Drawable mThumbDrawable;
    private BubbleIndicator mBubbleIndicator;

    public BubbleSeekBar(Context context) {
        this(context, null);
    }

    public BubbleSeekBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BubbleSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mBubbleIndicator = new BubbleIndicator(context);
        this.mBubbleIndicator.createTextViewFloater(context, attrs, defStyleAttr, "100");
    }

    public void setThumb(Drawable thumb) {
        super.setThumb(thumb);
        this.mThumbDrawable = thumb;
    }

    public void showIndicator(int direction) {
        this.mBubbleIndicator.setDirection(direction);
        this.mBubbleIndicator.showIndicator((View)this, this.mThumbDrawable.getBounds());
    }

    public void showIndicator(int direction, int backgroundColor) {
        this.mBubbleIndicator.setDirection(direction);
        this.mBubbleIndicator.showIndicator((View)this, this.mThumbDrawable.getBounds(), backgroundColor);
    }

    public void moveIndicator() {
        this.mBubbleIndicator.moveIndicator(this.mThumbDrawable.getBounds(), this.getProgress());
    }

    public void moveIndicator(String content) {
        this.mBubbleIndicator.moveIndicator(this.mThumbDrawable.getBounds(), content);
    }

    public void hideIndicator() {
        this.mBubbleIndicator.hideIndicator();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mBubbleIndicator.changeScreenSize(w, h);
        super.onSizeChanged(w, h, oldw, oldh);
    }
}

