/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.media;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.RelativeLayout;
import androidx.core.view.GestureDetectorCompat;

public class MultiWinView
extends RelativeLayout
implements View.OnTouchListener {
    private GestureDetectorCompat gestureDetector;
    private WndGestureDetector wndGestureDetector;
    private View.OnKeyListener onDispatchKeyListener;
    private OnChildFocusListener onChildFocusListener;
    private boolean isScroll = false;
    private float downX = 0.0f;
    private float downY = 0.0f;
    private OnViewSimpleGestureListener simpleGestureLs;
    private OnLayoutChangeListener layoutChangeListener;

    public MultiWinView(Context context) {
        super(context);
        this.init(context);
    }

    public MultiWinView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public MultiWinView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.wndGestureDetector = new WndGestureDetector();
        this.gestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)this.wndGestureDetector);
    }

    public WndGestureDetector getWndGestureDetector() {
        return this.wndGestureDetector;
    }

    public void setOnViewSimpleGestureListener(OnViewSimpleGestureListener ls) {
        this.simpleGestureLs = ls;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.simpleGestureLs != null) {
            this.simpleGestureLs.onTouchEvent((View)this.getParent(), event);
        }
        if (this.gestureDetector != null) {
            this.gestureDetector.onTouchEvent(event);
        }
        return true;
    }

    public boolean onTouch(View view, MotionEvent event) {
        switch (event.getAction()) {
            case 2: {
                this.isScroll = false;
                float moveX = event.getX() - this.downX;
                float moveY = event.getY() - this.downY;
                if (Math.abs(moveX) > 30.0f) {
                    this.isScroll = true;
                }
                this.gestureDetector.onTouchEvent(event);
                break;
            }
            case 1: {
                Log.i((String)"cat", (String)("ACTION_UP" + this.isScroll));
                if (this.isScroll) {
                    this.gestureDetector.onTouchEvent(event);
                    return true;
                }
                return false;
            }
            case 0: {
                Log.i((String)"cat", (String)"ACTION_DOWN");
                this.downX = event.getX();
                this.downY = event.getY();
                this.isScroll = false;
                this.gestureDetector.onTouchEvent(event);
                break;
            }
        }
        return false;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (changed && this.layoutChangeListener != null) {
            this.layoutChangeListener.onLayoutChange(this.getWidth(), this.getHeight());
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean consumed = super.dispatchKeyEvent(event);
        if (this.onDispatchKeyListener != null && !consumed) {
            return this.onDispatchKeyListener.onKey((View)this, event.getKeyCode(), event);
        }
        return consumed;
    }

    public void setOnDispatchKeyListener(View.OnKeyListener listener) {
        this.onDispatchKeyListener = listener;
    }

    public void requestChildFocus(View child, View focused) {
        if (this.onChildFocusListener != null) {
            this.onChildFocusListener.onRequestChildFocus(child, focused);
        }
        super.requestChildFocus(child, focused);
    }

    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        if (this.onChildFocusListener != null && this.onChildFocusListener.onRequestFocusInDescendants(direction, previouslyFocusedRect)) {
            return true;
        }
        return super.onRequestFocusInDescendants(direction, previouslyFocusedRect);
    }

    public void setOnChildFocusListener(OnChildFocusListener listener) {
        this.onChildFocusListener = listener;
    }

    public void setOnLayoutChangeListener(OnLayoutChangeListener layoutChangeListener) {
        this.layoutChangeListener = layoutChangeListener;
    }

    public static interface OnChildFocusListener {
        public boolean onRequestFocusInDescendants(int var1, Rect var2);

        public void onRequestChildFocus(View var1, View var2);
    }

    public static interface OnLayoutChangeListener {
        public void onLayoutChange(int var1, int var2);
    }

    public static interface OnViewSimpleGestureListener {
        public boolean isNeedInterceptTouchEvent(View var1);

        public boolean onTouchEvent(View var1, MotionEvent var2);

        public boolean onSingleTapUp(View var1, MotionEvent var2);

        public void onLongPress(View var1, MotionEvent var2);

        public boolean onDown(View var1, MotionEvent var2);

        public boolean onDoubleTap(View var1, MotionEvent var2);

        public boolean onDoubleTapEvent(View var1, MotionEvent var2);

        public boolean onSingleTapConfirmed(View var1, MotionEvent var2);

        public boolean onFling(View var1, MotionEvent var2, MotionEvent var3, float var4, float var5);

        public boolean onScroll(View var1, MotionEvent var2, MotionEvent var3, float var4, float var5);
    }

    public class WndGestureDetector
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onSingleTapUp(MotionEvent e) {
            if (MultiWinView.this.simpleGestureLs != null) {
                MultiWinView.this.simpleGestureLs.onSingleTapUp((View)MultiWinView.this.getParent(), e);
            }
            return false;
        }

        public void onLongPress(MotionEvent e) {
            if (MultiWinView.this.simpleGestureLs != null) {
                MultiWinView.this.simpleGestureLs.onLongPress((View)MultiWinView.this.getParent(), e);
            }
            super.onLongPress(e);
        }

        public boolean onDown(MotionEvent e) {
            if (MultiWinView.this.simpleGestureLs != null) {
                MultiWinView.this.simpleGestureLs.onDown((View)MultiWinView.this.getParent(), e);
            }
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (MultiWinView.this.simpleGestureLs != null) {
                return MultiWinView.this.simpleGestureLs.onDoubleTap((View)MultiWinView.this.getParent(), e);
            }
            return false;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            if (MultiWinView.this.simpleGestureLs != null) {
                MultiWinView.this.simpleGestureLs.onDoubleTapEvent((View)MultiWinView.this.getParent(), e);
            }
            return super.onDoubleTapEvent(e);
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (MultiWinView.this.simpleGestureLs != null) {
                MultiWinView.this.simpleGestureLs.onSingleTapConfirmed((View)MultiWinView.this.getParent(), e);
            }
            return super.onSingleTapConfirmed(e);
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (MultiWinView.this.simpleGestureLs != null) {
                MultiWinView.this.simpleGestureLs.onFling((View)MultiWinView.this.getParent(), e1, e2, velocityX, velocityY);
            }
            return super.onFling(e1, e2, velocityX, velocityY);
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (MultiWinView.this.simpleGestureLs != null) {
                MultiWinView.this.simpleGestureLs.onScroll((View)MultiWinView.this.getParent(), e1, e2, distanceX, distanceY);
            }
            return true;
        }
    }
}

