/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.manager;

import android.os.Handler;
import android.os.Message;
import android.view.View;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

public class AutoHideManager {
    private static final int SEND_HIDE_MSG = 0;
    private static final int SHOW_TIME = 15000;
    private int showTimes = 15000;
    private ArrayList<View> mViews = new ArrayList();
    private Timer mTimer;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            for (View view : AutoHideManager.this.mViews) {
                if (null == view) continue;
                view.setVisibility(8);
            }
            if (AutoHideManager.this.onAutoHideListener != null) {
                AutoHideManager.this.onAutoHideListener.onHide();
            }
            super.handleMessage(msg);
        }
    };
    private boolean mIsAutoHide = true;
    private OnAutoHideListener onAutoHideListener;

    public void setShowTimes(int showTimes) {
        this.showTimes = showTimes * 1000;
        if (this.mIsAutoHide) {
            if (null != this.mTimer) {
                this.mTimer.cancel();
                this.mTimer = null;
            }
            this.mTimer = new Timer();
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    AutoHideManager.this.mHandler.sendEmptyMessage(0);
                }
            }, showTimes);
        }
    }

    public void addView(View view) {
        if (!this.mViews.contains(view)) {
            this.mViews.add(view);
        }
    }

    public void removeView(View view) {
        if (this.mViews.contains(view)) {
            this.mViews.remove(view);
        }
    }

    public void setAutoHide(boolean isAutoHide) {
        this.mIsAutoHide = isAutoHide;
        if (this.mIsAutoHide) {
            if (null != this.mTimer) {
                this.mTimer.cancel();
                this.mTimer = null;
            }
            this.mTimer = new Timer();
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    AutoHideManager.this.mHandler.sendEmptyMessage(0);
                }
            }, this.showTimes);
        }
    }

    public void show() {
        if (null != this.mTimer) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
        if (this.mIsAutoHide) {
            this.mTimer = new Timer();
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    AutoHideManager.this.mHandler.sendEmptyMessage(0);
                }
            }, this.showTimes);
        }
        for (View view : this.mViews) {
            if (null == view) continue;
            view.setVisibility(0);
        }
    }

    public void hide() {
        if (this.onAutoHideListener != null) {
            this.onAutoHideListener.onHide();
        }
        for (View view : this.mViews) {
            if (null == view) continue;
            view.setVisibility(8);
        }
        if (null != this.mTimer) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    public void cancel() {
        if (null != this.mTimer) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    public boolean isVisible() {
        return 0 == this.mViews.size() ? false : this.mViews.get(0).getVisibility() == 0;
    }

    public void setOnAutoHideListener(OnAutoHideListener onAutoHideListener) {
        this.onAutoHideListener = onAutoHideListener;
    }

    public static interface OnAutoHideListener {
        public void onHide();
    }
}

