/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.dialog;

import android.app.DialogFragment;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.lib.FunSDK;
import com.lib.sdk.bean.StringUtils;
import demo.xm.com.libxmfunsdk.R;
import io.reactivex.annotations.Nullable;
import java.util.ArrayList;

public class SingleSelectionDlg
extends DialogFragment
implements View.OnClickListener {
    private View layout;
    private ListView listView;
    private String selectedOption;
    private OptionAdapter adapter;
    private OnSingleSelectionListener singleSelectionLs;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(1, R.style.SimpleDialog);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.layout = inflater.inflate(R.layout.funsdk_dlg_single_selection, container, false);
        this.listView = (ListView)this.layout.findViewById(R.id.option_lv);
        this.layout.findViewById(R.id.tv_cancel).setOnClickListener((View.OnClickListener)this);
        this.layout.findViewById(R.id.tv_sure).setOnClickListener((View.OnClickListener)this);
        this.initData();
        return this.layout;
    }

    private void initData() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(FunSDK.TS((String)"every_day"));
        list.add(FunSDK.TS((String)"Only"));
        this.adapter = new OptionAdapter((Context)this.getActivity(), list);
        this.listView.setAdapter((ListAdapter)this.adapter);
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                SingleSelectionDlg.this.selectedOption = (String)SingleSelectionDlg.this.adapter.getItem(i);
                SingleSelectionDlg.this.adapter.notifyDataSetChanged();
            }
        });
    }

    public void setCurSelectedOption(String option) {
        this.selectedOption = option;
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.tv_sure) {
            if (this.singleSelectionLs != null) {
                this.singleSelectionLs.onOptionSelected(this.selectedOption);
            }
            this.dismiss();
        } else if (i == R.id.tv_cancel) {
            this.dismiss();
        }
    }

    public void setOnSingleSelectionListener(OnSingleSelectionListener singleSelectionLs) {
        this.singleSelectionLs = singleSelectionLs;
    }

    public static interface OnSingleSelectionListener {
        public void onOptionSelected(String var1);
    }

    class OptionAdapter
    extends BaseAdapter {
        private LayoutInflater inflater;
        private ArrayList<String> optionList;

        public OptionAdapter(Context context, ArrayList optionList) {
            this.inflater = LayoutInflater.from((Context)context);
            this.optionList = optionList;
        }

        public int getCount() {
            return this.optionList == null ? 0 : this.optionList.size();
        }

        public Object getItem(int i) {
            return this.optionList == null ? null : this.optionList.get(i);
        }

        public long getItemId(int i) {
            return 0L;
        }

        public View getView(int i, View view, ViewGroup viewGroup) {
            ViewHolder viewHolder;
            if (view == null) {
                viewHolder = new ViewHolder();
                view = this.inflater.inflate(R.layout.funsdk_item_single_selection, viewGroup, false);
                view.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)view.getTag();
            }
            viewHolder.leftIv = (ImageView)view.findViewById(R.id.iv_left);
            viewHolder.rightTv = (TextView)view.findViewById(R.id.tv_right);
            String option = (String)this.getItem(i);
            viewHolder.rightTv.setText((CharSequence)option);
            if (StringUtils.contrast(option, SingleSelectionDlg.this.selectedOption)) {
                viewHolder.rightTv.setTextColor(SingleSelectionDlg.this.getResources().getColor(R.color.theme_color));
                viewHolder.leftIv.setImageResource(R.drawable.ic_check_sel);
            } else {
                viewHolder.rightTv.setTextColor(SingleSelectionDlg.this.getResources().getColor(R.color.default_normal_text_color));
                viewHolder.leftIv.setImageResource(R.drawable.ic_check_nor);
            }
            return view;
        }

        class ViewHolder {
            ImageView leftIv;
            TextView rightTv;

            ViewHolder() {
            }
        }
    }
}

