/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.dialog;

import android.app.AlertDialog;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.DialogInterface;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.utils.XUtils;
import com.xm.ui.widget.ButtonCheck;
import demo.xm.com.libxmfunsdk.R;

public class PasswordErrorDlg
implements DialogInterface.OnDismissListener {
    private AlertDialog mDlg;
    private EditText mPwdEdit;
    private Button mConfirmButton;
    private Button mCancelButton;
    private Button mRetrievePwdBtn;
    private TextView mDevId;
    private TextView mTips;
    private TextView mTvTitle;
    private static PasswordErrorDlg mInstance;
    private boolean mIsPositive;
    private EditText mEtDevUser;
    private ButtonCheck mBcShowPwd;
    private LinearLayout mllRetrievePwd;
    public static final int INPUT_TYPE_DEV_USER = 1;
    public static final int INPUT_TYPE_DEV_PWD = 2;
    public static final int INPUT_TYPE_DEV_USER_PWD = 3;
    private String mUserName;
    private String mPwd;
    private String mDesensitizationUser;
    private boolean mDefaultShowPwd;
    private boolean mIsDesensitizationUser;
    private OnDismissListener mDismissLs;

    public static PasswordErrorDlg getInstance(Context context) {
        if (null == mInstance || ((ContextWrapper)PasswordErrorDlg.mInstance.mDlg.getContext()).getBaseContext() != context) {
            mInstance = new PasswordErrorDlg(context);
        }
        return mInstance;
    }

    public PasswordErrorDlg(Context context) {
        this.mDlg = new AlertDialog.Builder(context).create();
        this.mDlg.setView(LayoutInflater.from((Context)context).inflate(R.layout.funsdk_dlg_pass_err, null));
        this.mDlg.show();
        this.mDlg.setCanceledOnTouchOutside(false);
        Window window = this.mDlg.getWindow();
        window.setContentView(R.layout.funsdk_dlg_pass_err);
        window.setBackgroundDrawableResource(R.color.transparent);
        this.initView();
    }

    private void initView() {
        this.mCancelButton = (Button)this.mDlg.findViewById(R.id.btnDigCancel);
        this.mConfirmButton = (Button)this.mDlg.findViewById(R.id.btnDigOk);
        this.mPwdEdit = (EditText)this.mDlg.findViewById(R.id.editInputPass);
        this.mDevId = (TextView)this.mDlg.findViewById(R.id.devId);
        this.mTvTitle = (TextView)this.mDlg.findViewById(R.id.txtDigTitle);
        this.mTips = (TextView)this.mDlg.findViewById(R.id.password_error_tip);
        this.mTips.setText(R.string.libfunsdk_dlg_pwd_error_tips);
        this.mEtDevUser = (EditText)this.mDlg.findViewById(R.id.et_dev_user);
        this.mBcShowPwd = (ButtonCheck)this.mDlg.findViewById(R.id.btn_show_pass);
        this.mRetrievePwdBtn = (Button)this.mDlg.findViewById(R.id.btn_retrieve_pwd);
        this.mllRetrievePwd = (LinearLayout)this.mDlg.findViewById(R.id.ll_retrieve_pwd);
        this.mPwdEdit.requestFocus();
        this.mEtDevUser.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                Log.e((String)"lmy", (String)("beforeTextChanged  s:" + s.toString() + " start:" + start + " after:" + after + " count:" + count));
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                Log.e((String)"lmy", (String)("onTextChanged  s:" + s.toString() + " start:" + start + " before:" + before + " count:" + count));
                if (PasswordErrorDlg.this.mIsDesensitizationUser && PasswordErrorDlg.this.mEtDevUser.hasFocus()) {
                    PasswordErrorDlg.this.mIsDesensitizationUser = false;
                    if (before > 0 && count == 0) {
                        PasswordErrorDlg.this.mEtDevUser.setText((CharSequence)"");
                    } else if (PasswordErrorDlg.this.mDesensitizationUser != null) {
                        String user = s.toString().replace(PasswordErrorDlg.this.mDesensitizationUser, "");
                        PasswordErrorDlg.this.mEtDevUser.setText((CharSequence)user);
                        PasswordErrorDlg.this.mEtDevUser.setSelection(PasswordErrorDlg.this.mEtDevUser.getText().length());
                    }
                }
            }

            public void afterTextChanged(Editable s) {
                Log.e((String)"lmy", (String)("afterTextChanged s:" + s.toString()));
                PasswordErrorDlg.this.mPwdEdit.setText((CharSequence)"");
            }
        });
        this.mPwdEdit.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (PasswordErrorDlg.this.mPwdEdit.getText().toString().length() == 0 && !PasswordErrorDlg.this.mDefaultShowPwd) {
                    PasswordErrorDlg.this.mBcShowPwd.setVisibility(0);
                }
            }
        });
        this.mBcShowPwd.setOnButtonClick(new ButtonCheck.OnButtonClickListener(){

            public boolean onButtonClick(ButtonCheck bc, boolean bBeforeChecked) {
                if (PasswordErrorDlg.this.mPwdEdit.getTransformationMethod() == null) {
                    PasswordErrorDlg.this.mPwdEdit.setTransformationMethod((TransformationMethod)new PasswordTransformationMethod());
                } else {
                    PasswordErrorDlg.this.mPwdEdit.setTransformationMethod(null);
                }
                PasswordErrorDlg.this.mPwdEdit.setSelection(PasswordErrorDlg.this.mPwdEdit.getText().toString().length());
                return true;
            }
        });
    }

    public void setEtDevUserVisibility(boolean isVisible) {
        this.mEtDevUser.setVisibility(isVisible ? 0 : 8);
    }

    public void setDefaultShowPwd(boolean mDefaultShowPwd) {
        this.mDefaultShowPwd = mDefaultShowPwd;
        if (this.mPwdEdit.getTransformationMethod() == null && !mDefaultShowPwd) {
            this.mPwdEdit.setTransformationMethod((TransformationMethod)new PasswordTransformationMethod());
        } else {
            this.mPwdEdit.setTransformationMethod(null);
        }
        if (mDefaultShowPwd) {
            this.mBcShowPwd.setVisibility(8);
        }
    }

    public void setEditTextFocus(int focusType) {
        if (focusType == 1) {
            this.mEtDevUser.requestFocus();
            this.mPwdEdit.clearFocus();
        } else if (focusType == 2) {
            this.mPwdEdit.requestFocus();
            this.mEtDevUser.clearFocus();
        } else {
            this.mEtDevUser.clearFocus();
            this.mPwdEdit.requestFocus();
        }
    }

    public void setTitle(String title) {
        this.mTvTitle.setText((CharSequence)title);
    }

    public String getInputText() {
        return this.mPwdEdit.getText().toString();
    }

    public String getUserInputText() {
        String userName = this.mEtDevUser.getText().toString();
        if (this.mIsDesensitizationUser && !TextUtils.isEmpty((CharSequence)this.mUserName)) {
            userName = this.mUserName;
        }
        return userName;
    }

    public void setInputText(String s) {
        this.mPwdEdit.setText((CharSequence)s);
    }

    public PasswordErrorDlg setCancelable(boolean cancelable) {
        this.mDlg.setCancelable(cancelable);
        return this;
    }

    public PasswordErrorDlg setPositiveButton(View.OnClickListener listener) {
        this.mConfirmButton.setOnClickListener(listener);
        return this;
    }

    public PasswordErrorDlg setNegativeButton(View.OnClickListener listener) {
        this.mCancelButton.setOnClickListener(listener);
        return this;
    }

    public PasswordErrorDlg setOnDismissListener(OnDismissListener listener) {
        this.mDismissLs = listener;
        this.mDlg.setOnDismissListener((DialogInterface.OnDismissListener)this);
        return this;
    }

    public void setUserName(String userName) {
        this.mEtDevUser.setHint(R.string.libfunsdk_dlg_input_dev_user_name_tip);
        if (!TextUtils.isEmpty((CharSequence)userName)) {
            this.mIsDesensitizationUser = true;
            this.mUserName = userName;
            this.mDesensitizationUser = XUtils.getDevUserNameByDesensitization(userName);
            this.mEtDevUser.setText((CharSequence)this.mDesensitizationUser);
        }
    }

    public void setPwd(String pwd) {
        this.mPwdEdit.setHint(R.string.libfunsdk_dlg_input_dev_pwd_tips);
        if (!TextUtils.isEmpty((CharSequence)pwd)) {
            this.mPwd = pwd;
            this.mPwdEdit.setText((CharSequence)pwd);
            this.mBcShowPwd.setVisibility(8);
        }
    }

    public void dismiss(boolean isPositive) {
        this.mIsPositive = isPositive;
        this.mDlg.dismiss();
    }

    public boolean isShowing() {
        try {
            if (this.mDlg != null) {
                return this.mDlg.isShowing();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void show() {
        try {
            if (!this.isShowing()) {
                this.mDlg.show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onDismiss(DialogInterface arg0) {
        if (null != this.mDismissLs) {
            this.mDismissLs.onDismiss(arg0, this.mIsPositive);
        }
    }

    public void setDevId(String devId) {
        this.mDevId.setText((CharSequence)devId);
    }

    public String getDevId() {
        return this.mDevId.getText().toString().trim();
    }

    public void setTips(String tips) {
        this.mTips.setText((CharSequence)tips);
    }

    public void setTipsClickable(View.OnClickListener listener, String text) {
        if (listener != null) {
            this.mRetrievePwdBtn.setOnClickListener(listener);
            this.mllRetrievePwd.setVisibility(0);
            this.mRetrievePwdBtn.setText((CharSequence)text);
        } else {
            this.mllRetrievePwd.setVisibility(8);
            this.mRetrievePwdBtn.setText((CharSequence)text);
        }
    }

    public static interface OnSurePasswordListener {
        public void onPassword(String var1);
    }

    public static interface OnDismissListener {
        public void onDismiss(DialogInterface var1, boolean var2);
    }
}

