/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.dialog;

import android.app.DialogFragment;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.IntRange;
import com.xm.ui.widget.NumberPicker;
import demo.xm.com.libxmfunsdk.R;
import io.reactivex.annotations.Nullable;
import java.util.Calendar;
import java.util.Date;

public class DatePickBottomDialog
extends DialogFragment
implements View.OnClickListener {
    private View root;
    private String[] years;
    private String[] months;
    private String[] days;
    private int year;
    private int month;
    private int day;
    private NumberPicker npYear;
    private NumberPicker npMonth;
    private NumberPicker npDay;
    private TextView btnOk;
    private TextView btnCancel;
    private OnDatePickerListener datePickerListener;
    private int seq;
    private Calendar tempCalendar;
    private NumberPicker.OnValueChangeListener onValueChangeListener = new NumberPicker.OnValueChangeListener(){

        @Override
        public void onValueChange(NumberPicker picker, int oldVal, int newVal, EditText editText) {
            DatePickBottomDialog.this.updateMaxDays(Integer.parseInt(DatePickBottomDialog.this.years[DatePickBottomDialog.this.npYear.getValue()]), Integer.parseInt(DatePickBottomDialog.this.months[DatePickBottomDialog.this.npMonth.getValue()]));
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(1, R.style.SimpleDialog);
        if (this.years == null) {
            this.initData();
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.initData();
        }
        this.root = inflater.inflate(R.layout.funsdk_date_number_pick, container, false);
        this.btnOk = (TextView)this.root.findViewById(R.id.tv_sure);
        this.btnCancel = (TextView)this.root.findViewById(R.id.tv_cancel);
        this.npYear = (NumberPicker)this.root.findViewById(R.id.numpicker_y);
        this.npMonth = (NumberPicker)this.root.findViewById(R.id.numpicker_Mo);
        this.npDay = (NumberPicker)this.root.findViewById(R.id.numpicker_d);
        this.npYear.setDescendantFocusability(393216);
        this.npYear.setMaxValue(this.years.length - 1);
        this.npYear.setMinValue(0);
        this.npYear.setDisplayedValues(this.years);
        this.npYear.setValue(this.year);
        this.npMonth.setDescendantFocusability(393216);
        this.npMonth.setMaxValue(this.months.length - 1);
        this.npMonth.setMinValue(0);
        this.npMonth.setDisplayedValues(this.months);
        this.npMonth.setValue(this.month);
        this.npDay.setDescendantFocusability(393216);
        this.npDay.setMaxValue(this.days.length - 1);
        this.npDay.setMinValue(0);
        this.npDay.setDisplayedValues(this.days);
        this.npDay.setValue(this.day);
        this.btnOk.setOnClickListener((View.OnClickListener)this);
        this.btnCancel.setOnClickListener((View.OnClickListener)this);
        this.npYear.setOnValueChangedListener(this.onValueChangeListener);
        this.npMonth.setOnValueChangedListener(this.onValueChangeListener);
        return this.root;
    }

    private void updateMaxDays(int year, int month) {
        if (this.tempCalendar == null) {
            this.tempCalendar = Calendar.getInstance();
        }
        this.tempCalendar.set(1, year);
        this.tempCalendar.set(2, month - 1);
        int currentMonthMaxDays = this.tempCalendar.getActualMaximum(5);
        if (currentMonthMaxDays != this.days.length) {
            this.days = new String[currentMonthMaxDays];
            for (int i = 0; i < this.days.length; ++i) {
                this.days[i] = (i < 9 ? "0" : "") + (i + 1);
            }
            this.npDay.setDisplayedValues(null);
            this.npDay.setMaxValue(this.days.length - 1);
            this.npDay.setMinValue(0);
            this.npDay.setDisplayedValues(this.days);
        }
    }

    public void onStart() {
        super.onStart();
        this.initParams();
    }

    private void initParams() {
        Window window = this.getDialog().getWindow();
        if (window != null) {
            WindowManager.LayoutParams params = window.getAttributes();
            params.gravity = 80;
            params.width = -1;
            params.height = -2;
            window.setAttributes(params);
            window.setWindowAnimations(R.style.CornerPopwindowAnimStyle);
        }
        this.setCancelable(true);
        this.getDialog().setCanceledOnTouchOutside(false);
    }

    private void initData() {
        int i;
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int currentYear = calendar.get(1);
        this.years = new String[20];
        for (i = 0; i < this.years.length; ++i) {
            this.years[i] = "" + currentYear;
            ++currentYear;
        }
        this.months = new String[12];
        for (i = 0; i < this.months.length; ++i) {
            this.months[i] = (i < 9 ? "0" : "") + (i + 1);
        }
        int currentMonthMaxDays = calendar.getActualMaximum(5);
        this.days = new String[currentMonthMaxDays];
        for (int i2 = 0; i2 < this.days.length; ++i2) {
            this.days[i2] = (i2 < 9 ? "0" : "") + (i2 + 1);
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.tv_sure) {
            if (this.datePickerListener != null) {
                this.datePickerListener.onTimePicked(this.years[this.npYear.getValue()], this.months[this.npMonth.getValue()], this.days[this.npDay.getValue()], null, null, this.seq);
            }
            this.dismiss();
        } else if (v.getId() == R.id.tv_cancel) {
            this.dismiss();
        }
    }

    public void setTimes(int year, @IntRange(from=1L, to=12L) int month, @IntRange(from=1L, to=31L) int day) {
        if (this.years == null) {
            this.initData();
        }
        this.year = year - Integer.parseInt(this.years[0]);
        this.month = month - 1;
        this.day = day - 1;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public void setOnDatePickerListener(OnDatePickerListener l) {
        this.datePickerListener = l;
    }

    public static interface OnDatePickerListener {
        public void onTimePicked(String var1, String var2, String var3, String var4, String var5, int var6);
    }
}

