/*
 * Decompiled with CFR 0.152.
 */
package com.xm.activity.device.router.presenter;

import android.graphics.Bitmap;
import android.net.DhcpInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.os.Message;
import android.text.format.Formatter;
import com.lib.MsgContent;
import com.manager.account.AccountManager;
import com.manager.account.BaseAccountManager;
import com.manager.db.DevDataCenter;
import com.manager.db.XMDevInfo;
import com.manager.device.DeviceManager;
import com.utils.XMWifiManager;
import com.utils.XUtils;
import com.xm.activity.base.XMBasePresenter;
import com.xm.activity.device.router.contract.SetDevToRouterByQrCodeContract;

public class SetDevToRouterByQrCodePresenter
extends XMBasePresenter<DeviceManager>
implements SetDevToRouterByQrCodeContract.ISetDevToRouterByQrCodePresenter {
    private SetDevToRouterByQrCodeContract.ISetDevToRouterByQrCodeView iSetDevToRouterByQrCodeView;
    private ScanResult scanResult;
    private XMWifiManager xmWifiManager;

    public SetDevToRouterByQrCodePresenter(SetDevToRouterByQrCodeContract.ISetDevToRouterByQrCodeView iSetDevToRouterByQrCodeView) {
        this.iSetDevToRouterByQrCodeView = iSetDevToRouterByQrCodeView;
        this.xmWifiManager = XMWifiManager.getInstance(iSetDevToRouterByQrCodeView.getContext());
    }

    @Override
    protected DeviceManager getManager() {
        return DeviceManager.getInstance();
    }

    @Override
    public Bitmap startSetDevToRouterByQrCode() {
        WifiInfo wifiInfo = this.xmWifiManager.getWifiInfo();
        DhcpInfo dhcpInfo = this.xmWifiManager.getDhcpInfo();
        String ssid = XUtils.initSSID(this.xmWifiManager.getSSID());
        this.scanResult = this.xmWifiManager.getCurScanResult(ssid);
        String wifiPwd = "1qaz2wsx";
        int pwdType = XUtils.getEncrypPasswordType(this.scanResult.capabilities);
        if (pwdType == 3 && (wifiPwd.length() == 10 || wifiPwd.length() == 26)) {
            wifiPwd = XUtils.asciiToString(wifiPwd);
        }
        String ipAddress = Formatter.formatIpAddress((int)dhcpInfo.ipAddress);
        String macAddress = XUtils.getWiFiMacAddress().replace(":", "");
        Bitmap bitmap = ((DeviceManager)this.manager).initDevToRouterByQrCode(ssid, wifiPwd, pwdType, macAddress, ipAddress, new DeviceManager.OnDevWiFiSetListener(){

            @Override
            public void onDevWiFiSetState(int result) {
                if (result < 0) {
                    SetDevToRouterByQrCodePresenter.this.iSetDevToRouterByQrCodeView.onSetDevTouRouterResult(false, null);
                }
            }

            @Override
            public void onDevWiFiSetResult(XMDevInfo xmDevInfo) {
                if (DevDataCenter.getInstance().getLoginType() == 0) {
                    DevDataCenter.getInstance().addDev(xmDevInfo);
                } else {
                    AccountManager.getInstance().addDev(xmDevInfo, new BaseAccountManager.OnAccountManagerListener(){

                        @Override
                        public void onSuccess(int msgId) {
                        }

                        @Override
                        public void onFailed(int msgId, int errorId) {
                        }

                        @Override
                        public void onFunSDKResult(Message msg, MsgContent ex) {
                        }
                    });
                }
                SetDevToRouterByQrCodePresenter.this.iSetDevToRouterByQrCodeView.onSetDevTouRouterResult(true, xmDevInfo);
            }
        });
        ((DeviceManager)this.manager).startDevToRouterByQrCode();
        return bitmap;
    }

    @Override
    public void stopSetDevToRouterByQrCode() {
        ((DeviceManager)this.manager).stopDevToRouterByQrCode();
    }
}

