/*
 * Decompiled with CFR 0.152.
 */
package com.xm.activity.device.monitor.view;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.SeekBar;
import com.xm.activity.base.XMBaseActivity;
import com.xm.activity.device.devset.ability.view.XMDevAbilityActivity;
import com.xm.activity.device.monitor.contract.XMMonitorContract;
import com.xm.activity.device.monitor.presenter.XMMonitorPresenter;
import com.xm.ui.dialog.XMPromptDlg;
import com.xm.ui.media.MultiWinLayout;
import com.xm.ui.media.image.XMVrImageView;
import com.xm.ui.widget.XMSeekBar;
import com.xm.ui.widget.XTitleBar;
import demo.xm.com.libxmfunsdk.R;

public class XMMonitorActivity
extends XMBaseActivity<XMMonitorPresenter>
implements XMMonitorContract.IXMMonitorView {
    private XTitleBar xbMonitorTitle;
    private MultiWinLayout surfaceView;
    private ViewGroup extraSurfaceView;
    private XMSeekBar xmSeekBar;

    @Override
    public XMMonitorPresenter getPresenter() {
        return new XMMonitorPresenter(this);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.funsdk_xm_activity_monitor);
        this.initView();
        this.initData();
    }

    private void initView() {
        this.xbMonitorTitle = (XTitleBar)this.findViewById(R.id.xb_monitor_title);
        this.surfaceView = (MultiWinLayout)this.findViewById(R.id.fl_monitor_surface);
        this.surfaceView.setOnMultiWndListener(new MultiWinLayout.OnMultiWndKeyListener(){

            @Override
            public boolean onKey(int keyCode, KeyEvent event, boolean isToTheBorder) {
                return false;
            }

            @Override
            public boolean isDisableToChangeWndSize(int id2) {
                return false;
            }

            @Override
            public boolean onTouchEvent(int id2, MotionEvent event) {
                return false;
            }

            @Override
            public boolean onSingleWnd(int id2, MotionEvent event, boolean isSingleWnd) {
                return false;
            }

            @Override
            public boolean onSelectedWnd(int id2, MotionEvent event, boolean isSelected) {
                return false;
            }

            @Override
            public boolean onSingleTapUp(int id2, MotionEvent event, boolean isSingleWnd) {
                return false;
            }

            @Override
            public boolean onSingleTapConfirmed(int id2, MotionEvent event, boolean isSingleWnd) {
                return false;
            }

            @Override
            public boolean onDoubleTap(View view, MotionEvent e) {
                if (((XMMonitorPresenter)XMMonitorActivity.this.presenter).isFishCtrlShow()) {
                    ((XMMonitorPresenter)XMMonitorActivity.this.presenter).hideFishCtrlShow();
                }
                return false;
            }

            @Override
            public void onLongPress(View view, MotionEvent e) {
            }

            @Override
            public void onFling(View view, MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            }
        });
        this.surfaceView.setViewCount(1);
        this.extraSurfaceView = (ViewGroup)this.findViewById(R.id.fl_extra_surface);
        this.xbMonitorTitle.setLeftClick((XTitleBar.OnLeftClickListener)this);
        this.xmSeekBar = (XMSeekBar)this.findViewById(R.id.xm_seekbar);
        this.xmSeekBar.getSeekBar().setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                ((XMMonitorPresenter)XMMonitorActivity.this.presenter).setScale((float)seekBar.getProgress() * 0.4f);
                XMMonitorActivity.this.xmSeekBar.getSeekBar().moveIndicator(progress + "");
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.xmSeekBar.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                XMMonitorActivity.this.xmSeekBar.getSeekBar().showIndicator(0, XMMonitorActivity.this.getResources().getColor(R.color.transparent));
            }
        });
    }

    private void initData() {
        ViewGroup.LayoutParams layoutParams = this.surfaceView.getLayoutParams();
        if (layoutParams != null) {
            layoutParams.height = this.screenWidth * 9 / 16;
        }
        ((XMMonitorPresenter)this.presenter).initMonitorPlayer(this.surfaceView.getWnd(0), this.extraSurfaceView);
        this.xbMonitorTitle.setTitleText(((XMMonitorPresenter)this.presenter).getDevId());
    }

    @Override
    protected void onResume() {
        super.onResume();
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                ((XMMonitorPresenter)XMMonitorActivity.this.presenter).startMonitor();
            }
        }, 500L);
    }

    @Override
    public void onPlayState(int playState) {
        this.hideWaitDialog();
    }

    @Override
    public void onVideoScaleResult(float scale) {
        this.xmSeekBar.setProgress((int)(scale / 0.4f));
    }

    @Override
    public void onCaptureResult(final String imgPath) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                View layout2 = LayoutInflater.from((Context)XMMonitorActivity.this).inflate(R.layout.funsdk_view_test, null);
                XMVrImageView imageView = (XMVrImageView)layout2.findViewById(R.id.iv_test);
                imageView.setImagePath(imgPath);
                imageView.setHasGestureOperate(true);
                XMPromptDlg.onShow((Context)XMMonitorActivity.this, layout2);
            }
        });
    }

    @Override
    public Activity getActivity() {
        return this;
    }

    @Override
    protected void onPause() {
        super.onPause();
        ((XMMonitorPresenter)this.presenter).stopMonitor();
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        ((XMMonitorPresenter)this.presenter).destroyMonitor();
    }

    public void onCapture(View view) {
        ((XMMonitorPresenter)this.presenter).capture();
    }

    public void onGetDevAbility(View view) {
        this.turnToActivity(XMDevAbilityActivity.class);
    }

    public void onExtraSensor1(View view) {
        ((XMMonitorPresenter)this.presenter).changeStream();
    }

    public void onExtraSensor2(View view) {
    }
}

