/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.lib.FunSDK;
import com.lib.sdk.bean.DayLightTimeBean;
import demo.xm.com.libxmfunsdk.R;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.NetworkInterface;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.apache.commons.lang3.StringUtils;

public class XUtils {
    private static long lastClickTime;
    private static final int ONE_TB = 0x40000000;
    private static final int ONE_GB = 0x100000;
    private static final int ONE_MB = 1024;
    private static final String MATCH_URL_PATTERN = "^(https?:\\/\\/){0}([\\da-z|_\\.-]+)\\.([a-z\\.]{2,6})([\\/\\w \\.-]*)*\\/?$";
    private static final String MATCH_IP_PATTERN = "^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
    private static final String MATCH_CODE_PATTERN = "^[0-9]{27}$";
    private static final String MATCH_EMAIL_PATTERN = "^([a-zA-Z0-9_\\-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$";
    private static final String MATCH_DESENSITIZATION_EMAIL_PATTERN = "^([a-zA-Z0-9_*\\-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$";
    private static final String MATCH_CORRECT_PWD_PATTERN = "(?![^a-zA-Z0-9]+$)(?![^a-zA-Z/D]+$)(?![^0-9/D]+$).{8,32}$";
    private static final String MATCH_NUMBER_PATTERN = "[0-9]*";
    private static final String MATCH_CHINA_PHONE_NUMBER_PATIERN = "^1[0-9]\\d{9}$";
    private static final String RANDOM_UUID = "random_uuid";
    private static final String XM_PUSH_TOKEN = "xm_push_token";
    private static final String USER_AGENT_INFO = "UserAgentInfo";
    public static final long SEVENDAY_TIMEMILLIS = 604800000L;
    private static final String REQUEST_CODE_URL = "https://tools.xmeye.net/deviceSuperPassword?text=%s&uuid=%s&appkey=%s";

    public static boolean notEmpty(String s) {
        return s != null && !"".equals(s) && !"null".equals(s) && !"undefined".equals(s) && s.trim().length() > 0;
    }

    public static boolean isEmpty(String s) {
        return !XUtils.notEmpty(s);
    }

    public static boolean isInteger(String numberStr) {
        return XUtils.isPatternMatches(numberStr, MATCH_NUMBER_PATTERN);
    }

    public static String getVersion(Context context) {
        if (context == null) {
            return null;
        }
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            String version = info.versionName;
            return version;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Unkown";
        }
    }

    public static String getAppName(Context context) {
        if (context == null) {
            return null;
        }
        PackageManager manager = context.getPackageManager();
        try {
            ApplicationInfo info = manager.getApplicationInfo(context.getPackageName(), 0);
            String appName = manager.getApplicationLabel(info).toString();
            return appName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Unkown";
        }
    }

    public static String getPackageName(Context context) {
        if (context == null) {
            return null;
        }
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            return info.packageName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isMainProcessExist(Context context) {
        ActivityManager mActivityManager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningAppProcessInfo appProcess : mActivityManager.getRunningAppProcesses()) {
            if (!appProcess.processName.equalsIgnoreCase(XUtils.getPackageName(context))) continue;
            return true;
        }
        return false;
    }

    public static boolean isMainProcess(Context context) {
        int pid = Process.myPid();
        ActivityManager mActivityManager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningAppProcessInfo appProcess : mActivityManager.getRunningAppProcesses()) {
            if (appProcess.pid != pid || !appProcess.processName.equalsIgnoreCase(XUtils.getPackageName(context))) continue;
            return true;
        }
        return false;
    }

    public static boolean isPushProcess(Context context) {
        int pid = Process.myPid();
        ActivityManager mActivityManager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningAppProcessInfo appProcess : mActivityManager.getRunningAppProcesses()) {
            if (appProcess.pid != pid || !appProcess.processName.equalsIgnoreCase(XUtils.getPackageName(context) + ":push")) continue;
            return true;
        }
        return false;
    }

    public static boolean isProcess(Context context) {
        int pid = Process.myPid();
        ActivityManager mActivityManager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningAppProcessInfo appProcess : mActivityManager.getRunningAppProcesses()) {
            if (appProcess.pid != pid || !appProcess.processName.equalsIgnoreCase(XUtils.getPackageName(context))) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmail(String email) {
        return email == null ? false : XUtils.isPatternMatches(email, MATCH_EMAIL_PATTERN);
    }

    public static boolean isDeSensitizationEmail(String email) {
        return XUtils.isPatternMatches(email, MATCH_DESENSITIZATION_EMAIL_PATTERN);
    }

    public static boolean isPhoneNum(String phoneNumber) {
        return phoneNumber != null && XUtils.isPatternMatches(phoneNumber, MATCH_CHINA_PHONE_NUMBER_PATIERN);
    }

    public static boolean isPhoneNum(String phoneNumber, String phoneNumberRule) {
        if (TextUtils.isEmpty((CharSequence)phoneNumber)) {
            return false;
        }
        if (phoneNumberRule == null) {
            phoneNumberRule = MATCH_CHINA_PHONE_NUMBER_PATIERN;
        }
        return XUtils.isPatternMatches(phoneNumber, phoneNumberRule);
    }

    public static boolean isSn(String sn) {
        return FunSDK.IsDevSN((String)sn) == 1;
    }

    public static String getSnByDesensitization(String sn) {
        if (XUtils.isSn(sn)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(sn.substring(0, 8));
            stringBuffer.append("****");
            stringBuffer.append(sn.substring(12));
            return stringBuffer.toString();
        }
        return sn;
    }

    public static String getDevUserNameByDesensitization(String devLoginName) {
        if (!TextUtils.isEmpty((CharSequence)devLoginName)) {
            int length = devLoginName.length();
            StringBuffer stringBuffer = new StringBuffer();
            if (length == 4) {
                stringBuffer.append(devLoginName.substring(0, 1));
                stringBuffer.append("**");
                stringBuffer.append(devLoginName.substring(3));
                return stringBuffer.toString();
            }
            if (length == 5) {
                stringBuffer.append(devLoginName.substring(0, 1));
                stringBuffer.append("***");
                stringBuffer.append(devLoginName.substring(4));
                return stringBuffer.toString();
            }
            if (length >= 6) {
                stringBuffer.append(devLoginName.substring(0, length / 2 - 2));
                stringBuffer.append("****");
                stringBuffer.append(devLoginName.substring(length / 2 + 2));
                return stringBuffer.toString();
            }
        }
        return devLoginName;
    }

    public static boolean isDeviceCode(String code) {
        return code != null && XUtils.isPatternMatches(code, MATCH_CODE_PATTERN);
    }

    public static boolean isIP(String ip) {
        return ip == null ? false : XUtils.isPatternMatches(ip, MATCH_IP_PATTERN);
    }

    public static boolean isURL(String url) {
        return url == null ? false : XUtils.isPatternMatches(url, MATCH_URL_PATTERN);
    }

    public static boolean isPatternMatches(CharSequence val, String match) {
        if (null == val) {
            return false;
        }
        Pattern p = Pattern.compile(match);
        Matcher m = p.matcher(val);
        return m.matches();
    }

    public static boolean isFastDoubleClick() {
        long time = System.currentTimeMillis();
        if (time - lastClickTime < 500L) {
            return true;
        }
        lastClickTime = time;
        return false;
    }

    public static String getMacAddress() {
        String result = "";
        String Mac = "";
        result = XUtils.callCmd("busybox ifconfig", "HWaddr");
        if (result == null) {
            return null;
        }
        if (result.length() > 0 && result.contains("HWaddr")) {
            Mac = result.substring(result.indexOf("HWaddr") + 6, result.length() - 1);
            Log.i((String)"test", (String)("Mac:" + Mac + " Mac.length: " + Mac.length()));
            if (Mac.length() > 1) {
                Mac = Mac.replaceAll(" ", "");
                result = "";
                String[] tmp = Mac.split(":");
                for (int i = 0; i < tmp.length; ++i) {
                    result = result + tmp[i];
                }
            }
            Log.i((String)"test", (String)(result + " result.length: " + result.length()));
        }
        return result;
    }

    private static String callCmd(String cmd, String filter) {
        String result = "";
        String line = "";
        try {
            java.lang.Process proc = Runtime.getRuntime().exec(cmd);
            InputStreamReader is = new InputStreamReader(proc.getInputStream());
            BufferedReader br = new BufferedReader(is);
            while ((line = br.readLine()) != null && !line.contains(filter)) {
                Log.i((String)"test", (String)("line: " + line));
            }
            result = line;
            Log.i((String)"test", (String)("result: " + result));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean isServiceRunning(Context mContext, String className) {
        boolean isRunning = false;
        ActivityManager activityManager = (ActivityManager)mContext.getSystemService("activity");
        List serviceList = activityManager.getRunningServices(200);
        if (serviceList.size() <= 0) {
            return false;
        }
        for (int i = 0; i < serviceList.size(); ++i) {
            if (!StringUtils.contains((CharSequence)((ActivityManager.RunningServiceInfo)serviceList.get((int)i)).service.getClassName(), (CharSequence)className) || !StringUtils.contains((CharSequence)((ActivityManager.RunningServiceInfo)serviceList.get((int)i)).service.getPackageName(), (CharSequence)mContext.getPackageName())) continue;
            isRunning = true;
            break;
        }
        return isRunning;
    }

    public static String getBackClassName(Context context) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List task_info = manager.getRunningTasks(20);
        String className = "";
        for (int i = 0; i < task_info.size(); ++i) {
            if (!"com.mobile.myeye".equals(((ActivityManager.RunningTaskInfo)task_info.get((int)i)).topActivity.getPackageName())) continue;
            className = ((ActivityManager.RunningTaskInfo)task_info.get((int)i)).topActivity.getClassName();
        }
        return className;
    }

    public static Bitmap createImageThumbnail(String filePath) {
        Bitmap bitmap = null;
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)opts);
        opts.inSampleSize = XUtils.computeSampleSize(opts, -1, 16384);
        opts.inJustDecodeBounds = false;
        try {
            bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)opts);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bitmap;
    }

    public static Bitmap decodeFile(Context context, String picturePath) {
        Bitmap bitmap = BitmapFactory.decodeFile((String)picturePath);
        if (bitmap == null) {
            bitmap = XUtils.getBitmapFromUri(context, XUtils.getImageContentUri(context, picturePath));
        }
        return bitmap;
    }

    public static Bitmap decodeFile(Context context, String picturePath, BitmapFactory.Options opts) {
        Bitmap bitmap = BitmapFactory.decodeFile((String)picturePath, (BitmapFactory.Options)opts);
        if (bitmap == null) {
            bitmap = XUtils.getBitmapFromUri(context, XUtils.getImageContentUri(context, picturePath), opts);
        }
        if (bitmap == null) {
            bitmap = XUtils.decodeFile(context, picturePath);
        }
        return bitmap;
    }

    public static Bitmap dealBitmapAdaptationSize(String filePath, int width, int height) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        if (bitmap == null) {
            return null;
        }
        Bitmap newBtimap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        if (!bitmap.equals(newBtimap)) {
            bitmap.recycle();
            bitmap = null;
        }
        return newBtimap;
    }

    public static final int sp2px(Context context, float sp) {
        float scale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(sp * scale + 0.5f);
    }

    public static int computeSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int roundedSize;
        int initialSize = XUtils.computeInitialSampleSize(options, minSideLength, maxNumOfPixels);
        if (initialSize <= 8) {
            for (roundedSize = 1; roundedSize < initialSize; roundedSize <<= 1) {
            }
        } else {
            roundedSize = (initialSize + 7) / 8 * 8;
        }
        return roundedSize;
    }

    public static int dp2px(Context context, float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    private static int computeInitialSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int upperBound;
        double w = options.outWidth;
        double h = options.outHeight;
        int lowerBound = maxNumOfPixels == -1 ? 1 : (int)Math.ceil(Math.sqrt(w * h / (double)maxNumOfPixels));
        int n = upperBound = minSideLength == -1 ? 128 : (int)Math.min(Math.floor(w / (double)minSideLength), Math.floor(h / (double)minSideLength));
        if (upperBound < lowerBound) {
            return lowerBound;
        }
        if (maxNumOfPixels == -1 && minSideLength == -1) {
            return 1;
        }
        if (minSideLength == -1) {
            return lowerBound;
        }
        return upperBound;
    }

    public static String getMediaPath(Context context) {
        File dirFile = Environment.getExternalStorageDirectory();
        if (dirFile == null || !dirFile.canWrite() || !dirFile.canRead()) {
            return XUtils.getAndroidPath(context);
        }
        return dirFile.getAbsolutePath();
    }

    public static String getDataPath(Context context) {
        File dirFile = context.getFilesDir();
        if (dirFile == null) {
            dirFile = context.getExternalFilesDir(null);
        }
        if (dirFile != null) {
            return dirFile.getAbsolutePath();
        }
        return null;
    }

    public static String getAndroidPath(Context context) {
        File dirFile = context.getExternalFilesDir(null);
        if (dirFile == null) {
            dirFile = context.getFilesDir();
        }
        return dirFile.getAbsolutePath();
    }

    public static String getUsedTime(int time) {
        String result = "";
        int hour = time / 3600;
        if (hour > 0) {
            if (hour < 10) {
                result = result + "0";
            }
            result = result + time / 3600 + ":";
        } else {
            result = result + "00:";
        }
        int minute = (time %= 3600) / 60;
        if (minute > 0) {
            if (minute < 10) {
                result = result + "0";
            }
            result = result + minute + ":";
        } else {
            result = result + "00:";
        }
        if ((time %= 60) > 0) {
            if (time < 10) {
                result = result + "0";
            }
            result = result + time;
        } else {
            result = result + "00";
        }
        return result;
    }

    public static int[] getUsedTimeV2(int time) {
        int[] times = new int[3];
        if (time >= 60) {
            times[1] = time / 60;
            times[2] = time % 60;
            if (times[1] > 0) {
                times[0] = times[1] / 24;
                times[1] = times[1] % 24;
            }
        } else {
            times[0] = 0;
            times[1] = 0;
            times[2] = time;
        }
        return times;
    }

    public static String date2Str(String formater, Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(formater);
        return sdf.format(date);
    }

    public static Date str2Date(String date, String formater) {
        if (XUtils.notEmpty(date)) {
            SimpleDateFormat sdf = new SimpleDateFormat(formater);
            try {
                return sdf.parse(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
                return new Date();
            }
        }
        return null;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            inSampleSize = width > height ? Math.round((float)height / (float)reqHeight) : Math.round((float)width / (float)reqWidth);
        }
        return inSampleSize;
    }

    public static final Bitmap greyBitmap(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Bitmap faceIconGreyBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(faceIconGreyBitmap);
        Paint paint = new Paint();
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0.0f);
        ColorMatrixColorFilter colorMatrixFilter = new ColorMatrixColorFilter(colorMatrix);
        paint.setColorFilter((ColorFilter)colorMatrixFilter);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return faceIconGreyBitmap;
    }

    public static String getFileSize(int size) {
        String result = "";
        result = size > 0x40000000 ? size / 0x40000000 + "T" : (size > 0x100000 ? size / 0x100000 + "G" : (size > 1024 ? size / 1024 + "M" : (size <= 0 ? "" : size + "K")));
        return result;
    }

    public static String getFileSize(long size) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        fileSizeString = size < 1024L ? df.format((double)size) + "B" : (size < 0x100000L ? df.format((double)size / 1024.0) + "K" : (size < 0x40000000L ? df.format((double)size / 1048576.0) + "M" : df.format((double)size / 1.073741824E9) + "G"));
        return fileSizeString;
    }

    public static String getFileSizeByMB(int size) {
        if (size > 0) {
            if (size > 0x100000) {
                return String.format("%.2f", (double)size / 1048576.0) + "T";
            }
            if (size > 1024) {
                return String.format("%.2f", (double)size / 1024.0) + "G";
            }
            return size + "M";
        }
        return "0M";
    }

    public static String getStreamSize(int size) {
        double stream = (double)size * 8.0;
        if (stream < 1024.0) {
            return (int)stream + "b/s";
        }
        if (stream < 1048576.0) {
            return String.format("%.1f", stream / 1024.0) + "Kb/s";
        }
        if (stream < 5.24288E7) {
            return String.format("%.1f", stream / 1024.0 / 1024.0) + "Mb/s";
        }
        return "";
    }

    public static String addZero(int from) {
        String str = String.valueOf(from);
        return str.length() > 1 ? str : "0" + str;
    }

    public static String getVideoFileName(String strId) {
        String splitStr;
        String str;
        String beginTimeStr = XUtils.GetString(strId, "st_3_beginTime", "st_4_endTime");
        beginTimeStr = XUtils.GetString(beginTimeStr, "[", "]");
        String[] beginStr = beginTimeStr.split(",");
        StringBuffer sb = new StringBuffer();
        sb.append("s-");
        for (int i = 0; i < beginStr.length; ++i) {
            str = beginStr[i];
            if (str.contains("wday") || str.contains("isdst")) continue;
            splitStr = str.split("=")[1];
            if (Integer.valueOf(splitStr) < 10) {
                splitStr = "0" + splitStr;
            }
            sb.append(splitStr);
        }
        System.out.println(sb.toString());
        String endTimeStr = strId.substring(strId.indexOf("st_4_endTime"));
        System.out.println(endTimeStr);
        endTimeStr = XUtils.GetString(endTimeStr, "[", "],");
        String[] endStr = endTimeStr.split(",");
        sb.append("_e-");
        for (int k = 0; k < endStr.length; ++k) {
            str = endStr[k];
            if (!str.contains("hour") && !str.contains("minute") && !str.contains("second")) continue;
            splitStr = str.split("=")[1];
            if (Integer.valueOf(splitStr) < 10) {
                splitStr = "0" + splitStr;
            }
            sb.append(splitStr);
        }
        sb.append(".mp4");
        System.out.println(sb.toString());
        return sb.toString();
    }

    public static String GetString(String strId, String start, String end) {
        if (strId != null && strId.length() >= strId.indexOf(start) && strId.length() >= strId.indexOf(end)) {
            return strId.substring(strId.indexOf(start), strId.indexOf(end));
        }
        return null;
    }

    public static long isFileExists(String file) {
        File f = new File(file);
        if (f.exists()) {
            return f.length();
        }
        return 0L;
    }

    public static String initSSID(String ssid) {
        if (XUtils.notEmpty(ssid) && ssid.startsWith("\"") && ssid.endsWith("\"")) {
            return ssid.substring(1, ssid.length() - 1);
        }
        return ssid;
    }

    public static boolean maybeIs5GHzWiFi(String ssid) {
        return XUtils.notEmpty(ssid) && ssid.endsWith("_5G");
    }

    public static int getEncrypPasswordType(String capabilities) {
        if (capabilities.contains("WPA2") && capabilities.contains("CCMP")) {
            return 1;
        }
        if (capabilities.contains("WPA2") && capabilities.contains("TKIP")) {
            return 2;
        }
        if (capabilities.contains("WPA") && capabilities.contains("TKIP")) {
            return 2;
        }
        if (capabilities.contains("WPA") && capabilities.contains("CCMP")) {
            return 1;
        }
        if (capabilities.contains("WEP")) {
            return 3;
        }
        return 0;
    }

    public static String asciiToString(String value) {
        StringBuffer sbu = new StringBuffer();
        int pos = 0;
        int length = value.length();
        String str = null;
        do {
            str = value.substring(pos, pos + 2);
            sbu.append((char)Integer.parseInt(str, 16));
        } while ((pos += 2) <= length - 2);
        return sbu.toString();
    }

    public static boolean isTopActivity(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List tasksInfo = am.getRunningTasks(100);
        if (tasksInfo.size() > 0) {
            String _className = ((ActivityManager.RunningTaskInfo)tasksInfo.get((int)0)).topActivity.getClassName();
            if (context.getClass().getName().equals(_className)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isTopActivity(Context context, String className) {
        String _className;
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List tasksInfo = am.getRunningTasks(100);
        return tasksInfo.size() > 0 && StringUtils.contains((CharSequence)className, (CharSequence)(_className = ((ActivityManager.RunningTaskInfo)tasksInfo.get((int)0)).topActivity.getClassName()));
    }

    public static boolean isExistMainActivity(Context context, Class<?> activity) {
        Intent intent = new Intent(context, activity);
        ComponentName cmpName = intent.resolveActivity(context.getPackageManager());
        boolean flag = false;
        if (cmpName != null) {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            List taskInfoList = am.getRunningTasks(10);
            for (ActivityManager.RunningTaskInfo taskInfo : taskInfoList) {
                if (!taskInfo.baseActivity.equals((Object)cmpName)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static int getExistActivityNumbers(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List taskInfoList = activityManager.getRunningTasks(10);
        int numActivities = ((ActivityManager.RunningTaskInfo)taskInfoList.get((int)0)).numActivities;
        return numActivities;
    }

    public static int getRamdom(int start, int end) {
        Random r = new Random();
        int result = r.nextInt(end) % (end - start + 1) + start;
        return result;
    }

    public static String getCountry() {
        return Locale.getDefault().getCountry();
    }

    public static boolean getMobileConnectStatus(Context context) {
        NetworkInfo mMobile = null;
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connManager != null) {
            mMobile = connManager.getNetworkInfo(0);
        }
        if (mMobile != null) {
            return mMobile.isConnectedOrConnecting();
        }
        return false;
    }

    public static int strCountByByte(String s) {
        s = s.replaceAll("[^\\x00-\\xff]", "**");
        int length = s.length();
        return length;
    }

    public static boolean isZh() {
        String language = XUtils.getLanguageEnv();
        return language != null && (language.trim().equals("zh-CN") || language.trim().equals("zh-TW"));
    }

    private static String getLanguageEnv() {
        Locale l = Locale.getDefault();
        String language = l.getLanguage();
        String country = l.getCountry().toLowerCase();
        if ("zh".equals(language)) {
            if ("cn".equals(country)) {
                language = "zh";
            } else if ("tw".equals(country)) {
                language = "zh-TW";
            }
        } else if ("pt".equals(language)) {
            if ("br".equals(country)) {
                language = "pt-BR";
            } else if ("pt".equals(country)) {
                language = "pt-PT";
            }
        }
        return language;
    }

    public static String getLanguage() {
        return XUtils.getLanguageEnv();
    }

    public static String getIoTLanguage() {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String lan = "en";
        String country = locale.getCountry().toLowerCase();
        if (language.compareToIgnoreCase("zh") == 0) {
            lan = country.compareToIgnoreCase("TW") == 0 || country.compareToIgnoreCase("HK") == 0 ? "zh_TW" : "zh_CN";
        } else if (language.compareToIgnoreCase("ko") == 0) {
            if (country.compareToIgnoreCase("KR") == 0) {
                lan = "ko_KR";
            }
        } else if (language.compareToIgnoreCase("vi") == 0) {
            lan = "vi_CN";
        } else if (language.compareToIgnoreCase("de") == 0) {
            lan = "de_US";
        } else if (language.compareToIgnoreCase("es") == 0) {
            lan = "es_US";
        } else if (language.compareToIgnoreCase("fr") == 0) {
            lan = "fr_US";
        } else if (language.compareToIgnoreCase("it") == 0) {
            lan = "it_US";
        } else if (language.compareToIgnoreCase("ja") == 0) {
            lan = "ja_CN";
        } else if (language.compareToIgnoreCase("pt") == 0) {
            lan = "pt_BR";
        } else if (language.compareToIgnoreCase("th") == 0) {
            lan = "th_CN";
        } else if (language.compareToIgnoreCase("tr") == 0) {
            lan = "tr";
        } else if (language.compareToIgnoreCase("ru") == 0) {
            lan = "ru_CN";
        } else if (language.compareToIgnoreCase("pl") == 0) {
            lan = "pl";
        }
        return lan;
    }

    public static String getSetLanguage() {
        Locale l = Locale.getDefault();
        String language = l.getLanguage();
        String country = l.getCountry().toLowerCase();
        if ("zh".equals(language)) {
            if ("cn".equals(country)) {
                return "SimpChinese";
            }
            if ("tw".equals(country)) {
                return "TradChinese";
            }
        } else {
            if ("en".equals(language)) {
                return "English";
            }
            if ("ko".equals(language)) {
                return "Korean";
            }
            if ("pt".equals(language)) {
                return "Portugal";
            }
            if ("fr".equals(language)) {
                return "French";
            }
            if ("tu".equals(language)) {
                return "Turkey";
            }
            if ("sp".equals(language)) {
                return "Spanish";
            }
            if ("ru".equals(language)) {
                return "Russian";
            }
            if ("it".equals(language)) {
                return "Italian";
            }
            if ("de".equals(language)) {
                return "German";
            }
            if ("ja".equals(language)) {
                return "Japanese";
            }
            if ("th".equals(language)) {
                return "Thai";
            }
            if ("vi".equals(language)) {
                return "Vietnamese";
            }
        }
        return "English";
    }

    public static boolean isBinaryValueOne(int binary, int where) {
        String binaryStr = Integer.toBinaryString(binary);
        Log.e((String)"www", (String)("char--->" + binaryStr));
        if (binaryStr.length() < where + 1) {
            return false;
        }
        char ch = binaryStr.charAt(where);
        Log.e((String)"www", (String)("char--->" + ch));
        return ch == '1';
    }

    public static boolean isLandScape(Activity mActivity) {
        return null != mActivity && mActivity.getResources().getConfiguration().orientation == 2;
    }

    public static boolean isPortrait(Activity mActivity) {
        return null != mActivity && mActivity.getResources().getConfiguration().orientation == 1;
    }

    public static boolean isSameSN(String strOptDevID, String sn) {
        return strOptDevID.equals(sn) || strOptDevID == sn;
    }

    public static int getVersionCode(Context context) {
        if (context == null) {
            return 0;
        }
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            int versionCode = info.versionCode;
            return versionCode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getMobileUUID(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String deviceId = telephonyManager.getDeviceId();
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        String uuid = "";
        String uuid1 = "";
        if (deviceId != null) {
            uuid1 = deviceId;
        }
        if (!"9774d56d682e549c".equals(androidId)) {
            uuid = androidId;
        }
        return uuid + uuid1;
    }

    public static String getPushToken(Context context) {
        String userId = FunSDK.GetFunStrAttr((int)12);
        String androidId = null;
        String pushToken = userId;
        try {
            pushToken = userId;
            try {
                androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pushToken = androidId == null ? pushToken + "-" + UUID.randomUUID().toString() : pushToken + "_" + androidId;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pushToken;
    }

    public static boolean contrast(String str1, String str2) {
        if (str1 == null && str2 != null) {
            return false;
        }
        if (str1 != null && str2 == null) {
            return false;
        }
        if (str1 == null && str2 == null) {
            return true;
        }
        return str1.equals(str2);
    }

    public static boolean isMobileNO(String mobiles) {
        boolean flag = false;
        try {
            mobiles = mobiles.replace(" ", "");
            if (mobiles.startsWith("(+") || mobiles.startsWith("+")) {
                return true;
            }
            Pattern p = Pattern.compile("[1][\\d|*]{10}$");
            Matcher m = p.matcher(mobiles);
            flag = m.matches();
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static int convertDpToPx(float dp, Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int[] getButtonPixels(View view) {
        if (null == view) {
            return null;
        }
        int[] pixels = new int[view.getWidth() * view.getHeight()];
        view.setDrawingCacheEnabled(true);
        Bitmap bitmap = view.getDrawingCache();
        if (null == bitmap) {
            return null;
        }
        bitmap.getPixels(pixels, 0, view.getWidth(), 0, 0, view.getWidth(), view.getHeight());
        view.setDrawingCacheEnabled(false);
        return pixels;
    }

    public static byte[] getPixelsToDevice(View view) {
        int n = 0;
        int m = 0;
        int[] pixels = XUtils.getButtonPixels(view);
        int w = view.getWidth();
        int h = view.getHeight();
        int bytesPerPixel = 1;
        int bytesPerRow = bytesPerPixel * w;
        byte[] pRet = new byte[w * h / 8];
        if (null == pixels) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                int offset = bytesPerRow * i + bytesPerPixel * j;
                if (pixels[offset] != -1) {
                    int n2 = m;
                    pRet[n2] = (byte)(pRet[n2] | 1 << 7 - n);
                    sb.append("*");
                } else {
                    sb.append(" ");
                }
                if (++n != 8) continue;
                ++m;
                n = 0;
            }
            sb.append("\n");
        }
        System.out.println(sb.toString());
        return pRet;
    }

    public static ArrayList<Integer> getParseMask(int mask) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int index = 0;
        do {
            if ((mask & 1) != 1) continue;
            result.add(index++);
        } while ((mask >>= 1) != 0);
        return result;
    }

    public static void alertIsWIFIConnect(Context context) {
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo mWifi = connManager.getNetworkInfo(1);
        if (!mWifi.isConnectedOrConnecting()) {
            Toast.makeText((Context)context, (int)R.string.libfunsdk_consumption_warning, (int)1).show();
        }
    }

    @SuppressLint(value={"NewApi"})
    public static boolean isNavigationBarShow(Activity activity) {
        if (Build.VERSION.SDK_INT >= 17) {
            Display display = activity.getWindowManager().getDefaultDisplay();
            Point size = new Point();
            Point realSize = new Point();
            display.getSize(size);
            display.getRealSize(realSize);
            return realSize.y != size.y;
        }
        boolean menu = ViewConfiguration.get((Context)activity).hasPermanentMenuKey();
        boolean back = KeyCharacterMap.deviceHasKey((int)4);
        return !menu && !back;
    }

    public static int getNavigationBarHeight(Activity activity) {
        if (!XUtils.isNavigationBarShow(activity)) {
            return 0;
        }
        Resources resources = activity.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        int height = resources.getDimensionPixelSize(resourceId);
        return height;
    }

    public static int getStatusBarHeight(Context context) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(new int[]{16843277});
        boolean windowFullscreen = typedArray.getBoolean(0, false);
        typedArray.recycle();
        if (windowFullscreen) {
            return 0;
        }
        int height = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            height = context.getResources().getDimensionPixelSize(resourceId);
        }
        return height;
    }

    public static int getScreenWidth(Activity activity) {
        if (null == activity) {
            return 0;
        }
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        if (null != dm) {
            return dm.widthPixels;
        }
        return 0;
    }

    public static int getScreenHeight(Activity activity) {
        if (null == activity) {
            return 0;
        }
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        if (null != dm) {
            return dm.heightPixels + XUtils.getNavigationBarHeight(activity);
        }
        return 0;
    }

    public static int getScreenHeightNoNavigationBar(Activity activity) {
        if (null == activity) {
            return 0;
        }
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        if (null != dm) {
            return dm.heightPixels;
        }
        return 0;
    }

    public static int getScreenHeightNoStateBar(Activity activity) {
        if (null == activity) {
            return 0;
        }
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        if (null != dm) {
            return dm.heightPixels;
        }
        return 0;
    }

    public static final int getCapabilities(String capabilities) {
        if (!TextUtils.isEmpty((CharSequence)capabilities)) {
            if (capabilities.contains("WPA") || capabilities.contains("wpa")) {
                return 1;
            }
            if (capabilities.contains("WEP") || capabilities.contains("wep")) {
                return 2;
            }
            return 0;
        }
        return 0;
    }

    public static boolean isApplicationAvilible(Context context, String appPackageName) {
        PackageManager packageManager = context.getPackageManager();
        List pinfo = packageManager.getInstalledPackages(0);
        if (pinfo != null) {
            for (int i = 0; i < pinfo.size(); ++i) {
                String pn = ((PackageInfo)pinfo.get((int)i)).packageName;
                if (!appPackageName.equals(pn)) continue;
                return true;
            }
        }
        return false;
    }

    public static int dp2px(Context context, int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static DayLightTimeBean getDayLightTimeInfo(TimeZone tz) {
        DayLightTimeBean dltInfo;
        block9: {
            dltInfo = new DayLightTimeBean();
            dltInfo.useDLT = tz.useDaylightTime();
            if (dltInfo.useDLT) {
                try {
                    int day;
                    String tmpStr;
                    Date date = new Date();
                    SimpleDateFormat sdfYear = new SimpleDateFormat("yyyy");
                    sdfYear.setTimeZone(tz);
                    SimpleDateFormat sdfDay = new SimpleDateFormat("yyyy-MM-dd");
                    sdfDay.setTimeZone(tz);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    sdf.setTimeZone(tz);
                    dltInfo.year = Integer.parseInt(sdfYear.format(date));
                    for (int month = 1; month <= 12; ++month) {
                        tmpStr = String.format("%04d-%02d-%02d", dltInfo.year, month, 1);
                        if (dltInfo.beginMonth == 0 && tz.inDaylightTime(sdfDay.parse(tmpStr))) {
                            dltInfo.beginMonth = month;
                        }
                        if (dltInfo.beginMonth > 0 && dltInfo.endMonth == 0 && !tz.inDaylightTime(sdfDay.parse(tmpStr))) {
                            dltInfo.endMonth = month;
                        }
                        if (dltInfo.beginMonth <= 0 || dltInfo.endMonth <= 0 || !tz.inDaylightTime(sdfDay.parse(tmpStr))) continue;
                        dltInfo.beginMonth = month;
                        break;
                    }
                    if (dltInfo.beginMonth > 1) {
                        dltInfo.beginDay = 1;
                        for (day = 1; day <= 31; ++day) {
                            tmpStr = String.format("%04d-%02d-%02d", dltInfo.year, dltInfo.beginMonth - 1, day);
                            if (!tz.inDaylightTime(sdfDay.parse(tmpStr))) continue;
                            dltInfo.beginDay = day;
                            --dltInfo.beginMonth;
                            break;
                        }
                    }
                    if (dltInfo.endMonth <= 1) break block9;
                    dltInfo.endDay = 1;
                    for (day = 1; day <= 31; ++day) {
                        int year = dltInfo.beginMonth > dltInfo.endMonth ? dltInfo.year + 1 : dltInfo.year;
                        String tmpStr2 = String.format("%04d-%02d-%02d", year, dltInfo.endMonth - 1, day);
                        if (tz.inDaylightTime(sdfDay.parse(tmpStr2))) continue;
                        --dltInfo.endMonth;
                        dltInfo.endDay = day;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return dltInfo;
    }

    public static void translateLayoutLanguage(ViewGroup layout2) {
        if (layout2 == null) {
            return;
        }
        int count = layout2.getChildCount();
        for (int i = 0; i < count; ++i) {
            View v = layout2.getChildAt(i);
            if (v instanceof ViewGroup) {
                XUtils.translateLayoutLanguage((ViewGroup)v);
                continue;
            }
            if (!(v instanceof TextView)) continue;
            if (((TextView)v).getText() != null) {
                String text = FunSDK.TS((String)((TextView)v).getText().toString());
                ((TextView)v).setText((CharSequence)text);
            }
            if (((TextView)v).getHint() == null) continue;
            ((TextView)v).setHint((CharSequence)FunSDK.TS((String)((TextView)v).getHint().toString()));
        }
    }

    public static void translateLayoutLanguage(@NonNull Activity activity) {
        ViewGroup layout2 = XUtils.getXMRootLayout(activity);
        if (layout2 == null) {
            return;
        }
        int count = layout2.getChildCount();
        for (int i = 0; i < count; ++i) {
            View v = layout2.getChildAt(i);
            if (v instanceof ViewGroup) {
                XUtils.translateLayoutLanguage((ViewGroup)v);
                continue;
            }
            if (!(v instanceof TextView)) continue;
            if (((TextView)v).getText() != null) {
                String text = FunSDK.TS((String)((TextView)v).getText().toString());
                ((TextView)v).setText((CharSequence)text);
            }
            if (((TextView)v).getHint() == null) continue;
            ((TextView)v).setHint((CharSequence)FunSDK.TS((String)((TextView)v).getHint().toString()));
        }
    }

    public static ViewGroup getXMRootLayout(@NonNull Activity activity) {
        View v;
        if (activity == null) {
            return null;
        }
        ViewGroup layout2 = (ViewGroup)activity.findViewById(R.id.xm_root_layout);
        if (layout2 == null && (v = activity.getCurrentFocus()) != null) {
            ViewParent vp = v.getParent();
            if (vp == null) {
                layout2 = (ViewGroup)v;
            } else {
                layout2 = (ViewGroup)vp;
                while ((vp = vp.getParent()) != null) {
                    layout2 = (ViewGroup)vp;
                }
            }
        }
        return layout2;
    }

    public static Bitmap createQRCodeBitmap(String text, Bitmap logo, BarcodeFormat format, int qrSize) throws WriterException {
        Matrix matrix = new Matrix();
        float sx = 80.0f / (float)logo.getWidth();
        float sy = 80.0f / (float)logo.getHeight();
        matrix.setScale(sx, sy);
        logo = Bitmap.createBitmap((Bitmap)logo, (int)0, (int)0, (int)logo.getWidth(), (int)logo.getHeight(), (Matrix)matrix, (boolean)false);
        MultiFormatWriter wirter = new MultiFormatWriter();
        Hashtable<EncodeHintType, Object> hintTypes = new Hashtable<EncodeHintType, Object>();
        hintTypes.put(EncodeHintType.CHARACTER_SET, CharacterSetECI.UTF8);
        hintTypes.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        BitMatrix bitMatrix = wirter.encode(text, format, qrSize, qrSize, hintTypes);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        int halfW = width / 2;
        int halfH = height / 2;
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                pixels[y * width + x] = x > halfW - 40 && x < halfW + 40 && y > halfH - 40 && y < halfH + 40 ? logo.getPixel(x - halfW + 40, y - halfH + 40) : (bitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        logo = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        logo.setPixels(pixels, 0, width, 0, 0, width, height);
        return logo;
    }

    public static String getRealPathFromUri(Context context, Uri uri) {
        int sdkVersion = Build.VERSION.SDK_INT;
        if (sdkVersion >= 19) {
            return XUtils.getRealPathFromUriAboveApi19(context, uri);
        }
        return XUtils.getRealPathFromUriBelowAPI19(context, uri);
    }

    private static String getRealPathFromUriBelowAPI19(Context context, Uri uri) {
        return XUtils.getDataColumn(context, uri, null, null);
    }

    @SuppressLint(value={"NewApi"})
    private static String getRealPathFromUriAboveApi19(Context context, Uri uri) {
        String filePath = null;
        if (DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            String documentId = DocumentsContract.getDocumentId((Uri)uri);
            if (XUtils.isMediaDocument(uri)) {
                String id2 = documentId.split(":")[1];
                String selection = "_id=?";
                String[] selectionArgs = new String[]{id2};
                filePath = XUtils.getDataColumn(context, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, selection, selectionArgs);
            } else if (XUtils.isDownloadsDocument(uri)) {
                Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(documentId));
                filePath = XUtils.getDataColumn(context, contentUri, null, null);
            }
        } else if ("content".equalsIgnoreCase(uri.getScheme())) {
            filePath = XUtils.getDataColumn(context, uri, null, null);
        } else if ("file".equals(uri.getScheme())) {
            filePath = uri.getPath();
        }
        return filePath;
    }

    private static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        String path;
        block3: {
            path = null;
            String[] projection = new String[]{"_data"};
            Cursor cursor = null;
            try {
                cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
                if (cursor != null && cursor.moveToFirst()) {
                    int columnIndex = cursor.getColumnIndexOrThrow(projection[0]);
                    path = cursor.getString(columnIndex);
                }
            }
            catch (Exception e) {
                if (cursor == null) break block3;
                cursor.close();
            }
        }
        return path;
    }

    private static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    private static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static String getWiFiMacAddress() {
        try {
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null) {
                    return "02:00:00:00:00:00";
                }
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02X:", b));
                }
                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                return res1.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "02:00:00:00:00:00";
    }

    public static boolean goToNotificationSettings(String channel, Context context) {
        if (context == null) {
            return false;
        }
        try {
            Intent intent = new Intent();
            intent.addFlags(0x10000000);
            if (Build.VERSION.SDK_INT >= 28) {
                if (channel != null) {
                    intent.setAction("android.settings.CHANNEL_NOTIFICATION_SETTINGS");
                    intent.putExtra("android.provider.extra.CHANNEL_ID", channel);
                } else {
                    intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                }
                intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
            } else if (Build.VERSION.SDK_INT >= 26) {
                if (channel != null) {
                    intent.setAction("android.settings.CHANNEL_NOTIFICATION_SETTINGS");
                    intent.putExtra("android.provider.extra.CHANNEL_ID", channel);
                } else {
                    intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                }
                intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
            } else if (Build.VERSION.SDK_INT >= 25) {
                intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                intent.putExtra("app_package", context.getPackageName());
            } else if (Build.VERSION.SDK_INT >= 21) {
                intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                intent.putExtra("app_package", context.getPackageName());
                intent.putExtra("app_uid", context.getApplicationInfo().uid);
            }
            context.startActivity(intent);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static long getAppInstallTime(Context context) {
        long firstInstallTime = 0L;
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            firstInstallTime = packageInfo.firstInstallTime;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return firstInstallTime;
    }

    public static boolean isAppInstallForSevenDays(Context context) {
        return System.currentTimeMillis() - XUtils.getAppInstallTime(context) > 604800000L;
    }

    public static Bitmap createQRCodeBitmap(String text, int qrSize, Hashtable hashtable) throws Exception {
        MultiFormatWriter wirter = new MultiFormatWriter();
        BitMatrix bitMatrix = wirter.encode(text, BarcodeFormat.QR_CODE, qrSize, qrSize, (Map)hashtable);
        bitMatrix = XUtils.deleteWhite(bitMatrix);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                pixels[y * width + x] = bitMatrix.get(x, y) ? -16777216 : -1;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return bitmap;
    }

    private static BitMatrix deleteWhite(BitMatrix matrix) {
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2] + 1;
        int resHeight = rec[3] + 1;
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = 0; i < resWidth; ++i) {
            for (int j = 0; j < resHeight; ++j) {
                if (!matrix.get(i + rec[0], j + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        return resMatrix;
    }

    public static Bitmap getBitmapFromUri(Context context, Uri uri) {
        if (context == null) {
            return null;
        }
        try {
            ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
            FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
            Bitmap image = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor);
            parcelFileDescriptor.close();
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap getBitmapFromUri(Context context, Uri uri, BitmapFactory.Options opts) {
        if (context == null) {
            return null;
        }
        try {
            ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
            FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
            Bitmap image = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)opts);
            parcelFileDescriptor.close();
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Uri getImageContentUri(Context context, String path) {
        if (context == null) {
            return null;
        }
        Cursor cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, "_data=? ", new String[]{path}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int id2 = cursor.getInt(cursor.getColumnIndex("_id"));
            Uri baseUri = Uri.parse((String)"content://media/external/images/media");
            return Uri.withAppendedPath((Uri)baseUri, (String)("" + id2));
        }
        if (new File(path).exists()) {
            ContentValues values = new ContentValues();
            values.put("_data", path);
            return context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        return null;
    }

    public static String getUrl(String baseUrl, Map<String, String> values) {
        StringBuilder sb = new StringBuilder(baseUrl);
        if (values != null && !values.isEmpty()) {
            sb.append("?");
            for (Map.Entry<String, String> entry : values.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    public static String getLightViewTips(String[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        String tip = "";
        for (String mode : array) {
            tip = tip + "/" + mode;
        }
        tip = tip.substring(1);
        return tip;
    }

    public static Bitmap bg2WhiteBitmap(Bitmap bitmap) {
        int size = bitmap.getWidth() < bitmap.getHeight() ? bitmap.getWidth() : bitmap.getHeight();
        int num = 14;
        int sizebig = size + num;
        Bitmap newBitmap = Bitmap.createBitmap((int)sizebig, (int)sizebig, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(newBitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-1);
        canvas.drawBitmap(bitmap, (float)(num / 2), (float)(num / 2), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
        canvas.drawRect(0.0f, 0.0f, (float)sizebig, (float)sizebig, paint);
        return newBitmap;
    }

    public static String getCopyString(Context context) {
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        if (clipboard != null) {
            try {
                ClipData clipData = clipboard.getPrimaryClip();
                if (clipData != null && clipData.getItemCount() > 0) {
                    return clipData.getItemAt(0).getText().toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void clearClipboard(Context context) {
        ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
        if (clipboardManager != null) {
            try {
                clipboardManager.setText((CharSequence)"");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String parseParams(RequestBody body) {
        try {
            if (body == null) {
                return "";
            }
            Buffer requestBuffer = new Buffer();
            body.writeTo((BufferedSink)requestBuffer);
            Charset charset = StandardCharsets.UTF_8;
            MediaType contentType = body.contentType();
            if (contentType != null) {
                charset = contentType.charset(charset);
            }
            String text = requestBuffer.readString(charset);
            if (contentType != null && !"json".equals(contentType.subtype())) {
                text = URLDecoder.decode(text, XUtils.convertCharset(charset));
            }
            return text;
        }
        catch (IOException e) {
            return "{\"error\": \"" + e.getMessage() + "\"}";
        }
    }

    private static String convertCharset(Charset charset) {
        String s = charset.toString();
        int i = s.indexOf("[");
        if (i == -1) {
            return s;
        }
        return s.substring(i + 1, s.length() - 1);
    }
}

