/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import com.lib.sdk.bean.StringUtils;
import java.util.Calendar;
import java.util.Random;

public class MobileInfoUtils {
    public static void jumpToSettingsPermission(Context context) {
        Intent localIntent = new Intent();
        localIntent.addFlags(0x10000000);
        if (Build.VERSION.SDK_INT >= 9) {
            localIntent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            localIntent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
        } else if (Build.VERSION.SDK_INT <= 8) {
            localIntent.setAction("android.intent.action.VIEW");
            localIntent.setClassName("com.android.settings", "com.android.settings.InstalledAppDetails");
            localIntent.putExtra("com.android.settings.ApplicationPkgName", context.getPackageName());
        }
        context.startActivity(localIntent);
    }

    public static void jumpToInstallPermission(Context context) {
        Intent intent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES");
        context.startActivity(intent);
    }

    public static void jumpToNotificationPermission(Context context) {
        try {
            Intent intent = new Intent();
            intent.addFlags(0x10000000);
            if (StringUtils.contrast(Build.MODEL, "MI 6")) {
                intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
                intent.setData(uri);
                intent.setAction("com.android.settings/.SubSettings");
            } else {
                intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                if (Build.VERSION.SDK_INT >= 26) {
                    intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
                    intent.putExtra("android.provider.extra.CHANNEL_ID", context.getApplicationInfo().uid);
                } else {
                    intent.putExtra("app_package", context.getPackageName());
                    intent.putExtra("app_uid", context.getApplicationInfo().uid);
                }
            }
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            Intent intent = new Intent();
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
            intent.setData(uri);
            context.startActivity(intent);
        }
    }

    public static String getRandomUUID() {
        Random random = new Random();
        StringBuilder uuid = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            uuid.append(Integer.toHexString(Math.abs(random.nextInt(16))));
        }
        Calendar calendar = Calendar.getInstance();
        String time = String.format("%02d%03d", calendar.get(12), calendar.get(14));
        uuid.append(time);
        System.out.println("getRandomUUID:" + uuid);
        return uuid.toString();
    }
}

