/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

import com.inuker.bluetooth.library.utils.ByteUtils;
import com.lib.sdk.bean.StringUtils;
import com.utils.LogUtils;
import java.nio.charset.StandardCharsets;

public class BleDistributionUtil {
    public static final String FLAME_HEADER = "8B8B";
    public static final String FLAME_VERSION = "02";
    private static final String TAG = "WIFIDistributionUtil";

    public static String combineFlameHeader(String version, String flameOrder, String orderType, String dataType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(FLAME_HEADER);
        stringBuilder.append(StringUtils.isStringNULL(version) ? FLAME_VERSION : version);
        stringBuilder.append(flameOrder);
        stringBuilder.append(orderType);
        stringBuilder.append(dataType);
        return stringBuilder.toString();
    }

    public static String combineWiFiSSIDToHexStr(String wifiSSID, String pwd, int pwdType, String mac) {
        try {
            if (wifiSSID == null) {
                wifiSSID = "";
            }
            if (pwd == null) {
                pwd = "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder flameContent = new StringBuilder();
            byte[] bWifiSSID = wifiSSID.getBytes(StandardCharsets.UTF_8);
            int wifiSize = bWifiSSID.length;
            flameContent.append(String.format("%02x", wifiSize));
            flameContent.append(ByteUtils.byteToString(bWifiSSID));
            byte[] bWifiPwd = pwd.getBytes(StandardCharsets.UTF_8);
            int pwdSize = bWifiPwd.length;
            flameContent.append(String.format("%02x", pwdSize));
            flameContent.append(ByteUtils.byteToString(bWifiPwd));
            flameContent.append(String.format("%02x", pwdType));
            String flameHeaderStr = BleDistributionUtil.combineFlameHeader(FLAME_VERSION, "01", "0002", "00");
            stringBuilder.append(flameHeaderStr);
            stringBuilder.append(String.format("%04x", flameContent.length() / 2));
            stringBuilder.append((CharSequence)flameContent);
            String checkCode = BleDistributionUtil.createCheckCode(stringBuilder.toString());
            LogUtils.debugInfo("[APP_BLE]->", "checkCode:" + checkCode);
            stringBuilder.append(checkCode);
            return stringBuilder.toString().toUpperCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String createCheckCode(String strContent) {
        if (strContent == null) {
            return "";
        }
        int total = 0;
        for (int i = 0; i < strContent.length() / 2; ++i) {
            int currentI = i * 2;
            int i12 = currentI + 2;
            String substring = strContent.substring(currentI, i12);
            total += Integer.parseInt(substring, 16);
        }
        return String.format("%02x", total % 256);
    }

    public static int getWifiEncrypt(String capability) {
        String afterCapability;
        if (capability.contains("WAPI") && capability.contains("PSK")) {
            return 8;
        }
        if (capability.contains("WPA3") && capability.contains("WPA2") && capability.contains("PSK")) {
            return 7;
        }
        if (capability.contains("WPA3") && capability.contains("PSK")) {
            return 6;
        }
        if (capability.contains("WPA2") && capability.contains("ENTERPRISE")) {
            return 5;
        }
        if (capability.contains("WPA2") && (afterCapability = capability.replace("WPA2", "")).contains("WPA") && afterCapability.contains("PSK")) {
            return 4;
        }
        if (capability.contains("WPA2") && capability.contains("PSK")) {
            return 3;
        }
        if (capability.contains("WPA_PSK")) {
            return 2;
        }
        if (capability.contains("WEP")) {
            return 1;
        }
        return 0;
    }
}

