/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import com.lib.FunSDK;
import com.utils.PathUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitmapUtils {
    private static Bitmap rsBlur(Context context, Bitmap source, int radius) {
        if (Build.VERSION.SDK_INT < 17) {
            return source;
        }
        Bitmap inputBmp = source;
        RenderScript renderScript = RenderScript.create((Context)context);
        Allocation input = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)inputBmp);
        Allocation output = Allocation.createTyped((RenderScript)renderScript, (Type)input.getType());
        ScriptIntrinsicBlur scriptIntrinsicBlur = ScriptIntrinsicBlur.create((RenderScript)renderScript, (Element)Element.U8_4((RenderScript)renderScript));
        scriptIntrinsicBlur.setInput(input);
        scriptIntrinsicBlur.setRadius((float)radius);
        scriptIntrinsicBlur.forEach(output);
        output.copyTo(inputBmp);
        renderScript.destroy();
        return inputBmp;
    }

    public static boolean saveBitmapToFile(Bitmap bitmap, String filePath) {
        File file = new File(filePath);
        try {
            FileOutputStream out = new FileOutputStream(file);
            if (bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out)) {
                out.flush();
                out.close();
            }
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getVideoThumbnail(Context context, String srcfile) {
        File tempFile = new File(srcfile.trim());
        int i = tempFile.getName().lastIndexOf(".");
        String srcName = tempFile.getName().substring(0, i);
        String strOutFileName = PathUtils.getAndroidPath(context) + File.separator + srcName + ".jpg";
        int nRet = FunSDK.GetMediaThumbnail((String)srcfile, (String)strOutFileName);
        if (nRet == 0) {
            return strOutFileName;
        }
        return "";
    }
}

