/*
 * Decompiled with CFR 0.152.
 */
package com.manager.websocket;

import android.content.Context;
import android.os.Looper;
import android.os.SystemClock;
import com.blankj.utilcode.util.NetworkUtils;
import com.manager.websocket.HeartBeatGenerateCallback;
import com.manager.websocket.WebSocketInfo;
import com.manager.websocket.WebSocketWorker;
import com.manager.websocket.pool.WebSocketInfoPool;
import com.utils.LogUtils;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Action;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.schedulers.Timed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class WebSocketWorkerImpl
implements WebSocketWorker {
    private static final String TAG = WebSocketWorkerImpl.class.getName();
    private Context mContext;
    private OkHttpClient mClient;
    private long mReconnectInterval;
    private TimeUnit mReconnectIntervalTimeUnit;
    private static Map<String, Observable<WebSocketInfo>> mObservableCacheMap;
    private static Map<String, WebSocket> mWebSocketPool;
    private final WebSocketInfoPool mWebSocketInfoPool;
    private boolean mIsPrintLog;

    public WebSocketWorkerImpl(Context context, boolean isPrintLog, OkHttpClient client, SSLSocketFactory sslSocketFactory, X509TrustManager trustManager, long reconnectInterval, TimeUnit reconnectIntervalTimeUnit) {
        this.mContext = context;
        this.mClient = client;
        this.mIsPrintLog = isPrintLog;
        this.mReconnectInterval = reconnectInterval;
        this.mReconnectIntervalTimeUnit = reconnectIntervalTimeUnit;
        if (sslSocketFactory != null && trustManager != null) {
            this.mClient = this.mClient.newBuilder().sslSocketFactory(sslSocketFactory, trustManager).build();
        }
        mObservableCacheMap = new HashMap<String, Observable<WebSocketInfo>>(16);
        mWebSocketPool = new HashMap<String, WebSocket>(16);
        this.mWebSocketInfoPool = new WebSocketInfoPool();
    }

    @Override
    public Observable<WebSocketInfo> get(String url) {
        return this.getWebSocketInfo(url);
    }

    @Override
    public Observable<WebSocketInfo> get(String url, long timeout, TimeUnit timeUnit) {
        return this.getWebSocketInfo(url, timeout, timeUnit);
    }

    @Override
    public Observable<Boolean> send(final String url, final String msg) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Boolean>(){

            public void subscribe(ObservableEmitter<Boolean> emitter) throws Exception {
                WebSocket webSocket = (WebSocket)mWebSocketPool.get(url);
                if (webSocket == null) {
                    emitter.onError((Throwable)new IllegalStateException("The WebSocket not open"));
                } else {
                    emitter.onNext((Object)webSocket.send(msg));
                }
            }
        });
    }

    @Override
    public Observable<Boolean> send(final String url, final ByteString byteString) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Boolean>(){

            public void subscribe(ObservableEmitter<Boolean> emitter) throws Exception {
                WebSocket webSocket = (WebSocket)mWebSocketPool.get(url);
                if (webSocket == null) {
                    emitter.onError((Throwable)new IllegalStateException("The WebSocket not open"));
                } else {
                    emitter.onNext((Object)webSocket.send(byteString));
                }
            }
        });
    }

    @Override
    public Observable<Boolean> asyncSend(String url, final String msg) {
        return this.getWebSocket(url).take(1L).map((Function)new Function<WebSocket, Boolean>(){

            public Boolean apply(WebSocket webSocket) throws Exception {
                return webSocket.send(msg);
            }
        });
    }

    @Override
    public Observable<Boolean> asyncSend(String url, final ByteString byteString) {
        return this.getWebSocket(url).take(1L).map((Function)new Function<WebSocket, Boolean>(){

            public Boolean apply(WebSocket webSocket) throws Exception {
                return webSocket.send(byteString);
            }
        });
    }

    @Override
    public Observable<Boolean> close(final String url) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<WebSocket>(){

            public void subscribe(ObservableEmitter<WebSocket> emitter) throws Exception {
                WebSocket webSocket = (WebSocket)mWebSocketPool.get(url);
                if (webSocket == null) {
                    emitter.onError((Throwable)new NullPointerException("url:" + url + " WebSocket must be not null"));
                } else {
                    emitter.onNext((Object)webSocket);
                }
            }
        }).map((Function)new Function<WebSocket, Boolean>(){

            public Boolean apply(WebSocket webSocket) throws Exception {
                return WebSocketWorkerImpl.this.closeWebSocket(webSocket);
            }
        });
    }

    @Override
    public boolean closeNow(String url) {
        return this.closeWebSocket(mWebSocketPool.get(url));
    }

    @Override
    public Observable<List<Boolean>> closeAll() {
        return Observable.just(mWebSocketPool).map((Function)new Function<Map<String, WebSocket>, Collection<WebSocket>>(){

            public Collection<WebSocket> apply(Map<String, WebSocket> webSocketMap) throws Exception {
                return webSocketMap.values();
            }
        }).concatMap((Function)new Function<Collection<WebSocket>, ObservableSource<WebSocket>>(){

            public ObservableSource<WebSocket> apply(Collection<WebSocket> webSockets) throws Exception {
                return Observable.fromIterable(webSockets);
            }
        }).map((Function)new Function<WebSocket, Boolean>(){

            public Boolean apply(WebSocket webSocket) throws Exception {
                return WebSocketWorkerImpl.this.closeWebSocket(webSocket);
            }
        }).collect((Callable)new Callable<List<Boolean>>(){

            @Override
            public List<Boolean> call() throws Exception {
                return new ArrayList<Boolean>();
            }
        }, (BiConsumer)new BiConsumer<List<Boolean>, Boolean>(){

            public void accept(List<Boolean> list, Boolean isCloseSuccess) throws Exception {
                list.add(isCloseSuccess);
            }
        }).toObservable();
    }

    @Override
    public void closeAllNow() {
        for (Map.Entry<String, WebSocket> entry : mWebSocketPool.entrySet()) {
            this.closeWebSocket(entry.getValue());
        }
    }

    @Override
    public Observable<Boolean> heartBeat(final String url, int period, TimeUnit unit, final HeartBeatGenerateCallback heartBeatGenerateCallback) {
        if (heartBeatGenerateCallback == null) {
            return Observable.error((Throwable)new NullPointerException("heartBeatGenerateCallback == null"));
        }
        return Observable.interval((long)period, (TimeUnit)unit).timestamp().retry().flatMap((Function)new Function<Timed<Long>, ObservableSource<Boolean>>(){

            public ObservableSource<Boolean> apply(Timed<Long> timed) throws Exception {
                long timestamp = timed.time();
                if (WebSocketWorkerImpl.this.mContext != null && NetworkUtils.isAvailable()) {
                    String heartBeatMsg = heartBeatGenerateCallback.onGenerateHeartBeatMsg(timestamp);
                    WebSocketWorkerImpl.this.printLog("\u53d1\u9001\u5fc3\u8df3\u6d88\u606f: " + heartBeatMsg);
                    if (WebSocketWorkerImpl.this.hasWebSocketConnection(url)) {
                        return WebSocketWorkerImpl.this.send(url, heartBeatMsg);
                    }
                    return WebSocketWorkerImpl.this.asyncSend(url, heartBeatMsg);
                }
                WebSocketWorkerImpl.this.printLog("\u65e0\u7f51\u7edc\u8fde\u63a5\uff0c\u4e0d\u53d1\u9001\u5fc3\u8df3\uff0c\u4e0b\u6b21\u7f51\u7edc\u8fde\u901a\u65f6\uff0c\u518d\u6b21\u53d1\u9001\u5fc3\u8df3");
                return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Boolean>(){

                    public void subscribe(ObservableEmitter<Boolean> emitter) throws Exception {
                        emitter.onNext((Object)false);
                    }
                });
            }
        });
    }

    private boolean hasWebSocketConnection(String url) {
        return mWebSocketPool.get(url) != null;
    }

    private boolean closeWebSocket(WebSocket webSocket) {
        if (webSocket == null) {
            return false;
        }
        boolean result = webSocket.close(1000, "userExit");
        this.removeUrlWebSocketMapping(webSocket);
        return result;
    }

    private synchronized void removeUrlWebSocketMapping(WebSocket webSocket) {
        for (Map.Entry<String, WebSocket> entry : mWebSocketPool.entrySet()) {
            if (entry.getValue() != webSocket) continue;
            String url = entry.getKey();
            mObservableCacheMap.remove(url);
            mWebSocketPool.remove(url);
            webSocket = null;
        }
    }

    private synchronized void removeWebSocketCache(WebSocket webSocket) {
        for (Map.Entry<String, WebSocket> entry : mWebSocketPool.entrySet()) {
            if (entry.getValue() != webSocket) continue;
            String url = entry.getKey();
            mWebSocketPool.remove(url);
        }
    }

    public Observable<WebSocket> getWebSocket(String url) {
        return this.getWebSocketInfo(url).filter((Predicate)new Predicate<WebSocketInfo>(){

            public boolean test(WebSocketInfo webSocketInfo) throws Exception {
                return webSocketInfo.getWebSocket() != null;
            }
        }).map((Function)new Function<WebSocketInfo, WebSocket>(){

            public WebSocket apply(WebSocketInfo webSocketInfo) throws Exception {
                return webSocketInfo.getWebSocket();
            }
        });
    }

    public Observable<WebSocketInfo> getWebSocketInfo(String url) {
        return this.getWebSocketInfo(url, 5L, TimeUnit.SECONDS);
    }

    public synchronized Observable<WebSocketInfo> getWebSocketInfo(final String url, long timeout, TimeUnit timeUnit) {
        Observable observable = mObservableCacheMap.get(url);
        if (observable == null) {
            observable = Observable.create((ObservableOnSubscribe)new WebSocketOnSubscribe(url)).retry().doOnDispose(new Action(){

                public void run() throws Exception {
                    WebSocket webSocket = (WebSocket)mWebSocketPool.get(url);
                    if (webSocket != null) {
                        webSocket.close(1000, "userExit");
                    }
                    WebSocketWorkerImpl.this.printLog("\u6240\u6709\u89c2\u5bdf\u8005\u90fd\u53d6\u6d88\u6ce8\u518c\uff0c\u5173\u95ed\u8fde\u63a5...");
                }
            }).share().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
            mObservableCacheMap.put(url, (Observable<WebSocketInfo>)observable);
        } else {
            WebSocket webSocket = mWebSocketPool.get(url);
            if (webSocket != null) {
                observable = observable.startWith((Object)this.createConnect(url, webSocket));
            } else if (mObservableCacheMap != null) {
                mObservableCacheMap.remove(url);
            }
        }
        return observable;
    }

    private WebSocketInfo createConnect(String url, WebSocket webSocket) {
        return ((WebSocketInfo)this.mWebSocketInfoPool.obtain(url)).setWebSocket(webSocket).setConnect(true).setState(1);
    }

    private WebSocketInfo createReconnect(String url, WebSocket webSocket) {
        return ((WebSocketInfo)this.mWebSocketInfoPool.obtain(url)).setWebSocket(webSocket).setReconnect(true).setState(2);
    }

    private WebSocketInfo createPrepareReconnect(String url) {
        return ((WebSocketInfo)this.mWebSocketInfoPool.obtain(url)).setPrepareReconnect(true).setState(3);
    }

    private WebSocketInfo createReceiveStringMsg(String url, WebSocket webSocket, String stringMsg) {
        return ((WebSocketInfo)this.mWebSocketInfoPool.obtain(url)).setConnect(true).setWebSocket(webSocket).setStrMsg(stringMsg).setState(4);
    }

    private WebSocketInfo createReceiveByteStringMsg(String url, WebSocket webSocket, ByteString byteMsg) {
        return ((WebSocketInfo)this.mWebSocketInfoPool.obtain(url)).setConnect(true).setWebSocket(webSocket).setByteMsg(byteMsg).setState(4);
    }

    private WebSocketInfo createClose(String url) {
        return ((WebSocketInfo)this.mWebSocketInfoPool.obtain(url)).setState(0);
    }

    private void printLog(String log) {
        if (this.mIsPrintLog) {
            LogUtils.debugInfo("[APP_WEB_SOCKET]->", log);
        }
    }

    private final class WebSocketOnSubscribe
    implements ObservableOnSubscribe<WebSocketInfo> {
        private String mWebSocketUrl;
        private WebSocket mWebSocket;
        private boolean isReconnecting = false;

        public WebSocketOnSubscribe(String webSocketUrl) {
            this.mWebSocketUrl = webSocketUrl;
        }

        public void subscribe(ObservableEmitter<WebSocketInfo> emitter) throws Exception {
            if (this.mWebSocket == null && this.isReconnecting && Thread.currentThread() != Looper.getMainLooper().getThread()) {
                long millis = WebSocketWorkerImpl.this.mReconnectIntervalTimeUnit.toMillis(WebSocketWorkerImpl.this.mReconnectInterval);
                if (millis == 0L) {
                    millis = 1000L;
                }
                SystemClock.sleep((long)millis);
                WebSocketWorkerImpl.this.printLog("subscribe delay");
            }
            this.initWebSocket(emitter);
        }

        private Request createRequest(String url) {
            return new Request.Builder().get().url(url).build();
        }

        private synchronized void initWebSocket(final ObservableEmitter<WebSocketInfo> emitter) {
            if (this.mWebSocket == null) {
                this.mWebSocket = WebSocketWorkerImpl.this.mClient.newWebSocket(this.createRequest(this.mWebSocketUrl), new WebSocketListener(){

                    public void onOpen(WebSocket webSocket, Response response) {
                        super.onOpen(webSocket, response);
                        if (!emitter.isDisposed()) {
                            mWebSocketPool.put(WebSocketOnSubscribe.this.mWebSocketUrl, WebSocketOnSubscribe.this.mWebSocket);
                            if (WebSocketOnSubscribe.this.isReconnecting) {
                                emitter.onNext((Object)WebSocketWorkerImpl.this.createReconnect(WebSocketOnSubscribe.this.mWebSocketUrl, webSocket));
                                WebSocketWorkerImpl.this.printLog("WebSocket\u91cd\u8fde\u6210\u529f");
                            } else {
                                emitter.onNext((Object)WebSocketWorkerImpl.this.createConnect(WebSocketOnSubscribe.this.mWebSocketUrl, webSocket));
                                WebSocketWorkerImpl.this.printLog("WebSocket\u8fde\u63a5\u6210\u529f");
                            }
                        } else {
                            WebSocketWorkerImpl.this.printLog("Observable disposed");
                        }
                        WebSocketOnSubscribe.this.isReconnecting = false;
                    }

                    public void onMessage(WebSocket webSocket, String text) {
                        super.onMessage(webSocket, text);
                        if (!emitter.isDisposed()) {
                            emitter.onNext((Object)WebSocketWorkerImpl.this.createReceiveStringMsg(WebSocketOnSubscribe.this.mWebSocketUrl, webSocket, text));
                            WebSocketWorkerImpl.this.printLog("\u63a5\u6536\u6570\u636e:" + text);
                        } else {
                            WebSocketWorkerImpl.this.printLog("Observable disposed,Message:" + text);
                        }
                    }

                    public void onMessage(WebSocket webSocket, ByteString bytes) {
                        super.onMessage(webSocket, bytes);
                        if (!emitter.isDisposed()) {
                            emitter.onNext((Object)WebSocketWorkerImpl.this.createReceiveByteStringMsg(WebSocketOnSubscribe.this.mWebSocketUrl, webSocket, bytes));
                        } else {
                            WebSocketWorkerImpl.this.printLog("Observable disposed,Message2");
                        }
                    }

                    public void onClosed(WebSocket webSocket, int code, String reason) {
                        super.onClosed(webSocket, code, reason);
                        if (!emitter.isDisposed()) {
                            emitter.onNext((Object)WebSocketWorkerImpl.this.createClose(WebSocketOnSubscribe.this.mWebSocketUrl));
                        }
                        WebSocketWorkerImpl.this.printLog("WebSocket\u88ab\u5173\u95ed\u4e86");
                    }

                    public void onFailure(WebSocket webSocket, Throwable throwable, Response response) {
                        super.onFailure(webSocket, throwable, response);
                        WebSocketOnSubscribe.this.isReconnecting = true;
                        WebSocketOnSubscribe.this.mWebSocket = null;
                        if (!emitter.isDisposed()) {
                            emitter.onNext((Object)WebSocketWorkerImpl.this.createPrepareReconnect(WebSocketOnSubscribe.this.mWebSocketUrl));
                        }
                        WebSocketWorkerImpl.this.closeNow(WebSocketOnSubscribe.this.mWebSocketUrl);
                        if (response != null) {
                            WebSocketWorkerImpl.this.printLog("WebSocket\u8bbf\u95ee\u5931\u8d25:[" + throwable.getMessage() + "][" + response.message() + "]");
                        } else {
                            WebSocketWorkerImpl.this.printLog("WebSocket\u8bbf\u95ee\u5931\u8d25:[" + throwable.getMessage() + "]");
                        }
                    }
                });
            }
        }
    }
}

