/*
 * Decompiled with CFR 0.152.
 */
package com.manager.websocket;

import android.content.Context;
import com.manager.websocket.HeartBeatGenerateCallback;
import com.manager.websocket.RxWebSocketBuilder;
import com.manager.websocket.WebSocketInfo;
import com.manager.websocket.WebSocketWorker;
import com.manager.websocket.WebSocketWorkerImpl;
import io.reactivex.Observable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okio.ByteString;

public class RxWebSocket
implements WebSocketWorker {
    Context context;
    boolean isPrintLog;
    OkHttpClient client;
    SSLSocketFactory sslSocketFactory;
    X509TrustManager trustManager;
    long reconnectInterval;
    TimeUnit reconnectIntervalTimeUnit;
    private WebSocketWorker workerImpl;

    private RxWebSocket() {
    }

    RxWebSocket(RxWebSocketBuilder builder) {
        this.context = builder.context;
        this.isPrintLog = builder.isPrintLog;
        this.client = builder.client == null ? new OkHttpClient() : builder.client;
        this.sslSocketFactory = builder.sslSocketFactory;
        this.trustManager = builder.trustManager;
        this.reconnectInterval = builder.reconnectInterval == 0L ? 1L : builder.reconnectInterval;
        this.reconnectIntervalTimeUnit = builder.reconnectIntervalTimeUnit == null ? TimeUnit.SECONDS : builder.reconnectIntervalTimeUnit;
        this.setup();
    }

    private void setup() {
        this.workerImpl = new WebSocketWorkerImpl(this.context, this.isPrintLog, this.client, this.sslSocketFactory, this.trustManager, this.reconnectInterval, this.reconnectIntervalTimeUnit);
    }

    @Override
    public Observable<WebSocketInfo> get(String url) {
        return this.workerImpl.get(url);
    }

    @Override
    public Observable<WebSocketInfo> get(String url, long timeout, TimeUnit timeUnit) {
        return this.workerImpl.get(url, timeout, timeUnit);
    }

    @Override
    public Observable<Boolean> send(String url, String msg) {
        return this.workerImpl.send(url, msg);
    }

    @Override
    public Observable<Boolean> send(String url, ByteString byteString) {
        return this.workerImpl.send(url, byteString);
    }

    @Override
    public Observable<Boolean> asyncSend(String url, String msg) {
        return this.workerImpl.asyncSend(url, msg);
    }

    @Override
    public Observable<Boolean> asyncSend(String url, ByteString byteString) {
        return this.workerImpl.asyncSend(url, byteString);
    }

    @Override
    public Observable<Boolean> close(String url) {
        return this.workerImpl.close(url);
    }

    @Override
    public boolean closeNow(String url) {
        return this.workerImpl.closeNow(url);
    }

    @Override
    public Observable<List<Boolean>> closeAll() {
        return this.workerImpl.closeAll();
    }

    @Override
    public void closeAllNow() {
        this.workerImpl.closeAllNow();
    }

    @Override
    public Observable<Boolean> heartBeat(String url, int period, TimeUnit unit, HeartBeatGenerateCallback heartBeatGenerateCallback) {
        return this.workerImpl.heartBeat(url, period, unit, heartBeatGenerateCallback);
    }
}

