/*
 * Decompiled with CFR 0.152.
 */
package com.manager.sysability;

import android.content.Context;
import android.os.Message;
import android.util.ArrayMap;
import androidx.annotation.NonNull;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.bean.SysDevAbilityInfoBean;
import com.manager.db.DevDataCenter;
import com.manager.sysability.OnSysAbilityResultListener;
import com.utils.LogUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class SysAbilityManager
implements IFunSDKResult {
    private static final int BATCH_QUERY_COUNT = 20;
    private int userId;
    private static SysAbilityManager instance;
    private AtomicInteger supportCloudDevCount = new AtomicInteger();
    private Map<String, SysDevAbilityInfoBean> sysDevAbilityInfoBeanMap = new HashMap<String, SysDevAbilityInfoBean>();
    private Map<Integer, OnSysAbilityResultListener> abilityResultListenerMap = new HashMap<Integer, OnSysAbilityResultListener>();
    private HashMap<String, Boolean> needRefreshState = new HashMap();
    private OnSysAbilityResultListener.OnHasDevSupportCloudListener onHasDevSupportCloudListener;
    private OnSysAbilityResultListener.OnAllDevAbilityResultListener onAllDevAbilityResultListener;
    private String packageName;

    private SysAbilityManager() {
        this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SysAbilityManager getInstance() {
        Class<SysAbilityManager> clazz = SysAbilityManager.class;
        synchronized (SysAbilityManager.class) {
            if (instance == null) {
                instance = new SysAbilityManager();
            } else {
                instance.init();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init() {
        this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAllDevAbility(Context context, OnSysAbilityResultListener.OnAllDevAbilityResultListener listener) {
        if (!DevDataCenter.getInstance().isLoginByAccount()) {
            LogUtils.debugInfo("[APP_CAPS->]", "Access to cloud service-related functions requires account login.");
            return;
        }
        this.onAllDevAbilityResultListener = listener;
        List<String> deviceInfos = DevDataCenter.getInstance().getDevList();
        if (deviceInfos == null || this.sysDevAbilityInfoBeanMap == null) {
            return;
        }
        ArrayList<SysDevAbilityInfoBean> sysDevAbilityInfoBeans = new ArrayList<SysDevAbilityInfoBean>();
        for (String devId : deviceInfos) {
            Map<String, SysDevAbilityInfoBean> map = this.sysDevAbilityInfoBeanMap;
            synchronized (map) {
                SysDevAbilityInfoBean bean;
                if (!this.sysDevAbilityInfoBeanMap.containsKey(devId)) {
                    bean = new SysDevAbilityInfoBean(devId);
                    this.sysDevAbilityInfoBeanMap.put(devId, bean);
                } else {
                    bean = this.sysDevAbilityInfoBeanMap.get(devId);
                }
                sysDevAbilityInfoBeans.add(bean);
            }
            if (sysDevAbilityInfoBeans.size() != 20) continue;
            String sendJson = this.getAllDevSendJson(sysDevAbilityInfoBeans);
            LogUtils.debugInfo("[APP_CAPS->]", "send:20");
            FunSDK.SysBatchGetDevCapabilitySet((int)this.userId, (String)sendJson, (int)0);
            sysDevAbilityInfoBeans.clear();
        }
        if (!sysDevAbilityInfoBeans.isEmpty()) {
            String sendJson = this.getAllDevSendJson(sysDevAbilityInfoBeans);
            LogUtils.debugInfo("[APP_CAPS->]", "send:" + sysDevAbilityInfoBeans.size());
            FunSDK.SysBatchGetDevCapabilitySet((int)this.userId, (String)sendJson, (int)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDevAbility(Context context, String devId) {
        if (!DevDataCenter.getInstance().isLoginByAccount()) {
            LogUtils.debugInfo("[APP_CAPS->]", "Access to cloud service-related functions requires account login.");
            return;
        }
        if (this.sysDevAbilityInfoBeanMap != null) {
            Map<String, SysDevAbilityInfoBean> map = this.sysDevAbilityInfoBeanMap;
            synchronized (map) {
                SysDevAbilityInfoBean bean = null;
                if (this.sysDevAbilityInfoBeanMap.containsKey(devId)) {
                    bean = this.sysDevAbilityInfoBeanMap.get(devId);
                }
                if (bean == null) {
                    bean = new SysDevAbilityInfoBean(devId);
                    this.sysDevAbilityInfoBeanMap.put(devId, bean);
                }
                bean.setPackageName(this.packageName);
                FunSDK.SysGetDevCapabilitySet((int)this.userId, (String)bean.getSendJson(context, "xmc.service"), (int)-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupport(@NonNull Context context, String devId, String key, boolean isRefreshDataFromService, OnSysAbilityResultListener<Boolean> lisener) {
        try {
            if (!DevDataCenter.getInstance().isLoginByAccount()) {
                this.dealWithCallback(lisener, false, false);
                LogUtils.debugInfo("[APP_CAPS->]", "Access to cloud service-related functions requires account login.");
                return false;
            }
            SysDevAbilityInfoBean bean = null;
            boolean isSupport = false;
            if (this.sysDevAbilityInfoBeanMap != null) {
                Map<String, SysDevAbilityInfoBean> map = this.sysDevAbilityInfoBeanMap;
                synchronized (map) {
                    if (this.sysDevAbilityInfoBeanMap.containsKey(devId)) {
                        bean = this.sysDevAbilityInfoBeanMap.get(devId);
                        if (bean != null) {
                            isSupport = bean.isConfigSupport(key, false);
                            this.dealWithCallback(lisener, isSupport, false);
                        }
                    } else {
                        isRefreshDataFromService = true;
                    }
                    if (isRefreshDataFromService) {
                        if (bean == null) {
                            bean = new SysDevAbilityInfoBean(devId);
                            this.sysDevAbilityInfoBeanMap.put(devId, bean);
                        }
                        this.getSysDevAbilityFromServer(context, lisener, bean, key);
                    }
                    return isSupport;
                }
            }
            this.dealWithCallback(lisener, false, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealWithCallback(lisener, false, false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isSupports(@NonNull Context context, String devId, boolean isRefreshDataFromService, OnSysAbilityResultListener<Map<String, Object>> lisener, String ... keys) {
        block12: {
            try {
                if (!DevDataCenter.getInstance().isLoginByAccount()) {
                    this.dealWithCallback(lisener, false, false);
                    LogUtils.debugInfo("[APP_CAPS->]", "Access to cloud service-related functions requires account login.");
                    return;
                }
                SysDevAbilityInfoBean bean = null;
                if (this.sysDevAbilityInfoBeanMap != null) {
                    Map<String, SysDevAbilityInfoBean> map = this.sysDevAbilityInfoBeanMap;
                    synchronized (map) {
                        if (this.sysDevAbilityInfoBeanMap.containsKey(devId)) {
                            bean = this.sysDevAbilityInfoBeanMap.get(devId);
                            if (bean != null) {
                                Map<String, Object> isSupports = bean.getConfigSupports();
                                this.dealWithCallback(lisener, isSupports, false);
                            }
                        } else {
                            isRefreshDataFromService = true;
                        }
                        if (isRefreshDataFromService) {
                            if (bean == null) {
                                bean = new SysDevAbilityInfoBean(devId);
                                this.sysDevAbilityInfoBeanMap.put(devId, bean);
                            }
                            this.getSysDevAbilityFromServer(context, lisener, bean, keys);
                        }
                        break block12;
                    }
                }
                this.dealWithCallback(lisener, new HashMap<String, Object>(), false);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.dealWithCallback(lisener, new HashMap<String, Object>(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SysDevAbilityInfoBean getSysDevAbilityFromLocal(String devId) {
        if (!DevDataCenter.getInstance().isLoginByAccount()) {
            LogUtils.debugInfo("[APP_CAPS->]", "Access to cloud service-related functions requires account login.");
            return null;
        }
        if (this.sysDevAbilityInfoBeanMap != null) {
            Map<String, SysDevAbilityInfoBean> map = this.sysDevAbilityInfoBeanMap;
            synchronized (map) {
                return this.sysDevAbilityInfoBeanMap.get(devId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDevSupportCloud() {
        if (this.supportCloudDevCount != null) {
            AtomicInteger atomicInteger = this.supportCloudDevCount;
            synchronized (atomicInteger) {
                return this.supportCloudDevCount.get() > 0;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSysDevAbilityInfos(Context context, String devId, boolean isRefreshDataFromService, OnSysAbilityResultListener<SysDevAbilityInfoBean> listener, String ... keys) {
        block10: {
            try {
                if (!DevDataCenter.getInstance().isLoginByAccount()) {
                    LogUtils.debugInfo("[APP_CAPS->]", "Access to cloud service-related functions requires account login.");
                    return;
                }
                SysDevAbilityInfoBean bean = null;
                if (this.sysDevAbilityInfoBeanMap != null) {
                    Map<String, SysDevAbilityInfoBean> map = this.sysDevAbilityInfoBeanMap;
                    synchronized (map) {
                        if (this.sysDevAbilityInfoBeanMap.containsKey(devId)) {
                            bean = this.sysDevAbilityInfoBeanMap.get(devId);
                            this.dealWithCallback(listener, bean, false);
                        }
                        if (bean == null) {
                            bean = new SysDevAbilityInfoBean(devId);
                            this.sysDevAbilityInfoBeanMap.put(devId, bean);
                            isRefreshDataFromService = true;
                        }
                        if (isRefreshDataFromService) {
                            this.getSysDevAbilityFromServer(context, listener, bean, keys);
                        }
                        break block10;
                    }
                }
                this.dealWithCallback(listener, null, false);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.dealWithCallback(listener, null, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isSupportsRefreshFromService(Context context, String devId, OnSysAbilityResultListener<Map<String, Object>> lisener, String ... keys) {
        block9: {
            try {
                if (!DevDataCenter.getInstance().isLoginByAccount()) {
                    LogUtils.debugInfo("[APP_CAPS->]", "Access to cloud service-related functions requires account login.");
                    return;
                }
                if (this.sysDevAbilityInfoBeanMap != null) {
                    Map<String, SysDevAbilityInfoBean> map = this.sysDevAbilityInfoBeanMap;
                    synchronized (map) {
                        SysDevAbilityInfoBean bean = null;
                        if (this.sysDevAbilityInfoBeanMap.containsKey(devId)) {
                            bean = this.sysDevAbilityInfoBeanMap.get(devId);
                        }
                        if (bean == null) {
                            bean = new SysDevAbilityInfoBean(devId);
                            this.sysDevAbilityInfoBeanMap.put(devId, bean);
                        }
                        this.getSysDevAbilityFromServer(context, lisener, bean, keys);
                        break block9;
                    }
                }
                this.dealWithCallback(lisener, new HashMap<String, Object>(), false);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.dealWithCallback(lisener, new HashMap<String, Object>(), false);
            }
        }
    }

    private void getSysDevAbilityFromServer(Context context, OnSysAbilityResultListener<?> listener, SysDevAbilityInfoBean bean, String ... keys) {
        if (listener == null || bean == null || context == null) {
            return;
        }
        int seq = listener.hashCode();
        this.abilityResultListenerMap.put(seq, listener);
        bean.setPackageName(this.packageName);
        int iret = FunSDK.SysGetDevCapabilitySet((int)this.userId, (String)bean.getSendJson(context, keys), (int)seq);
        if (iret < 0) {
            Type[] interfaces = listener.getClass().getGenericInterfaces();
            if (interfaces.length > 0) {
                try {
                    Type type;
                    if (interfaces[0] instanceof ParameterizedType && (type = ((ParameterizedType)interfaces[0]).getActualTypeArguments()[0]) != null) {
                        if (type == HashMap.class) {
                            this.dealWithCallback(listener, new HashMap<String, Object>(), true);
                            return;
                        }
                        if (type == Boolean.class) {
                            this.dealWithCallback(listener, false, true);
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.dealWithCallback(listener, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeData(String devId) {
        if (this.sysDevAbilityInfoBeanMap != null) {
            Map<String, SysDevAbilityInfoBean> map = this.sysDevAbilityInfoBeanMap;
            synchronized (map) {
                if (this.sysDevAbilityInfoBeanMap.containsKey(devId)) {
                    SysDevAbilityInfoBean sysDevAbilityInfoBean = this.sysDevAbilityInfoBeanMap.get(devId);
                    if (sysDevAbilityInfoBean != null && sysDevAbilityInfoBean.isConfigSupport("xmc.service.support")) {
                        this.supportCloudDevCount.decrementAndGet();
                    }
                    this.sysDevAbilityInfoBeanMap.remove(devId);
                }
            }
        }
        if (this.onHasDevSupportCloudListener != null) {
            this.onHasDevSupportCloudListener.onHasDevSupportCloud(this.hasDevSupportCloud());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllData() {
        if (this.sysDevAbilityInfoBeanMap != null) {
            Map<String, SysDevAbilityInfoBean> map = this.sysDevAbilityInfoBeanMap;
            synchronized (map) {
                this.sysDevAbilityInfoBeanMap.clear();
            }
        }
        if (this.supportCloudDevCount != null) {
            this.supportCloudDevCount.set(0);
        }
        if (this.onHasDevSupportCloudListener != null) {
            this.onHasDevSupportCloudListener.onHasDevSupportCloud(this.hasDevSupportCloud());
        }
    }

    public void addNeedRefreshFlowState(String devId) {
        if (this.needRefreshState != null) {
            this.needRefreshState.put(devId, true);
        }
    }

    public boolean isNeedRefreshFlowState(String devId) {
        if (this.needRefreshState != null && this.needRefreshState.containsKey(devId)) {
            return this.needRefreshState.get(devId);
        }
        return false;
    }

    public void removeNeedRefreshFlowState(String devId) {
        if (this.needRefreshState != null && this.needRefreshState.containsKey(devId)) {
            this.needRefreshState.remove(devId);
        }
    }

    public void release() {
        this.removeAllData();
        if (this.abilityResultListenerMap != null) {
            this.abilityResultListenerMap.clear();
            this.abilityResultListenerMap = null;
        }
        if (this.onHasDevSupportCloudListener != null) {
            this.onHasDevSupportCloudListener = null;
        }
        instance = null;
        FunSDK.UnRegUser((int)this.userId);
        this.userId = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int OnFunSDKResult(Message message, MsgContent msgContent) {
        switch (message.what) {
            case 5089: {
                try {
                    String devId = G.ToString((byte[])msgContent.pData);
                    OnSysAbilityResultListener resultListener = this.abilityResultListenerMap.get(msgContent.seq);
                    if (message.arg1 < 0) {
                        this.dealWithCallback(resultListener, null, true);
                        return 0;
                    }
                    if (this.sysDevAbilityInfoBeanMap == null) return 0;
                    Map<String, SysDevAbilityInfoBean> map = this.sysDevAbilityInfoBeanMap;
                    synchronized (map) {
                        SysDevAbilityInfoBean bean;
                        boolean isNeedIncrement = true;
                        if (this.sysDevAbilityInfoBeanMap.containsKey(devId)) {
                            bean = this.sysDevAbilityInfoBeanMap.get(devId);
                            if (bean != null && bean.isConfigSupport("xmc.service.support")) {
                                isNeedIncrement = false;
                            }
                        } else {
                            bean = new SysDevAbilityInfoBean(devId);
                            this.sysDevAbilityInfoBeanMap.put(devId, bean);
                        }
                        bean.parseJson(msgContent.str);
                        if (isNeedIncrement && bean.isConfigSupport("xmc.service.support")) {
                            this.supportCloudDevCount.incrementAndGet();
                        }
                        this.dealWithCallbackType(resultListener, bean);
                        if (this.onHasDevSupportCloudListener == null) return 0;
                        this.onHasDevSupportCloudListener.onHasDevSupportCloud(this.hasDevSupportCloud());
                        return 0;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return 0;
            }
            case 5092: {
                if (message.arg1 < 0) {
                    return 0;
                }
                List<String> devList = this.parseAllDevJson(msgContent.str);
                LogUtils.debugInfo("[APP_CAPS->]", "receive:" + devList.size());
                if (this.onAllDevAbilityResultListener == null) return 0;
                this.onAllDevAbilityResultListener.onUpdateAllDevAbilityResult(devList);
                return 0;
            }
        }
        return 0;
    }

    private void dealWithCallbackType(OnSysAbilityResultListener listener, SysDevAbilityInfoBean bean) {
        if (listener == null) {
            return;
        }
        Type[] interfaces = listener.getClass().getGenericInterfaces();
        if (interfaces.length > 0) {
            try {
                Type type;
                if (interfaces[0] instanceof ParameterizedType && (type = ((ParameterizedType)interfaces[0]).getActualTypeArguments()[0]) != null) {
                    if (type == Boolean.class) {
                        this.dealWithCallback(listener, bean.isConfigSupport(), true);
                        return;
                    }
                    if (type == SysDevAbilityInfoBean.class) {
                        this.dealWithCallback(listener, bean, true);
                        return;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.dealWithCallback(listener, bean.getConfigSupports(), true);
    }

    private void dealWithCallback(OnSysAbilityResultListener listener, Map<String, Object> configSupports, boolean isRefreshFromServer) {
        if (listener == null) {
            return;
        }
        listener.onSupportResult(configSupports, isRefreshFromServer);
    }

    private void dealWithCallback(OnSysAbilityResultListener listener, Object result, boolean isRefreshFromServer) {
        if (listener == null) {
            return;
        }
        listener.onSupportResult(result, isRefreshFromServer);
    }

    public boolean isCanMonitor(String devId) {
        SysDevAbilityInfoBean sysDevAbilityInfoBean;
        if (this.sysDevAbilityInfoBeanMap != null && (sysDevAbilityInfoBean = this.sysDevAbilityInfoBeanMap.get(devId)) != null) {
            int localFlowState = sysDevAbilityInfoBean.getLocalFlowState();
            return localFlowState == 1 || localFlowState == 0;
        }
        return true;
    }

    public int getDevCloudStorageState(Map<String, Object> isSupports) {
        String expiration;
        String enable;
        int cloudState = 0;
        boolean isCloudVidSupport = false;
        boolean isCloudVidEnable = false;
        boolean isCloudVidNormal = false;
        if (isSupports.containsKey("xmc.css.vid.support")) {
            isCloudVidSupport = (Boolean)isSupports.get("xmc.css.vid.support");
        }
        if (isSupports.containsKey("xmc.css.vid.enable")) {
            isCloudVidEnable = (Boolean)isSupports.get("xmc.css.vid.enable");
        }
        if (isSupports.containsKey("xmc.css.vid.normal")) {
            isCloudVidNormal = (Boolean)isSupports.get("xmc.css.vid.normal");
        }
        String[] enableChn = null;
        String[] expirationChn = null;
        if (isSupports.containsKey("xmc.css.vid.enable.channels") && isSupports.get("xmc.css.vid.enable.channels") instanceof String && (enable = (String)isSupports.get("xmc.css.vid.enable.channels")) != null) {
            enableChn = enable.split("_");
        }
        if (isSupports.containsKey("xmc.css.vid.expirationtime.channels") && isSupports.get("xmc.css.vid.expirationtime.channels") instanceof String && (expiration = (String)isSupports.get("xmc.css.vid.expirationtime.channels")) != null) {
            expirationChn = expiration.split("_");
        }
        if (isCloudVidSupport && enableChn != null && expirationChn != null && enableChn.length == expirationChn.length) {
            return this.checkDevChnCloudState(enableChn, expirationChn);
        }
        if (isCloudVidSupport) {
            cloudState = isCloudVidNormal ? 1 : (isCloudVidEnable ? 2 : 3);
        }
        return cloudState;
    }

    public int checkDevChnCloudState(String[] enableChn, String[] expirationChn) {
        int cloudState = 0;
        try {
            if (enableChn != null && expirationChn != null && enableChn.length == expirationChn.length) {
                cloudState = 3;
                for (int i = 0; i < expirationChn.length; ++i) {
                    long time = Long.parseLong(expirationChn[i]);
                    if (time <= 0L || !"true".equals(enableChn[i])) continue;
                    if (time > System.currentTimeMillis() / 1000L) {
                        return 1;
                    }
                    cloudState = 2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cloudState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDevChnCloud(@NonNull Context context, String devId) {
        block8: {
            try {
                if (this.sysDevAbilityInfoBeanMap == null) break block8;
                Map<String, SysDevAbilityInfoBean> map = this.sysDevAbilityInfoBeanMap;
                synchronized (map) {
                    SysDevAbilityInfoBean bean;
                    if (this.sysDevAbilityInfoBeanMap.containsKey(devId) && (bean = this.sysDevAbilityInfoBeanMap.get(devId)) != null) {
                        Map<String, Object> isSupports = bean.getConfigSupports();
                        boolean isCloudVidSupport = false;
                        if (isSupports.containsKey("xmc.css.vid.support")) {
                            isCloudVidSupport = (Boolean)isSupports.get("xmc.css.vid.support");
                        }
                        if (isCloudVidSupport && isSupports.containsKey("xmc.css.vid.enable.channels") && isSupports.containsKey("xmc.css.vid.expirationtime.channels")) {
                            return true;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getNormalUseChnList(@NonNull Context context, String devId) {
        block12: {
            try {
                SysDevAbilityInfoBean bean = null;
                if (this.sysDevAbilityInfoBeanMap == null) break block12;
                Map<String, SysDevAbilityInfoBean> map = this.sysDevAbilityInfoBeanMap;
                synchronized (map) {
                    if (this.sysDevAbilityInfoBeanMap.containsKey(devId) && (bean = this.sysDevAbilityInfoBeanMap.get(devId)) != null) {
                        String expiration;
                        String enable;
                        Map<String, Object> isSupports = bean.getConfigSupports();
                        String[] enableChn = null;
                        String[] expirationChn = null;
                        if (isSupports.containsKey("xmc.css.vid.enable.channels") && isSupports.get("xmc.css.vid.enable.channels") instanceof String && (enable = (String)isSupports.get("xmc.css.vid.enable.channels")) != null) {
                            enableChn = enable.split("_");
                        }
                        if (isSupports.containsKey("xmc.css.vid.expirationtime.channels") && isSupports.get("xmc.css.vid.expirationtime.channels") instanceof String && (expiration = (String)isSupports.get("xmc.css.vid.expirationtime.channels")) != null) {
                            expirationChn = expiration.split("_");
                        }
                        if (enableChn != null && expirationChn != null && enableChn.length == expirationChn.length) {
                            ArrayList<Integer> chnList = new ArrayList<Integer>();
                            try {
                                for (int i = 0; i < expirationChn.length; ++i) {
                                    long time = Long.parseLong(expirationChn[i]);
                                    if (time <= 0L || !"true".equals(enableChn[i]) || time <= System.currentTimeMillis() / 1000L) continue;
                                    chnList.add(i);
                                }
                                return chnList;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setOnHasDevSupportCloudListener(OnSysAbilityResultListener.OnHasDevSupportCloudListener onHasDevSupportCloudListener) {
        this.onHasDevSupportCloudListener = onHasDevSupportCloudListener;
    }

    private String getAllDevSendJson(List<SysDevAbilityInfoBean> sysDevAbilityInfoBeans) {
        if (sysDevAbilityInfoBeans == null) {
            return "";
        }
        JSONObject sendObj = new JSONObject();
        try {
            sendObj.put("ver", (Object)2);
            sendObj.put("caps", (Object)new String[]{"xmc.service"});
            if (!StringUtils.isStringNULL(this.packageName)) {
                sendObj.put("appType", (Object)this.packageName);
            }
            JSONArray devIds = new JSONArray();
            for (SysDevAbilityInfoBean sysDevAbilityInfoBean : sysDevAbilityInfoBeans) {
                JSONObject devIdObj = new JSONObject();
                if (sysDevAbilityInfoBean != null) {
                    devIdObj.put("tp", (Object)sysDevAbilityInfoBean.getDevType());
                    devIdObj.put("sn", (Object)sysDevAbilityInfoBean.getDevId());
                    HashMap devAbilityMap = (HashMap)sysDevAbilityInfoBean.getConfigSupports();
                    if (devAbilityMap != null) {
                        devAbilityMap.put("xmc.service", false);
                        devAbilityMap.put("devId", sysDevAbilityInfoBean.getDevId());
                    }
                }
                devIds.add((Object)devIdObj);
            }
            sendObj.put("snList", (Object)devIds);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        System.out.println("sysDevAbility:" + sendObj.toString());
        return sendObj.toString();
    }

    private List<String> parseAllDevJson(String allDevAbilityJson) {
        if (StringUtils.isStringNULL(allDevAbilityJson)) {
            return new ArrayList<String>();
        }
        if (this.sysDevAbilityInfoBeanMap == null) {
            this.sysDevAbilityInfoBeanMap = new ArrayMap();
        }
        try {
            JSONArray capsArray;
            JSONObject jObj = JSON.parseObject((String)allDevAbilityJson);
            if (jObj == null) {
                return new ArrayList<String>();
            }
            ArrayList<String> devList = new ArrayList<String>();
            if (jObj.containsKey((Object)"capsList") && (capsArray = jObj.getJSONArray("capsList")) != null) {
                for (int i = 0; i < capsArray.size(); ++i) {
                    SysDevAbilityInfoBean bean;
                    JSONObject capsObj = capsArray.getJSONObject(i);
                    if (capsObj == null || !capsObj.containsKey((Object)"sn")) continue;
                    String devId = capsObj.getString("sn");
                    boolean isNeedIncrement = true;
                    if (this.sysDevAbilityInfoBeanMap.containsKey(devId)) {
                        bean = this.sysDevAbilityInfoBeanMap.get(devId);
                        if (bean != null && bean.isConfigSupport("xmc.service.support")) {
                            isNeedIncrement = false;
                        }
                    } else {
                        bean = new SysDevAbilityInfoBean(devId);
                        this.sysDevAbilityInfoBeanMap.put(devId, bean);
                    }
                    bean.parseJson(capsObj.toJSONString());
                    devList.add(devId);
                    if (!isNeedIncrement || !bean.isConfigSupport("xmc.service.support")) continue;
                    this.supportCloudDevCount.incrementAndGet();
                }
                return devList;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
        return new ArrayList<String>();
    }
}

