/*
 * Decompiled with CFR 0.152.
 */
package com.manager.path;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.FileUtils;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import com.lib.sdk.bean.StringUtils;
import com.manager.path.MediaPathBean;
import com.utils.MediaUtils;
import com.utils.PathUtils;
import com.utils.XUtils;
import io.reactivex.disposables.Disposable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PathManager {
    private String tempImages;
    private String tempCaptures;
    private String pushDownloadPath;
    private String pushImagePath;
    private String logPath;
    private String adPath;
    private String localDevListPath;
    private String imagePath;
    private String videoPath;
    private String fishEyeCachePath;
    private String appPrivatePath;
    private String receiveFilesPath;
    private String appNamePath;
    private String appPackageName;
    private String devConfigPath;
    private static PathManager pathManager;
    private Disposable disposable;

    private PathManager(Context context) {
        if (context != null) {
            this.appPackageName = XUtils.getPackageName(context);
            this.initAndroidPath(context);
        }
    }

    private void initAndroidPath(Context context) {
        this.appPrivatePath = PathUtils.getAndroidPath(context);
        this.appNamePath = this.appPrivatePath + File.separator + this.appPackageName;
        this.imagePath = this.appNamePath + File.separator + "snapshot" + File.separator;
        this.videoPath = this.appNamePath + File.separator + "videorecord" + File.separator;
        this.receiveFilesPath = this.appNamePath + File.separator + "receiveFilesPath" + File.separator;
        this.logPath = this.appNamePath + File.separator + "log" + File.separator;
        this.fishEyeCachePath = this.appNamePath + File.separator + "fe.json";
        this.localDevListPath = this.appNamePath + File.separator + "CSFile.db";
        this.tempImages = this.appNamePath + File.separator + ".temp_images" + File.separator;
        this.tempCaptures = this.appNamePath + File.separator + ".temp_capture" + File.separator;
        this.pushDownloadPath = this.appNamePath + ".push" + File.separator + "download" + File.separator;
        this.pushImagePath = this.appNamePath + ".push" + File.separator + "img" + File.separator;
        this.adPath = this.appNamePath + File.separator + ".temp_ad" + File.separator;
        this.devConfigPath = this.appNamePath + File.separator + "devConfig" + File.separator;
    }

    public static synchronized PathManager getInstance(Context context) {
        if (pathManager == null) {
            pathManager = new PathManager(context);
        }
        return pathManager;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public String getAdPath() {
        return this.adPath;
    }

    public String getLocalDevListPath() {
        return this.localDevListPath;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public String getVideoPath() {
        return this.videoPath;
    }

    public String getAppPath() {
        return this.appNamePath;
    }

    public void createLocalPath() {
        File pFile = new File(this.appNamePath);
        if (!pFile.exists()) {
            this.makePrivateDirectory(pFile.getPath());
        }
        if (!(pFile = new File(this.imagePath)).exists()) {
            this.makePrivateDirectory(pFile.getPath());
        }
        if (!(pFile = new File(this.videoPath)).exists()) {
            this.makePrivateDirectory(pFile.getPath());
        }
        if (!(pFile = new File(this.receiveFilesPath)).exists()) {
            this.makePrivateDirectory(pFile.getPath());
        }
        if (!(pFile = new File(this.tempImages)).exists()) {
            this.makePrivateDirectory(pFile.getPath());
        }
        if (!(pFile = new File(this.tempCaptures)).exists()) {
            this.makePrivateDirectory(pFile.getPath());
        }
        if (!(pFile = new File(this.pushDownloadPath)).exists()) {
            this.makePrivateDirectory(pFile.getPath());
        }
        if (!(pFile = new File(this.pushImagePath)).exists()) {
            this.makePrivateDirectory(pFile.getPath());
        }
        if (!(pFile = new File(this.logPath)).exists()) {
            this.makePrivateDirectory(pFile.getPath());
        }
        if (!(pFile = new File(this.adPath)).exists()) {
            this.makePrivateDirectory(pFile.getPath());
        }
    }

    public boolean makePrivateDirectory(String filePath) {
        File file = null;
        String newPath = null;
        if (filePath == null || !filePath.startsWith(this.appPrivatePath)) {
            return false;
        }
        String[] path = filePath.split(File.separator);
        for (int i = 0; i < path.length; ++i) {
            if (StringUtils.isStringNULL(newPath = newPath == null ? path[i] : newPath + File.separator + path[i]) || this.appPrivatePath.contains(newPath) || (file = new File(newPath)).exists() || file.mkdir()) continue;
            return false;
        }
        return true;
    }

    public void copyPasswordFromOldPath(Context context, String passwordPath) {
        if (context == null) {
            return;
        }
        String oldConfigPath = PathUtils.getMediaPath(context) + File.separator + XUtils.getPackageName(context) + File.separator + ".ConfigPath/password.txt";
        if (com.utils.FileUtils.isFileOrDirExists(oldConfigPath) && !com.utils.FileUtils.isFileExist(passwordPath) && com.utils.FileUtils.copyFile(oldConfigPath, passwordPath)) {
            com.utils.FileUtils.deleteFile(new File(oldConfigPath));
        }
    }

    public List<MediaPathBean> getAllImages(Context context) {
        ArrayList<MediaPathBean> mediaPathBeans = new ArrayList<MediaPathBean>();
        if (context == null) {
            return mediaPathBeans;
        }
        try {
            Cursor cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, null, null, null);
            int idColumn = cursor.getColumnIndexOrThrow("_id");
            int dataColumn = cursor.getColumnIndexOrThrow("_data");
            while (cursor.moveToNext()) {
                long id2 = cursor.getLong(idColumn);
                String filePath = cursor.getString(dataColumn);
                System.out.println("filePath:" + filePath);
                if (!filePath.contains(this.appPackageName + File.separator)) continue;
                Uri uri = ContentUris.withAppendedId((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (long)id2);
                mediaPathBeans.add(new MediaPathBean(id2, filePath, uri));
            }
            cursor.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mediaPathBeans;
    }

    public List<MediaPathBean> getAllVideos(Context context) {
        if (context == null) {
            return null;
        }
        ArrayList<MediaPathBean> mediaPathBeans = new ArrayList<MediaPathBean>();
        try {
            Cursor cursor = context.getContentResolver().query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, null, null, null, null);
            int idColumn = cursor.getColumnIndexOrThrow("_id");
            int dataColumn = cursor.getColumnIndexOrThrow("_data");
            while (cursor.moveToNext()) {
                long id2 = cursor.getLong(idColumn);
                String filePath = cursor.getString(dataColumn);
                System.out.println("filePath:" + filePath);
                if (!filePath.contains(this.appPackageName + File.separator)) continue;
                Uri uri = ContentUris.withAppendedId((Uri)MediaStore.Video.Media.EXTERNAL_CONTENT_URI, (long)id2);
                mediaPathBeans.add(new MediaPathBean(id2, filePath, uri));
            }
            cursor.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mediaPathBeans;
    }

    public static String insetImage(Context context, String filePath) {
        if (context == null || !com.utils.FileUtils.isFileExist(filePath)) {
            return null;
        }
        if (Build.VERSION.SDK_INT > 29) {
            ContentValues contentValues = new ContentValues();
            ContentResolver contentResolver = context.getContentResolver();
            contentValues.put("relative_path", Environment.DIRECTORY_PICTURES);
            contentValues.put("_size", Long.valueOf(com.utils.FileUtils.getFileOrFilesSize(filePath)));
            contentValues.put("date_modified", Long.valueOf(System.currentTimeMillis()));
            Uri insertUri = contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
            if (insertUri != null) {
                try {
                    OutputStream outputStream = contentResolver.openOutputStream(insertUri);
                    if (outputStream != null) {
                        FileInputStream inputStream = new FileInputStream(filePath);
                        byte[] buffer = new byte[1024];
                        int byteRead = 0;
                        while ((byteRead = ((InputStream)inputStream).read(buffer)) != -1) {
                            outputStream.write(buffer, 0, byteRead);
                        }
                        outputStream.close();
                        ((InputStream)inputStream).close();
                        return insertUri.toString();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            return MediaUtils.getInstance(context).saveImage(filePath);
        }
        return filePath;
    }

    public static String insetVideo(Context context, String filePath) {
        block6: {
            if (context == null || !com.utils.FileUtils.isFileExist(filePath)) {
                return null;
            }
            try {
                String[] names;
                String[] filePaths = filePath.split(File.separator);
                if (Build.VERSION.SDK_INT < 29) {
                    String newPath = PathUtils.getMediaPath(context) + File.separator + filePaths[filePaths.length - 1];
                    if (com.utils.FileUtils.copyFile(filePath, newPath)) {
                        return newPath;
                    }
                    break block6;
                }
                String fileName = filePaths[filePaths.length - 1];
                if (!TextUtils.isEmpty((CharSequence)fileName) && (names = fileName.split("_")) != null && names.length > 0) {
                    fileName = names[0] + "_" + Long.valueOf(System.currentTimeMillis()) + ".mp4";
                }
                return PathManager.copyPrivateToDownload(context, filePath, fileName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return filePath;
    }

    public static String saveVideoToAlbum(Context context, String filePath) {
        String saveVideoPath = "";
        try {
            saveVideoPath = PathManager.insetVideo(context, filePath);
            if (Build.VERSION.SDK_INT <= 29) {
                File file = new File(saveVideoPath);
                ContentResolver localContentResolver = context.getContentResolver();
                ContentValues localContentValues = PathManager.getVideoContentValues(file, System.currentTimeMillis());
                Uri localUri = localContentResolver.insert(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, localContentValues);
                context.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", localUri));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return saveVideoPath;
    }

    public static ContentValues getVideoContentValues(File paramFile, long paramLong) {
        ContentValues localContentValues = new ContentValues();
        localContentValues.put("title", paramFile.getName());
        localContentValues.put("_display_name", paramFile.getName());
        localContentValues.put("mime_type", "video/mp4");
        localContentValues.put("datetaken", Long.valueOf(paramLong));
        localContentValues.put("date_modified", Long.valueOf(paramLong));
        localContentValues.put("date_added", Long.valueOf(paramLong));
        localContentValues.put("_data", paramFile.getAbsolutePath());
        localContentValues.put("_size", Long.valueOf(paramFile.length()));
        return localContentValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=29)
    public static String copyPrivateToDownload(Context context, String orgFilePath, String displayName) {
        ContentValues values = new ContentValues();
        values.put("_display_name", displayName);
        values.put("mime_type", "video/*");
        values.put("title", displayName);
        values.put("relative_path", "Download" + File.separator + XUtils.getPackageName(context));
        Uri external = MediaStore.Downloads.EXTERNAL_CONTENT_URI;
        ContentResolver resolver = context.getContentResolver();
        Uri insertUri = resolver.insert(external, values);
        InputStream ist = null;
        OutputStream ost = null;
        try {
            ist = new FileInputStream(new File(orgFilePath));
            if (insertUri != null) {
                ost = resolver.openOutputStream(insertUri);
            }
            if (ost != null) {
                byte[] buffer = new byte[4096];
                int byteCount = 0;
                while ((byteCount = ist.read(buffer)) != -1) {
                    ost.write(buffer, 0, byteCount);
                }
                String string2 = insertUri.toString();
                return string2;
            }
        }
        catch (Exception e) {
            String string3 = orgFilePath;
            return string3;
        }
        finally {
            try {
                if (ist != null) {
                    ist.close();
                }
                if (ost != null) {
                    ost.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return orgFilePath;
    }

    public void clearCache() {
        com.utils.FileUtils.deleteFiles(new File(this.tempCaptures));
        com.utils.FileUtils.deleteFiles(new File(this.tempImages));
        com.utils.FileUtils.deleteFiles(new File(this.pushImagePath));
        com.utils.FileUtils.deleteFiles(new File(this.pushDownloadPath));
        com.utils.FileUtils.deleteFile(this.fishEyeCachePath);
    }

    public long getCacheSize() {
        long size = 0L;
        size = com.utils.FileUtils.getFileOrFilesSize(this.tempCaptures) + com.utils.FileUtils.getFileOrFilesSize(this.tempImages) + com.utils.FileUtils.getFileOrFilesSize(this.pushImagePath) + com.utils.FileUtils.getFileOrFilesSize(this.pushDownloadPath);
        return size;
    }

    public String getPathForPhoto(Context context) {
        if (context == null) {
            return "";
        }
        SharedPreferences bell = context.getSharedPreferences("my_pref", 0);
        String path = bell.getString("img_save_path", null);
        return path == null ? this.imagePath : path;
    }

    public String getPathForVideo(Context context) {
        if (context == null) {
            return "";
        }
        SharedPreferences bell = context.getSharedPreferences("my_pref", 0);
        String path = bell.getString("video_save_path", null);
        return path == null ? this.videoPath : path;
    }

    public String getAdBootPath() {
        try {
            String adBootPath = this.adPath + "boot";
            File pFile = new File(adBootPath);
            if (!pFile.exists()) {
                this.makePrivateDirectory(pFile.getPath());
            }
            return adBootPath + File.separator;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getAdInfoBootPath() {
        try {
            String adBootInfoPath = this.getAdBootPath() + "adinfo";
            return adBootInfoPath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getAdInterstital() {
        try {
            String adInterstitalPath = this.adPath + "interstital";
            File pFile = new File(adInterstitalPath);
            if (!pFile.exists()) {
                this.makePrivateDirectory(pFile.getPath());
            }
            return adInterstitalPath + File.separator;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getAdInfoInterstitalPath() {
        try {
            String adInterstitalInfoPath = this.getAdInterstital() + "adinfo";
            return adInterstitalInfoPath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getFishEyeCachePath() {
        return this.fishEyeCachePath;
    }

    public String getPushImagePath() {
        return this.pushImagePath;
    }

    public String getPushDownloadPath() {
        return this.pushDownloadPath;
    }

    public String getTempImages() {
        return this.tempImages;
    }

    public String getTempCaptures() {
        return this.tempCaptures;
    }

    public String getReceiveFilesPath() {
        return this.receiveFilesPath;
    }

    public static String getFileName(Uri uri) {
        if (uri == null) {
            return null;
        }
        String fileName = null;
        String path = uri.getPath();
        int cut = path.lastIndexOf(47);
        if (cut != -1) {
            fileName = path.substring(cut + 1);
        }
        return fileName;
    }

    public static void copyFile(Context context, Uri srcUri, File dstFile) {
        try {
            InputStream inputStream = context.getContentResolver().openInputStream(srcUri);
            if (inputStream == null) {
                return;
            }
            FileOutputStream outputStream = new FileOutputStream(dstFile);
            PathManager.copyStream(inputStream, outputStream);
            inputStream.close();
            ((OutputStream)outputStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyStream(InputStream input, OutputStream output) throws Exception, IOException {
        int BUFFER_SIZE = 2048;
        byte[] buffer = new byte[2048];
        BufferedInputStream in = new BufferedInputStream(input, 2048);
        BufferedOutputStream out = new BufferedOutputStream(output, 2048);
        int count = 0;
        int n = 0;
        try {
            while ((n = in.read(buffer, 0, 2048)) != -1) {
                out.write(buffer, 0, n);
                count += n;
            }
            out.flush();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return count;
    }

    public String getFileAbsolutePath(Context context, Uri uri) {
        if (context == null || uri == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 19) {
            return PathManager.getRealFilePath(context, uri);
        }
        if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 29 && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (PathManager.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (PathManager.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                    return PathManager.getDataColumn(context, contentUri, null, null);
                }
                if (PathManager.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return PathManager.getDataColumn(context, contentUri, selection, selectionArgs);
                }
            }
        }
        if (Build.VERSION.SDK_INT >= 29) {
            return this.uriToFileApiQ(context, uri);
        }
        if ("content".equalsIgnoreCase(uri.getScheme())) {
            if (PathManager.isGooglePhotosUri(uri)) {
                return uri.getLastPathSegment();
            }
            return PathManager.getDataColumn(context, uri, null, null);
        }
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            return uri.getPath();
        }
        return null;
    }

    private static String getRealFilePath(Context context, Uri uri) {
        if (null == uri) {
            return null;
        }
        String scheme = uri.getScheme();
        String data = null;
        if (scheme == null) {
            data = uri.getPath();
        } else if ("file".equals(scheme)) {
            data = uri.getPath();
        } else if ("content".equals(scheme)) {
            String[] projection = new String[]{"_data"};
            Cursor cursor = context.getContentResolver().query(uri, projection, null, null, null);
            if (null != cursor) {
                int index;
                if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                    data = cursor.getString(index);
                }
                cursor.close();
            }
        }
        return data;
    }

    private static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{column};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndexOrThrow(column);
                String string2 = cursor.getString(index);
                return string2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    private static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    private static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileFromContentUri(Context context, Uri uri) {
        if (uri == null) {
            return null;
        }
        String[] filePathColumn = new String[]{"_data", "_display_name"};
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query(uri, filePathColumn, null, null, null);
        if (cursor != null) {
            cursor.moveToFirst();
            try {
                String filePath;
                String string2 = filePath = cursor.getString(cursor.getColumnIndex(filePathColumn[0]));
                return string2;
            }
            catch (Exception exception) {
            }
            finally {
                cursor.close();
            }
        }
        return "";
    }

    @RequiresApi(api=29)
    private String uriToFileApiQ(Context context, Uri uri) {
        File file = null;
        if (uri.getScheme().equals("file")) {
            file = new File(uri.getPath());
        } else if (uri.getScheme().equals("content")) {
            try {
                ContentResolver contentResolver = context.getContentResolver();
                Cursor cursor = contentResolver.query(uri, null, null, null, null);
                if (cursor.moveToFirst()) {
                    String displayName = cursor.getString(cursor.getColumnIndex("_display_name"));
                    InputStream is = contentResolver.openInputStream(uri);
                    File cache = new File(this.receiveFilesPath, displayName);
                    FileOutputStream fos = new FileOutputStream(cache);
                    FileUtils.copy((InputStream)is, (OutputStream)fos);
                    file = cache;
                    fos.close();
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return file == null ? null : file.getAbsolutePath();
    }

    private static Uri getUri(Context context, Uri uri) {
        String path = uri.getEncodedPath();
        if (path != null) {
            Uri uri_temp;
            path = Uri.decode((String)path);
            ContentResolver cr = context.getContentResolver();
            StringBuffer buff = new StringBuffer();
            buff.append("(").append("_data").append("=").append("'" + path + "'").append(")");
            Cursor cur = cr.query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, buff.toString(), null, null);
            int index = 0;
            cur.moveToFirst();
            while (!cur.isAfterLast()) {
                index = cur.getColumnIndex("_id");
                index = cur.getInt(index);
                cur.moveToNext();
            }
            if (index != 0 && (uri_temp = Uri.parse((String)("content://media/external/images/media/" + index))) != null) {
                uri = uri_temp;
            }
        }
        return uri;
    }

    public static interface OnCopyFilesListener {
        public void onCompleted(boolean var1);
    }
}

