/*
 * Decompiled with CFR 0.152.
 */
package com.manager.image;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Message;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.lib.sdk.struct.H264_DVR_FILE_DATA;
import com.manager.image.BaseImageManager;
import com.utils.FileUtils;
import com.utils.XUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;

public class DevImageManager
extends BaseImageManager
implements IFunSDKResult {
    public DevImageManager(String saveImageDir) {
        super(saveImageDir);
    }

    public Bitmap downloadVideoThumb(H264_DVR_FILE_DATA h264DvrFileData, int seq, int imgWidth, int imgHeight, BaseImageManager.OnImageManagerListener listener, boolean isDownloadFromDev) {
        if (h264DvrFileData == null) {
            if (listener != null) {
                listener.onDownloadResult(false, null, null, 1, seq);
            }
            return null;
        }
        try {
            String path = this.mSaveImageDir + File.separator + this.mDevId + "_" + h264DvrFileData.getLongStartTime() + h264DvrFileData.getLongEndTime() + "thumb.jpg";
            if (FileUtils.isFileExist(path)) {
                if (this.mBitmapMaps == null) {
                    this.mBitmapMaps = new HashMap();
                }
                Bitmap bitmap = BitmapFactory.decodeFile((String)path);
                this.mBitmapMaps.put(path, bitmap);
                if (listener != null) {
                    listener.onDownloadResult(true, path, bitmap, 1, seq);
                }
                return bitmap;
            }
            Bitmap bitmap = this.getPicBitmap(path);
            if (bitmap != null) {
                if (listener != null) {
                    listener.onDownloadResult(true, path, bitmap, 1, seq);
                }
                return bitmap;
            }
            int times = FunSDK.ToTimeType((int[])new int[]{h264DvrFileData.st_3_beginTime.st_0_year, h264DvrFileData.st_3_beginTime.st_1_month, h264DvrFileData.st_3_beginTime.st_2_day, h264DvrFileData.st_3_beginTime.st_4_hour, h264DvrFileData.st_3_beginTime.st_5_minute, h264DvrFileData.st_3_beginTime.st_6_second});
            BaseImageManager.DownItemData down = new BaseImageManager.DownItemData();
            down.mHeight = Math.max(imgHeight, 0);
            down.mWidth = Math.max(imgWidth, 0);
            down.mPath = path;
            down.mTimes = times;
            down.mType = 1;
            down.mSeq = seq;
            down.mChnId = h264DvrFileData.st_0_ch;
            down.mListener = listener;
            if (this.mDownloadQueue == null) {
                this.mDownloadQueue = new LinkedBlockingDeque();
            }
            if (!this.mDownloadQueue.contains(down)) {
                this.mDownloadQueue.add(down);
            }
            if (!this.mIsDownloading && isDownloadFromDev) {
                this.downloadImage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Bitmap downloadVideoThumb(H264_DVR_FILE_DATA h264DvrFileData, int nSeq, int imgWidth, int imgHeight) {
        return this.downloadVideoThumb(h264DvrFileData, nSeq, imgWidth, imgHeight, this.mListener, true);
    }

    public Bitmap downloadVideoThumb(H264_DVR_FILE_DATA h264DvrFileData, int imgWidth, int imgHeight, BaseImageManager.OnImageManagerListener listener) {
        return this.downloadVideoThumb(h264DvrFileData, 0, imgWidth, imgHeight, listener, true);
    }

    private void downloadImage() {
        if (this.mDownloadQueue == null || this.mDownloadQueue.isEmpty()) {
            this.mIsDownloading = false;
            return;
        }
        if (this.mDownloadResultMap == null) {
            this.mDownloadResultMap = new HashMap();
        }
        BaseImageManager.DownItemData down = (BaseImageManager.DownItemData)this.mDownloadQueue.poll();
        this.mDownloadResultMap.put(down.mSeq, down);
        FunSDK.DownloadRecordBImage((int)this.mUserId, (String)this.mDevId, (int)down.mChnId, (int)down.mTimes, (String)down.mPath, (int)0, (int)down.mSeq);
    }

    @Override
    public void cancel() {
        if (this.mDownloadQueue != null) {
            this.mDownloadQueue.clear();
        }
    }

    @Override
    public void release() {
        if (this.mBitmapMaps != null) {
            for (Map.Entry entry : this.mBitmapMaps.entrySet()) {
                Bitmap bitmap;
                if (entry == null || (bitmap = (Bitmap)entry.getValue()) == null) continue;
                bitmap.recycle();
            }
            this.mBitmapMaps.clear();
        }
        this.cancel();
    }

    public Bitmap getPicBitmap(H264_DVR_FILE_DATA h264DvrFileData, boolean isThumb) {
        if (h264DvrFileData == null) {
            return null;
        }
        String path = isThumb ? this.mSaveImageDir + File.separator + this.mDevId + "_" + h264DvrFileData.getLongStartTime() + h264DvrFileData.getLongEndTime() + "thumb.jpg" : this.mSaveImageDir + File.separator + this.mDevId + "_" + h264DvrFileData.getLongStartTime() + h264DvrFileData.getLongEndTime() + ".jpg";
        return this.getPicBitmap(path);
    }

    public int OnFunSDKResult(Message message, MsgContent msgContent) {
        switch (message.what) {
            case 5534: {
                break;
            }
            case 5535: {
                if (message.arg1 < 0) {
                    BaseImageManager.DownItemData downItemData = (BaseImageManager.DownItemData)this.mDownloadResultMap.get(msgContent.seq);
                    if (downItemData != null && downItemData.mListener != null) {
                        downItemData.mListener.onDownloadResult(false, null, null, downItemData.mType, msgContent.seq);
                    } else if (this.mListener != null) {
                        if (downItemData != null) {
                            this.mListener.onDownloadResult(false, msgContent.str, null, downItemData.mType, msgContent.seq);
                        } else {
                            this.mListener.onDownloadResult(false, null, null, 0, msgContent.seq);
                        }
                    }
                } else {
                    Bitmap bitmap;
                    BaseImageManager.DownItemData downItemData;
                    if (this.mBitmapMaps == null) {
                        this.mBitmapMaps = new HashMap();
                    }
                    if ((downItemData = (BaseImageManager.DownItemData)this.mDownloadResultMap.get(msgContent.seq)) != null && downItemData.mWidth > 0) {
                        bitmap = XUtils.createImageThumbnail(msgContent.str);
                        this.mBitmapMaps.put(msgContent.str, bitmap);
                    } else {
                        bitmap = BitmapFactory.decodeFile((String)msgContent.str);
                        this.mBitmapMaps.put(msgContent.str, bitmap);
                    }
                    if (downItemData != null && downItemData.mListener != null) {
                        downItemData.mListener.onDownloadResult(true, msgContent.str, bitmap, downItemData.mType, msgContent.seq);
                    } else if (this.mListener != null) {
                        if (downItemData != null) {
                            this.mListener.onDownloadResult(true, msgContent.str, bitmap, downItemData.mType, msgContent.seq);
                        } else {
                            this.mListener.onDownloadResult(true, msgContent.str, bitmap, 0, msgContent.seq);
                        }
                    }
                    this.mDownloadResultMap.remove(msgContent.seq);
                }
                this.mIsDownloading = false;
                this.downloadImage();
                break;
            }
            case 5536: {
                break;
            }
        }
        return 0;
    }
}

