/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media.playback;

import android.os.Message;
import android.view.ViewGroup;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.manager.db.DevDataCenter;
import com.manager.device.media.MediaManager;
import com.manager.device.media.attribute.RecordPlayerAttribute;
import com.manager.device.media.playback.RecordManagerInterface;
import com.manager.image.BaseImageManager;
import java.util.TreeMap;

public abstract class RecordManager
extends MediaManager<RecordPlayerAttribute, MediaManager.OnRecordManagerListener>
implements RecordManagerInterface,
IFunSDKResult {
    private DevDataCenter devDataCenter = DevDataCenter.getInstance();
    protected boolean isThumb = false;
    protected boolean isSearching = false;

    public abstract byte[] getRecordTimes(int var1, byte[] var2, String var3, int var4);

    public RecordManager(ViewGroup playView, RecordPlayerAttribute playerAttribute) {
        super(playView, playerAttribute);
    }

    @Override
    public int OnFunSDKResult(Message msg, MsgContent ex) {
        switch (msg.what) {
            case 5102: 
            case 5131: 
            case 6200: 
            case 6203: {
                boolean hasRecords = false;
                if (msg.arg1 < 0) {
                    if (null == this.mediaManagerLs) break;
                    ((MediaManager.OnRecordManagerListener)this.mediaManagerLs).searchResult(this.playerAttribute, null);
                    break;
                }
                byte[] pRet = this.getRecordTimes(msg.arg2, ex.pData, ex.str, 1);
                if (null != pRet) {
                    char[][] datas = new char[144][];
                    int i = 0;
                    int k = 0;
                    while (i < pRet.length) {
                        char[] data = new char[]{(char)pRet[i], (char)pRet[i + 1], (char)pRet[i + 2], (char)pRet[i + 3], (char)pRet[i + 4]};
                        datas[k] = data;
                        i += 5;
                        ++k;
                    }
                    for (i = 0; i < pRet.length; ++i) {
                        int ret = this.showRecordType(i, pRet[i]);
                        if (hasRecords || ret < 0) continue;
                        hasRecords = true;
                    }
                    if (null == this.mediaManagerLs) break;
                    ((MediaManager.OnRecordManagerListener)this.mediaManagerLs).searchResult(this.playerAttribute, (char[][])(hasRecords ? datas : null));
                    break;
                }
                if (null == this.mediaManagerLs) break;
                ((MediaManager.OnRecordManagerListener)this.mediaManagerLs).searchResult(this.playerAttribute, null);
                break;
            }
            case 5501: 
            case 5511: {
                if (msg.arg1 < 0 && ((RecordPlayerAttribute)this.playerAttribute).getPlayHandle() != 0) {
                    this.stopPlay();
                    break;
                }
                if (((RecordPlayerAttribute)this.playerAttribute).getPlayState() != 1) break;
                FunSDK.MediaPause((int)((RecordPlayerAttribute)this.playerAttribute).getPlayHandle(), (int)0, (int)0);
                this.setPlayState(0);
                break;
            }
            case 5509: {
                this.playCompleted();
                break;
            }
            case 5500: {
                if (this.mediaManagerLs == null) break;
                ((MediaManager.OnRecordManagerListener)this.mediaManagerLs).onMediaPlayState(this.playerAttribute, 20);
                break;
            }
        }
        return super.OnFunSDKResult(msg, ex);
    }

    private int showRecordType(int index, byte b) {
        boolean hasRecord;
        int min = index * 2;
        int flag = 0;
        int first_min = 0;
        if (b >> 4 != 0 || (b & 0xF) != 0) {
            ++flag;
        }
        boolean bl = hasRecord = (b & 0xF) != 0;
        if (hasRecord && flag == 1 && first_min == 0) {
            first_min = min;
        }
        this.devDataCenter.setHasRecordFile(min, hasRecord);
        ++min;
        boolean bl2 = hasRecord = b >> 4 != 0;
        if (hasRecord && flag == 1 && first_min == 0) {
            first_min = min;
        }
        this.devDataCenter.setHasRecordFile(min, hasRecord);
        return flag > 0 ? first_min : -1;
    }

    private void playCompleted() {
        if (this.playerAttribute != null && ((RecordPlayerAttribute)this.playerAttribute).getPlayHandle() != 0) {
            FunSDK.MediaStop((int)((RecordPlayerAttribute)this.playerAttribute).getPlayHandle());
            ((RecordPlayerAttribute)this.playerAttribute).setPlayHandle(0);
            ((RecordPlayerAttribute)this.playerAttribute).setRecord(false);
            this.setPlayState(16);
        }
    }

    @Override
    public void stopDevSearchPic() {
        if (this.isThumb) {
            FunSDK.StopDevSearchPic((int)this.userId, (String)this.getDevId(), (int)0);
        }
    }

    @Override
    public void stopSearchFile() {
        this.stopDevSearchPic();
    }

    @Override
    public int setPlaySpeed(int speed) {
        if (this.playerAttribute != null && ((RecordPlayerAttribute)this.playerAttribute).getPlayHandle() != 0 && ((RecordPlayerAttribute)this.playerAttribute).getPlaySpeed() != speed) {
            ((RecordPlayerAttribute)this.playerAttribute).setPlaySpeed(speed);
            FunSDK.MediaSetPlaySpeed((int)((RecordPlayerAttribute)this.playerAttribute).getPlayHandle(), (int)((RecordPlayerAttribute)this.playerAttribute).getPlaySpeed(), (int)0);
        }
        return 0;
    }

    @Override
    public int dealWithRecordEffectiveByMinute(int minute) {
        int forward;
        int playTimeByMinute = -1;
        TreeMap haveRecordMap = DevDataCenter.getInstance().getHasRecordFile();
        if (haveRecordMap == null) {
            return playTimeByMinute;
        }
        if (haveRecordMap.containsKey(minute) && Boolean.TRUE.equals(haveRecordMap.get(minute))) {
            playTimeByMinute = minute;
        }
        int backward = minute - 1;
        boolean findForward = false;
        boolean findBackWard = false;
        for (forward = minute + 1; forward < haveRecordMap.size(); ++forward) {
            if (!Boolean.TRUE.equals(haveRecordMap.get(forward))) continue;
            findForward = true;
            break;
        }
        while (backward >= 0) {
            if (Boolean.TRUE.equals(haveRecordMap.get(forward))) {
                findBackWard = true;
                break;
            }
            --backward;
        }
        if (findBackWard && findForward) {
            int b;
            int f = Math.abs(forward - minute);
            playTimeByMinute = f < (b = Math.abs(backward - minute)) ? forward : backward;
        } else if (findForward) {
            playTimeByMinute = forward;
        } else if (findBackWard) {
            playTimeByMinute = backward;
        }
        return playTimeByMinute;
    }

    public void initVideoThumb(String videoThumbPath, String devId, BaseImageManager.OnImageManagerListener onDevImageListener) {
    }
}

