/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media.encode;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Message;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.lib.sdk.bean.encode.EncodeAudioBean;
import com.lib.sdk.bean.encode.EncodeCameraBean;
import com.lib.sdk.bean.encode.EncodeVideoBean;
import com.manager.device.media.encode.AudioEncodeManager;
import com.manager.device.media.encode.VideoEncodeManagerInterface;
import com.utils.ImageYuvUtils;
import com.utils.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class VideoEncodeManager
implements AudioEncodeManager.OnAudioEncodeListener,
VideoEncodeManagerInterface,
IFunSDKResult {
    public static final int CAMERA_DATA_TYPE_YUV = 0;
    public static final int CAMERA_DATA_TYPE_H264 = 1;
    public static final int SEND_DATA_VIDEO = 1;
    public static final int SEND_DATA_AUDIO = 2;
    private CameraManager cameraManager;
    private CameraCaptureSession captureSession;
    private CaptureRequest.Builder previewRequestBuilder;
    private CameraDevice cameraDevice;
    private ImageReader imageReader;
    private TextureView cameraSurfaceView;
    private Size targetCameraSize = new Size(864, 480);
    private Size cameraSize = new Size(864, 480);
    private int fps = 8;
    private EncodeAudioBean encodeAudioBean;
    private OnVideoEncodeListener onVideoEncodeListener;
    private int userId;
    private String devId;
    private int avTalkHandle;
    private String cameraId;
    private int cameraLensType;
    private int sensorOrientation;
    private AudioEncodeManager audioEncodeManager;
    private Context context;
    private Size[] supportVideoSize;
    private boolean isVerticalScreen;
    private CameraDevice.StateCallback cameraStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(@NonNull CameraDevice camera) {
            VideoEncodeManager.this.cameraDevice = camera;
            VideoEncodeManager.this.initializeImageReader();
            VideoEncodeManager.this.createCameraPreviewSession();
            if (VideoEncodeManager.this.onVideoEncodeListener != null) {
                VideoEncodeManager.this.onVideoEncodeListener.onCameraOpenResult();
            }
        }

        public void onDisconnected(@NonNull CameraDevice camera) {
            camera.close();
            VideoEncodeManager.this.cameraDevice = null;
            if (VideoEncodeManager.this.onVideoEncodeListener != null) {
                VideoEncodeManager.this.onVideoEncodeListener.onCameraCloseResult();
            }
        }

        public void onError(@NonNull CameraDevice camera, int error) {
            camera.close();
            VideoEncodeManager.this.cameraDevice = null;
        }
    };
    private boolean isNeedSendFrame = true;
    private int needSendInterval = 2;
    private long currentReaderFrameNum = 0L;

    public VideoEncodeManager(Context context, OnVideoEncodeListener onVideoEncodeListener, String devId) {
        if (this.cameraManager == null) {
            this.cameraManager = (CameraManager)context.getSystemService("camera");
        }
        this.context = context;
        this.onVideoEncodeListener = onVideoEncodeListener;
        this.devId = devId;
        this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
    }

    private void initCameraId(int cameraLensType) throws CameraAccessException {
        this.cameraLensType = cameraLensType;
        for (String id2 : this.cameraManager.getCameraIdList()) {
            CameraCharacteristics characteristics = this.cameraManager.getCameraCharacteristics(id2);
            if ((Integer)characteristics.get(CameraCharacteristics.LENS_FACING) != cameraLensType) continue;
            this.cameraId = id2;
            this.dealWithCameraOrientation();
            break;
        }
    }

    private void dealWithCameraOrientation() {
        try {
            CameraCharacteristics characteristics = this.cameraManager.getCameraCharacteristics(this.cameraId);
            this.sensorOrientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void initializeImageReader() {
        this.isNeedSendFrame = true;
        this.needSendInterval = 2;
        this.currentReaderFrameNum = 0L;
        this.imageReader = ImageReader.newInstance((int)this.cameraSize.getWidth(), (int)this.cameraSize.getHeight(), (int)35, (int)2);
        this.imageReader.setOnImageAvailableListener(new ImageReader.OnImageAvailableListener(){

            public void onImageAvailable(ImageReader imageReader) {
                try (Image image = imageReader.acquireLatestImage();){
                    if (image != null) {
                        VideoEncodeManager.this.isNeedSendFrame = VideoEncodeManager.this.currentReaderFrameNum % (long)VideoEncodeManager.this.needSendInterval == 0L;
                        if (VideoEncodeManager.this.isNeedSendFrame) {
                            VideoEncodeManager.this.isNeedSendFrame = false;
                            byte[] yuv420P = VideoEncodeManager.this.isVerticalScreen && VideoEncodeManager.this.cameraSize.getWidth() > VideoEncodeManager.this.cameraSize.getHeight() || !VideoEncodeManager.this.isVerticalScreen && VideoEncodeManager.this.cameraSize.getWidth() < VideoEncodeManager.this.cameraSize.getHeight() ? ImageYuvUtils.getBytesFromImageAsType(image, 0, VideoEncodeManager.this.sensorOrientation) : ImageYuvUtils.getBytesFromImageAsType(image, 0, 0);
                            if (VideoEncodeManager.this.avTalkHandle != 0) {
                                long frameTime = System.currentTimeMillis();
                                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                hashMap.put("timestamp", String.valueOf(frameTime));
                                hashMap.put("type", 1);
                                LogUtils.debugInfo("[APP_VIDEO_ENCODE]->", "frameTime:" + frameTime);
                                FunSDK.DevSendAVTalkData((int)VideoEncodeManager.this.avTalkHandle, (String)new Gson().toJson(hashMap), (byte[])yuv420P, (int)yuv420P.length);
                            }
                        }
                        VideoEncodeManager.this.currentReaderFrameNum++;
                        image.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, null);
    }

    private void createCameraPreviewSession() {
        try {
            SurfaceTexture texture;
            ArrayList<Surface> surfaceList = new ArrayList<Surface>();
            Surface imageReaderSurface = this.imageReader.getSurface();
            this.previewRequestBuilder = this.cameraDevice.createCaptureRequest(3);
            this.dealWithVideoFps();
            this.previewRequestBuilder.addTarget(imageReaderSurface);
            surfaceList.add(imageReaderSurface);
            if (this.cameraSurfaceView != null && (texture = this.cameraSurfaceView.getSurfaceTexture()) != null) {
                texture.setDefaultBufferSize(this.cameraSize.getWidth(), this.cameraSize.getHeight());
                Surface surface = new Surface(texture);
                this.previewRequestBuilder.addTarget(surface);
                surfaceList.add(surface);
            }
            this.cameraDevice.createCaptureSession(surfaceList, new CameraCaptureSession.StateCallback(){

                public void onConfigured(@NonNull CameraCaptureSession session) {
                    if (VideoEncodeManager.this.cameraDevice == null) {
                        return;
                    }
                    VideoEncodeManager.this.captureSession = session;
                    try {
                        VideoEncodeManager.this.captureSession.setRepeatingRequest(VideoEncodeManager.this.previewRequestBuilder.build(), null, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession session) {
                }
            }, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean startVideoTalk(@NotNull TextureView textureView, @NotNull EncodeCameraBean encodeCameraBean, int cameraLensType, boolean isVerticalScreen, boolean isAudioCall) {
        try {
            if (textureView == null) {
                LogUtils.debugInfo("[APP_VIDEO_ENCODE]->", "textureView is null");
                return false;
            }
            if (encodeCameraBean == null) {
                LogUtils.debugInfo("[APP_VIDEO_ENCODE]->", "encodeCameraBean is null");
                return false;
            }
            if (this.cameraManager == null) {
                LogUtils.debugInfo("[APP_VIDEO_ENCODE]->", "cameraManager is null");
                return false;
            }
            LogUtils.debugInfo("[APP_VIDEO_ENCODE]->", "[cameraLensType] is " + cameraLensType);
            this.isVerticalScreen = isVerticalScreen;
            this.cameraSurfaceView = textureView;
            if (!isAudioCall) {
                this.initCameraId(cameraLensType);
                this.dealWithVideoSize(encodeCameraBean, isVerticalScreen);
            }
            this.avTalkHandle = FunSDK.DevStartAVTalk((int)this.userId, (String)this.devId, (String)new Gson().toJson((Object)encodeCameraBean), (int)5000, (int)0);
            return true;
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void initCameraSize(int width, int height) {
        this.cameraSize = new Size(width, height);
    }

    private void dealWithVideoSize(EncodeCameraBean encodeCameraBean, boolean isVerticalScreen) throws CameraAccessException {
        CameraCharacteristics characteristics = this.cameraManager.getCameraCharacteristics(this.cameraId);
        StreamConfigurationMap streamMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        this.supportVideoSize = streamMap.getOutputSizes(MediaRecorder.class);
        EncodeVideoBean encodeVideoBean = encodeCameraBean.getVideoinfo();
        if (encodeVideoBean != null) {
            if (encodeVideoBean.getSrcwidth() > 0 && encodeVideoBean.getSrcheight() > 0) {
                this.targetCameraSize = new Size(encodeVideoBean.getSrcwidth(), encodeVideoBean.getSrcheight());
            }
            this.cameraSize = this.findBestResolutionMatch(this.targetCameraSize, this.supportVideoSize);
            if (isVerticalScreen && this.cameraSize.getWidth() > this.cameraSize.getHeight() || !isVerticalScreen && this.cameraSize.getWidth() < this.cameraSize.getHeight()) {
                encodeVideoBean.setSrcwidth(this.cameraSize.getHeight());
                encodeVideoBean.setSrcheight(this.cameraSize.getWidth());
                encodeVideoBean.setDstwidth(this.cameraSize.getHeight());
                encodeVideoBean.setDstheight(this.cameraSize.getWidth());
            } else {
                encodeVideoBean.setSrcwidth(this.cameraSize.getWidth());
                encodeVideoBean.setSrcheight(this.cameraSize.getHeight());
                encodeVideoBean.setDstwidth(this.cameraSize.getWidth());
                encodeVideoBean.setDstheight(this.cameraSize.getHeight());
            }
            if (encodeVideoBean.getFps() > 0) {
                this.fps = encodeVideoBean.getFps();
            }
            this.encodeAudioBean = encodeCameraBean.getAudioinfo();
        }
    }

    private Size[] findCameraAllSupportVideoSize() throws CameraAccessException {
        String frontCameraId = this.getCameraId(0);
        String backCameraId = this.getCameraId(1);
        CameraCharacteristics characteristicsFront = this.cameraManager.getCameraCharacteristics(frontCameraId);
        StreamConfigurationMap streamMapFront = (StreamConfigurationMap)characteristicsFront.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Size[] frontSupportSize = streamMapFront.getOutputSizes(MediaRecorder.class);
        CameraCharacteristics characteristicsBack = this.cameraManager.getCameraCharacteristics(backCameraId);
        StreamConfigurationMap streamMapBack = (StreamConfigurationMap)characteristicsBack.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Size[] backSupportSize = streamMapBack.getOutputSizes(MediaRecorder.class);
        HashSet<Size> backSet = new HashSet<Size>(Arrays.asList(backSupportSize));
        HashSet<Size> frontSet = new HashSet<Size>(Arrays.asList(frontSupportSize));
        frontSet.retainAll(backSet);
        int index = 0;
        Size[] allSupportSize = new Size[frontSet.size()];
        for (Size size : frontSet) {
            allSupportSize[index++] = size;
        }
        return allSupportSize;
    }

    private String getCameraId(int cameraLensType) throws CameraAccessException {
        for (String id2 : this.cameraManager.getCameraIdList()) {
            CameraCharacteristics characteristics = this.cameraManager.getCameraCharacteristics(id2);
            if ((Integer)characteristics.get(CameraCharacteristics.LENS_FACING) != cameraLensType) continue;
            return id2;
        }
        return null;
    }

    private boolean dealWithVideoFps() throws CameraAccessException {
        if (this.previewRequestBuilder == null) {
            return false;
        }
        CameraCharacteristics characteristics = this.cameraManager.getCameraCharacteristics(this.cameraId);
        Range[] ranges = (Range[])characteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        Range maxStaticRange = null;
        String manufacturer = Build.MANUFACTURER.toLowerCase(Locale.ENGLISH);
        if (manufacturer.contains("sony") || manufacturer.contains("xperia")) {
            LogUtils.debugInfo("[VideoEncodeFPSRange]", "current mobile model is Sony phone!");
            for (int i = ranges.length - 1; i >= 0; --i) {
                if (((Integer)ranges[i].getLower()).intValue() != ((Integer)ranges[i].getUpper()).intValue()) continue;
                maxStaticRange = ranges[i];
                this.needSendInterval = (int)Math.ceil((double)((Integer)ranges[i].getUpper()).intValue() / ((double)this.fps * 1.0));
                LogUtils.debugInfo("[VideoEncodeFPSRange]", "current find maxStaticRange,  range lower:" + ranges[i].getLower() + "  range upper : " + ranges[i].getUpper());
                break;
            }
        }
        if (maxStaticRange != null) {
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, maxStaticRange);
        } else {
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)new Range((Comparable)Integer.valueOf(this.fps * this.needSendInterval), (Comparable)Integer.valueOf(this.fps * this.needSendInterval)));
        }
        LogUtils.debugInfo("[VideoEncodeFPSRange]", "needSendInterval :[" + this.needSendInterval + "]");
        return true;
    }

    private void initAudioEncode() {
        if (this.audioEncodeManager == null) {
            this.audioEncodeManager = new AudioEncodeManager(this.context);
            if (this.encodeAudioBean != null) {
                int audioFormat = this.encodeAudioBean.getBit() == 8 ? 3 : 2;
                this.audioEncodeManager.initAudio(this.encodeAudioBean.getSampleRate(), audioFormat, 2);
            }
            this.audioEncodeManager.setOnAudioEncodeListener(this);
        }
    }

    @Override
    public void changeCameraLensType(int cameraLensType) {
        this.closeCamera();
        try {
            this.initCameraId(cameraLensType);
            CameraCharacteristics characteristics = this.cameraManager.getCameraCharacteristics(this.cameraId);
            StreamConfigurationMap streamMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            this.supportVideoSize = streamMap.getOutputSizes(MediaRecorder.class);
            this.cameraSize = this.findBestResolutionMatch(this.targetCameraSize, this.supportVideoSize);
            if (this.isVerticalScreen && this.cameraSize.getWidth() > this.cameraSize.getHeight() || !this.isVerticalScreen && this.cameraSize.getWidth() < this.cameraSize.getHeight()) {
                this.controlDevAvTalk(this.createControlCommand("switching_resolution", this.cameraSize.getHeight(), this.cameraSize.getWidth()), 0);
            } else {
                this.controlDevAvTalk(this.createControlCommand("switching_resolution", this.cameraSize.getWidth(), this.cameraSize.getHeight()), 0);
            }
            if (this.cameraId != null) {
                this.openCamera();
            }
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String createControlCommand(String command) {
        return this.createControlCommand(command, -1, -1);
    }

    private String createControlCommand(String command, int width, int height) {
        JSONObject avControlCmd = new JSONObject();
        avControlCmd.put("command", (Object)command);
        if (width > 0 && height > 0) {
            JSONObject info = new JSONObject();
            info.put("srcwidth", (Object)width);
            info.put("srcheight", (Object)height);
            info.put("dstwidth", (Object)width);
            info.put("dstheight", (Object)height);
            avControlCmd.put("info", (Object)info);
        }
        return avControlCmd.toJSONString();
    }

    @Override
    public void openCamera() {
        try {
            if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.CAMERA") == 0) {
                this.cameraManager.openCamera(this.cameraId, this.cameraStateCallback, null);
            }
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void controlDevAvTalk(String controlAvTalkCmd, int tryNo) {
        if (this.avTalkHandle != 0) {
            FunSDK.DevControlAVTalk((int)this.avTalkHandle, (String)controlAvTalkCmd, (int)tryNo);
        }
    }

    @Override
    public void closeCamera() {
        if (this.imageReader != null) {
            this.imageReader.close();
            this.imageReader = null;
        }
        if (this.cameraDevice != null) {
            this.cameraDevice.close();
            this.cameraDevice = null;
        }
        this.previewRequestBuilder = null;
    }

    @Override
    public void stopVideoTalk() {
        this.closeCamera();
        this.stopAudioRecord();
        if (this.avTalkHandle != 0) {
            FunSDK.DevStopAVTalkData((int)this.avTalkHandle);
            this.avTalkHandle = 0;
        }
    }

    @Override
    public Size[] getSupportVideoSizeList(int cameraLensType) {
        try {
            this.initCameraId(cameraLensType);
            CameraCharacteristics characteristics = this.cameraManager.getCameraCharacteristics(this.cameraId);
            StreamConfigurationMap streamMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            this.supportVideoSize = streamMap.getOutputSizes(MediaRecorder.class);
            return this.supportVideoSize;
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
            return new Size[0];
        }
    }

    @Override
    public boolean isCameraRecording() {
        return this.avTalkHandle != 0;
    }

    @Override
    public void release() {
        if (this.userId != 0) {
            FunSDK.UnRegUser((int)this.userId);
            this.userId = 0;
        }
        this.stopVideoTalk();
        if (this.audioEncodeManager != null) {
            this.audioEncodeManager.release();
        }
        this.cameraManager = null;
        this.context = null;
        this.onVideoEncodeListener = null;
    }

    private Size findBestResolutionMatch(Size currentResolution, Size[] supportedResolutions) {
        Size bestMatch = null;
        double bestMatchScore = Double.MAX_VALUE;
        double bestAbsRange = Double.MAX_VALUE;
        ArrayList<Size> filterResolutions = new ArrayList<Size>();
        double targetAspectRatio = (double)currentResolution.getWidth() / (double)currentResolution.getHeight();
        double targetInvertAspectRatio = (double)currentResolution.getHeight() / (double)currentResolution.getWidth();
        long curVideoSize = (long)currentResolution.getWidth() * (long)currentResolution.getHeight();
        Size lastCurVideoSize = currentResolution;
        for (Size supportedResolution : supportedResolutions) {
            if ((long)supportedResolution.getWidth() * (long)supportedResolution.getHeight() > curVideoSize) continue;
            if (supportedResolution.getWidth() == currentResolution.getWidth() && supportedResolution.getHeight() == currentResolution.getHeight() || supportedResolution.getWidth() == currentResolution.getHeight() && supportedResolution.getHeight() == currentResolution.getWidth()) {
                return supportedResolution;
            }
            double aspectRatio = (double)supportedResolution.getWidth() / (double)supportedResolution.getHeight();
            if (targetAspectRatio * 0.6 <= aspectRatio && aspectRatio <= 1.15 * targetAspectRatio || targetInvertAspectRatio * 0.6 <= aspectRatio && aspectRatio <= 1.15 * targetInvertAspectRatio) {
                filterResolutions.add(supportedResolution);
            }
            lastCurVideoSize = supportedResolution;
        }
        if (!filterResolutions.isEmpty()) {
            for (Size supportedResolution : filterResolutions) {
                double score;
                double currentAspectRatio = (double)supportedResolution.getWidth() / (double)supportedResolution.getHeight();
                double widthHeightAbsRange = Math.abs(supportedResolution.getHeight() - currentResolution.getHeight() + supportedResolution.getWidth() - currentResolution.getWidth());
                if (targetAspectRatio >= targetInvertAspectRatio) {
                    score = currentAspectRatio > 1.0 ? Math.abs(targetAspectRatio - currentAspectRatio) : Math.abs(targetInvertAspectRatio - currentAspectRatio);
                } else {
                    double d = score = currentAspectRatio > 1.0 ? Math.abs(targetInvertAspectRatio - currentAspectRatio) : Math.abs(targetAspectRatio - currentAspectRatio);
                }
                if (widthHeightAbsRange < bestAbsRange) {
                    bestMatchScore = score;
                    bestAbsRange = widthHeightAbsRange;
                    bestMatch = supportedResolution;
                    LogUtils.debugInfo("[APP_VIDEO_ENCODE]->", "w:" + supportedResolution.getWidth() + " h:" + supportedResolution.getHeight());
                    continue;
                }
                if (widthHeightAbsRange != bestAbsRange || !(score < bestMatchScore)) continue;
                bestMatchScore = score;
                bestMatch = supportedResolution;
                LogUtils.debugInfo("[APP_VIDEO_ENCODE]->", "w:" + supportedResolution.getWidth() + " h:" + supportedResolution.getHeight());
            }
        } else {
            bestMatch = lastCurVideoSize;
        }
        return bestMatch;
    }

    /*
     * Unable to fully structure code
     */
    public int OnFunSDKResult(Message message, MsgContent msgContent) {
        switch (message.what) {
            case 5556: {
                if (message.arg1 < 0) ** GOTO lbl15
                try {
                    if (this.cameraId == null) ** GOTO lbl16
                    if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.CAMERA") != 0) ** GOTO lbl10
                    this.cameraManager.openCamera(this.cameraId, this.cameraStateCallback, null);
                    LogUtils.debugInfo("[APP_VIDEO_ENCODE]->", "\u6253\u5f00\u6444\u50cf\u5934");
                    ** GOTO lbl16
lbl10:
                    // 1 sources

                    LogUtils.debugInfo("[APP_VIDEO_ENCODE]->", "\u6253\u5f00\u6444\u50cf\u5934\u5931\u8d25\uff0c\u6ca1\u6709\u6743\u9650");
                }
                catch (CameraAccessException e) {
                    e.printStackTrace();
                }
                ** GOTO lbl16
lbl15:
                // 1 sources

                LogUtils.debugInfo("[APP_VIDEO_ENCODE]->", "\u89c6\u9891\u5bf9\u8bb2\u521d\u59cb\u5316\u5931\u8d25:" + message.arg1);
lbl16:
                // 5 sources

                if (this.onVideoEncodeListener == null) break;
                if (this.isVerticalScreen && this.cameraSize.getWidth() > this.cameraSize.getHeight() || !this.isVerticalScreen && this.cameraSize.getWidth() < this.cameraSize.getHeight()) {
                    this.onVideoEncodeListener.onStartCameraResult(message.arg1 >= 0, this.cameraSize.getHeight(), this.cameraSize.getWidth(), this.fps);
                    break;
                }
                this.onVideoEncodeListener.onStartCameraResult(message.arg1 >= 0, this.cameraSize.getWidth(), this.cameraSize.getHeight(), this.fps);
                break;
            }
            case 5557: {
                break;
            }
            case 5558: {
                LogUtils.debugInfo("[APP_VIDEO_ENCODE]->", "\u505c\u6b62\u89c6\u9891\u5bf9\u8bb2:" + message.arg1);
                if (this.onVideoEncodeListener == null) break;
                this.onVideoEncodeListener.onStopCameraResult(message.arg1 >= 0);
                break;
            }
            case 5103: 
            case 5114: 
            case 5513: {
                this.stopVideoTalk();
                LogUtils.debugInfo("[APP_VIDEO_ENCODE]->", "\u4e3b\u94fe\u63a5/\u5a92\u4f53\u94fe\u63a5\u5df2\u7ecf\u65ad\u5f00");
                if (this.onVideoEncodeListener == null) break;
                this.onVideoEncodeListener.onStopCameraResult(true);
                break;
            }
            case 5559: {
                if (message.arg1 < 0 && msgContent.seq < 2) {
                    this.controlDevAvTalk(msgContent.str, msgContent.seq + 1);
                }
                LogUtils.debugInfo("[APP_VIDEO_ENCODE]->", "DEV_CONTROL_AV_TALK CODE: [" + message.arg1 + "]");
                break;
            }
        }
        if (this.onVideoEncodeListener != null) {
            this.onVideoEncodeListener.OnFunSDKResult(message, msgContent);
        }
        return 0;
    }

    @Override
    public void onAudioDataResult(byte[] data, int dataLen) {
        if (this.avTalkHandle != 0) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
            hashMap.put("type", 2);
            FunSDK.DevSendAVTalkData((int)this.avTalkHandle, (String)new Gson().toJson(hashMap), (byte[])data, (int)dataLen);
        }
    }

    @Override
    public void startAudioRecord() {
        if (this.audioEncodeManager == null) {
            this.initAudioEncode();
        }
        this.audioEncodeManager.startAudioRecord();
    }

    @Override
    public void stopAudioRecord() {
        if (this.audioEncodeManager != null) {
            this.audioEncodeManager.stopAudioRecord();
        }
    }

    @Override
    public AudioEncodeManager getAudioEncodeManager() {
        return this.audioEncodeManager;
    }

    public static interface OnVideoEncodeListener
    extends IFunSDKResult {
        public void onCameraDataResult(byte[] var1, int var2, int var3);

        public void onStartCameraResult(boolean var1, int var2, int var3, int var4);

        public void onStopCameraResult(boolean var1);

        default public void onCameraOpenResult() {
        }

        default public void onCameraCloseResult() {
        }
    }
}

