/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media.download;

import android.os.Message;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.manager.base.BaseManager;
import com.manager.db.DownloadInfo;
import com.manager.device.media.download.DownloadInterface;
import java.util.Calendar;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;

public class DownloadManager
extends BaseManager
implements IFunSDKResult,
DownloadInterface {
    public static final int DOWNLOAD_STATE_UNINT = 0;
    public static final int DOWNLOAD_STATE_START = 1;
    public static final int DOWNLOAD_STATE_PROGRESS = 2;
    public static final int DOWNLOAD_STATE_COMPLETE = 3;
    public static final int DOWNLOAD_STATE_STOP = 4;
    public static final int DOWNLOAD_STATE_FAILED = 5;
    public static final int DOWNLOAD_STATE_COMPLETE_ALL = 6;
    private int userId;
    private Queue<DownloadInfo> downloadInfos;
    private DownloadInfo curDownloadInfo;
    private OnDownloadListener listener;
    private boolean isDownloading;
    private int downloadHandle;

    private DownloadManager(OnDownloadListener listener) {
        this.listener = listener;
        this.init();
    }

    public static DownloadManager getInstance(OnDownloadListener listener) {
        return new DownloadManager(listener);
    }

    @Override
    public boolean init() {
        this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
        if (this.downloadInfos == null) {
            this.downloadInfos = new LinkedBlockingDeque<DownloadInfo>();
        }
        return true;
    }

    @Override
    public void unInit() {
        if (this.userId != 0) {
            FunSDK.UnRegUser((int)this.userId);
            this.userId = 0;
        }
    }

    private boolean downloadByFile(DownloadInfo info) {
        if (info != null) {
            this.downloadHandle = FunSDK.DevDowonLoadByFile((int)this.userId, (String)info.getDevId(), (byte[])G.ObjToBytes((Object)info.getObj()), (String)info.getSaveFileName(), (int)info.getSeq());
            if (this.downloadHandle != 0) {
                this.curDownloadInfo = info;
                this.isDownloading = true;
                return true;
            }
        }
        return false;
    }

    private boolean downloadByTime(DownloadInfo info) {
        if (info != null) {
            this.downloadHandle = FunSDK.DevDowonLoadByTime((int)this.userId, (String)info.getDevId(), (byte[])G.ObjToBytes((Object)info.getObj()), (String)info.getSaveFileName(), (int)info.getSeq());
            if (this.downloadHandle != 0) {
                this.curDownloadInfo = info;
                this.isDownloading = true;
                return true;
            }
        }
        return false;
    }

    private boolean downloadByCloud(DownloadInfo info) {
        if (info != null) {
            Calendar startTime = info.getStartTime();
            Calendar endTime = info.getEndTime();
            int sTime = FunSDK.ToTimeType((int[])new int[]{startTime.get(1), startTime.get(2) + 1, startTime.get(5), startTime.get(11), startTime.get(12), startTime.get(13)});
            int eTime = FunSDK.ToTimeType((int[])new int[]{endTime.get(1), endTime.get(2) + 1, endTime.get(5), endTime.get(11), endTime.get(12), endTime.get(13)});
            this.downloadHandle = FunSDK.MediaCloudRecordDownload((int)this.userId, (String)info.getDevId(), (int)info.getChnId(), (String)(info.getStreamType() == 0 ? "Main" : "Sub"), (int)sTime, (int)eTime, (String)info.getSaveFileName(), (int)info.getSeq());
            if (this.downloadHandle != 0) {
                this.curDownloadInfo = info;
                this.isDownloading = true;
                return true;
            }
        }
        return false;
    }

    public int OnFunSDKResult(Message msg, MsgContent ex) {
        if (msg.arg1 < 0) {
            this.curDownloadInfo.setDownloadState(5);
            this.isDownloading = false;
            this.download();
            this.updateDownloadState();
            return 0;
        }
        switch (msg.what) {
            case 5116: {
                this.curDownloadInfo.setDownloadState(1);
                break;
            }
            case 5118: {
                if (msg.arg1 <= 0) break;
                int progress = (int)((float)msg.arg2 / (float)msg.arg1 * 100.0f);
                this.curDownloadInfo.setDownloadProgress(progress);
                this.curDownloadInfo.setDownloadState(2);
                break;
            }
            case 5117: {
                if (msg.arg1 == 0) {
                    this.curDownloadInfo.setDownloadState(5);
                    this.isDownloading = false;
                    this.download();
                    break;
                }
                this.curDownloadInfo.setDownloadState(3);
                this.isDownloading = false;
                this.download();
                break;
            }
            case 5530: {
                this.curDownloadInfo.setDownloadState(4);
                break;
            }
        }
        this.updateDownloadState();
        return 0;
    }

    private void updateDownloadState() {
        if (this.listener != null) {
            this.listener.onDownload(this.curDownloadInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDownload(DownloadInfo info) {
        Queue<DownloadInfo> queue = this.downloadInfos;
        synchronized (queue) {
            if (info != null) {
                this.downloadInfos.offer(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDownload() {
        Queue<DownloadInfo> queue = this.downloadInfos;
        synchronized (queue) {
            if (!this.isDownloading) {
                this.download();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean download() {
        Queue<DownloadInfo> queue = this.downloadInfos;
        synchronized (queue) {
            if (this.downloadInfos.isEmpty()) {
                if (this.curDownloadInfo != null) {
                    this.curDownloadInfo.setDownloadState(6);
                }
                return false;
            }
            DownloadInfo info = this.downloadInfos.poll();
            if (info != null) {
                switch (info.getDownloadType()) {
                    case 0: {
                        return this.downloadByFile(info);
                    }
                    case 1: {
                        return this.downloadByCloud(info);
                    }
                    case 2: {
                        return this.downloadByTime(info);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void stopDownload() {
        if (this.isDownloading) {
            FunSDK.DevStopDownLoad((int)this.downloadHandle);
            this.isDownloading = false;
        }
    }

    public static interface OnDownloadListener {
        public void onDownload(DownloadInfo var1);
    }
}

