/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.lib.sdk.bean.HandleConfigData;
import com.lib.sdk.bean.OPTalkBean;
import com.lib.sdk.struct.SDevTalkParams;
import com.manager.device.media.audio.OnAudioDecibelListener;
import com.manager.device.media.audio.XMAudioManager;
import com.utils.LogUtils;

public class TalkManager
extends XMAudioManager {
    private static final String TAG = "TalkManager";
    public static final int DELAY_SEND = 106;
    public static final int OPEN_UPLOAD_VOICE_DATA = 1;
    public static final int CLOSE_UPLOAD_VOICE_DATA = -1;
    public int hTalkHandle = 0;
    private boolean isTalkInitSuccess;
    private int mMsgId = 0xFF00FF;
    private OnTalkListener mTalkBtnLs;
    private Handler mHandler;
    private boolean isIPCTalk;

    public TalkManager(Context context, String devId, OnTalkListener listener) {
        super(false);
        this.mContext = context;
        this.mDevId = devId;
        this.mTalkBtnLs = listener;
        this.mMsgId = FunSDK.GetId((int)this.mMsgId, (IFunSDKResult)this);
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 106: {
                        TalkManager.this.deviceStopUploadData();
                        break;
                    }
                }
            }
        };
    }

    public void setChnId(int chnId) {
        this.chnId = chnId;
    }

    @Override
    public int OnFunSDKResult(Message msg, MsgContent ex) {
        LogUtils.debugInfo("[APP_TALK]->", "arg1:  " + String.valueOf(msg.arg1) + "    ex.str   :" + ex.str);
        switch (msg.what) {
            case 5111: {
                LogUtils.debugInfo("[APP_TALK]->", "DEV_START_TALK arg1:  " + String.valueOf(msg.arg1));
                if (msg.arg1 < 0) {
                    this.canSendTalkDataToDevice = false;
                    this.stopTalkThread();
                    this.hTalkHandle = 0;
                    this.isTalkInitSuccess = false;
                    if (this.mTalkBtnLs != null) {
                        this.mTalkBtnLs.onStartTalkResult(msg.arg1);
                    }
                    return 0;
                }
                this.isTalkInitSuccess = true;
                this.canSendTalkDataToDevice = true;
                if (this.mTalkBackMode == 2) {
                    FunSDK.MediaSetSound((int)this.hTalkHandle, (int)100, (int)0);
                    if (this.mTalkBtnLs != null) {
                        this.mTalkBtnLs.onVoiceOperateResult(1, -1);
                    }
                } else if (this.mTalkBackMode == 1) {
                    this.deviceStopUploadData();
                }
                if (this.mTalkBtnLs != null) {
                    this.mTalkBtnLs.onStartTalkResult(msg.arg1);
                }
                FunSDK.SetFunIntAttr((int)6, (int)this.mMsgId);
                break;
            }
            case 5113: {
                this.mTalkBtnLs.onStopTalkResult(msg.arg1);
                if (msg.arg1 >= 0) {
                    LogUtils.debugInfo("[APP_TALK]->", "Intercom closed successfully");
                    break;
                }
                LogUtils.debugInfo("[APP_TALK]->", "Intercom closed failed:" + msg.arg1);
                break;
            }
            case 5131: {
                if (msg.arg1 >= 0) {
                    if (ex.seq != 256) break;
                    LogUtils.debugInfo("[APP_TALK]->", "Device voice data is opened and uploaded successfully");
                    this.mTalkBtnLs.onVoiceOperateResult(1, msg.arg1);
                    FunSDK.MediaSetSound((int)this.hTalkHandle, (int)100, (int)0);
                    break;
                }
                if (ex.seq != 256) break;
                LogUtils.debugInfo("[APP_TALK]->", "Device voice data failed to open and upload");
                this.mTalkBtnLs.onVoiceOperateResult(1, msg.arg1);
                FunSDK.MediaSetSound((int)this.hTalkHandle, (int)100, (int)0);
                break;
            }
            case 5103: 
            case 5114: 
            case 5513: {
                this.canSendTalkDataToDevice = false;
                this.stopTalkThread();
                this.sendStopTalkCommand();
                this.mTalkBtnLs.onTalkDisconnect();
                break;
            }
        }
        return super.OnFunSDKResult(msg, ex);
    }

    public void startTalkByHalfDuplex() {
        this.mTalkBackMode = 1;
        this.createTalkHandle();
        this.createThreadAndStart();
        FunSDK.MediaSetSound((int)this.hTalkHandle, (int)0, (int)0);
        if (this.canSendTalkDataToDevice) {
            this.deviceStopUploadData();
        }
    }

    public void stopTalkByHalfDuplex() {
        this.canSendTalkDataToDevice = false;
        this.stopTalkThread();
        this.makeDeviceUploadData();
        if (this.hTalkHandle != 0) {
            FunSDK.MediaSetSound((int)this.hTalkHandle, (int)100, (int)0);
        }
    }

    public void stopTalkByDoubleDirection() {
        this.canSendTalkDataToDevice = false;
        this.stopTalkThread();
        this.sendStopTalkCommand();
    }

    @Deprecated
    public void startTalkByDoubleDirection(boolean uploadTalk) {
        this.mTalkBackMode = 2;
        this.createTalkHandle();
        this.createThreadAndStart(uploadTalk);
    }

    public void startTalkByDoubleDirection() {
        this.mTalkBackMode = 2;
        this.createTalkHandle();
        this.createThreadAndStart();
    }

    public void doubleDirectionSound(int voice) {
        if (this.hTalkHandle != 0) {
            FunSDK.MediaSetSound((int)this.hTalkHandle, (int)voice, (int)0);
        }
    }

    public void uploadTalk(boolean uploadTalk) {
        this.setUploadTalk(uploadTalk);
    }

    private void createTalkHandle() {
        if (this.hTalkHandle == 0) {
            SDevTalkParams sDevTalkParams = new SDevTalkParams();
            sDevTalkParams.st_3_nSampleRate = this.sampleRate;
            sDevTalkParams.st_1_nDevChannel = this.chnId;
            sDevTalkParams.st_0_nSupIpcTalk = this.isIPCTalk ? 1 : 0;
            this.hTalkHandle = FunSDK.DevStartTalk((int)this.mMsgId, (String)this.mDevId, (byte[])G.ObjToBytes((Object)sDevTalkParams), (int)0);
            LogUtils.debugInfo("[APP_TALK]->", "Create hTalkHandle");
        } else {
            LogUtils.debugInfo("[APP_TALK]->", "hTalkHandle Created");
            this.canSendTalkDataToDevice = true;
        }
    }

    private void makeDeviceUploadData() {
        if (this.hTalkHandle != 0 && this.isTalkInitSuccess) {
            OPTalkBean mOPTalk = new OPTalkBean();
            mOPTalk.Action = "ResumeUpload";
            FunSDK.DevCmdGeneral((int)this.mMsgId, (String)this.mDevId, (int)1430, (String)"OPTalk", (int)-1, (int)0, (byte[])HandleConfigData.getSendData("OPTalk", "0x1", mOPTalk).getBytes(), (int)-1, (int)256);
            LogUtils.debugInfo("[APP_TALK]->", "ResumeUpload");
        }
    }

    private void deviceStopUploadData() {
        if (this.hTalkHandle != 0 && this.isTalkInitSuccess) {
            OPTalkBean mOPTalk = new OPTalkBean();
            mOPTalk.Action = "PauseUpload";
            FunSDK.DevCmdGeneral((int)this.mMsgId, (String)this.mDevId, (int)1430, (String)"OPTalk", (int)-1, (int)0, (byte[])HandleConfigData.getSendData("OPTalk", "0x1", mOPTalk).getBytes(), (int)-1, (int)4097);
            LogUtils.debugInfo("[APP_TALK]->", "PauseUpload");
        }
    }

    public void sendStopTalkCommand() {
        if (this.hTalkHandle != 0) {
            LogUtils.debugInfo("[APP_TALK]->", "sendStopTalkCommand");
            FunSDK.DevStopTalk((int)this.hTalkHandle);
            FunSDK.MediaSetSound((int)this.hTalkHandle, (int)0, (int)0);
            FunSDK.SetFunIntAttr((int)6, (int)-1);
            this.hTalkHandle = 0;
            this.isTalkInitSuccess = false;
            this.canSendTalkDataToDevice = false;
        }
    }

    public boolean isTalking() {
        return this.hTalkHandle != 0;
    }

    public boolean isTalkInit() {
        return this.isTalkInitSuccess;
    }

    @Override
    public void sendAudioToDev(byte[] audioData, int dataLen) {
        if (this.canSendTalkDataToDevice && this.isTalking()) {
            FunSDK.DevSendTalkData((String)this.mDevId, (byte[])audioData, (int)dataLen);
        }
    }

    @Override
    public void setAudioDecibelListener(OnAudioDecibelListener listener) {
        this.mAudioDecibelLs = listener;
    }

    public boolean isIPCTalk() {
        return this.isIPCTalk;
    }

    public void setIPCTalk(boolean IPCTalk) {
        this.isIPCTalk = IPCTalk;
    }

    public static interface OnTalkListener {
        public void onStartTalkResult(int var1);

        public void onStopTalkResult(int var1);

        public void onVoiceOperateResult(int var1, int var2);

        public void onTalkDisconnect();
    }
}

