/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.idr;

import android.app.Activity;
import android.app.BackgroundServiceStartNotAllowedException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Message;
import android.text.TextUtils;
import com.lib.FunSDK;
import com.lib.MsgContent;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.bean.idr.SDStorage;
import com.manager.db.DevDataCenter;
import com.manager.device.idr.BatteryStorageResult;
import com.manager.device.idr.IDRDevBatteryManager;
import com.manager.device.idr.IDRManagerCallBack;
import com.manager.device.idr.IDRSleepService;
import com.manager.device.idr.IDRStateResult;
import com.manager.device.idr.IDRWake;
import com.manager.device.idr.IdrDefine;
import com.utils.LogUtils;
import com.xm.ui.widget.idr.IDRWakeWaitView;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public final class IDRManager {
    public static final String IS_ACTIVITY_DESTROY_SLEEP_DEV = "is_activity_destroy_sleep_dev";
    private static final int WAKE_UP_COUNT = 2;
    private IDRWake mIDRWake;
    private boolean mIsExecuteIDRFlow = false;
    private boolean mIsIDR = false;
    private String mSN;
    private boolean mResumed = false;
    private IDRIDRManagerCallBack mIDRCallBack;
    private int mUpNum = 0;
    private Disposable mDisposable;
    private WeakReference<Context> mContextWakeReference;
    private boolean mIsRegisterReceiver = false;
    private boolean mIsHomeSendSleep = true;
    private IDRDevBatteryManager mDevBatteryManager;
    private IDRWakeWaitView mIDRWakeWaitView;
    private IDRPowerListener mIDRPowerListener;
    private SDStorage mSDStorage;
    private IDRManagerCallBack mStorageSizeIDRManagerCallBack;
    private BroadcastReceiver mHomeClickReceiver = new BroadcastReceiver(){
        static final String SYSTEM_DIALOG_REASON_KEY = "reason";
        static final String SYSTEM_DIALOG_REASON_HOME_KEY = "homekey";
        static final String SYSTEM_DIALOG_REASON_RECENTAPPS = "recentapps";

        public void onReceive(Context context, Intent intent) {
            if (IDRManager.this.mIDRWake != null && IDRManager.this.mIDRWake.getState() == 10004) {
                LogUtils.debugInfo("[APP_IDR]->", "IDR Already Sleep->" + IDRManager.this.mSN);
                return;
            }
            LogUtils.debugInfo("[APP_IDR]->", "receive home " + IDRManager.this.mResumed);
            String action = intent.getAction();
            LogUtils.debugInfo("[APP_IDR]->", "receive home1  " + action);
            switch (action) {
                case "android.intent.action.CLOSE_SYSTEM_DIALOGS": {
                    String reason = intent.getStringExtra(SYSTEM_DIALOG_REASON_KEY);
                    LogUtils.debugInfo("[APP_IDR]->", "receive home2  " + reason);
                    if (SYSTEM_DIALOG_REASON_RECENTAPPS.equals(reason)) break;
                    if (!SYSTEM_DIALOG_REASON_HOME_KEY.equals(reason) && FunSDK.IsActive()) {
                        return;
                    }
                    if (IDRManager.this.mResumed) break;
                    return;
                }
                case "android.intent.action.SCREEN_OFF": {
                    break;
                }
                default: {
                    return;
                }
            }
            LogUtils.debugInfo("[APP_IDR]->", "handle addToSleepQueue");
            if (IDRManager.this.mContextWakeReference.get() != null && IDRManager.this.mIsHomeSendSleep) {
                if (Build.VERSION.SDK_INT >= 31) {
                    try {
                        IDRManager.this.addToSleepQueue();
                    }
                    catch (BackgroundServiceStartNotAllowedException e) {
                        LogUtils.debugInfo("[APP_IDR]->", "app is backGround and not allowed start forgeGroundService");
                    }
                } else {
                    IDRManager.this.addToSleepQueue();
                }
            }
        }
    };

    public IDRManager(Context context, String sn) {
        this(context, sn, true);
    }

    public IDRManager(Context context, String sn, boolean isRegisterHome) {
        WifiInfo info;
        if (context == null || StringUtils.isStringNULL(sn)) {
            return;
        }
        if (!DevDataCenter.getInstance().isLowPowerDev(sn)) {
            return;
        }
        this.mSN = sn;
        this.mIsIDR = true;
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        if (wifiManager != null && (info = wifiManager.getConnectionInfo()) != null && info.getSSID().toLowerCase().replace("\"", "").startsWith("xmjp_idr_")) {
            return;
        }
        IdrDefine.addToPlayDevices(this.mSN);
        this.mIsExecuteIDRFlow = true;
        this.mContextWakeReference = new WeakReference<Context>(context);
        this.mIDRCallBack = new IDRIDRManagerCallBack();
        this.removeFromSleepQueue();
        if (isRegisterHome) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.CLOSE_SYSTEM_DIALOGS");
            filter.addAction("android.intent.action.SCREEN_OFF");
            if (Build.VERSION.SDK_INT >= 33) {
                context.registerReceiver(this.mHomeClickReceiver, filter, 2);
            } else {
                context.registerReceiver(this.mHomeClickReceiver, filter);
            }
            this.mIsRegisterReceiver = true;
        }
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void receiverSleepMsg(IDRStateResult result) {
        try {
            if (!result.getSN().equals(this.mSN)) {
                return;
            }
            if (this.mIDRWake != null) {
                this.mIDRWake.setState(result.getState());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void removeFromSleepQueue(Context context, String sn) {
        if (TextUtils.isEmpty((CharSequence)sn)) {
            return;
        }
        IDRSleepService.start(context, sn, 501);
    }

    public static void addToSleepQueue(Context context, String sn) {
        if (TextUtils.isEmpty((CharSequence)sn)) {
            return;
        }
        IDRSleepService.start(context, sn, 500);
    }

    public static void sleepNow(Context context, String sn) {
        if (TextUtils.isEmpty((CharSequence)sn)) {
            return;
        }
        IDRSleepService.start(context, sn, 502);
    }

    public static boolean isWake(String sn) {
        if (TextUtils.isEmpty((CharSequence)sn)) {
            return false;
        }
        int state = FunSDK.GetDevState((String)sn, (int)8);
        return state == 1;
    }

    public static final boolean isUnWakeUp(String sn) {
        if (TextUtils.isEmpty((CharSequence)sn)) {
            return false;
        }
        int state = FunSDK.GetDevState((String)sn, (int)8);
        LogUtils.debugInfo("[APP_IDR]->", sn + "\u662f\u5426\u53ef\u5524\u9192\u72b6\u6001" + state);
        return state == 3;
    }

    public void initWakeUp() {
        if (this.mIDRWake == null) {
            this.mIDRWake = new IDRWake(this.mSN);
        }
        this.mIDRWake.setState(10001);
    }

    public void setHomeSendSleep(boolean homeSendSleep) {
        this.mIsHomeSendSleep = homeSendSleep;
    }

    public String getSN() {
        return this.mSN;
    }

    public final void showWait(Activity activity) {
        if (this.mIDRWakeWaitView == null) {
            this.mIDRWakeWaitView = new IDRWakeWaitView(activity);
        }
        this.mIDRWakeWaitView.show();
    }

    public final void dismissWait() {
        if (this.mIDRWakeWaitView == null) {
            return;
        }
        this.mIDRWakeWaitView.dismiss();
    }

    public int getWakeUpState() {
        if (this.mIDRWake == null) {
            return 10003;
        }
        return this.mIDRWake.getState();
    }

    public boolean onCreate(IDRManagerCallBack IDRManagerCallBack2) {
        boolean isSuccess = this.wakeUp(IDRManagerCallBack2);
        return isSuccess;
    }

    public boolean onRestart(IDRManagerCallBack IDRManagerCallBack2) {
        if (!this.mIsIDR || !this.mIsExecuteIDRFlow) {
            IDRManagerCallBack2.onSuccess(true);
            return false;
        }
        if (this.mContextWakeReference.get() != null) {
            this.removeFromSleepQueue();
        }
        return this.wakeUpDevNeedCheckDevState(IDRManagerCallBack2);
    }

    private boolean reGetUp(IDRManagerCallBack IDRManagerCallBack2) {
        if (!this.mIsIDR || !this.mIsExecuteIDRFlow) {
            IDRManagerCallBack2.onSuccess(true);
            return false;
        }
        if (this.mIDRWake == null) {
            this.mIDRWake = new IDRWake(this.mSN);
        }
        this.mIDRCallBack.setCallBack(IDRManagerCallBack2);
        return this.mIDRWake.wakeUp(this.mIDRCallBack);
    }

    private boolean wakeUp(IDRManagerCallBack IDRManagerCallBack2) {
        if (!this.mIsIDR || !this.mIsExecuteIDRFlow) {
            IDRManagerCallBack2.onSuccess(true);
            return false;
        }
        if (this.mIDRWake == null) {
            this.mIDRWake = new IDRWake(this.mSN);
        }
        this.mIDRCallBack.setCallBack(IDRManagerCallBack2);
        boolean isSuccess = this.mIDRWake.wakeUp(this.mIDRCallBack);
        if (isSuccess) {
            this.mUpNum = 0;
            IDRManagerCallBack2.onStartWakeUp();
        }
        return isSuccess;
    }

    public void stopWakeUp() {
        if (this.mIDRWake != null) {
            this.mIDRWake.stopWakeUp();
        }
    }

    private boolean wakeUpDevNeedCheckDevState(IDRManagerCallBack IDRManagerCallBack2) {
        if (!this.mIsIDR || !this.mIsExecuteIDRFlow) {
            IDRManagerCallBack2.onSuccess(true);
            return false;
        }
        if (this.mIDRWake == null) {
            this.mIDRWake = new IDRWake(this.mSN);
        }
        this.mIDRCallBack.setCallBack(IDRManagerCallBack2);
        boolean isSuccess = this.mIDRWake.wakeUpDevNeedCheckDevState(this.mIDRCallBack);
        if (isSuccess) {
            this.mUpNum = 0;
            IDRManagerCallBack2.onStartWakeUp();
        }
        return isSuccess;
    }

    public void removeSleepDelay() {
        if (!this.mIsIDR || !this.mIsExecuteIDRFlow) {
            return;
        }
        if (this.mContextWakeReference != null && this.mContextWakeReference.get() != null) {
            this.removeFromSleepQueue();
        }
    }

    public void cancelBatteryInfo() {
        if (!this.mIsIDR) {
            return;
        }
        if (this.mDevBatteryManager == null) {
            return;
        }
        this.mDevBatteryManager.stopReceive();
    }

    public int getLastStorageStatus() {
        if (this.mDevBatteryManager == null) {
            return -2;
        }
        return this.mDevBatteryManager.getLastStorageStatus();
    }

    public void reReceiveBatteryInfo(IDRDevBatteryManager.OnBatteryLevelListener batteryLevelListener) {
        if (!this.mIsIDR) {
            return;
        }
        if (this.mDevBatteryManager == null) {
            this.mDevBatteryManager = new IDRDevBatteryManager(this.mSN);
        }
        if (this.mIDRPowerListener == null) {
            this.mIDRPowerListener = new IDRPowerListener();
        }
        this.mDevBatteryManager.restartReceive();
        this.mIDRPowerListener.setOnBatteryLevelListener(batteryLevelListener);
        this.mDevBatteryManager.setOnBatteryLevelListener(this.mIDRPowerListener);
    }

    public void receiveBatteryInfo(IDRDevBatteryManager.OnBatteryLevelListener batteryLevelListener) {
        if (!this.mIsIDR) {
            return;
        }
        if (this.mDevBatteryManager == null) {
            this.mDevBatteryManager = new IDRDevBatteryManager(this.mSN);
        }
        if (this.mIDRPowerListener == null) {
            this.mIDRPowerListener = new IDRPowerListener();
        }
        this.mIDRPowerListener.setOnBatteryLevelListener(batteryLevelListener);
        this.mDevBatteryManager.setOnBatteryLevelListener(this.mIDRPowerListener);
        this.mDevBatteryManager.startReceive();
    }

    public boolean requestStorageSize(IDRManagerCallBack storageSizeIDRManagerCallBack) {
        if (!this.mIsIDR) {
            return false;
        }
        this.mStorageSizeIDRManagerCallBack = storageSizeIDRManagerCallBack;
        if (this.mSDStorage == null) {
            this.mSDStorage = new SDStorage(this.mSN);
        }
        return this.mSDStorage.requestGetSD(this.mStorageSizeIDRManagerCallBack);
    }

    private void addToSleepQueue() {
        if (!this.mIsIDR) {
            return;
        }
        if (this.mContextWakeReference.get() != null) {
            IDRSleepService.start((Context)this.mContextWakeReference.get(), this.mSN, 500);
        }
    }

    private void removeFromSleepQueue() {
        if (!this.mIsIDR) {
            return;
        }
        if (this.mContextWakeReference.get() != null) {
            IDRSleepService.start((Context)this.mContextWakeReference.get(), this.mSN, 501);
        }
    }

    public boolean isResumed() {
        return this.mResumed;
    }

    public void onResume() {
        this.mResumed = true;
        IdrDefine.addToPlayDevices(this.mSN);
        this.removeFromSleepQueue();
    }

    public void onStop() {
        this.mResumed = false;
    }

    public void clear() {
        EventBus.getDefault().unregister((Object)this);
        if (this.mSDStorage != null) {
            this.mSDStorage.onDestroy();
        }
        if (this.mIDRPowerListener != null) {
            this.mIDRPowerListener.destroy();
        }
        if (this.mDevBatteryManager != null) {
            this.mDevBatteryManager.onDestroy();
        }
        if (this.mIDRWake != null) {
            this.mIDRWake.onDestroy();
        }
        if (this.mIsRegisterReceiver && this.mContextWakeReference.get() != null) {
            ((Context)this.mContextWakeReference.get()).unregisterReceiver(this.mHomeClickReceiver);
        }
        if (this.mDisposable != null && !this.mDisposable.isDisposed()) {
            this.mDisposable.dispose();
        }
        if (this.mIDRCallBack != null) {
            this.mIDRCallBack.destroy();
            this.mIDRCallBack = null;
        }
        if (this.mIDRWakeWaitView != null) {
            this.mIDRWakeWaitView.destroy();
            this.mIDRWakeWaitView = null;
        }
    }

    public void onDestroy(boolean sleepNow) {
        this.clear();
        IdrDefine.exitPlayDevices(this.mSN);
        if (!this.mIsExecuteIDRFlow) {
            return;
        }
        if (sleepNow) {
            if (this.mContextWakeReference.get() != null) {
                IDRSleepService.start((Context)this.mContextWakeReference.get(), this.mSN, 502);
            }
        } else {
            this.addToSleepQueue();
        }
    }

    private final class IDRIDRManagerCallBack
    implements IDRManagerCallBack {
        private IDRManagerCallBack IDRManagerCallBack;

        private IDRIDRManagerCallBack() {
        }

        public void setCallBack(IDRManagerCallBack IDRManagerCallBack2) {
            this.IDRManagerCallBack = IDRManagerCallBack2;
        }

        private void destroy() {
            this.IDRManagerCallBack = null;
        }

        @Override
        public void onStartWakeUp() {
            if (this.IDRManagerCallBack != null) {
                this.IDRManagerCallBack.onStartWakeUp();
            }
        }

        @Override
        public void onError(final Message msg, final MsgContent ex) {
            if (this.IDRManagerCallBack == null) {
                return;
            }
            if (msg.arg1 == -11301 || msg.arg1 == -11318) {
                this.IDRManagerCallBack.onError(msg, ex);
                return;
            }
            IDRManager.this.mUpNum++;
            if (IDRManager.this.mUpNum >= 2) {
                this.IDRManagerCallBack.onError(msg, ex);
                this.destroy();
            } else {
                if (IDRManager.this.mDisposable != null && !IDRManager.this.mDisposable.isDisposed()) {
                    IDRManager.this.mDisposable.dispose();
                }
                IDRManager.this.mDisposable = Observable.just((Object)0).delay(1L, TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Integer>(){

                    public void accept(@NonNull Integer integer) throws Exception {
                        if (!IDRManager.this.reGetUp(IDRIDRManagerCallBack.this.IDRManagerCallBack)) {
                            IDRIDRManagerCallBack.this.IDRManagerCallBack.onError(msg, ex);
                            IDRIDRManagerCallBack.this.destroy();
                        }
                    }
                });
            }
        }

        @Override
        public void onFail(int status) {
            if (this.IDRManagerCallBack == null) {
                return;
            }
            this.IDRManagerCallBack.onFail(status);
        }

        public void onSuccess(Object obj) {
            if (this.IDRManagerCallBack == null) {
                return;
            }
            if (IDRManager.this.mResumed) {
                this.IDRManagerCallBack.onSuccess(true);
                this.destroy();
            } else {
                this.IDRManagerCallBack.onSuccess(false);
                this.destroy();
            }
        }
    }

    private final class IDRPowerListener
    implements IDRDevBatteryManager.OnBatteryLevelListener {
        private IDRDevBatteryManager.OnBatteryLevelListener onBatteryLevelListener;

        private IDRPowerListener() {
        }

        public void setOnBatteryLevelListener(IDRDevBatteryManager.OnBatteryLevelListener onBatteryLevelListener) {
            this.onBatteryLevelListener = onBatteryLevelListener;
        }

        public void destroy() {
            this.onBatteryLevelListener = null;
        }

        @Override
        public void onBatteryLevel(int devStorageStatus, int electable, int level, int percent) {
            if (!IDRManager.this.mIsIDR) {
                return;
            }
            EventBus.getDefault().post((Object)new BatteryStorageResult(devStorageStatus, electable, level));
            if (this.onBatteryLevelListener != null) {
                this.onBatteryLevelListener.onBatteryLevel(devStorageStatus, electable, level, percent);
            }
            if (IDRManager.this.mContextWakeReference == null || IDRManager.this.mContextWakeReference.get() == null) {
                return;
            }
            if (electable >= 0 && electable < 3) {
                IdrDefine.putPower((Context)IDRManager.this.mContextWakeReference.get(), IDRManager.this.mSN, electable, percent);
            }
        }
    }
}

