/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.fisheye;

import android.util.Log;
import android.view.SurfaceView;
import com.lib.sdk.struct.SDK_FishEyeFrame;
import com.lib.sdk.struct.SDK_FishEyeFrameCM;
import com.lib.sdk.struct.SDK_FishEyeFrameHW;
import com.lib.sdk.struct.SDK_FishEyeFrameSW;
import com.lib.sdk.struct.SDK_TwoLensesInOne;
import com.manager.device.fisheye.FishEyeVidType;
import com.vatics.dewarp.GL2JNIView;
import com.video.opengl.GLSurfaceView20;
import com.xmgl.vrsoft.VRSoftGLView;

public class FishEyeParams {
    private FishEyeVidType vidType;
    private int spliceDirection;
    private int cameraSwitch;
    public int xCenter;
    public int yCenter;
    public int radius;
    public int imageWidth;
    public int imageHeight;
    public int cameraType;
    public boolean isSupportFollow;

    public FishEyeParams(FishEyeVidType type) {
        this.vidType = type;
        this.xCenter = 0;
        this.yCenter = 0;
        this.radius = 0;
        this.imageWidth = 0;
        this.imageHeight = 0;
    }

    public FishEyeParams(SDK_FishEyeFrame fishFrame) {
        if (fishFrame instanceof SDK_FishEyeFrameSW) {
            this.init((SDK_FishEyeFrameSW)fishFrame);
        } else if (fishFrame instanceof SDK_FishEyeFrameHW) {
            this.init((SDK_FishEyeFrameHW)fishFrame);
        } else if (fishFrame instanceof SDK_FishEyeFrameCM) {
            this.init((SDK_FishEyeFrameCM)fishFrame);
        } else if (fishFrame instanceof SDK_TwoLensesInOne) {
            this.init((SDK_TwoLensesInOne)fishFrame);
        }
    }

    private void init(SDK_FishEyeFrameSW fishLens) {
        this.vidType = FishEyeParams.toVidType(fishLens.st_1_lensType);
        if (this.vidType != FishEyeVidType.GENERAL_VIDEO && fishLens.st_2_centerOffsetX > 0 && fishLens.st_3_centerOffsetY > 0 && fishLens.st_4_radius > 0 && fishLens.st_5_imageWidth > 0 && fishLens.st_6_imageHeight > 0) {
            this.xCenter = fishLens.st_2_centerOffsetX;
            this.yCenter = fishLens.st_3_centerOffsetY;
            this.radius = fishLens.st_4_radius;
            this.imageWidth = fishLens.st_5_imageWidth;
            this.imageHeight = fishLens.st_6_imageHeight;
            this.isSupportFollow = fishLens.st_1_lensType == 6;
        } else {
            this.xCenter = 0;
            this.yCenter = 0;
            this.radius = 0;
            this.imageWidth = 0;
            this.imageHeight = 0;
        }
    }

    private void init(SDK_FishEyeFrameHW fishParam) {
        this.vidType = FishEyeParams.toVidTypeBySecene(fishParam.st_0_secene);
        this.xCenter = 0;
        this.yCenter = 0;
        this.radius = 0;
        this.imageWidth = 0;
        this.imageHeight = 0;
    }

    private void init(SDK_FishEyeFrameCM fishParam) {
        this.vidType = FishEyeVidType.GENERAL_DISTORTION;
        this.cameraType = fishParam.st_0_camera;
    }

    private void init(SDK_TwoLensesInOne twoLensesInOneParam) {
        this.vidType = FishEyeVidType.TWO_LENSES_IN_ONE;
        this.spliceDirection = twoLensesInOneParam.st_0_spliceDirection;
        this.cameraSwitch = twoLensesInOneParam.st_3_switchType;
        this.imageWidth = twoLensesInOneParam.getWidth();
        this.imageHeight = twoLensesInOneParam.getHeight();
    }

    public boolean hasOffset() {
        return this.xCenter > 0 && this.yCenter > 0 && this.radius > 0 && this.imageWidth > 0 && this.imageHeight > 0;
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        FishEyeParams cp = (FishEyeParams)o;
        return this.vidType == cp.vidType && this.xCenter == cp.xCenter && this.yCenter == cp.yCenter && this.radius == cp.radius && this.spliceDirection == cp.spliceDirection && this.cameraSwitch == cp.cameraSwitch && this.imageWidth == cp.imageWidth && this.imageHeight == cp.imageHeight;
    }

    private static FishEyeVidType toVidType(int lensType) {
        switch (lensType) {
            case 0: {
                return FishEyeVidType.GENERAL_VIDEO;
            }
            case 1: 
            case 2: {
                return FishEyeVidType.GENERAL_360VR;
            }
            case 3: 
            case 6: {
                return FishEyeVidType.GENERAL_180VR;
            }
            case 7: {
                return FishEyeVidType.SINGLE_PIP;
            }
            case 8: 
            case 9: {
                return FishEyeVidType.PIP_TWO_IN_ONE;
            }
        }
        return FishEyeVidType.GENERAL_VIDEO;
    }

    private static FishEyeVidType toVidTypeBySecene(int secene) {
        switch (secene) {
            case 12: {
                return FishEyeVidType.FISHEYE_360VR;
            }
        }
        return FishEyeVidType.GENERAL_VIDEO;
    }

    public boolean isSurfaceViewMatched(SurfaceView surfaceView) {
        Log.e((String)"XMMOnPlay", (String)("vidType:" + (Object)((Object)this.vidType)));
        Log.e((String)"XMMOnPlay", (String)("spliceDirection:" + this.spliceDirection));
        if (null == surfaceView) {
            return false;
        }
        if (this.vidType == FishEyeVidType.TWO_LENSES_IN_ONE) {
            if (this.spliceDirection == -1) {
                if (surfaceView instanceof GLSurfaceView20) {
                    Log.e((String)"XMMOnPlay", (String)"GLSurfaceView20");
                    return true;
                }
            } else if (surfaceView instanceof VRSoftGLView) {
                Log.e((String)"XMMOnPlay", (String)"VRSoftGLView");
                return true;
            }
        } else if (this.vidType == FishEyeVidType.GENERAL_VIDEO) {
            if (surfaceView instanceof GLSurfaceView20) {
                Log.e((String)"XMMOnPlay", (String)"GLSurfaceView20");
                return true;
            }
        } else if (this.vidType == FishEyeVidType.GENERAL_180VR || this.vidType == FishEyeVidType.GENERAL_360VR || this.vidType == FishEyeVidType.SINGLE_PIP || this.vidType == FishEyeVidType.PIP_TWO_IN_ONE) {
            if (surfaceView instanceof VRSoftGLView) {
                Log.e((String)"XMMOnPlay", (String)"VRSoftGLView");
                return true;
            }
            if (surfaceView instanceof GL2JNIView) {
                Log.e((String)"XMMOnPlay", (String)"GL2JNIView");
                return true;
            }
        } else if (this.vidType == FishEyeVidType.GENERAL_DISTORTION) {
            if (surfaceView instanceof VRSoftGLView) {
                Log.e((String)"XMMOnPlay", (String)"VRSoftGLView");
                return true;
            }
        } else if (surfaceView instanceof GL2JNIView) {
            Log.e((String)"XMMOnPlay", (String)"GL2JNIView");
            return true;
        }
        return false;
    }

    public FishEyeVidType getVidType() {
        return this.vidType;
    }

    public int getSpliceDirection() {
        return this.spliceDirection;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }
}

