/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.config;

import android.os.Message;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.lib.sdk.bean.OPTUpDataBean;
import com.lib.sdk.bean.StringUtils;
import com.manager.device.config.IDevReportManager;
import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;

public class DevReportManager
implements IDevReportManager {
    private static final int TRY_COUNT = 3;
    private int userId;
    private int mStopType = 0;
    private boolean isSendingStop = false;
    private int uploadDataType;
    private String devId;
    private String sendJsonData;
    private OnDevReportListener onDevReportListener;
    private Disposable disposable;

    public DevReportManager(String specificType, int uploadDataType, OnDevReportListener onDevReportListener) {
        this.onDevReportListener = onDevReportListener;
        this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
        this.uploadDataType = uploadDataType;
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("Name", (Object)"OPTUpData");
            jsonObject.put("SessionID", (Object)"0x08");
            OPTUpDataBean optUpDataBean = new OPTUpDataBean();
            if (!StringUtils.isStringNULL(specificType)) {
                optUpDataBean.setSpecificType(specificType);
            }
            optUpDataBean.setUpLoadDataType(uploadDataType);
            jsonObject.put("OPTUpData", (Object)optUpDataBean);
            this.sendJsonData = jsonObject.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startReceive(String devId) {
        if (this.isSendingStop) {
            return;
        }
        if (StringUtils.isStringNULL(devId)) {
            return;
        }
        this.devId = devId;
        FunSDK.DevGeneralStartUploadData((int)this.userId, (String)devId, (String)this.sendJsonData, (int)0, (int)this.uploadDataType, (int)3);
    }

    @Override
    public void stopReceive(String devId) {
        if (StringUtils.isStringNULL(devId)) {
            return;
        }
        this.isSendingStop = true;
        this.mStopType = 0;
        FunSDK.DevGeneralStopUploadData((int)this.userId, (String)devId, (String)this.sendJsonData, (int)0, (int)this.uploadDataType, (int)0);
    }

    public int OnFunSDKResult(Message msg, final MsgContent ex) {
        switch (msg.what) {
            case 5135: {
                if (msg.arg1 >= 0 || ex.seq <= 0) break;
                FunSDK.DevGeneralStartUploadData((int)this.userId, (String)ex.str, (String)this.sendJsonData, (int)0, (int)this.uploadDataType, (int)(ex.seq - 1));
                break;
            }
            case 5136: {
                if (this.mStopType != 1) break;
                this.disposable = Flowable.just((Object)0).delay(1L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Integer>(){

                    public void accept(Integer integer) throws Exception {
                        DevReportManager.this.isSendingStop = false;
                        DevReportManager.this.startReceive(ex.str);
                        if (DevReportManager.this.disposable != null) {
                            DevReportManager.this.disposable.dispose();
                        }
                    }
                });
                break;
            }
            case 5137: {
                this.parseState(G.ToString((byte[])ex.pData));
                break;
            }
        }
        return 0;
    }

    private void parseState(String jsonStr) {
        if (StringUtils.isStringNULL(jsonStr)) {
            return;
        }
        try {
            JSONObject jsonObject = JSON.parseObject((String)jsonStr);
            if (jsonObject != null) {
                if (jsonObject.containsKey((Object)"dateType")) {
                    String stateType = jsonObject.getString("dateType");
                    String stateData = jsonObject.getString("Remote");
                    if (this.onDevReportListener != null) {
                        this.onDevReportListener.onReport(this.devId, stateType, stateData);
                    }
                } else if (this.onDevReportListener != null) {
                    this.onDevReportListener.onReport(this.devId, null, jsonStr);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void release() {
        this.stopReceive(this.devId);
        this.onDevReportListener = null;
        FunSDK.UnRegUser((int)this.userId);
        if (this.disposable != null) {
            this.disposable.dispose();
        }
    }

    public static interface OnDevReportListener {
        public void onReport(String var1, String var2, String var3);
    }
}

