/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.alarm;

import android.content.Context;
import android.os.Message;
import android.util.Log;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.Mps.MpsClient;
import com.lib.Mps.XPMS_SEARCH_ALARMINFO_REQ;
import com.lib.MsgContent;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.bean.alarm.AlarmGroup;
import com.lib.sdk.bean.alarm.AlarmInfo;
import com.lib.sdk.bean.alarm.SearchAlarmInfo;
import com.manager.base.BaseManager;
import com.manager.device.alarm.DevAlarmInfoManagerInterface;
import com.utils.XUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import org.json.JSONArray;
import org.json.JSONObject;

public class DevAlarmInfoManager
extends BaseManager
implements IFunSDKResult,
DevAlarmInfoManagerInterface {
    private static final int SEARCH_DAYS = 7;
    private static final int DELETE_SEND_DATA_MAX_COUNT = 60;
    private static final int SEARCH_MIN_COUNT = 20;
    private Context context;
    private int userId;
    private OnAlarmInfoListener onAlarmInfoListener;
    private boolean isSupportCloudStorage;
    private List<AlarmGroup> alarmGroupList;
    private List<AlarmInfo> tempDeleteAlarmInfos;
    private Queue<SearchAlarmInfo> searchAlarmInfoQueue;
    private int alarmType;
    private Date searchTime;
    private int searchDays = 7;
    private int thumbWidth;
    private int thumbHeight;

    public DevAlarmInfoManager(OnAlarmInfoListener listener) {
        this.onAlarmInfoListener = listener;
        this.searchAlarmInfoQueue = new LinkedBlockingDeque<SearchAlarmInfo>();
        this.init();
    }

    @Override
    public boolean init() {
        this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
        return true;
    }

    @Override
    public void unInit() {
        FunSDK.UnRegUser((int)this.userId);
        this.userId = 0;
    }

    @Override
    public void searchAlarmInfo(String devId, int chnId, int alarmType, Date searchTime, int searchDays, boolean isSupportCloudStorage) {
        this.alarmType = alarmType;
        this.searchTime = searchTime;
        this.searchDays = searchDays;
        this.isSupportCloudStorage = isSupportCloudStorage;
        if (this.alarmGroupList != null) {
            this.alarmGroupList.clear();
        } else {
            this.alarmGroupList = new ArrayList<AlarmGroup>();
        }
        if (this.searchAlarmInfoQueue != null) {
            this.searchAlarmInfoQueue.clear();
        }
        if (isSupportCloudStorage) {
            for (int i = 0; i >= 1 - searchDays; --i) {
                Calendar searchDay = Calendar.getInstance();
                searchDay.setTime(this.searchTime);
                searchDay.add(5, i);
                searchDay.set(11, 23);
                searchDay.set(12, 59);
                searchDay.set(13, 59);
                SearchAlarmInfo searchAlarmInfo = new SearchAlarmInfo();
                searchAlarmInfo.setDevId(devId);
                searchAlarmInfo.setChnId(chnId);
                searchAlarmInfo.setSearchCalendar(searchDay);
                searchAlarmInfo.setFlag(i);
                this.searchAlarmInfoQueue.offer(searchAlarmInfo);
            }
            this.searchAlarmInfoByDayQueue();
        } else {
            this.searchAlarmInfoAll(devId, chnId);
        }
    }

    @Override
    public void searchAlarmInfo(String devId, int chnId, int alarmType, Date searchTime, int searchDays, int thumbWidth, int thumbHeight) {
        this.thumbWidth = thumbWidth;
        this.thumbHeight = thumbHeight;
        this.searchAlarmInfo(devId, chnId, alarmType, searchTime, searchDays, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean searchAlarmInfoByDayQueue() {
        if (this.searchAlarmInfoQueue == null || this.searchAlarmInfoQueue.isEmpty()) {
            return false;
        }
        Queue<SearchAlarmInfo> queue = this.searchAlarmInfoQueue;
        synchronized (queue) {
            SearchAlarmInfo searchAlarmInfo = this.searchAlarmInfoQueue.peek();
            if (searchAlarmInfo != null) {
                Calendar calendar = searchAlarmInfo.getSearchCalendar();
                int flag = searchAlarmInfo.getFlag();
                return this.searchAlarmInfoByDay(searchAlarmInfo.getDevId(), searchAlarmInfo.getChnId(), calendar, flag);
            }
        }
        return false;
    }

    private boolean searchAlarmInfoByDay(String devId, int chnId, Calendar calendar, int seq) {
        if (calendar == null) {
            return false;
        }
        Calendar startSearchDay = Calendar.getInstance();
        startSearchDay.setTime(calendar.getTime());
        startSearchDay.set(11, 0);
        startSearchDay.set(12, 0);
        startSearchDay.set(13, 0);
        Calendar stopSearchDay = Calendar.getInstance();
        stopSearchDay.setTime(calendar.getTime());
        this.searchAlarmInfoByTime(devId, chnId, startSearchDay, stopSearchDay, seq);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAlarmInfo(String devId, String deleteType, AlarmInfo ... alarmInfos) {
        if (alarmInfos == null) {
            return;
        }
        if (this.alarmGroupList == null || this.alarmGroupList.isEmpty()) {
            return;
        }
        List<AlarmGroup> list = this.alarmGroupList;
        synchronized (list) {
            int i;
            if (this.tempDeleteAlarmInfos == null) {
                this.tempDeleteAlarmInfos = new ArrayList<AlarmInfo>();
            }
            StringBuffer sb = new StringBuffer();
            ArrayList<String> sendJsons = new ArrayList<String>();
            for (i = 0; i < alarmInfos.length; ++i) {
                sb.append(alarmInfos[i].getId());
                sb.append(";");
                this.tempDeleteAlarmInfos.add(alarmInfos[i]);
                if (StringUtils.isStringNULL(sb.toString()) || (i + 1) % 60 != 0 && i + 1 != alarmInfos.length) continue;
                sendJsons.add(sb.toString());
                sb = new StringBuffer();
            }
            if (sendJsons.isEmpty()) {
                return;
            }
            for (i = 0; i < sendJsons.size(); ++i) {
                String sendJson = (String)sendJsons.get(i);
                boolean isLast = i + 1 == sendJsons.size();
                MpsClient.DeleteMediaFile((int)this.userId, (String)devId, (String)deleteType, (String)sendJson, (int)(isLast ? 1 : 0));
            }
        }
    }

    @Override
    public void deleteAllAlarmInfos(String devId, String deleteType) {
        MpsClient.DeleteMediaFile((int)this.userId, (String)devId, (String)deleteType, null, (int)1);
    }

    @Override
    public void searchAlarmInfoAll(String devId, int chnId) {
        XPMS_SEARCH_ALARMINFO_REQ info = new XPMS_SEARCH_ALARMINFO_REQ();
        G.SetValue((byte[])info.st_00_Uuid, (String)devId);
        Calendar c = Calendar.getInstance();
        c.setTime(this.searchTime);
        info.st_02_StarTime.st_0_year = c.get(1);
        info.st_02_StarTime.st_1_month = c.get(2) + 1;
        info.st_02_StarTime.st_2_day = c.get(5);
        info.st_02_StarTime.st_4_hour = 0;
        info.st_02_StarTime.st_5_minute = 0;
        info.st_02_StarTime.st_6_second = 0;
        info.st_03_EndTime.st_0_year = c.get(1);
        info.st_03_EndTime.st_1_month = c.get(2) + 1;
        info.st_03_EndTime.st_2_day = c.get(5);
        info.st_03_EndTime.st_4_hour = 23;
        info.st_03_EndTime.st_5_minute = 59;
        info.st_03_EndTime.st_6_second = 59;
        info.st_04_Channel = chnId;
        info.st_06_Number = 0;
        info.st_05_AlarmType = this.alarmType;
        MpsClient.SearchAlarmInfo((int)this.userId, (byte[])G.ObjToBytes((Object)info), (int)0);
    }

    public void searchAlarmInfoByTime(String devId, int chnId, Calendar startSearchDay, Calendar stopSearchDay, int seq) {
        XPMS_SEARCH_ALARMINFO_REQ info = new XPMS_SEARCH_ALARMINFO_REQ();
        G.SetValue((byte[])info.st_00_Uuid, (String)devId);
        info.st_02_StarTime.st_0_year = startSearchDay.get(1);
        info.st_02_StarTime.st_1_month = startSearchDay.get(2) + 1;
        info.st_02_StarTime.st_2_day = startSearchDay.get(5);
        info.st_02_StarTime.st_4_hour = startSearchDay.get(11);
        info.st_02_StarTime.st_5_minute = startSearchDay.get(12);
        info.st_02_StarTime.st_6_second = startSearchDay.get(13);
        info.st_03_EndTime.st_0_year = stopSearchDay.get(1);
        info.st_03_EndTime.st_1_month = stopSearchDay.get(2) + 1;
        info.st_03_EndTime.st_2_day = stopSearchDay.get(5);
        info.st_03_EndTime.st_4_hour = stopSearchDay.get(11);
        info.st_03_EndTime.st_5_minute = stopSearchDay.get(12);
        info.st_03_EndTime.st_6_second = stopSearchDay.get(13);
        info.st_04_Channel = chnId;
        info.st_06_Number = 0;
        info.st_05_AlarmType = this.alarmType;
        MpsClient.SearchCloudAlarmInfoByTime((int)this.userId, (byte[])G.ObjToBytes((Object)info), (int)this.thumbWidth, (int)this.thumbHeight, (int)seq);
    }

    private void searchAlarmInfoByTime(String devId, int chnId, Calendar startSearchDay, Calendar stopSearchDay) {
        this.searchAlarmInfoByTime(devId, chnId, startSearchDay, stopSearchDay, 0);
    }

    private void searchAlarmInfoByTime(String devId, int chnId, String stopTime, int seq) {
        Calendar startSearchDay = Calendar.getInstance();
        startSearchDay.setTime(this.searchTime);
        startSearchDay.add(5, seq);
        startSearchDay.set(11, 0);
        startSearchDay.set(12, 0);
        startSearchDay.set(13, 0);
        XPMS_SEARCH_ALARMINFO_REQ info = new XPMS_SEARCH_ALARMINFO_REQ();
        G.SetValue((byte[])info.st_00_Uuid, (String)devId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        try {
            date = sdf.parse(stopTime);
            Calendar stopSearchDay = Calendar.getInstance();
            stopSearchDay.setTime(date);
            stopSearchDay.add(13, -1);
            if (this.isContinueToSearchAlarmInfo()) {
                this.searchAlarmInfoByTime(devId, chnId, startSearchDay, stopSearchDay, seq);
            } else {
                SearchAlarmInfo searchAlarmInfo = this.searchAlarmInfoQueue.peek();
                if (searchAlarmInfo != null) {
                    searchAlarmInfo.setSearchCalendar(stopSearchDay);
                }
                this.onAlarmInfoListener.onSearchResult(this.alarmGroupList);
            }
        }
        catch (ParseException e) {
            Log.e((String)"ccy", (String)"\u67e5\u8be2\u62a5\u8b66\u6d88\u606f\u65f6\uff0c\u670d\u52a1\u5668\u8fd4\u56de\u7684\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHaveAlarmInfo() {
        if (this.alarmGroupList == null) {
            return false;
        }
        List<AlarmGroup> list = this.alarmGroupList;
        synchronized (list) {
            return !this.alarmGroupList.isEmpty();
        }
    }

    private boolean isContinueToSearchAlarmInfo() {
        if (this.alarmGroupList == null || this.alarmGroupList.isEmpty()) {
            return true;
        }
        int alarmCount = 0;
        for (AlarmGroup alarmGroup : this.alarmGroupList) {
            if (alarmGroup == null) continue;
            alarmCount += alarmGroup.getCount();
        }
        return alarmCount < 20;
    }

    public int OnFunSDKResult(Message msg, MsgContent ex) {
        switch (msg.what) {
            case 6003: {
                if (msg.arg1 >= 0) {
                    this.dealWithSearchAlarmResult(msg, ex);
                    break;
                }
                this.searchAlarmInfoQueue.poll();
                if (msg.arg1 == -222400) {
                    if (!this.isHaveAlarmInfo()) {
                        if (this.searchAlarmInfoByDayQueue() || this.onAlarmInfoListener == null) break;
                        this.onAlarmInfoListener.onSearchResult(null);
                        break;
                    }
                    if (!this.isContinueToSearchAlarmInfo() || this.searchAlarmInfoByDayQueue() || this.onAlarmInfoListener == null) break;
                    this.onAlarmInfoListener.onSearchResult(this.alarmGroupList);
                    break;
                }
                if (this.onAlarmInfoListener == null) break;
                this.onAlarmInfoListener.onSearchResult(null);
                break;
            }
            case 6027: {
                if (msg.arg1 >= 0) {
                    this.dealWithSearchAlarmResultV2(msg, ex);
                    break;
                }
                this.searchAlarmInfoQueue.poll();
                if (msg.arg1 == -222400) {
                    if (!this.isHaveAlarmInfo()) {
                        if (this.searchAlarmInfoByDayQueue() || this.onAlarmInfoListener == null) break;
                        this.onAlarmInfoListener.onSearchResult(null);
                        break;
                    }
                    if (!this.isContinueToSearchAlarmInfo() || this.searchAlarmInfoByDayQueue() || this.onAlarmInfoListener == null) break;
                    this.onAlarmInfoListener.onSearchResult(this.alarmGroupList);
                    break;
                }
                if (this.onAlarmInfoListener == null) break;
                this.onAlarmInfoListener.onSearchResult(null);
                break;
            }
            case 6012: {
                if (ex.seq == 1) {
                    this.deleteAlarmInfoResult();
                }
                if (this.onAlarmInfoListener == null) break;
                this.onAlarmInfoListener.onDeleteResult(msg.arg1 >= 0, msg, ex, this.tempDeleteAlarmInfos);
                break;
            }
        }
        return 0;
    }

    private void dealWithSearchAlarmResult(Message msg, MsgContent ex) {
        boolean isContain = false;
        if (ex.arg3 <= 0) {
            this.searchAlarmInfoQueue.poll();
            if (this.isSupportCloudStorage) {
                if (this.isContinueToSearchAlarmInfo()) {
                    if (!this.searchAlarmInfoByDayQueue() && this.onAlarmInfoListener != null) {
                        this.onAlarmInfoListener.onSearchResult(this.alarmGroupList);
                    }
                } else if (this.onAlarmInfoListener != null) {
                    this.onAlarmInfoListener.onSearchResult(this.alarmGroupList);
                }
            } else if (this.onAlarmInfoListener != null) {
                this.onAlarmInfoListener.onSearchResult(this.alarmGroupList);
            }
            return;
        }
        AlarmInfo alarmInfo = this.parseAlarmInfos(ex.arg3, ex.pData);
        Collections.sort(this.alarmGroupList, (object1, object2) -> object2.getDate().compareTo(object1.getDate()));
        if (this.isSupportCloudStorage) {
            if (alarmInfo != null) {
                if (!this.isContinueToSearchAlarmInfo()) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date date = new Date();
                    if (alarmInfo.getStartTime() != null) {
                        try {
                            date = sdf.parse(alarmInfo.getStartTime());
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                    Calendar stopSearchDay = Calendar.getInstance();
                    stopSearchDay.setTime(date);
                    stopSearchDay.add(13, -1);
                    SearchAlarmInfo searchAlarmInfo = this.searchAlarmInfoQueue.peek();
                    if (searchAlarmInfo != null) {
                        searchAlarmInfo.setSearchCalendar(stopSearchDay);
                    }
                    if (this.onAlarmInfoListener != null) {
                        this.onAlarmInfoListener.onSearchResult(this.alarmGroupList);
                    }
                } else {
                    SearchAlarmInfo searchAlarmInfo = this.searchAlarmInfoQueue.peek();
                    if (searchAlarmInfo != null) {
                        this.searchAlarmInfoByTime(searchAlarmInfo.getDevId(), searchAlarmInfo.getChnId(), alarmInfo.getStartTime(), ex.seq);
                    } else if (this.onAlarmInfoListener != null) {
                        this.onAlarmInfoListener.onSearchResult(this.alarmGroupList);
                    }
                }
            }
        } else if (this.onAlarmInfoListener != null) {
            this.onAlarmInfoListener.onSearchResult(this.alarmGroupList);
        }
    }

    private void dealWithSearchAlarmResultV2(Message msg, MsgContent ex) {
        block23: {
            try {
                String jsonData = G.ToStringJson((byte[])ex.pData);
                JSONObject jsonObject = new JSONObject(jsonData);
                int count = 0;
                if (jsonObject.has("msgnum")) {
                    count = jsonObject.optInt("msgnum", 0);
                }
                if (count <= 0) {
                    this.searchAlarmInfoQueue.poll();
                    if (this.isSupportCloudStorage) {
                        if (this.isContinueToSearchAlarmInfo()) {
                            if (!this.searchAlarmInfoByDayQueue() && this.onAlarmInfoListener != null) {
                                this.onAlarmInfoListener.onSearchResult(this.alarmGroupList);
                            }
                        } else if (this.onAlarmInfoListener != null) {
                            this.onAlarmInfoListener.onSearchResult(this.alarmGroupList);
                        }
                    } else if (this.onAlarmInfoListener != null) {
                        this.onAlarmInfoListener.onSearchResult(this.alarmGroupList);
                    }
                    return;
                }
                if (!jsonObject.has("msglist")) {
                    if (this.onAlarmInfoListener != null) {
                        this.onAlarmInfoListener.onSearchResult(this.alarmGroupList);
                    }
                    return;
                }
                JSONArray jsonArray = jsonObject.optJSONArray("msglist");
                AlarmInfo alarmInfo = this.parseAlarmInfosV2(jsonArray);
                Collections.sort(this.alarmGroupList, (object1, object2) -> object2.getDate().compareTo(object1.getDate()));
                if (this.isSupportCloudStorage) {
                    if (alarmInfo == null) break block23;
                    if (!this.isContinueToSearchAlarmInfo()) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        Date date = new Date();
                        try {
                            date = sdf.parse(alarmInfo.getStartTime());
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        Calendar stopSearchDay = Calendar.getInstance();
                        stopSearchDay.setTime(date);
                        stopSearchDay.add(13, -1);
                        SearchAlarmInfo searchAlarmInfo = this.searchAlarmInfoQueue.peek();
                        if (searchAlarmInfo != null) {
                            searchAlarmInfo.setSearchCalendar(stopSearchDay);
                        }
                        if (this.onAlarmInfoListener != null) {
                            this.onAlarmInfoListener.onSearchResult(this.alarmGroupList);
                        }
                        break block23;
                    }
                    SearchAlarmInfo searchAlarmInfo = this.searchAlarmInfoQueue.peek();
                    if (searchAlarmInfo != null) {
                        this.searchAlarmInfoByTime(searchAlarmInfo.getDevId(), searchAlarmInfo.getChnId(), alarmInfo.getStartTime(), ex.seq);
                    } else if (this.onAlarmInfoListener != null) {
                        this.onAlarmInfoListener.onSearchResult(this.alarmGroupList);
                    }
                    break block23;
                }
                if (this.onAlarmInfoListener != null) {
                    this.onAlarmInfoListener.onSearchResult(this.alarmGroupList);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private AlarmInfo parseAlarmInfos(int alarmCount, byte[] alarmInfos) {
        if (this.alarmGroupList == null) {
            this.alarmGroupList = new ArrayList<AlarmGroup>();
        }
        AlarmInfo info = null;
        int[] nNext = new int[]{0};
        int nStart = 0;
        String time = "";
        for (int i = 0; i < alarmCount; ++i) {
            String extUserData;
            boolean isExist = false;
            String ret = G.ArrayToString((byte[])alarmInfos, (int)nStart, (int[])nNext);
            nStart = nNext[0];
            info = new AlarmInfo();
            if (!info.onParse(ret) && !info.onParse("{" + ret) || null != info.getExtInfo() && null != (extUserData = info.getExtUserData()) && extUserData.length() > 0) continue;
            if (XUtils.notEmpty(info.getStartTime()) && info.getStartTime().split(" ").length > 0) {
                time = info.getStartTime().split(" ")[0];
            }
            AlarmGroup group = null;
            if (this.alarmGroupList.isEmpty()) {
                group = new AlarmGroup();
                group.setDate(time);
                group.getInfoList().add(info);
            } else {
                for (AlarmGroup alarmGroup : this.alarmGroupList) {
                    if (!alarmGroup.getDate().equals(time)) continue;
                    isExist = true;
                    group = null;
                    alarmGroup.getInfoList().add(info);
                }
                if (!isExist) {
                    group = new AlarmGroup();
                    group.setDate(time);
                    group.getInfoList().add(info);
                }
            }
            if (group == null || this.alarmGroupList == null) continue;
            this.alarmGroupList.add(group);
        }
        return info;
    }

    private AlarmInfo parseAlarmInfosV2(JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        if (this.alarmGroupList == null) {
            this.alarmGroupList = new ArrayList<AlarmGroup>();
        }
        AlarmInfo alarmInfo = null;
        String time = "";
        ArrayList<AlarmInfo> alarmInfos = new ArrayList<AlarmInfo>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            boolean isExist = false;
            alarmInfo = new AlarmInfo();
            String subJson = jsonArray.optString(i);
            if (StringUtils.isStringNULL(subJson)) continue;
            alarmInfo.onParse(subJson);
            alarmInfos.add(alarmInfo);
            if (XUtils.notEmpty(alarmInfo.getStartTime()) && alarmInfo.getStartTime().split(" ").length > 0) {
                time = alarmInfo.getStartTime().split(" ")[0];
            }
            AlarmGroup group = null;
            if (this.alarmGroupList.isEmpty()) {
                group = new AlarmGroup();
                group.setDate(time);
                group.getInfoList().add(alarmInfo);
            } else {
                for (AlarmGroup alarmGroup : this.alarmGroupList) {
                    if (!alarmGroup.getDate().equals(time)) continue;
                    isExist = true;
                    group = null;
                    alarmGroup.getInfoList().add(alarmInfo);
                }
                if (!isExist) {
                    group = new AlarmGroup();
                    group.setDate(time);
                    group.getInfoList().add(alarmInfo);
                }
            }
            if (group == null || this.alarmGroupList == null) continue;
            this.alarmGroupList.add(group);
        }
        return alarmInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAlarmInfoResult() {
        List<AlarmGroup> list = this.alarmGroupList;
        synchronized (list) {
            try {
                if (this.tempDeleteAlarmInfos != null && this.alarmGroupList != null && !this.alarmGroupList.isEmpty()) {
                    block5: for (AlarmInfo alarmInfo : this.tempDeleteAlarmInfos) {
                        if (alarmInfo == null) continue;
                        for (AlarmGroup alarmGroup : this.alarmGroupList) {
                            List<AlarmInfo> alarmInfos;
                            if (alarmGroup == null || (alarmInfos = alarmGroup.getInfoList()) == null || !alarmInfos.contains(alarmInfo)) continue;
                            alarmInfos.remove(alarmInfo);
                            continue block5;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface OnAlarmInfoListener {
        public void onSearchResult(List<AlarmGroup> var1);

        public void onDeleteResult(boolean var1, Message var2, MsgContent var3, List<AlarmInfo> var4);
    }
}

