/*
 * Decompiled with CFR 0.152.
 */
package com.manager.devfirmware;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.lib.sdk.bean.DevFirmwareInfoBean;
import com.lib.sdk.bean.StringUtils;
import com.manager.devfirmware.serverinteraction.DevFirmwareCheckServerInterface;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class DevFirmwareCheckManager {
    private Queue<String> devIdQueue = new LinkedBlockingDeque<String>(200);
    private HashMap<String, DevFirmwareInfoBean> devFirmwareHashMap;
    private HashMap<Integer, OnDevFirmwareCheckResultListener> listenerHashMap = new HashMap();
    private DevFirmwareCheckServerInterface serverInteraction;
    private static DevFirmwareCheckManager manager;
    private boolean isChecking;

    private DevFirmwareCheckManager() {
        this.devFirmwareHashMap = new HashMap();
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://upgrade.secu100.net/").build();
        this.serverInteraction = (DevFirmwareCheckServerInterface)retrofit.create(DevFirmwareCheckServerInterface.class);
    }

    public static DevFirmwareCheckManager getInstance(OnDevFirmwareCheckResultListener listener) {
        if (manager == null) {
            manager = new DevFirmwareCheckManager();
        }
        manager.setOnDevFirmwareCheckResultListener(listener);
        return manager;
    }

    public boolean checkDevFirmware(String devId) {
        if (this.serverInteraction == null) {
            return false;
        }
        if (StringUtils.isStringNULL(devId) || this.listenerHashMap == null || this.listenerHashMap.isEmpty()) {
            return false;
        }
        if (this.devFirmwareHashMap.containsKey(devId)) {
            this.dealWithCallback(devId, this.devFirmwareHashMap.get(devId));
            return this.devFirmwareHashMap.get(devId) != null;
        }
        return false;
    }

    public boolean checkAllDevFirmware(String[] devIds) {
        if (devIds == null || this.listenerHashMap == null || this.listenerHashMap.isEmpty()) {
            return false;
        }
        if (this.serverInteraction == null || this.isChecking) {
            return false;
        }
        this.isChecking = true;
        try {
            String jsonData = JSON.toJSONString((Object)devIds);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonData);
            Call<ResponseBody> call = this.serverInteraction.checkAllDevFirmware(requestBody);
            call.enqueue(this.createCallback());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.isChecking = false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDevFirmwareFromQueue() {
        Queue<String> queue = this.devIdQueue;
        synchronized (queue) {
            if (this.devIdQueue.isEmpty() || this.isChecking) {
                return;
            }
            this.isChecking = true;
            String devId = this.devIdQueue.poll();
            try {
                Call<ResponseBody> call = this.serverInteraction.checkDevFirmware(devId);
                call.enqueue(this.createCallback());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.dealWithCallback(devId, null);
                this.isChecking = false;
            }
        }
    }

    private Callback<ResponseBody> createCallback() {
        return new Callback<ResponseBody>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                Queue queue = DevFirmwareCheckManager.this.devIdQueue;
                synchronized (queue) {
                    ResponseBody responseBody;
                    if (response != null && (responseBody = (ResponseBody)response.body()) != null) {
                        try {
                            Object result;
                            String jsonResult = URLDecoder.decode(responseBody.string(), "UTF-8");
                            if (jsonResult != null && (result = JSON.parse((String)jsonResult)) != null) {
                                if (result instanceof JSONArray) {
                                    ArrayList devFirmwareInfoBeans = (ArrayList)JSON.parseArray((String)jsonResult, DevFirmwareInfoBean.class);
                                    if (devFirmwareInfoBeans != null) {
                                        for (DevFirmwareInfoBean firmwareInfoBean : devFirmwareInfoBeans) {
                                            DevFirmwareCheckManager.this.devFirmwareHashMap.put(firmwareInfoBean.getUuid(), firmwareInfoBean);
                                            DevFirmwareCheckManager.this.dealWithCallback(firmwareInfoBean.getUuid(), firmwareInfoBean);
                                        }
                                    }
                                    DevFirmwareCheckManager.this.isChecking = false;
                                    return;
                                }
                                if (result instanceof JSONObject) {
                                    DevFirmwareInfoBean devFirmwareInfoBean = (DevFirmwareInfoBean)JSON.parseObject((String)jsonResult, DevFirmwareInfoBean.class);
                                    if (devFirmwareInfoBean != null) {
                                        DevFirmwareCheckManager.this.devFirmwareHashMap.put(devFirmwareInfoBean.getUuid(), devFirmwareInfoBean);
                                        DevFirmwareCheckManager.this.dealWithCallback(devFirmwareInfoBean.getUuid(), devFirmwareInfoBean);
                                    }
                                    DevFirmwareCheckManager.this.isChecking = false;
                                    DevFirmwareCheckManager.this.checkDevFirmwareFromQueue();
                                    return;
                                }
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    DevFirmwareCheckManager.this.isChecking = false;
                    DevFirmwareCheckManager.this.checkDevFirmwareFromQueue();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                Queue queue = DevFirmwareCheckManager.this.devIdQueue;
                synchronized (queue) {
                    DevFirmwareCheckManager.this.isChecking = false;
                    DevFirmwareCheckManager.this.checkDevFirmwareFromQueue();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.isChecking = false;
        this.listenerHashMap.clear();
        manager = null;
        this.devFirmwareHashMap.clear();
        Queue<String> queue = this.devIdQueue;
        synchronized (queue) {
            this.devIdQueue.clear();
        }
    }

    public void removeListener(OnDevFirmwareCheckResultListener listener) {
        if (this.listenerHashMap != null && this.listenerHashMap.containsValue(listener)) {
            this.listenerHashMap.remove(listener.hashCode());
        }
    }

    public void removeFirmwareInfo(String devId) {
        if (this.devFirmwareHashMap != null && this.devFirmwareHashMap.containsKey(devId)) {
            this.devFirmwareHashMap.remove(devId);
            this.dealWithCallback(devId, null);
        }
    }

    private void dealWithCallback(String devId, DevFirmwareInfoBean devFirmwareInfoBean) {
        if (this.listenerHashMap != null) {
            for (Map.Entry<Integer, OnDevFirmwareCheckResultListener> entry : this.listenerHashMap.entrySet()) {
                OnDevFirmwareCheckResultListener listener = entry.getValue();
                if (listener == null) continue;
                listener.onCheckDevFirmwareResult(devId, devFirmwareInfoBean);
            }
        }
    }

    public void setOnDevFirmwareCheckResultListener(OnDevFirmwareCheckResultListener listener) {
        if (listener != null) {
            this.listenerHashMap.put(listener.hashCode(), listener);
        }
    }

    public static interface OnDevFirmwareCheckResultListener {
        public void onCheckDevFirmwareResult(String var1, DevFirmwareInfoBean var2);
    }
}

