/*
 * Decompiled with CFR 0.152.
 */
package com.manager.bluetooth;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.basic.G;
import com.blankj.utilcode.util.ConvertUtils;
import com.inuker.bluetooth.library.BluetoothClient;
import com.inuker.bluetooth.library.beacon.Beacon;
import com.inuker.bluetooth.library.beacon.BeaconItem;
import com.inuker.bluetooth.library.connect.options.BleConnectOptions;
import com.inuker.bluetooth.library.connect.response.BleConnectResponse;
import com.inuker.bluetooth.library.connect.response.BleMtuResponse;
import com.inuker.bluetooth.library.connect.response.BleNotifyResponse;
import com.inuker.bluetooth.library.connect.response.BleWriteResponse;
import com.inuker.bluetooth.library.model.BleGattProfile;
import com.inuker.bluetooth.library.model.BleGattService;
import com.inuker.bluetooth.library.search.SearchRequest;
import com.inuker.bluetooth.library.search.SearchResult;
import com.inuker.bluetooth.library.search.response.SearchResponse;
import com.inuker.bluetooth.library.utils.ByteUtils;
import com.lib.FunSDK;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.bean.bluetooth.XMBleData;
import com.lib.sdk.bean.bluetooth.XMBleHead;
import com.lib.sdk.bean.bluetooth.XMBleInfo;
import com.lib.sdk.struct.CONFIG_IPAddress;
import com.lib.sdk.struct.SDBDeviceInfo;
import com.lib.sdk.struct.SDK_CONFIG_NET_COMMON_V2;
import com.manager.bluetooth.IXMBleManager;
import com.manager.bluetooth.IXMBleManagerListener;
import com.manager.db.XMDevInfo;
import com.utils.BleDistributionUtil;
import com.utils.BleUtils;
import com.utils.LogUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class XMBleManager
implements IXMBleManager {
    private static final String TAG = "BleManager";
    private static final String SERVICE_UUID = "00001910-0000-1000-8000-00805f9b34fb";
    private static final String WRITE_UUID = "00002b11-0000-1000-8000-00805f9b34fb";
    private static final String NOTIFY_UUID = "00002b10-0000-1000-8000-00805f9b34fb";
    private static final String BLE_HEARD_V1 = "8B8B8B8B";
    private static final String BLE_HEARD_V2 = "8B8B";
    private static final String BLE_HEARD_V1_BLE_DOORLOCK = "8BB88B8B8B8B";
    private static final int FACTORY_NAME_TYPE = 9;
    private static final int UUID_TYPE = 22;
    private static final int UUID_MEMBERS_TYPE = 3;
    private static final int FACTORY_INFO_HEAD_TYPE = 255;
    private static final int DEFAULT_MTU = 512;
    private static final int BUFFER_SIZE = 65545;
    private static IXMBleManager IXMBleManager;
    private BluetoothClient bluetoothClient;
    private BleGattProfile bleGattProfile;
    private HashMap<String, XMBleInfo> xmBleInfoHashMap;
    private int timeout = 60000;
    private HashMap<String, Integer> mtuMap;
    private HashMap<String, AtomicInteger> atomicIntegerMap;
    private HashMap<String, IXMBleManagerListener> bleManagerListenerHashMap = new HashMap();
    private HashMap<String, Object> revDataMap;

    private XMBleManager() {
        this.atomicIntegerMap = new HashMap();
        this.revDataMap = new HashMap();
        this.mtuMap = new HashMap();
    }

    public static synchronized IXMBleManager getInstance() {
        if (IXMBleManager == null) {
            IXMBleManager = new XMBleManager();
        }
        return IXMBleManager;
    }

    @Override
    public IXMBleManager setTimeOut(int timeout) {
        this.timeout = timeout;
        return IXMBleManager;
    }

    @Override
    public void setMtu(String mac, int mtu) {
        this.mtuMap.put(mac, mtu);
    }

    @Override
    public void startScan(Context context, final IXMBleManagerListener iBleManagerListener) {
        if (context == null) {
            throw new NullPointerException("Context null");
        }
        if (this.bluetoothClient == null) {
            this.bluetoothClient = new BluetoothClient(context);
        }
        if (this.xmBleInfoHashMap == null) {
            this.xmBleInfoHashMap = new HashMap();
        }
        SearchRequest.Builder builder = new SearchRequest.Builder();
        builder.searchBluetoothLeDevice(this.timeout);
        SearchRequest request = builder.build();
        this.bluetoothClient.search(request, new SearchResponse(){

            @Override
            public void onSearchStarted() {
            }

            @Override
            public void onDeviceFounded(SearchResult device) {
                XMBleInfo xmBleInfo;
                if (device == null) {
                    return;
                }
                if (iBleManagerListener != null && (xmBleInfo = XMBleManager.this.parseBelInfoFromSearch(device)) != null && XMBleManager.this.xmBleInfoHashMap != null) {
                    XMBleManager.this.xmBleInfoHashMap.put(xmBleInfo.getMac(), xmBleInfo);
                    iBleManagerListener.onBleScanResult(xmBleInfo);
                }
            }

            @Override
            public void onSearchStopped() {
            }

            @Override
            public void onSearchCanceled() {
            }
        });
    }

    private XMBleInfo parseBelInfoFromSearch(SearchResult bluetoothDevice) {
        if (bluetoothDevice == null) {
            return null;
        }
        HashMap<Integer, BeaconItem> beaconItems = new Beacon((byte[])bluetoothDevice.scanRecord).mItems;
        BeaconItem beaconItem = null;
        if (beaconItems != null && !beaconItems.isEmpty()) {
            if (beaconItems.containsKey(255)) {
                beaconItem = beaconItems.get(255);
            }
            if (beaconItem == null) {
                return null;
            }
            String byteData = ByteUtils.byteToString(beaconItem.bytes);
            Log.d((String)TAG, (String)byteData);
            if (!TextUtils.isEmpty((CharSequence)byteData) && (byteData.endsWith(BLE_HEARD_V1) || byteData.startsWith(BLE_HEARD_V2) || byteData.startsWith(BLE_HEARD_V1_BLE_DOORLOCK))) {
                String productData;
                int version = 0;
                String devId = null;
                boolean isActivated = false;
                if (byteData.startsWith(BLE_HEARD_V2) && !byteData.endsWith("8B")) {
                    productData = ByteUtils.byteToString(beaconItem.bytes);
                    if (productData.length() >= 48) {
                        devId = new String(ConvertUtils.hexString2Bytes((String)productData.substring(4, 44)));
                        isActivated = ConvertUtils.hexString2Int((String)productData.substring(44, 46)) == 1;
                        version = ConvertUtils.hexString2Int((String)productData.substring(46, 48));
                    }
                } else if (byteData.startsWith(BLE_HEARD_V1_BLE_DOORLOCK)) {
                    productData = ByteUtils.byteToString(beaconItem.bytes);
                    if (productData.length() >= 52) {
                        devId = new String(ConvertUtils.hexString2Bytes((String)productData.substring(12, 52)));
                    }
                    if (productData.length() >= 54) {
                        boolean bl = isActivated = ConvertUtils.hexString2Int((String)productData.substring(52, 54)) == 1;
                    }
                }
                if (beaconItems.containsKey(22)) {
                    beaconItem = beaconItems.get(22);
                }
                if (beaconItem == null) {
                    return null;
                }
                String uuid = ByteUtils.byteToString(beaconItem.bytes);
                if (!TextUtils.isEmpty((CharSequence)uuid)) {
                    XMBleInfo xmBleInfo = new XMBleInfo();
                    xmBleInfo.setActivated(isActivated);
                    String devName = "";
                    try {
                        devName = URLDecoder.decode(bluetoothDevice.getName(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    xmBleInfo.setName(devName);
                    xmBleInfo.setMac(bluetoothDevice.getAddress());
                    xmBleInfo.setProductId(new String(ConvertUtils.hexString2Bytes((String)uuid.substring(4))));
                    xmBleInfo.setRssi(bluetoothDevice.rssi);
                    if (!StringUtils.isStringNULL(devId)) {
                        xmBleInfo.setSn(devId);
                    }
                    xmBleInfo.setVersion(version);
                    return xmBleInfo;
                }
            }
        }
        return null;
    }

    @Override
    public void stopScan() {
        if (this.bluetoothClient != null) {
            this.bluetoothClient.stopSearch();
        }
        if (this.xmBleInfoHashMap != null) {
            this.xmBleInfoHashMap.clear();
            this.xmBleInfoHashMap = null;
        }
    }

    @Override
    public void release() {
        if (this.xmBleInfoHashMap != null && this.bluetoothClient != null) {
            for (Map.Entry<String, XMBleInfo> xmBleInfoSet : this.xmBleInfoHashMap.entrySet()) {
                String mac = xmBleInfoSet.getKey();
                if (mac == null) continue;
                this.bluetoothClient.disconnect(mac);
            }
            this.xmBleInfoHashMap.clear();
            this.xmBleInfoHashMap = null;
        }
        if (this.atomicIntegerMap != null) {
            this.atomicIntegerMap.clear();
            this.atomicIntegerMap = null;
        }
        if (this.bleManagerListenerHashMap != null) {
            this.bleManagerListenerHashMap.clear();
            this.bleManagerListenerHashMap = null;
        }
        if (this.bluetoothClient != null) {
            this.bluetoothClient.stopSearch();
            this.bluetoothClient = null;
        }
        IXMBleManager = null;
    }

    @Override
    public void connect(final String mac, final IXMBleManagerListener iBleManagerListener) {
        if (mac == null) {
            return;
        }
        if (this.bluetoothClient != null) {
            BleConnectOptions options = new BleConnectOptions.Builder().setConnectRetry(3).setConnectTimeout(30000).setServiceDiscoverRetry(3).setServiceDiscoverTimeout(20000).build();
            this.bluetoothClient.connect(mac, options, new BleConnectResponse(){

                @Override
                public void onResponse(int connectCode, BleGattProfile data) {
                    LogUtils.debugInfo("[APP_BLE]->", "BleManager->connect ble failed:" + connectCode);
                    XMBleManager.this.bleGattProfile = data;
                    XMBleManager.this.bluetoothClient.requestMtu(mac, 512, new BleMtuResponse(){

                        @Override
                        public void onResponse(int code, Integer data) {
                            LogUtils.debugInfo("[APP_BLE]->", "requestMtu() called with: code = [" + code + "], data = [" + data + "]");
                        }
                    });
                    if (iBleManagerListener != null) {
                        iBleManagerListener.onConnectBleResult(mac, connectCode);
                    }
                }
            });
        }
    }

    @Override
    public void disConnect(String mac) {
        if (mac == null) {
            return;
        }
        if (this.bleManagerListenerHashMap != null) {
            this.bleManagerListenerHashMap.remove(mac + ":send");
        }
        if (this.atomicIntegerMap != null) {
            this.atomicIntegerMap.remove(mac + ":send");
        }
        if (this.revDataMap != null) {
            this.revDataMap.remove(mac);
            this.revDataMap.remove(mac + ":allDataLen");
        }
        if (this.mtuMap != null) {
            this.mtuMap.remove(mac);
        }
        if (this.bluetoothClient != null) {
            this.bluetoothClient.disconnect(mac);
        }
    }

    @Override
    public void connectWiFi(String mac, String ssid, String pwd, String capabilities, final IXMBleManagerListener iBleManagerListener) {
        String combineWIFISSID = BleDistributionUtil.combineWiFiSSIDToHexStr(ssid, pwd, BleDistributionUtil.getWifiEncrypt(capabilities), "");
        LogUtils.debugInfo("[APP_BLE]->", "Connect WiFi:" + combineWIFISSID);
        this.write(mac, ConvertUtils.hexString2Bytes((String)combineWIFISSID), new IXMBleManagerListener(){

            @Override
            public void onWriteBleResult(String mac, int code) {
                super.onWriteBleResult(mac, code);
                if (iBleManagerListener != null) {
                    iBleManagerListener.onConnectWiFiResult(mac, code);
                }
            }
        });
    }

    @Override
    public boolean write(String mac, byte[] data, IXMBleManagerListener iBleManagerListener) {
        if (mac == null) {
            LogUtils.debugInfo("[APP_BLE]->", "mac is null");
            return false;
        }
        if (data == null) {
            LogUtils.debugInfo("[APP_BLE]->", "data is null");
            return false;
        }
        if (this.bluetoothClient != null && this.bleGattProfile != null) {
            this.packetSendData(mac, data, iBleManagerListener);
            return true;
        }
        LogUtils.debugInfo("[APP_BLE]->", "bluetoothClient is null or bleGattProfile is null");
        return false;
    }

    private void packetSendData(final String mac, byte[] data, IXMBleManagerListener iBleManagerListener) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        if (!this.mtuMap.containsKey(mac)) {
            this.mtuMap.put(mac, 512);
        }
        AtomicInteger atomicInteger = new AtomicInteger();
        this.atomicIntegerMap.put(mac + ":send", atomicInteger);
        this.bleManagerListenerHashMap.put(mac + ":send", iBleManagerListener);
        while (buffer.hasRemaining()) {
            byte[] readData = new byte[this.mtuMap.get(mac).intValue()];
            int bytesRead = Math.min(readData.length, buffer.remaining());
            buffer.get(readData, 0, bytesRead);
            byte[] sendData = new byte[bytesRead];
            System.arraycopy(readData, 0, sendData, 0, sendData.length);
            atomicInteger.incrementAndGet();
            BleGattService service = this.bleGattProfile.getService(UUID.fromString(SERVICE_UUID));
            if (service != null) {
                UUID write = UUID.fromString(WRITE_UUID);
                LogUtils.debugInfo("[APP_BLE]->", "packetSendData:" + ConvertUtils.bytes2HexString((byte[])sendData));
                this.bluetoothClient.write(mac, service.getUUID(), write, sendData, new BleWriteResponse(){

                    @Override
                    public void onResponse(int code) {
                        LogUtils.debugInfo("[APP_BLE]->", "code:" + code);
                        XMBleManager.this.dealWithSendResult(mac, code);
                    }
                });
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void dealWithSendResult(String mac, int code) {
        IXMBleManagerListener iBleManagerListener;
        AtomicInteger atomicInteger = this.atomicIntegerMap.get(mac + ":send");
        if (atomicInteger.decrementAndGet() <= 0 && (iBleManagerListener = this.bleManagerListenerHashMap.get(mac + ":send")) != null) {
            iBleManagerListener.onWriteBleResult(mac, code);
        }
    }

    @Override
    public void notify(final String mac, final IXMBleManagerListener iBleManagerListener) {
        if (mac == null) {
            return;
        }
        BleGattService service = this.bleGattProfile.getService(UUID.fromString(SERVICE_UUID));
        UUID notify = UUID.fromString(NOTIFY_UUID);
        if (this.bluetoothClient != null && this.bleGattProfile != null && service != null) {
            this.bluetoothClient.notify(mac, service.getUUID(), notify, new BleNotifyResponse(){

                @Override
                public void onNotify(UUID service, UUID character, byte[] value) {
                    XMBleManager.this.packetRevData(mac, value, iBleManagerListener);
                }

                @Override
                public void onResponse(int code) {
                    if (code != 0 && iBleManagerListener != null) {
                        iBleManagerListener.onResponse(mac, null, code);
                    }
                }
            });
        }
    }

    private boolean packetRevData(String mac, byte[] data, IXMBleManagerListener iBleManagerListener) {
        LogUtils.debugInfo("[APP_BLE]->", "packetRevData:" + ConvertUtils.bytes2HexString((byte[])data));
        if (data.length > 9 && BleUtils.isXMBleData(data)) {
            XMBleHead xmBleHead = new XMBleHead();
            boolean isOk = xmBleHead.parseHead(data);
            if (isOk) {
                int dataLen = xmBleHead.getContentDataLen();
                int allDataLen = dataLen + 9 + 1;
                if (allDataLen == data.length || data.length == allDataLen - 1 && xmBleHead.getVersion() == 1) {
                    this.dealWithRevResult(mac, data, iBleManagerListener);
                } else {
                    ByteBuffer buffer = (ByteBuffer)this.revDataMap.get(mac);
                    if (buffer == null) {
                        buffer = ByteBuffer.allocate(65545);
                        this.revDataMap.put(mac, buffer);
                        this.revDataMap.put(mac + ":allDataLen", allDataLen);
                    }
                    buffer.put(data);
                }
                return true;
            }
            return false;
        }
        ByteBuffer buffer = (ByteBuffer)this.revDataMap.get(mac);
        if (buffer == null) {
            buffer = ByteBuffer.allocate(65545);
            this.revDataMap.put(mac, buffer);
        }
        buffer.put(data);
        LogUtils.debugInfo("[APP_BLE]->", "buffer position:" + buffer.position());
        int allDataLen = 10;
        allDataLen = this.revDataMap.containsKey(mac + ":allDataLen") ? ((Integer)this.revDataMap.get(mac + ":allDataLen")).intValue() : this.parseAllDataLen(mac, buffer);
        if (buffer.position() >= allDataLen) {
            byte[] revData = new byte[buffer.position()];
            System.arraycopy(buffer.array(), 0, revData, 0, revData.length);
            this.dealWithRevResult(mac, revData, iBleManagerListener);
        }
        return true;
    }

    private int parseAllDataLen(String mac, ByteBuffer buffer) {
        if (!this.revDataMap.containsKey(mac + ":allDataLen") && buffer.position() >= 9) {
            byte[] revData = new byte[buffer.position()];
            System.arraycopy(buffer.array(), 0, revData, 0, revData.length);
            XMBleHead xmBleHead = new XMBleHead();
            boolean isOk = xmBleHead.parseHead(revData);
            if (isOk) {
                int allDataLen = xmBleHead.getContentDataLen() + 9 + 1;
                this.revDataMap.put(mac + ":allDataLen", allDataLen);
                LogUtils.debugInfo("[APP_BLE]->", "allDataLen:" + allDataLen);
                return allDataLen;
            }
        }
        return 10;
    }

    private byte[] findNextHead(byte[] data) {
        String hexData = ConvertUtils.bytes2HexString((byte[])data);
        int index = hexData.lastIndexOf(BLE_HEARD_V2);
        if (index > 0) {
            String nextHeadData = hexData.substring(index);
            return ConvertUtils.hexString2Bytes((String)nextHeadData);
        }
        return null;
    }

    private void dealWithRevResult(String mac, byte[] data, IXMBleManagerListener iBleManagerListener) {
        XMBleData xmBleData = new XMBleData();
        boolean isOk = xmBleData.parseData(data);
        if (isOk) {
            this.revDataMap.remove(mac);
            this.revDataMap.remove(mac + ":allDataLen");
        } else {
            byte[] nextData = this.findNextHead(data);
            if (nextData != null) {
                ByteBuffer buffer = (ByteBuffer)this.revDataMap.get(mac);
                buffer.clear();
                buffer.put(nextData);
                this.parseAllDataLen(mac, buffer);
            } else {
                this.revDataMap.remove(mac);
                this.revDataMap.remove(mac + ":allDataLen");
            }
        }
        if (iBleManagerListener != null) {
            iBleManagerListener.onResponse(mac, isOk ? xmBleData : null, 0);
        }
    }

    @Override
    public List<XMBleInfo> getAllXMBleInfos() {
        if (this.xmBleInfoHashMap == null || this.xmBleInfoHashMap.isEmpty()) {
            return null;
        }
        ArrayList<XMBleInfo> xmBleInfoList = new ArrayList<XMBleInfo>();
        for (Map.Entry<String, XMBleInfo> entry : this.xmBleInfoHashMap.entrySet()) {
            if (entry == null) continue;
            xmBleInfoList.add(entry.getValue());
        }
        return xmBleInfoList;
    }

    public XMBleInfo getXMBleInfoByMac(String mac) {
        if (this.xmBleInfoHashMap != null && mac != null) {
            return this.xmBleInfoHashMap.get(mac);
        }
        return null;
    }

    public static HashMap parseBleWiFiConfigResult(@NotNull String pid, @NotNull String hexData) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (hexData == null) {
            hashMap.put("isSuccess", false);
            return hashMap;
        }
        try {
            int connectResult = ConvertUtils.hexString2Int((String)hexData.substring(0, 2));
            if (connectResult == 0) {
                int sLen = 0;
                int eLen = 0;
                byte[] userName = "".getBytes();
                byte[] password = "".getBytes();
                byte[] devId = "".getBytes();
                int userNameLen = ConvertUtils.hexString2Int((String)hexData.substring(2, 4));
                if (userNameLen > 0) {
                    sLen = 4;
                    eLen = userNameLen * 2 + 4;
                    userName = ConvertUtils.hexString2Bytes((String)hexData.substring(sLen, eLen));
                } else {
                    userNameLen = 0;
                }
                sLen = userNameLen * 2 + 4;
                eLen = userNameLen * 2 + 6;
                int passwordLen = ConvertUtils.hexString2Int((String)hexData.substring(sLen, eLen));
                if (passwordLen > 0) {
                    sLen = userNameLen * 2 + 6;
                    eLen = passwordLen * 2 + userNameLen * 2 + 6;
                    password = ConvertUtils.hexString2Bytes((String)hexData.substring(sLen, eLen));
                } else {
                    passwordLen = 0;
                }
                sLen = passwordLen * 2 + userNameLen * 2 + 6;
                eLen = passwordLen * 2 + userNameLen * 2 + 8;
                int devIdLen = ConvertUtils.hexString2Int((String)hexData.substring(sLen, eLen));
                if (devIdLen > 0) {
                    sLen = passwordLen * 2 + userNameLen * 2 + 8;
                    eLen = passwordLen * 2 + userNameLen * 2 + devIdLen * 2 + 8;
                    devId = ConvertUtils.hexString2Bytes((String)hexData.substring(sLen, eLen));
                } else {
                    devIdLen = 0;
                }
                sLen = passwordLen * 2 + userNameLen * 2 + devIdLen * 2 + 8;
                eLen = passwordLen * 2 + userNameLen * 2 + devIdLen * 2 + 16;
                byte[] devIp = ConvertUtils.hexString2Bytes((String)hexData.substring(sLen, eLen));
                CONFIG_IPAddress ipAddress = new CONFIG_IPAddress();
                ipAddress.setIp(devIp[3], devIp[2], devIp[1], devIp[0]);
                sLen = passwordLen * 2 + userNameLen * 2 + devIdLen * 2 + 16;
                eLen = passwordLen * 2 + userNameLen * 2 + devIdLen * 2 + 28;
                String mac = hexData.substring(sLen, eLen);
                StringBuffer afterMac = new StringBuffer();
                for (int i = 0; i < mac.length() / 2; ++i) {
                    afterMac.append(mac.substring(i * 2, i * 2 + 2));
                    if (i >= mac.length() / 2 - 1) continue;
                    afterMac.append(":");
                }
                int tokenLen = 0;
                byte[] token = null;
                if (hexData.length() > eLen) {
                    sLen = passwordLen * 2 + userNameLen * 2 + devIdLen * 2 + 28;
                    eLen = passwordLen * 2 + userNameLen * 2 + devIdLen * 2 + 30;
                    tokenLen = ConvertUtils.hexString2Int((String)hexData.substring(sLen, eLen));
                    if (tokenLen > 0) {
                        sLen = passwordLen * 2 + userNameLen * 2 + devIdLen * 2 + 30;
                        eLen = passwordLen * 2 + userNameLen * 2 + devIdLen * 2 + 30 + tokenLen * 2;
                        token = ConvertUtils.hexString2Bytes((String)hexData.substring(sLen, eLen));
                    } else {
                        tokenLen = 0;
                    }
                }
                String strDevId = new String(devId, StandardCharsets.UTF_8);
                String strUserName = new String(userName, StandardCharsets.UTF_8);
                String strPassword = new String(password, StandardCharsets.UTF_8);
                String strIp = ipAddress.getIp();
                String strMac = afterMac.toString();
                String strToken = null;
                if (token != null) {
                    strToken = new String(token, StandardCharsets.UTF_8);
                }
                LogUtils.debugInfo("[APP_BLE]->", "BleManger:->" + strDevId + " " + strUserName + " " + strPassword + " " + strIp + " " + strMac + " " + strToken);
                if (StringUtils.isStringNULL(strUserName)) {
                    strUserName = "admin";
                }
                SDBDeviceInfo sdbDeviceInfo = new SDBDeviceInfo();
                G.SetValue((byte[])sdbDeviceInfo.st_0_Devmac, (String)strDevId);
                G.SetValue((byte[])sdbDeviceInfo.st_4_loginName, (String)strUserName);
                G.SetValue((byte[])sdbDeviceInfo.st_2_Devip, (String)strIp);
                XMDevInfo xmDevInfo = new XMDevInfo();
                xmDevInfo.sdbDevInfoToXMDevInfo(sdbDeviceInfo);
                xmDevInfo.setDevUserName(strUserName);
                xmDevInfo.setDevPassword(strPassword);
                xmDevInfo.setDevToken(strToken);
                xmDevInfo.setDevIp(strIp);
                xmDevInfo.setMac(strMac);
                xmDevInfo.setPid(pid);
                FunSDK.DevSetDevInfoToLocal((String)xmDevInfo.getDevId(), (String)xmDevInfo.getDevUserName(), (String)xmDevInfo.getDevPassword(), (String)xmDevInfo.getDevToken());
                XMBleManager.addLanDevsToCache(xmDevInfo, ipAddress);
                hashMap.put("isSuccess", true);
                hashMap.put("devInfo", xmDevInfo);
                return hashMap;
            }
            hashMap.put("isSuccess", false);
            hashMap.put("errorId", connectResult);
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            hashMap.put("isSuccess", false);
            return hashMap;
        }
    }

    private static void addLanDevsToCache(XMDevInfo xmDevInfo, CONFIG_IPAddress ipAddress) {
        Object[] localDevInfo = new SDK_CONFIG_NET_COMMON_V2[]{new SDK_CONFIG_NET_COMMON_V2()};
        G.SetValue((byte[])localDevInfo[0].st_14_sSn, (String)xmDevInfo.getDevId());
        G.SetValue((byte[])localDevInfo[0].st_13_sMac, (String)xmDevInfo.getMac());
        localDevInfo[0].st_01_HostIP = ipAddress;
        localDevInfo[0].st_05_TCPPort = 34567;
        G.SetValue((byte[])localDevInfo[0].st_18_sRandomUser, (String)xmDevInfo.getDevUserName());
        G.SetValue((byte[])localDevInfo[0].st_19_sRandomPwd, (String)xmDevInfo.getDevPassword());
        FunSDK.AddLANDevsToCache((byte[])G.ObjToBytes((Object[])localDevInfo), (int)1);
        new Thread(new Runnable((SDK_CONFIG_NET_COMMON_V2[])localDevInfo){
            final /* synthetic */ SDK_CONFIG_NET_COMMON_V2[] val$localDevInfo;
            {
                this.val$localDevInfo = sDK_CONFIG_NET_COMMON_V2Array;
            }

            @Override
            public void run() {
                FunSDK.DevIsDetectTCPService((byte[])G.ObjToBytes((Object[])this.val$localDevInfo), (int)15000);
            }
        });
    }
}

