/*
 * Decompiled with CFR 0.152.
 */
package com.manager.base.http;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.lib.sdk.bean.StringUtils;
import com.manager.XMFunSDKManager;
import com.manager.db.Define;
import com.utils.AESECBUtils;
import com.utils.LogUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public class SecureInterceptor
implements Interceptor {
    private static final String TAG = "okhttp.OkHttpClient";

    @NonNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        ResponseBody responseBody;
        Response response;
        MediaType contentType;
        Request request = chain.request();
        HttpUrl httpUrl = request.url();
        String url = httpUrl.toString();
        List segments = httpUrl.encodedPathSegments();
        if (!url.startsWith(Define.RS_BASE_URL) && !url.startsWith("https://jvss.xmcsrv.net/")) {
            return chain.proceed(request);
        }
        String method = request.method().toLowerCase().trim();
        if (!"post".equals(method)) {
            return chain.proceed(request);
        }
        String timMillis = "";
        if (!segments.isEmpty()) {
            int vIndex = -1;
            for (int i = 0; i < segments.size(); ++i) {
                if (!"v3".equals(segments.get(i))) continue;
                vIndex = i;
                break;
            }
            if (vIndex < 0 || segments.size() <= vIndex + 1) {
                return chain.proceed(request);
            }
            if (segments.size() > 2) {
                timMillis = (String)segments.get(segments.size() - 2);
            }
            if (TextUtils.isEmpty((CharSequence)timMillis) || !org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)timMillis)) {
                return chain.proceed(request);
            }
        } else {
            return chain.proceed(request);
        }
        String key = AESECBUtils.keyFilter(timMillis, XMFunSDKManager.getInstance().getAppSecret());
        RequestBody requestBody = request.body();
        if (requestBody != null) {
            Charset charset = StandardCharsets.UTF_8;
            contentType = requestBody.contentType();
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            String requestData = buffer.readString(charset);
            try {
                String encryptData = AESECBUtils.encryptToHexString(requestData, key, false);
                RequestBody newRequestBody = RequestBody.create((MediaType)contentType, (String)encryptData);
                Request.Builder newRequestBuilder = request.newBuilder();
                newRequestBuilder.post(newRequestBody);
                request = newRequestBuilder.build();
            }
            catch (Exception encryptData) {
                // empty catch block
            }
        }
        if ((response = chain.proceed(request)).isSuccessful() && (responseBody = response.body()) != null) {
            contentType = responseBody.contentType();
            if (url.startsWith(Define.RS_BASE_URL) && contentType != null && StringUtils.contrast(contentType.subtype(), "json")) {
                return response;
            }
            try {
                BufferedSource source = responseBody.source();
                source.request(Long.MAX_VALUE);
                Buffer buffer = source.getBuffer();
                Charset charset = StandardCharsets.UTF_8;
                if (contentType != null) {
                    charset = contentType.charset(charset);
                }
                String bodyString = buffer.clone().readString(charset);
                LogUtils.debugInfo("[APP_JVSS->]", "response:" + bodyString);
                String responseData = AESECBUtils.decryptToHexString(bodyString, key, false);
                ResponseBody newResponseBody = ResponseBody.create((MediaType)contentType, (String)responseData.trim());
                response = response.newBuilder().body(newResponseBody).build();
            }
            catch (Exception e) {
                return response;
            }
        }
        return response;
    }
}

