/*
 * Decompiled with CFR 0.152.
 */
package com.lib.sdk.bean.idr;

import android.os.Message;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.MsgContent;
import com.lib.sdk.bean.idr.BaseRequest;
import com.lib.sdk.bean.idr.StorageInfo;
import com.manager.device.idr.IDRManagerCallBack;
import java.text.DecimalFormat;
import java.util.List;

public class SDStorage
extends BaseRequest {
    private List<StorageInfo> mStorageInfos;

    public SDStorage(String sn) {
        super(sn);
    }

    public static String getSize(List<StorageInfo> storageInfos, boolean isShowPercent) {
        StorageInfo info = storageInfos.get(0);
        long mReaminSize = 0L;
        long mTotalSize = 0L;
        for (int i = 0; i < info.PartNumber && i < info.Partition.size(); ++i) {
            mReaminSize += G.getLongFromHex((String)info.Partition.get((int)i).RemainSpace);
            mTotalSize += G.getLongFromHex((String)info.Partition.get((int)i).TotalSpace);
        }
        if (isShowPercent) {
            double remainPercent = Math.min((double)mReaminSize * 100.0 / (double)mTotalSize, 100.0);
            DecimalFormat decimalFormat = new DecimalFormat("#0.0");
            return decimalFormat.format(remainPercent) + "%";
        }
        DecimalFormat df = new DecimalFormat("#.00");
        if (mReaminSize == 0L) {
            return "0.00K";
        }
        if (mReaminSize < 1L) {
            return df.format((double)mReaminSize * 1024.0) + "K";
        }
        if (mReaminSize < 1024L) {
            return df.format((double)mReaminSize) + "M";
        }
        if (mReaminSize < 0x100000L) {
            return df.format((double)mReaminSize / 1024.0) + "G";
        }
        if (mReaminSize < 0x40000000L) {
            return df.format((double)mReaminSize / 1048576.0) + "T";
        }
        return df.format((double)mReaminSize / 1.073741824E9) + "P";
    }

    public boolean requestGetSD(IDRManagerCallBack storageSizeCallBack) {
        if (this.isSending()) {
            return false;
        }
        this.mIDRManagerCallBack = storageSizeCallBack;
        FunSDK.DevGetConfigByJson((int)this.mID, (String)this.mSN, (String)"StorageInfo", (int)1024, (int)-1, (int)5000, (int)0);
        return true;
    }

    @Override
    public int OnFunSDKResult(Message msg, MsgContent ex) {
        if (this.mIDRManagerCallBack == null) {
            return 0;
        }
        if (msg.arg1 < 0 || ex.pData == null || ex.pData.length == 0) {
            this.mIDRManagerCallBack.onError(msg, ex);
            this.mIDRManagerCallBack = null;
            return 0;
        }
        String jsonStr = G.ToString((byte[])ex.pData);
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            this.mIDRManagerCallBack.onFail(-1);
            this.mIDRManagerCallBack = null;
            return 0;
        }
        try {
            this.mStorageInfos = JSON.parseArray((String)JSON.parseObject((String)jsonStr).getString("StorageInfo"), StorageInfo.class);
            this.mIDRManagerCallBack.onSuccess(this.mStorageInfos);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mIDRManagerCallBack.onFail(-1);
        }
        this.mIDRManagerCallBack = null;
        return 0;
    }
}

