/*
 * Decompiled with CFR 0.152.
 */
package com.lib.sdk.bean.bluetooth;

import android.text.TextUtils;
import com.blankj.utilcode.util.ConvertUtils;
import com.lib.sdk.bean.StringUtils;
import com.utils.BleDistributionUtil;
import com.utils.LogUtils;

public class XMBleHead {
    public static final String XM_BLE_HEAD = "8B8B";
    public static final int HEAD_SIZE = 9;
    public static final int CMD_SEND = 1;
    public static final int CMD_RECEIVE = 2;
    public static final int CMD_CALLBACK = 3;
    public static final int DATA_TYPE_BINARY_ENCRYPTION = 0;
    public static final int DATA_TYPE_STRING_ENCRYPTION = 1;
    public static final int DATA_TYPE_BINARY_NO_ENCRYPTION = 2;
    private int version = 0;
    private int cmdId = 1;
    private int funId = 1;
    private int dataType = 0;
    private int headLen = 9;
    private int contentDataLen = 0;
    private String contentDataHexString;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getCmdId() {
        return this.cmdId;
    }

    public void setCmdId(int cmdId) {
        this.cmdId = cmdId;
    }

    public int getFunId() {
        return this.funId;
    }

    public void setFunId(int funId) {
        this.funId = funId;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public int getContentDataLen() {
        return this.contentDataLen;
    }

    public void setContentDataLen(int contentDataLen) {
        this.contentDataLen = contentDataLen;
    }

    public boolean parseData(byte[] data) {
        if (data == null) {
            return false;
        }
        String hexString = ConvertUtils.bytes2HexString((byte[])data);
        if (TextUtils.isEmpty((CharSequence)hexString)) {
            LogUtils.debugInfo("[APP_BLE]->", "Ble Data empty");
            return false;
        }
        LogUtils.debugInfo("[APP_BLE]->", "Ble Data:" + hexString);
        if (!StringUtils.containsIgnoreCase(hexString.toUpperCase(), XM_BLE_HEAD)) {
            LogUtils.debugInfo("[APP_BLE]->", "Ble Data head error");
            return false;
        }
        try {
            this.version = ConvertUtils.hexString2Int((String)hexString.substring(4, 6));
            this.cmdId = ConvertUtils.hexString2Int((String)hexString.substring(6, 8));
            this.funId = ConvertUtils.hexString2Int((String)hexString.substring(8, 12));
            this.dataType = ConvertUtils.hexString2Int((String)hexString.substring(12, 14));
            this.contentDataLen = ConvertUtils.hexString2Int((String)hexString.substring(14, 18));
            this.contentDataHexString = hexString.substring(18, hexString.length() - 2);
            String checkCode = hexString.substring(hexString.length() - 2);
            if (!StringUtils.contrastIgnoreCase(checkCode, BleDistributionUtil.createCheckCode(hexString.substring(0, hexString.length() - 2)))) {
                LogUtils.debugInfo("[APP_BLE]->", "Ble Data check code error");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean parseHead(byte[] data) {
        if (data == null) {
            return false;
        }
        String hexString = ConvertUtils.bytes2HexString((byte[])data);
        if (TextUtils.isEmpty((CharSequence)hexString)) {
            LogUtils.debugInfo("[APP_BLE]->", "Ble Data empty");
            return false;
        }
        LogUtils.debugInfo("[APP_BLE]->", "Ble Data:" + hexString);
        if (!hexString.toUpperCase().startsWith(XM_BLE_HEAD)) {
            LogUtils.debugInfo("[APP_BLE]->", "Ble Data head error");
            return false;
        }
        try {
            this.version = ConvertUtils.hexString2Int((String)hexString.substring(4, 6));
            this.cmdId = ConvertUtils.hexString2Int((String)hexString.substring(6, 8));
            this.funId = ConvertUtils.hexString2Int((String)hexString.substring(8, 12));
            this.dataType = ConvertUtils.hexString2Int((String)hexString.substring(12, 14));
            this.contentDataLen = ConvertUtils.hexString2Int((String)hexString.substring(14, 18));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getContentDataHexString() {
        return this.contentDataHexString;
    }

    public void setContentDataHexString(String contentDataHexString) {
        this.contentDataHexString = contentDataHexString;
    }

    public int getHeadLen() {
        return this.headLen;
    }
}

