/*
 * Decompiled with CFR 0.152.
 */
package com.lib.sdk.bean.bluetooth;

import android.text.TextUtils;
import com.blankj.utilcode.util.ConvertUtils;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.bean.bluetooth.XMBleHead;
import com.utils.BleDistributionUtil;
import com.utils.LogUtils;

public class XMBleData
extends XMBleHead {
    public static final String XM_BLE_HEAD = "8B8B";
    private String contentDataHexString;

    @Override
    public boolean parseData(byte[] data) {
        if (data == null) {
            return false;
        }
        String hexString = ConvertUtils.bytes2HexString((byte[])data);
        if (TextUtils.isEmpty((CharSequence)hexString)) {
            LogUtils.debugInfo("[APP_BLE]->", "Ble Data empty");
            return false;
        }
        try {
            boolean isOk = this.parseHead(data);
            if (isOk) {
                String createCode;
                this.contentDataHexString = hexString.substring(18, hexString.length() - 2);
                String checkCode = hexString.substring(hexString.length() - 2);
                if (!StringUtils.contrastIgnoreCase(checkCode, createCode = BleDistributionUtil.createCheckCode(hexString.substring(0, hexString.length() - 2)))) {
                    LogUtils.debugInfo("[APP_BLE]->", "Ble Data check code error:" + createCode);
                    return false;
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public String getContentDataHexString() {
        return this.contentDataHexString;
    }

    @Override
    public void setContentDataHexString(String contentDataHexString) {
        this.contentDataHexString = contentDataHexString;
    }
}

