/*
 * Decompiled with CFR 0.152.
 */
package com.lib.sdk.bean.alarm;

import android.text.TextUtils;
import android.webkit.URLUtil;
import com.alibaba.fastjson.JSON;
import com.basic.BaseJson;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.bean.doorlock.DoorLockOpenCountBean;
import com.utils.XUtils;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.json.JSONException;
import org.json.JSONObject;

public class AlarmInfo
extends BaseJson
implements Serializable {
    public static final String CLASSNAME = "AlarmInfo";
    private String id;
    private int channel;
    private String event;
    private String eventEx;
    private String startTime;
    private String status;
    private long picSize;
    private boolean isHaveCloud;
    private boolean isHaveCloudPic;
    private String sn;
    private String extInfo;
    private String pushMsg;
    private String alarmRing;
    private String pic;
    private String devName;
    private LinkCenterExt mLinkCenterExt;
    private boolean videoInfo = false;
    private String originJson;
    private int downloadState;
    private int downloadProgress;
    private long downloadCompleteTime;
    private int picError;

    public boolean isVideoInfo() {
        return this.videoInfo;
    }

    public void setVideoInfo(boolean videoInfo) {
        this.videoInfo = videoInfo;
    }

    public String getOriginJson() {
        if (null == this.originJson) {
            this.jsonObj = new JSONObject();
            try {
                this.jsonObj.put("ID", (Object)this.id);
                JSONObject object = new JSONObject();
                object.put("Event", (Object)(this.event + ":" + this.eventEx));
                object.put("StartTime", (Object)this.startTime);
                object.put("DevMac", (Object)this.sn);
                this.jsonObj.put(CLASSNAME, (Object)object);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return this.jsonObj.toString();
        }
        return this.originJson;
    }

    public String getExtInfo() {
        return this.extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public String getExtUserData() {
        try {
            String userdataKey = "userdata:";
            if (this.extInfo.contains(userdataKey)) {
                String tmp = this.extInfo.substring(this.extInfo.indexOf(userdataKey) + userdataKey.length()).trim();
                if (tmp.toLowerCase().equals("null")) {
                    return null;
                }
                return tmp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getSn() {
        return this.sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id2) {
        this.id = id2;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getStartTimeNotSpace() {
        if (!StringUtils.isStringNULL(this.startTime)) {
            return this.startTime.replace(" ", "").replace("-", "").replace(":", "");
        }
        return "";
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public long getPicSize() {
        return this.picSize;
    }

    public void setPicSize(long picSize) {
        this.picSize = picSize;
    }

    public String getPushMsg() {
        return this.pushMsg;
    }

    public void setPushMsg(String pushMsg) {
        this.pushMsg = pushMsg;
    }

    public String getAlarmRing() {
        return this.alarmRing;
    }

    public void setAlarmRing(String alarmRing) {
        this.alarmRing = alarmRing;
    }

    public String getPic() {
        return this.pic;
    }

    public void setPic(String pic) {
        this.pic = pic;
    }

    public LinkCenterExt getLinkCenterExt() {
        return this.mLinkCenterExt;
    }

    public void setLinkCenterExt(LinkCenterExt linkCenterExt) {
        this.mLinkCenterExt = linkCenterExt;
    }

    public int getPicError() {
        return this.picError;
    }

    public void setPicError(int picError) {
        this.picError = picError;
    }

    public boolean onParse(String json) {
        if (!super.onParse(json)) {
            return false;
        }
        try {
            this.originJson = json;
            if (this.jsonObj.has(CLASSNAME)) {
                JSONObject jsonObject = this.jsonObj.getJSONObject(CLASSNAME);
                this.setId(this.jsonObj.optString("ID"));
                String strPicSize = this.jsonObj.optString("picSize");
                if (XUtils.isInteger(strPicSize)) {
                    this.picSize = Long.parseLong(strPicSize);
                    if (this.picSize >= 2L) {
                        this.isHaveCloud = true;
                    }
                }
                return this.onParse(jsonObject);
            }
            return this.parseV2();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean parseV2() {
        String event;
        boolean isOk = false;
        if (this.jsonObj.has("tm")) {
            this.setStartTime(this.jsonObj.optString("tm"));
        }
        if (this.jsonObj.has("id")) {
            this.setId(this.jsonObj.optString("id"));
            isOk = true;
        }
        if (this.jsonObj.has("ch")) {
            this.setChannel(this.jsonObj.optInt("ch", 0));
        }
        if (this.jsonObj.has("event") && !StringUtils.isStringNULL(event = this.jsonObj.optString("event"))) {
            String[] events = event.split(":");
            this.setEvent(events[0]);
        }
        if (this.jsonObj.has("vidinfo")) {
            this.isHaveCloud = true;
            this.videoInfo = true;
        }
        if (this.jsonObj.has("alarmmsg")) {
            String alarmmsg = this.jsonObj.optString("alarmmsg");
            this.mLinkCenterExt = LinkCenterExt.parseJson(alarmmsg);
        }
        if (this.jsonObj.has("picinfo")) {
            this.isHaveCloud = true;
            JSONObject picInfo = this.jsonObj.optJSONObject("picinfo");
            if (picInfo.has("size")) {
                int picSize = picInfo.optInt("size", 0);
                boolean bl = this.isHaveCloudPic = picSize > 0;
            }
            if (picInfo.has("url")) {
                this.pic = picInfo.optString("url");
            }
        }
        return isOk;
    }

    public boolean onParse(JSONObject obj) throws JSONException {
        if (null == obj) {
            return false;
        }
        if (obj.has("DevName")) {
            this.setDevName(obj.optString("DevName"));
        }
        if (obj.has("AlarmID")) {
            this.setId(obj.optString("AlarmID"));
        }
        if (obj.has("SerialNumber")) {
            this.setSn(obj.optString("SerialNumber"));
        }
        if (obj.has("Channel")) {
            this.setChannel(obj.optInt("Channel"));
        }
        if (obj.has("Event")) {
            this.setEvent(obj.optString("Event"));
        } else if (obj.has("AlarmMsg")) {
            this.setEvent(obj.optString("AlarmMsg"));
        }
        if (obj.has("StartTime")) {
            this.setStartTime(obj.optString("StartTime"));
        } else if (obj.has("AlarmTime")) {
            this.setStartTime(obj.optString("AlarmTime"));
        }
        if (obj.has("Status")) {
            this.setStatus(obj.optString("Status"));
        }
        if (obj.has("ExtInfo")) {
            this.extInfo = obj.optString("ExtInfo");
        }
        if (obj.has("PushMsg")) {
            this.pushMsg = obj.optString("PushMsg");
        }
        if (obj.has("AlarmRing")) {
            this.alarmRing = obj.optString("AlarmRing");
        }
        if (obj.has("Pic")) {
            this.pic = obj.optString("Pic");
        }
        this.mLinkCenterExt = LinkCenterExt.parseJson(this.extInfo);
        if (obj.has("VideoInfo")) {
            this.videoInfo = this.isHaveCloud = obj.has("VideoInfo");
        }
        if (obj.has("PicInfo")) {
            this.isHaveCloud = true;
            JSONObject picInfo = obj.optJSONObject("PicInfo");
            if (picInfo.has("ObjSize")) {
                Object result = picInfo.get("ObjSize");
                if (result instanceof Long) {
                    this.isHaveCloudPic = (Long)result > 0L;
                } else if (result instanceof Integer) {
                    boolean bl = this.isHaveCloudPic = (Integer)result > 0;
                }
            }
        }
        if (obj.has("PicErr")) {
            this.picError = obj.optInt("PicErr");
            this.isHaveCloud = true;
            this.isHaveCloudPic = false;
        }
        return true;
    }

    public String toString() {
        return "AlarmInfo [id=" + this.id + ", channel=" + this.channel + ", event=" + this.event + ", startTime=" + this.startTime + ", status=" + this.status + ", picSize=" + this.picSize + "]";
    }

    public String getEventEx() {
        return this.eventEx;
    }

    public void setEventEx(String eventEx) {
        this.eventEx = eventEx;
    }

    public boolean isHaveCloud() {
        return this.isHaveCloud;
    }

    public boolean isHavePic() {
        if (this.isHaveCloud) {
            return this.isHaveCloudPic;
        }
        return true;
    }

    public String getDevName() {
        return this.devName;
    }

    public void setDevName(String devName) {
        this.devName = new String(URLUtil.decode((byte[])devName.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public int getDownloadState() {
        return this.downloadState;
    }

    public void setDownloadState(int downloadState) {
        this.downloadState = downloadState;
    }

    public int getDownloadProgress() {
        return this.downloadProgress;
    }

    public void setDownloadProgress(int downloadProgress) {
        this.downloadProgress = downloadProgress;
    }

    public long getDownloadCompleteTime() {
        return this.downloadCompleteTime;
    }

    public void setDownloadCompleteTime(long downloadCompleteTime) {
        this.downloadCompleteTime = downloadCompleteTime;
    }

    public String getMsgType() {
        if (this.extInfo != null) {
            try {
                JSONObject jsonObject = new JSONObject(this.extInfo);
                if (jsonObject.has("MsgType")) {
                    return jsonObject.optString("MsgType");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getMsg() {
        if (this.extInfo != null) {
            try {
                JSONObject jsonObject = new JSONObject(this.extInfo);
                if (jsonObject.has("Msg")) {
                    return jsonObject.optString("Msg");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static class LinkCenterExt
    implements Serializable {
        private String msgType;
        private String msg;
        private String subSn;
        private int modelType;
        private DoorLockOpenCountBean dlOpenCountBean;

        public String getMsgType() {
            return this.msgType == null ? "" : this.msgType;
        }

        public void setMsgType(String msgType) {
            this.msgType = msgType;
        }

        public String getMsg() {
            return this.msg == null ? "" : this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String getSubSn() {
            return this.subSn == null ? "" : this.subSn;
        }

        public void setSubSn(String subSn) {
            this.subSn = subSn;
        }

        public int getModelType() {
            return this.modelType;
        }

        public void setModelType(int modelType) {
            this.modelType = modelType;
        }

        public static LinkCenterExt parseJson(String jsonStr) {
            if (TextUtils.isEmpty((CharSequence)jsonStr)) {
                return null;
            }
            try {
                String dlOpenCountJson;
                JSONObject jsonObject = new JSONObject(jsonStr);
                LinkCenterExt ext = new LinkCenterExt();
                if (jsonObject.has("MsgType")) {
                    ext.msgType = jsonObject.optString("MsgType");
                }
                if (jsonObject.has("ModelType")) {
                    ext.modelType = jsonObject.optInt("ModelType");
                }
                if (jsonObject.has("Msg")) {
                    ext.msg = jsonObject.optString("Msg");
                }
                if (jsonObject.has("SubSn")) {
                    ext.subSn = jsonObject.optString("SubSn");
                }
                if (jsonObject.has("DoorLockOpenCount") && !StringUtils.isStringNULL(dlOpenCountJson = jsonObject.optString("DoorLockOpenCount"))) {
                    DoorLockOpenCountBean bean = (DoorLockOpenCountBean)JSON.parseObject((String)dlOpenCountJson, DoorLockOpenCountBean.class);
                    ext.setDlOpenCountBean(bean);
                }
                return ext;
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "msgType = " + this.msgType + ";msg = " + this.msg + ";subSn = " + this.subSn + ";modelType = " + this.modelType;
        }

        public DoorLockOpenCountBean getDlOpenCountBean() {
            return this.dlOpenCountBean;
        }

        public void setDlOpenCountBean(DoorLockOpenCountBean dlOpenCountBean) {
            this.dlOpenCountBean = dlOpenCountBean;
        }
    }
}

