/*
 * Decompiled with CFR 0.152.
 */
package com.inuker.bluetooth.library.model;

import android.bluetooth.BluetoothGattCharacteristic;
import android.os.Parcel;
import android.os.Parcelable;
import com.inuker.bluetooth.library.model.BleGattCharacter;
import com.inuker.bluetooth.library.model.BleGattService;
import com.inuker.bluetooth.library.utils.ListUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BleGattProfile
implements Parcelable {
    private List<BleGattService> services;
    public static final Parcelable.Creator<BleGattProfile> CREATOR = new Parcelable.Creator<BleGattProfile>(){

        public BleGattProfile createFromParcel(Parcel in) {
            return new BleGattProfile(in);
        }

        public BleGattProfile[] newArray(int size) {
            return new BleGattProfile[size];
        }
    };

    public BleGattProfile(Map<UUID, Map<UUID, BluetoothGattCharacteristic>> map) {
        Iterator<Map.Entry<UUID, Map<UUID, BluetoothGattCharacteristic>>> itor = map.entrySet().iterator();
        ArrayList<BleGattService> serviceList = new ArrayList<BleGattService>();
        while (itor.hasNext()) {
            Map<UUID, BluetoothGattCharacteristic> characters;
            Map.Entry<UUID, Map<UUID, BluetoothGattCharacteristic>> entry = itor.next();
            UUID serviceUUID = entry.getKey();
            BleGattService service = new BleGattService(serviceUUID, characters = entry.getValue());
            if (serviceList.contains(service)) continue;
            serviceList.add(service);
        }
        this.addServices(serviceList);
    }

    public BleGattProfile(Parcel in) {
        in.readTypedList(this.getServices(), BleGattService.CREATOR);
    }

    public void addServices(List<BleGattService> services) {
        Collections.sort(services);
        this.getServices().addAll(services);
    }

    public List<BleGattService> getServices() {
        if (this.services == null) {
            this.services = new ArrayList<BleGattService>();
        }
        return this.services;
    }

    public BleGattService getService(UUID serviceId) {
        if (serviceId == null) {
            return null;
        }
        List<BleGattService> services = this.getServices();
        for (BleGattService service : services) {
            if (!service.getUUID().equals(serviceId)) continue;
            return service;
        }
        return null;
    }

    public boolean containsCharacter(UUID serviceId, UUID characterId) {
        List<BleGattCharacter> characters;
        if (serviceId == null || characterId == null) {
            return false;
        }
        BleGattService service = this.getService(serviceId);
        if (service != null && !ListUtils.isEmpty(characters = service.getCharacters())) {
            for (BleGattCharacter character : characters) {
                if (!characterId.equals(character.getUuid())) continue;
                return true;
            }
        }
        return false;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(this.getServices());
    }

    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (BleGattService service : this.services) {
            sb.append(service).append("\n");
        }
        return sb.toString();
    }
}

