/*
 * Decompiled with CFR 0.152.
 */
package com.inuker.bluetooth.library.connect.request;

import android.os.Message;
import com.inuker.bluetooth.library.connect.listener.ServiceDiscoverListener;
import com.inuker.bluetooth.library.connect.options.BleConnectOptions;
import com.inuker.bluetooth.library.connect.request.BleRequest;
import com.inuker.bluetooth.library.connect.response.BleGeneralResponse;
import com.inuker.bluetooth.library.model.BleGattProfile;
import com.inuker.bluetooth.library.utils.BluetoothLog;

public class BleConnectRequest
extends BleRequest
implements ServiceDiscoverListener {
    private static final int MSG_CONNECT = 1;
    private static final int MSG_DISCOVER_SERVICE = 2;
    private static final int MSG_CONNECT_TIMEOUT = 3;
    private static final int MSG_DISCOVER_SERVICE_TIMEOUT = 4;
    private static final int MSG_RETRY_DISCOVER_SERVICE = 5;
    private BleConnectOptions mConnectOptions;
    private int mConnectCount;
    private int mServiceDiscoverCount;

    public BleConnectRequest(BleConnectOptions options, BleGeneralResponse response) {
        super(response);
        this.mConnectOptions = options != null ? options : new BleConnectOptions.Builder().build();
    }

    @Override
    public void processRequest() {
        this.processConnect();
    }

    private void processConnect() {
        this.mHandler.removeCallbacksAndMessages(null);
        this.mServiceDiscoverCount = 0;
        switch (this.getCurrentStatus()) {
            case 2: {
                this.processDiscoverService();
                break;
            }
            case 0: {
                if (!this.doOpenNewGatt()) {
                    this.closeGatt();
                    break;
                }
                this.mHandler.sendEmptyMessageDelayed(3, (long)this.mConnectOptions.getConnectTimeout());
                break;
            }
            case 19: {
                this.onConnectSuccess();
            }
        }
    }

    private boolean doOpenNewGatt() {
        ++this.mConnectCount;
        return this.openGatt();
    }

    private boolean doDiscoverService() {
        ++this.mServiceDiscoverCount;
        return this.discoverService();
    }

    private void retryConnectIfNeeded() {
        if (this.mConnectCount < this.mConnectOptions.getConnectRetry() + 1) {
            this.retryConnectLater();
        } else {
            this.onRequestCompleted(-1);
        }
    }

    private void retryDiscoverServiceIfNeeded() {
        if (this.mServiceDiscoverCount < this.mConnectOptions.getServiceDiscoverRetry() + 1) {
            this.retryDiscoverServiceLater();
        } else {
            this.closeGatt();
        }
    }

    private void onServiceDiscoverFailed() {
        BluetoothLog.v(String.format("onServiceDiscoverFailed", new Object[0]));
        this.refreshDeviceCache();
        this.mHandler.sendEmptyMessage(5);
    }

    private void processDiscoverService() {
        BluetoothLog.v(String.format("processDiscoverService, status = %s", this.getStatusText()));
        switch (this.getCurrentStatus()) {
            case 2: {
                if (!this.doDiscoverService()) {
                    this.onServiceDiscoverFailed();
                    break;
                }
                this.mHandler.sendEmptyMessageDelayed(4, (long)this.mConnectOptions.getServiceDiscoverTimeout());
                break;
            }
            case 0: {
                this.retryConnectIfNeeded();
                break;
            }
            case 19: {
                this.onConnectSuccess();
            }
        }
    }

    private void retryConnectLater() {
        this.log(String.format("retry connect later", new Object[0]));
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler.sendEmptyMessageDelayed(1, 1000L);
    }

    private void retryDiscoverServiceLater() {
        this.log(String.format("retry discover service later", new Object[0]));
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler.sendEmptyMessageDelayed(2, 1000L);
    }

    private void processConnectTimeout() {
        this.log(String.format("connect timeout", new Object[0]));
        this.mHandler.removeCallbacksAndMessages(null);
        this.closeGatt();
    }

    private void processDiscoverServiceTimeout() {
        this.log(String.format("service discover timeout", new Object[0]));
        this.mHandler.removeCallbacksAndMessages(null);
        this.closeGatt();
    }

    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.processConnect();
                break;
            }
            case 2: {
                this.processDiscoverService();
                break;
            }
            case 5: {
                this.retryDiscoverServiceIfNeeded();
                break;
            }
            case 3: {
                this.processConnectTimeout();
                break;
            }
            case 4: {
                this.processDiscoverServiceTimeout();
            }
        }
        return super.handleMessage(msg);
    }

    @Override
    public String toString() {
        return "BleConnectRequest{options=" + this.mConnectOptions + '}';
    }

    @Override
    public void onConnectStatusChanged(boolean connectedOrDisconnected) {
        this.checkRuntime();
        this.mHandler.removeMessages(3);
        if (connectedOrDisconnected) {
            this.mHandler.sendEmptyMessageDelayed(2, 300L);
        } else {
            this.mHandler.removeCallbacksAndMessages(null);
            this.retryConnectIfNeeded();
        }
    }

    @Override
    public void onServicesDiscovered(int status, BleGattProfile profile) {
        this.checkRuntime();
        this.mHandler.removeMessages(4);
        if (status == 0) {
            this.onConnectSuccess();
        } else {
            this.onServiceDiscoverFailed();
        }
    }

    private void onConnectSuccess() {
        BleGattProfile profile = this.getGattProfile();
        if (profile != null) {
            this.putParcelable("extra.gatt.profile", profile);
        }
        this.onRequestCompleted(0);
    }
}

